<?php
set_time_limit(3000);
require_once "../../../modelos/compras.modelo.php";
require_once "../../../modelos/productos.modelo.php";

class imprimirCodigosBarra{
	public function crearPDFCodsBarra(){

		$codigosBarra = json_decode($_GET['etiqs']);

		//REQUERIMOS LA CLASE TCPDF
		require_once('tcpdf_include.php');
		
		$ancho = $_GET['ancho'];
		$alto = $_GET['alto'];
		$medidas = array($ancho, $alto); // Ajustar aqui segun los milimetros necesarios;
		$pdf = new TCPDF('L', 'mm', $medidas, true, 'UTF-8', false);
		$pdf->SetMargins(2, 2, 2, 2);
		$pdf->SetAutoPageBreak(false, PDF_MARGIN_BOTTOM); 
		$pdf-> setPrintHeader(false);
		$pdf-> setPrintFooter(false);
		$pdf->startPageGroup();

		if($ancho == 50 && $alto == 30){
			$altoTitulo = '9px';
			$altoPrecioMayor = '15px';
		}else if($ancho == 100 && $alto == 50){
			$altoTitulo = '14px';
			$altoPrecioMayor = '30px';
			// $altoDesde = $producto['mayor_sobre'] == 0 ? '15px' : '14px';
		}

		$nombres = [];
		$codigos = [];
		foreach($codigosBarra as $key => $value) {

			$idProducto = $codigosBarra[$key]->id;
			$cantEtiquetasProd = 1;

			$producto = ModeloProductos::mdlMostrarProductos('productos','id', $idProducto, 'fecha');
			$sku = $producto["categoria"] <= 9 ? '0'.$producto["sku"] : $producto["sku"];
			for ($i=0; $i < $cantEtiquetasProd; $i++) { 
        		
				if($ancho == 50 && $alto == 30){
					$altoOtros = '10px';
					$altoMayorSobre = '13px';
					$saltosPrecioUnico = '<br><br> ';
                    $altoSku = '10px';
				}else if($ancho == 100 && $alto == 50){
					$altoOtros = '15px';
					$altoMayorSobre	 = '25px';
					$saltosPrecioUnico = '<br><br><br>   ';
                    $altoSku = '15px';
				}
        		$pdf->AddPage();
        		if($producto['mayor_sobre'] == 0){ // SIN MAYOREO
        			$precio_y_mayoreo =	$saltosPrecioUnico.'<font size="'.$altoOtros.'">PRECIO ÚNICO </font>'.
										'   <font size="'.$altoPrecioMayor.'">$ <b>'.number_format($producto['precio_mayor'],0,',','.').'</font>';
        			
        		}else{ // CON MAYOREO
        			$precio_y_mayoreo =	'<br><br>   <font size="'.$altoOtros.'">$ '.number_format($producto['precio_venta'],0,',','.').'</font> c/u'.
										'<br>   <font size="'.$altoOtros.'">DESDE </font><font size="'.$altoMayorSobre.'"><b>'.number_format($producto['mayor_sobre'],0,',','.').'u</b></font>'.
										'   <font size="'.$altoPrecioMayor.'">$ <b>'.number_format($producto['precio_mayor'],0,',','.').'</font>';
        		}

				$html = 	'<font style="text-align:center" size="'.$altoTitulo.'"><b>'.strtoupper($producto['desc_sii']).'</b>'.
							$precio_y_mayoreo. 
							'<font style="text-align:right" size="'.$altoSku.'"><br>SKU. <b>'.$sku.'</font>';

        		$pdf->writeHTML($html, false, false, false, false, '');
			}
		}

		
		$pdf->Output('Etiqueta Mostrador'.'.pdf');
	}
}

$codigosBarra = new imprimirCodigosBarra();
$codigosBarra -> crearPDFCodsBarra();

