<?php
session_start();
require_once "../../../modelos/movimientos-bancarios.modelo.php";
$datosCompromiso = ModeloMovimientosBancarios::mdlMostrarCompromisosPago('compromisos_pago', 'id', $_GET['id']);


require_once('../tcpdf.php');
require_once('../../fpdi/autoload.php');

use setasign\Fpdi\Tcpdf\Fpdi;

$pdf = new Fpdi();

$pdf->SetAutoPageBreak(true, 40);
$pdf->AddPage('P', 'A4');
$pdf->setPrintHeader(false);
// $pdf->AddPage();
$pdf->SetFont('freesans', '', 12);
$abonos=json_decode($datosCompromiso["abonos"],true);

$html = '<h1 style="text-align:center">'.strtoupper($datosCompromiso['descripcion']).'</h1>';
$html .= '	<table style="width:100%">
				<tr style="font-size:12px">
					<th><b>PAGO</b></th>
					<th><b>DETALLE</b></th>
					<th><b>SALDO</b></th>
				</tr>
				<tr style="font-size:12px">
					<td></td>
					<td>MONTO COMPRA</td>
					<td>$ '.number_format($datosCompromiso['monto'],0,',','.').'</td>
				</tr>';

$saldo = $datosCompromiso['monto']; 
for ($i=0; $i < count($abonos); $i++) { 
	$saldo -= $abonos[$i]['monto'];
	if($abonos[$i]['tipo'] == 'nc'){		
		$html .= '
			<tr style="font-size:12px; color:blue">
				<td>- $'.number_format($abonos[$i]['monto'],0,',','.').'</td>
				<td>NC (Nro:'.number_format($abonos[$i]['nro'],0,',','.').')</td>
				<td>$ '.number_format($saldo,0,',','.').'</td>
			</tr>';
	}else if($abonos[$i]['tipo'] == 'ab'){		
		// $monedaMostrar = $abonos[$i]['moneda'] == 'transf' ? 'Transferencia' : ucfirst($abonos[$i]['moneda']);
				// <td>AB: '.$monedaMostrar.'</td>
		$html .= '
			<tr style="font-size:12px; color:blue">
				<td>- $'.number_format($abonos[$i]['monto'],0,',','.').'</td>
				<td>$ '.number_format($saldo,0,',','.').'</td>
			</tr>';
	}
}

$saldo -= $datosCompromiso['monto_pagado'];
$html .= '</table>';
$pdf->writeHTML($html, false, false, false, false, '');

for ($i=0; $i < count($abonos); $i++) { 
	if($abonos[$i]['tipo'] == 'ab'){
		if(substr($abonos[$i]['comprobante'], -4) == '.pdf'){ // DETECTA PDF
			$archivoFactura = '../../'.$abonos[$i]['comprobante'];
			if(file_exists($archivoFactura)){
				$pdf->setSourceFile('../../'.$abonos[$i]['comprobante']);
				$pdfFactura = $pdf->importPage(1);
				$pdf->AddPage('P', 'A4');
				$pdf->useTemplate($pdfFactura);
			}
		}else{ // SI ES IMAGEN
			$pdf->AddPage('P', 'A4');
			$html = '<img src="../../../'.$abonos[$i]['comprobante'].'">';
			$pdf->writeHTML($html, false, false, false, false, '');
		}
	}
}

$pdf->Output('Detalles Pago '.$datosCompromiso['descripcion'].'.pdf', 'I');
