<?php
session_start();
if (!isset($_SESSION['id'])) {
    header("Location: ../../../inicio");
    exit();
}

require_once "../../../controladores/ventas.controlador.php";
require_once "../../../modelos/ventas.modelo.php";
require_once "../../../controladores/clientes.controlador.php";
require_once "../../../modelos/clientes.modelo.php";
require_once "../../../controladores/movimientos.controlador.php";
require_once "../../../modelos/movimientos.modelo.php";
require_once "../../../controladores/usuarios.controlador.php";
require_once "../../../modelos/usuarios.modelo.php";
require_once "../../../controladores/ajustes.controlador.php";
require_once "../../../modelos/ajustes.modelo.php";

class historialCliente{


public function mostrarHistorial(){

//TRAEMOS LA INFORMACIÓN DE LA VENTA
$item = 'id';
$valor = $_GET["id"];
$cliente = ControladorClientes::ctrMostrarClientes($item, $valor);
$apellidos = explode(" ", $cliente["apellido"]);
$nombres = explode(" ", $cliente["nombre"]);
$nombre = strtoupper($nombres[0].' '.$apellidos[0].' ('.$cliente["referencia"].')');
$orden = 'ASC';
$movimientosCredito = ModeloMovimientos::mdlHistorialCredIntCliente($valor, $orden);
date_default_timezone_set("America/Santiago");
require_once('tcpdf_include.php');
// $titulo = 'RESUMEN VENTAS CON CRÉDITO INTERNO';
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// $pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, $titulo, $nombre.'                                         '.date('d/m/Y H:i:s', strtotime(date('Y-m-d H:i:s'))));

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
// $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

$pdf->setPrintHeader(false);
$pdf->setFooterData(array(0,64,0), array(0,64,128));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
// $pdf->SetFooterMargin(PDF_MARGIN_FOOTER); // HOJAS
$pdf->startPageGroup();
$pdf->AddPage();

$fechaHora = ControladorAjustes::ctrFechaHora();

$bloque0 = '<table>
				<tr>
					<td style="width:20px; border-bottom: 0.5px solid #000000;"></td>
					<td style="width:70px; border-bottom: 0.5px solid #000000;"><img src="'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"></td>
					<td style="width:20px; border-bottom: 0.5px solid #000000;"></td>
					<td style="background-color:white; width:400px; border-bottom: 0.5px solid #000000;">
						<div style="font-size:11px; text-align:left; line-height:15px;">
							ESTADO DE CUENTA RESUMIDO (VENTAS)<br>
							<b>'.$nombre.'</b>                                                 <font size="-3">'.date('d/m/Y H:i:s', strtotime($fechaHora)).'</font>
						</div>
					</td>
				</tr>
			</table>
			<br><br>';

$pdf->writeHTML($bloque0, false, false, false, false, '');



/*=============================================
                 CABECERA           
=============================================*/
$bloque1 =
	
	'<br>
	<table style="font-size:8px; padding:5px 2px;">
		<tr>
			<td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center"><b>#</b></td>		
			<td style="border: 0.5px solid #000000; background-color:white; width:55px; text-align:center"><b>FECHA</b></td>		
			<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center"><b>TIPO MOVIMIENTO</b></td>
			<td style="border: 0.5px solid #000000; background-color:white; width:100px; text-align:center"><b>TIPO MONEDA</b></td>
			<td style="border: 0.5px solid #000000; background-color:white; width:100px; text-align:center"><b>CODIGO</b></td>
			<td style="border: 0.5px solid #000000; background-color:white; width:75px; text-align:center"><b>MONTO ($)</b></td>
			<td style="border: 0.5px solid #000000; background-color:white; width:75px; text-align:center"><b>SALDO ($)</b></td>
		</tr>
	</table><br>';

$pdf->writeHTML($bloque1, false, false, false, false, '');		
	
$tabla = '';
$saldoAntiguo = 0;
$nro = 0;

if(count($movimientosCredito)<=25){ // si hay menos de 25 movs
	$saldo = 0;
	foreach($movimientosCredito as $key => $value) {
		$codigoVenta = $value['cod_venta'];
		$fecha = date("d/m/Y", strtotime($value['fecha_cont']));
		if($value['estado']=='abClient'){
			$tipo_mov = 'ABONO';
			$saldo -= $value['total'];
			$color = 'color:blue';
		}else if($value['estado']=='dctoClient'){
			$tipo_mov = 'DESCUENTO';
			$saldo -= $value['total'];
			$color = 'color:blue';
		}else if($value['estado']=='anticipoClient'){
			$tipo_mov = 'ANTICIPO';	
			$saldo -= $value['total'];
			$color = 'color:green';
		}else if($value['estado']=='abPrest'){
			$tipo_mov = 'AB. PRÉSTAMO';	
			$saldo -= $value['total'];
			$color = 'color:green';
		}else if($value['estado']=='prestTerc'){
			$tipo_mov = 'PRÉSTAMO';	
			$saldo += $value['total'];
			$color = 'color:purple';
		}else if($value['estado']=='devClient'){
			$tipo_mov = 'DEVOLUCIÓN';	
			$saldo += $value['total'];
			$color = 'color:black';
		}else{
			$codigoVenta = '<a href="boleta-carta.php?codigo='.$value['id'].'&motivo=ver" target="_blank">'.$value['cod_venta'].'</a>';
			$tipo_mov = 'COMPRA';	
			$saldo += $value['total'];
			$color = 'color:red';
		}
		$saldoMostrar = number_format($saldo,0,',','.');
		$total = number_format($value['total'],0,',','.');

		if($value['tipo_pago']=='ef'){
			$moneda = 'EFECTIVO';
		}else if($value['tipo_pago']=='transf'){
			$moneda = 'TRANSFERENCIA';	
		}else if($value['tipo_pago']=='td'){
			$moneda = 'T. DÉBITO';	
		}else if($value['tipo_pago']=='tc'){
			$moneda = 'T. CRÉDITO';	
		}else if($value['tipo_pago']=='dcto'){
			$moneda = 'DESCUENTO';	
		}else{
			$moneda = 'CRÉDITO INTERNO';		
		}


		if($saldo == 0){
			$tabla = '';
			$nro = 0;
		}else{
			$nro = $nro+1;
			$tabla .=  '<table style="font-size:8px; padding:5px 2px;">
							<tr>
								<td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center; '.$color.'">'.$nro.'</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:55px; text-align:center; '.$color.'">'.$fecha.'</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; '.$color.'">'.$tipo_mov.'</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:100px; text-align:center; '.$color.'">'.$moneda.'</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:100px; text-align:center; '.$color.'">'.$codigoVenta.'</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:75px; text-align:center; '.$color.'">'.$total.'</td>
								<td style="border: 0.5px solid #000000; background-color:white; width:75px; text-align:center; '.$color.'">'.$saldoMostrar.'</td>
							</tr>
						</table>';
		}
	}


}else{ // si hay mas de 25 movs


	foreach ($movimientosCredito as $key => $value) {

		if($key<count($movimientosCredito)-25){	// SALDO ANTES DE LOS ULTIMOS 30 MOVIMIENTO 
			if($value['estado']=='abClient'){
				$saldoAntiguo -= $value['total'];
			}else if($value['estado']=='dctoClient'){
				$saldoAntiguo -= $value['total'];
			}else if($value['estado']=='anticipoClient'){
				$saldoAntiguo -= $value['total'];
			}else if($value['estado']=='abPrest'){
				$saldoAntiguo -= $value['total'];
			}else if($value['estado']=='prestTerc'){
				$saldoAntiguo += $value['total'];
			}else if($value['estado']=='devClient'){
				$saldoAntiguo += $value['total'];
			}else{ // VENTA
				$saldoAntiguo += $value['total'];
			}
		}
	}


	$saldoMostrar = number_format($saldoAntiguo,0,',','.');
	$fechaSaldoAntiguo =  date("d/m/Y", strtotime($movimientosCredito[count($movimientosCredito)-25-1]['fecha_cont']));
	$fecha = date("d/m/Y", strtotime($value['fecha_cont']));

	// PRIMERA FILA CON EL SALDO ANTERIOR A LOS SIGUIENTES 25 MOVIMIENTOS
	$tabla .= '<table style="font-size:8px; padding:5px 2px;"><tr><td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center;">-</td><td style="border: 0.5px solid #000000; background-color:white; width:55px; text-align:center;">'.$fechaSaldoAntiguo.'</td><td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center;">SALDO ANTERIOR</td><td style="border: 0.5px solid #000000; background-color:white; width:100px; text-align:center;">SALDO</td><td style="border: 0.5px solid #000000; background-color:white; width:100px; text-align:center;">-</td><td style="border: 0.5px solid #000000; background-color:white; width:75px; text-align:center;">-</td><td style="border: 0.5px solid #000000; background-color:white; width:75px; text-align:center;">'.$saldoMostrar.'</td></tr></table>';

	// LOS SIGUIENTES MOVIMIENTOS
	$nro = 0;
	$saldo = $saldoAntiguo;
	foreach($movimientosCredito as $key => $value) {
		$codigoVenta = $value['cod_venta'];
		if($key>=count($movimientosCredito)-25){	// SALDO ANTES DE LOS ULTIMOS 30 MOVIMIENTO 
			$fecha = date("d/m/Y", strtotime($value['fecha_cont']));
			if($value['estado']=='abClient'){
				$tipo_mov = 'ABONO';
				$saldo -= $value['total'];
				$color = 'color:blue';
			}else if($value['estado']=='dctoClient'){
				$tipo_mov = 'DESCUENTO';
				$saldo -= $value['total'];
				$color = 'color:blue';
			}else if($value['estado']=='anticipoClient'){
				$tipo_mov = 'ANTICIPO';	
				$saldo -= $value['total'];
				$color = 'color:green';
			}else if($value['estado']=='abPrest'){
				$tipo_mov = 'AB. PRÉSTAMO';	
				$saldo -= $value['total'];
				$color = 'color:green';
			}else if($value['estado']=='prestTerc'){
				$tipo_mov = 'PRÉSTAMO';	
				$saldo += $value['total'];
				$color = 'color:purple';
			}else if($value['estado']=='devClient'){
				$tipo_mov = 'DEVOLUCIÓN';	
				$saldo += $value['total'];
				$color = 'color:black';
			}else{
				$codigoVenta = '<a href="boleta-carta.php?codigo='.$value['id'].'&motivo=ver" target="_blank">'.$value['cod_venta'].'</a>';
				$tipo_mov = 'COMPRA';	
				$saldo += $value['total'];
				$color = 'color:red';
			}
			$saldoMostrar = number_format($saldo,0,',','.');
			$total = number_format($value['total'],0,',','.');

			if($value['tipo_pago']=='ef'){
				$moneda = 'EFECTIVO';
			}else if($value['tipo_pago']=='transf'){
				$moneda = 'TRANSFERENCIA';	
			}else if($value['tipo_pago']=='td'){
				$moneda = 'T. DÉBITO';	
			}else if($value['tipo_pago']=='tc'){
				$moneda = 'T. CRÉDITO';	
			}else if($value['tipo_pago']=='dcto'){
				$moneda = 'DESCUENTO';	
			}else{
				$moneda = 'CRÉDITO INTERNO';		
			}


			if($saldo == 0){
				$tabla = '';
				$nro = 0;
			}else{
				$nro += 1;
				$tabla .= '<table style="font-size:8px; padding:5px 2px;"><tr><td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center; '.$color.'">'.$nro.'</td><td style="border: 0.5px solid #000000; background-color:white; width:55px; text-align:center; '.$color.'">'.$fecha.'</td><td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; '.$color.'">'.$tipo_mov.'</td><td style="border: 0.5px solid #000000; background-color:white; width:100px; text-align:center; '.$color.'">'.$moneda.'</td><td style="border: 0.5px solid #000000; background-color:white; width:100px; text-align:center; '.$color.'">'.$codigoVenta.'</td><td style="border: 0.5px solid #000000; background-color:white; width:75px; text-align:center; '.$color.'">'.$total.'</td><td style="border: 0.5px solid #000000; background-color:white; width:75px; text-align:center; '.$color.'">'.$saldoMostrar.'</td></tr></table>';

			}
		}
	}

}
$pdf->writeHTML($tabla, false, false, false, false, '');

/*=============================================
               PIE DE PAGINA           
=============================================*/

if($saldo>0){// DATOS DE TRANSFERENCIA SI HAY DEUDA

	$nombreBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_banco')['ajuste'];
	$tipoCuentaBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'tipo_cuenta_banco')['ajuste'];
	$nroCuentaBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nro_cuenta_banco')['ajuste'];
	$nombreTitularBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_titular_banco')['ajuste'];
	$rutTitularBanco = explode('-',ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_titular_banco')['ajuste']);
	$rutMostrar = number_format($rutTitularBanco[0],0,',','.').'-'.$rutTitularBanco[1];
	$correoPagosBanco = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_pagos_banco')['ajuste'];



	$datosPiePagina =
		
		'<table>
			<tr><td></td></tr>
			<tr><td>EL SALDO ADEUDADO ES DE <b>$ '.$saldoMostrar.'.-</b></td></tr>
			<tr><td></td></tr>
			<tr><td><b>DATOS PARA TRANSFERENCIA:</b></td></tr>
			<tr>
				<td style="width:120px; text-align:left; font-size:8px; padding:0px 2px;">
					BANCO <br>
					TIPO DE CUENTA<br>
					NRO. DE CUENTA<br>
					TITULAR<br>
					RUT<br>
					CORREO CONFIRMACIÓN
				</td>
				<td style="width:5px; text-align:left; font-size:8px; padding:0px 2px;">
					:<br>
					:<br>
					:<br>
					:<br>
					:<br>
					:<br>
				</td>
				<td style="width:240px; text-align:left; font-size:8px; padding:0px 2px;">
					BANCO '.strtoupper($nombreBanco).'<br>
					'.strtoupper($tipoCuentaBanco).'<br>
					'.$nroCuentaBanco.'<br>
					'.strtoupper($nombreTitularBanco).'<br>
					'.$rutMostrar.'<br>
					'.strtolower($correoPagosBanco).'<br>
				</td>
			</tr>
		</table>';
	$pdf->writeHTML($datosPiePagina, false, false, false, false, '');
}else if($saldo<0){
	$saldoMostrar = number_format(-$saldo,0,',','.');
	$datosPiePagina = 
		'<table>	
			<tr><td></td></tr>
			<tr><td>TIENES UN SALDO A FAVOR DE <b>$ '.$saldoMostrar.'.-</b></td></tr>
		</table>';
	$pdf->writeHTML($datosPiePagina, false, false, false, false, '');
}else{
	$datosPiePagina =
		'<table>	
			<tr><td></td></tr>
			<tr><td>NO TIENES SALDO ADEUDADO, ESTÁS AL DÍA</td></tr>
		</table>';
	$pdf->writeHTML($datosPiePagina, false, false, false, false, '');
}


$pdf->Output('MOVIMIENTOS CUENTA '.$nombre.'.pdf');

}

}

$historial = new historialCliente();
$historial -> mostrarHistorial();


?>