<?php

require_once "../../../controladores/ventas.controlador.php";
require_once "../../../modelos/ventas.modelo.php";
require_once "../../../controladores/cotizador.controlador.php";
require_once "../../../modelos/cotizador.modelo.php";
require_once "../../../controladores/clientes.controlador.php";
require_once "../../../modelos/clientes.modelo.php";
require_once "../../../controladores/usuarios.controlador.php";
require_once "../../../modelos/usuarios.modelo.php";
require_once "../../../controladores/productos.controlador.php";
require_once "../../../modelos/productos.modelo.php";
require_once "../../../controladores/ajustes.controlador.php";
require_once "../../../modelos/ajustes.modelo.php";

class imprimirCotizacion{

public $codigo;

public function traerImpresionCotizacion(){

//TRAEMOS LA INFORMACIÓN DE LA VENTA

$itemVenta = "id";
$nroCot = $this->codigo;

$respuestaCotizacion = ControladorCotizaciones::ctrMostrarCotizaciones($itemVenta, $nroCot);

// $fecha = substr($respuestaCotizacion["fecha"],0,-8);
$fechaIngreso = $respuestaCotizacion["fecha_ingreso"]; 
$fechaExpiracion = $respuestaCotizacion["fecha_expiracion"]; 
$productos = json_decode($respuestaCotizacion["productos"], true);
$neto = number_format($respuestaCotizacion["neto"],0,',','.');
$impuesto = number_format($respuestaCotizacion["iva"],0,',','.');
$total = number_format($respuestaCotizacion["total"],0,',','.');
$totalConRecargo = number_format($respuestaCotizacion["total"]*1.05,0,',','.');

//TRAEMOS LA INFORMACIÓN DEL CLIENTE

$itemCliente = "id";
$valorCliente = $respuestaCotizacion["id_client"];
if($respuestaCotizacion["id_client"]==0){
$nomNew = explode(" (",$respuestaCotizacion["nom_client"]);
$nomClient = $nomNew[0];
}else{
$respuestaCliente = ControladorClientes::ctrMostrarClientes($itemCliente, $valorCliente);
$apellidos = explode(" ", $respuestaCliente["apellido"]);
$nomClient = '<b>'.$respuestaCliente["nombre"].' '.$apellidos[0].'</b>';
}



//TRAEMOS LA INFORMACIÓN DEL VENDEDOR

$itemVendedor = "id";
$valorVendedor = $respuestaCotizacion["id_vendedor"];

$respuestaVendedor = ControladorUsuarios::ctrMostrarUsuarios($itemVendedor, $valorVendedor);

//REQUERIMOS LA CLASE TCPDF
require_once('tcpdf_include.php');
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf-> setPrintHeader(false);
$pdf->startPageGroup();
$pdf->AddPage();

$nombreComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_comercial')['ajuste']);
$nombreReal = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_real')['ajuste']);
$rutComercio = explode('-',ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_comercial')['ajuste']);
$rutMostrar = number_format($rutComercio[0],0,',','.').'-'.$rutComercio[1];
$direccionComercio = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'direccion_comercial')['ajuste']);
$wsp = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_cot')['ajuste'];
$fono = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_cot')['ajuste'];
if($fono == ''){
	$fonoCot = '';
}else{
	$fonoCot = 'Fono-Ventas: '.$fono.'<br>';
}
$correo = strtolower(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_cot')['ajuste']);
$logo = 'src="'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"';

$bloque1 = <<<EOF
	<table>
		<tr>
			<td style="width:150px"><img $logo></td>
			<td style="background-color:white; width:140px">
				<div style="font-size:8.5px; text-align:right; line-height:15px;">
					<br>
					$nombreComercio
					<br>
					$nombreReal
					<br>
					$rutMostrar
					<br>
					Dirección: $direccionComercio
				</div>
			</td>
			<td style="background-color:white; width:140px">
				<div style="font-size:8.5px; text-align:right; line-height:15px;">
					<br>
					Whatsapp: $wsp
					<br>
					$fonoCot
					$correo
				</div>
			</td>
			<td style="background-color:white; width:110px; text-align:center"><br><br>Cotización Nro. <br>$nroCot</td>
		</tr>
	</table>
EOF;
$pdf->writeHTML($bloque1, false, false, false, false, '');

// ---------------------------------------------------------

$bloque2 = <<<EOF

	<table>
		
		<tr>
			
			<td style="width:540px"><img src="images/back.jpg"></td>
		
		</tr>

	</table>

	<table style="font-size:10px; padding:5px 10px;">
	
		<tr>
		
			<td style="border: 1px solid #333; background-color:white; width:240px">
					
					
					<font size="+2">Cliente: $nomClient</font>
				
			</td>

			<td style="border: 1px solid #333; background-color:white; width:145px; text-align:left">
			
				Fecha Ingreso: $fechaIngreso

			</td>

			<td style="border: 1px solid #333; background-color:white; width:155px; text-align:left">
			
				Fecha Expiración: $fechaExpiracion

			</td>

		</tr>

		<tr>
		
			<td style="border: 1px solid #333; background-color:white; width:540px">

				<font size="+2">Vendedor: <b>$respuestaVendedor[nombre]</b></font>
			
			</td>

		</tr>

		<tr>
		
		<td style="border-bottom: 1px solid #333; background-color:white; width:540px"></td>

		</tr>

	</table>

EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');

// ---------------------------------------------------------

$bloque3 = <<<EOF
	<table style="font-size:10px; padding:5px 3px;">
		<tr>
			<td style="border: 1px solid #333; background-color:white; width:35px; text-align:center; font-size:8px"><b>Cant</b></td>
			<td style="border: 1px solid #333; background-color:white; width:50px; text-align:center; font-size:8px"><b>Código</b></td>
			<td style="border: 1px solid #333; background-color:white; width:320px; text-align:left; font-size:8px"><b>Productos</b></td>
			<td style="border: 1px solid #333; background-color:white; width:65px; text-align:center; font-size:8px"><b>$ Neto</b></td>
			<td style="border: 1px solid #333; background-color:white; width:70px; text-align:center; font-size:8px"><b>Total</b></td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

// ---------------------------------------------------------
$netoAcum = 0;
foreach(array_reverse($productos) as $key => $item) {

$itemProducto = "id";
$valorProducto = $item["id"];
$orden = 'id';
$cantCotizada = $item["cant"];

$respuestaProducto = ControladorProductos::ctrMostrarProductos($itemProducto, $valorProducto, $orden);

if($item["pV"]>$item["tot"]/$item["cant"]){ // si pV es mayor que precio unitario asignado
$vUnit = "$".number_format($item["pV"], 0,',','.');
$vUnitDcto = number_format($item["tot"]/$item["cant"], 0,',','.');
$precioTotal = number_format($item["tot"], 0,',','.');
$netoAcum += $item["pV"]*$item["cant"];
// $pNormal = "<i>[Normal ".$vUnit."]</i>";
}else{
$vUnit = "$".number_format($item["pV"], 0,',','.');
$vUnitDcto = number_format(($item["tot"]/$item["cant"])/1.19, 2,',','.');
$precioTotal = number_format($item["tot"]/1.19, 0,',','.');
$netoAcum += ($item["tot"]/1.19);
// $pNormal = "";
}
// }else if($cantCotizada<=$respuestaProducto["mayor_sobre"] && $item["descuento"]>0){
// $valorUnitario = number_format($respuestaProducto["precio_venta"]*(1-$item["descuento"]/100), 0,',','.');
// $valorUnitario = number_format($item["total"]/$item["cantidad"], 0,',','.');
// }else{
// $valorUnitario = number_format($item["total"]/$item["cantidad"], 0,',','.');

// }
if ($respuestaProducto["sku"]==''){
	$codigoProd = '000000';
}else{
	$codigoProd = $respuestaProducto["sku"];
}

// if($item["dcto"]>0){
// $dcto = "(Dcto: ".$item["dcto"]."%)";
// }else{
// $dcto = "";
// }

$bloque4 = <<<EOF
	<table style="font-size:10px; padding:5px 3px;">
		<tr>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:35px; text-align:center; font-size:8px">
				$item[cant]
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:50px; text-align:center; font-size:8px">
				$codigoProd
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:320px; text-align:left; font-size:8px">
				$item[prod]
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:65px; text-align:center; font-size:8px">$ 
				$vUnitDcto
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:70px; text-align:center; font-size:8px">$ 
				$precioTotal
			</td>
		</tr>
	</table>
EOF;

$pdf->writeHTML($bloque4, false, false, false, false, '');

}

// ---------------------------------------------------------
$netoTotalCot = number_format($netoAcum, 0,',','.');
$ivaTotalCot = number_format(round(round($netoAcum)*0.19), 0,',','.');
$total = number_format(round($netoAcum)+round(round($netoAcum)*0.19), 0,',','.');
$bloque5 = <<<EOF


	<table style="font-size:10px; padding:5px 10px;">

		<tr>

			<td style="color:#333; background-color:white; width:113px; text-align:center"></td>
			<td style="color:#333; background-color:white; width:262px; text-align:center"></td>
			<td style="background-color:white; width:80px; text-align:center"></td>
			<td style="color:#333; background-color:white; width:85px; text-align:center"></td>

		</tr>
		
		<tr>
			<td style="width:100px"></td>		
			<td style="width:212px"></td>
			<td style="border: 1px solid #333; background-color:white; width:98px; text-align:center">
				NETO
			</td>
			
			<td style="border: 1px solid #333; color:#333; background-color:white; width:130px; text-align:center">
				$ $netoTotalCot
			</td>
		</tr>

		<tr>
			<td style="width:100px"></td>		
			<td style="width:212px"></td>
			<td style="border: 1px solid #333; background-color:white; width:98px; text-align:center">
				IVA
			</td>
			
			<td style="border: 1px solid #333; color:#333; background-color:white; width:130px; text-align:center">
				$ $ivaTotalCot
			</td>

		</tr>
		<tr>
			<td style="width:100px"></td>		
			<td style="width:212px"></td>
			<td style="border: 1px solid #333; width:98px; text-align:center; font-size:13px">
				<b>TOTAL</b>
			</td>
			
			<td style="border: 1px solid #333; color:#333; width:130px; text-align:center; font-size:13px">
				<b>$ $total</b>
			</td>

		</tr>
		<tr>
			<td style="color:#333; background-color:white; width:113px; text-align:left">Condición Despacho<br>Validez<br>Condición de Pago</td>		
			<td style="color:#333; background-color:white; width:262px; text-align:left">: Sin Despacho<br>: 5 días corridos<br>: Efectivo o Transferencia</td>
		</tr>
		<tr>
			<td style="color:#333; background-color:white; width:113px; text-align:left">Observaciones</td>		
			<td style="color:#333; background-color:white; width:427px; text-align:left">: Esta cotización <b>NO ASEGURA</b> disponibilidad del producto. Se solicita confirmar<br>  existencia al momento de la compra
			</td>
		</tr>


	</table>




EOF;

$pdf->writeHTML($bloque5, false, false, false, false, '');	
// }

$bloque6 = <<<EOF

	<table style="font-size:10px; padding:5px 10px;">

		<tr>
			<td></td>
		</tr>


		<tr>

			<td style="color:#333; background-color:white; ; text-align:left">
			Esperando que el contenido de la presente sea de su utilidad, me pongo a sus órdenes para cualquier duda al respecto. Atentamente,
			</td>

		</tr>


	</table>

	<table style="font-size:10px; padding:5px 10px;">

		<tr>
			<td style="width:300px"></td>

			<td style="color:#000; background-color:white; width:150px; text-align:center">
			$respuestaVendedor[nombre] <br>	$correo
			</td>
			<td style="width:90px"></td>

		</tr>

	</table>



EOF;

$pdf->writeHTML($bloque6, false, false, false, false, '');


// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 

//$pdf->Output('factura.pdf', 'D');
$pdf->Output(date("Ymd").' Cotizacion '.$respuestaCotizacion["id"].'.pdf');

}

}

$cotizacion = new imprimirCotizacion();
$cotizacion -> codigo = $_GET["codigo"];
$cotizacion -> traerImpresionCotizacion();

?>