<?php

require_once "../../../modelos/compras.modelo.php";
require_once "../../../controladores/productos.controlador.php";
require_once "../../../modelos/productos.modelo.php";
require_once "../../../controladores/ajustes.controlador.php";
require_once "../../../modelos/ajustes.modelo.php";

class imprimirCompra{
public function traerImpresionCompra(){


$item = 'id';
$valor = $_GET['codigo'];
$orden = "fecha";
$respuestaCompra = ModeloCompras::mdlMostrarCompra('compras', 'id', $valor);	

//REQUERIMOS LA CLASE TCPDF
require_once('tcpdf_include.php');
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf-> setPrintHeader(false);
$pdf->startPageGroup();
$pdf->AddPage();

$logo = 'src="'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"';
date_default_timezone_set("America/Santiago");
$fecha = date("d-m-Y H:i:s");
$sucursalProveedora = $respuestaCompra['nom_prov'];
$sucursalAbastecida = $respuestaCompra['sucursal_abastecida'];
// $titulo = 'INTERCAMBIO STOCK desde <b>'.strtoupper($respuestaCompra['nom_prov']).'</b> hacia <b>'.strtoupper($respuestaCompra['sucursal_abastecida']).'</b>     <span style="font-size:7px">'.$fecha.'</span>';
$titulo = 'Compra a <b>'.strtoupper($respuestaCompra['nom_prov']).'</b> ingresado en <b>'.strtoupper($respuestaCompra['sucursal_abastecida']).'</b>';


$factura = $respuestaCompra['factura'] == 0 ? '' : 'Fact: <b>'.$respuestaCompra['factura'].'</b>';
$guia = $respuestaCompra['guia'] == 0 ? '' : ' Guia: <b>'.$respuestaCompra['guia'].'</b>';
$otroDoc = $respuestaCompra['otro_doc'] == 0 ? '' : ' Otro: <b>'.$respuestaCompra['otro_doc'].'</b>';
$responsable = 'Responsable: '.$respuestaCompra['nom_trab'].'<br>';
$docsCompra = ($respuestaCompra['factura'] == 0 && $respuestaCompra['guia'] == 0 && $respuestaCompra['otro_doc'] == 0) ? $responsable.'s/Doc' : $responsable.$factura.$guia.$otroDoc;

$bloque1 = <<<EOF
	<table>
		<tr>
			<td style="width:50px"><img $logo></td>
			<td style="width:10px;"></td>
			<td style="width:350px;">$titulo</td>
			<td style="width:130px; text-align:right"><font size="8px">$docsCompra</font></td>

		</tr>
	</table>
EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

// ---------------------------------------------------------
$sucReceptora = strtoupper($sucursalAbastecida);
$bloque2 = <<<EOF

	<table style="font-size:8px; padding:5px 10px;">
		<tr>
			<td style="border: 1px solid #333; background-color:white; width:30px; text-align:center;"><b>#</b></td>
			<td style="border: 1px solid #333; background-color:white; width:100px; text-align:left;"><b>SKU</b></td>
			<td style="border: 1px solid #333; background-color:white; width:190px; text-align:left;"><b>PRODUCTOS</b></td>
			<td style="border: 1px solid #333; background-color:white; width:80px; text-align:center;"><b>ABASTECIDO<br>$sucReceptora</b></td>
			<td style="border: 1px solid #333; background-color:white; width:80px; text-align:center;"><b>STK ACTUAL<br>$sucReceptora</b></td>
			<td style="border: 1px solid #333; background-color:white; width:60px; text-align:center;"><b>CONTEO</b></td>
		</tr>
	</table>

EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');

// ---------------------------------------------------------

$productos = json_decode($respuestaCompra['abastecimiento'], true);
foreach(array_reverse($productos) as $key => $item) {
$nro = $key+1;
$idProducto = $item['id'];
$respuestaProducto = ControladorProductos::ctrMostrarProductos('id', $idProducto, 'fecha');
$sucursal = $respuestaCompra['sucursal_abastecida'];
$abastecido =  number_format($item['cant'],0,',','.');
$stock = number_format($respuestaProducto['stock_'.$sucursal],0,',','.');
$zona = $respuestaProducto['zona_'.$sucursalAbastecida];
$sku = $respuestaProducto["categoria"] <= 9 ? '0'.$respuestaProducto["sku"] : $respuestaProducto["sku"];

$bloque3 = <<<EOF

	<table style="font-size:8px; padding:5px 10px;">

		<tr>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:30px; text-align:center;">
				$nro
			</td>

			<td style="border: 1px solid #333; color:#333; background-color:white; width:100px; text-align:left;">
				<b>$zona</b>-$sku
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:190px; text-align:left;">
				$respuestaProducto[descripcion]
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:80px; text-align:left;">
				$abastecido
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:80px; text-align:left;">
				$stock
			</td>
			<td style="border: 1px solid #333; color:#333; background-color:white; width:60px; text-align:left;">
			</td>


		</tr>

	</table>


EOF;

$pdf->writeHTML($bloque3, false, false, false, false, '');

}

if($_GET['motivo']=='descarga'){
	$pdf->Output('Compra Nro.'.$respuestaCompra["id"].'.pdf', 'D');
}else if($_GET['motivo']=='ver'){
	$pdf->Output('Compra Nro.'.$respuestaCompra["id"].'.pdf');
}


}

}

$compra = new imprimirCompra();
$compra -> traerImpresionCompra();

