<?php
require_once "../../../controladores/clientes.controlador.php";
require_once "../../../modelos/clientes.modelo.php";

$item = null;
$valor = null;
$clientes = ControladorClientes::ctrMostrarClientes($item, $valor);
require_once('tcpdf_include.php');
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf-> setPrintHeader(false);
$pdf->setFooterData(array(0,64,0), array(0,64,128));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
$pdf->startPageGroup();
$pdf->AddPage();

/*=============================================
                 TITULO
=============================================*/
$bloque0 = <<<EOF
	<table>
		<tr>
			<td style="background-color:white; width:540px">	
				<div style="font-size:15px; text-align:center; line-height:15px;">
					LISTA DE CLIENTES
				</div>
			</td>
		</tr>
	</table>
	<br><br>
EOF;

$pdf->writeHTML($bloque0, false, false, false, false, '');

/*=============================================
                 CABECERA           
=============================================*/
$bloque1 = <<<EOF
	
	<br>

	<table style="font-size:8px; padding:5px 2px;">

		<tr>

		<td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center"><b>#</b></td>		
		<td style="border: 0.5px solid #000000; background-color:white; width:215px; text-align:center"><b>NOMBRE</b></td>		
		<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center"><b>TIPO CLIENTE</b></td>		
		<td style="border: 0.5px solid #000000; background-color:white; width:70px; text-align:center"><b>FONO</b></td>
		<td style="border: 0.5px solid #000000; background-color:white; width:150px; text-align:center"><b>CORREO</b></td>

		</tr>

	</table>
EOF;

$pdf->writeHTML($bloque1, false, false, false, false, '');

//----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

$color = 'black';
foreach ($clientes as $i => $val){
	if($val['id']!=1){
    	
    	$nombre = '<b>'.$val['nombre'].' '.$val['apellido'].'</b> ('.$val['referencia'].') <b><i>ID:'.$val['id'].'</i></b>';
        $tipo = mb_strtoupper($val['tipo_cliente']);

$bloque2 = <<<EOF

	<br>

	<table style="font-size:8px; padding:5px 2px;">

		<tr>

		<td style="border: 0.5px solid #000000; background-color:white; width:25px; text-align:center; $color">$i</td>		
		<td style="border: 0.5px solid #000000; background-color:white; width:215px; text-align:left; $color"> $nombre</td>		
		<td style="border: 0.5px solid #000000; background-color:white; width:80px; text-align:center; $color">$tipo</td>
		<td style="border: 0.5px solid #000000; background-color:white; width:70px; text-align:center; $color">$val[telefono]</td>
		<td style="border: 0.5px solid #000000; background-color:white; width:150px; text-align:left; $color"> $val[email]</td>

		</tr>

	</table>
EOF;

$pdf->writeHTML($bloque2, false, false, false, false, '');

	}
}

$pdf->Output('LISTA DE CLIENTES SAMA.pdf');

?>