<?php
session_start();
require_once "../../../controladores/ventas.controlador.php";
require_once "../../../modelos/ventas.modelo.php";
require_once "../../../controladores/clientes.controlador.php";
require_once "../../../modelos/clientes.modelo.php";
require_once "../../../controladores/usuarios.controlador.php";
require_once "../../../modelos/usuarios.modelo.php";
require_once "../../../controladores/productos.controlador.php";
require_once "../../../modelos/productos.modelo.php";
require_once "../../../controladores/ajustes.controlador.php";
require_once "../../../modelos/ajustes.modelo.php";

class imprimirVenta{
public function traerImpresionVenta(){

//TRAEMOS LA INFORMACIÓN DE LA VENTA
if(isset($_GET['codigo'])){ // accedero por id
	$itemVenta = "id";
	$valorVenta = $_GET['codigo'] != 'ultima' ? $_GET['codigo'] : ModeloVentas::mdlSeleccionarUltimoIdVenta($_SESSION['perfil'])['id']; // entrega id de ultima venta que puede ver el vendedor o administrador
}else if(isset($_GET['cod_venta'])){ // acceder por 
	$itemVenta = "cod_venta";
	$valorVenta = $_GET['cod_venta'];
}
$compItem = '=';
$compEstado = '!=';
$estado = 0;
$filOrden = 'fecha_cont';
$ord = 'DESC';
$respuestaVenta = ControladorVentas::ctrMostrarVentas($itemVenta, $valorVenta, $compItem, $compEstado, $estado, $filOrden, $ord);


$fecha = $respuestaVenta["fecha_venta"];
$productos = json_decode($respuestaVenta["productos"], true);
$total = number_format($respuestaVenta["total"],0,',','.');

//TRAEMOS LA INFORMACIÓN DEL CLIENTE
$itemCliente = "id";
$valorCliente = $respuestaVenta["id_cliente"];
if($respuestaVenta["id_cliente"]==0){
$nomNew = explode(" (",$respuestaVenta["nom_client"]);
$nomClient = $nomNew[0];
}else{
$respuestaCliente = ControladorClientes::ctrMostrarClientes($itemCliente, $valorCliente);
$apellidos = explode(" ", $respuestaCliente["apellido"]);
$nomClient = '<b>'.$respuestaCliente["nombre"].' '.$apellidos[0].'</b>';
}


//TRAEMOS LA INFORMACIÓN DEL VENDEDOR
$itemVendedor = "id";
$valorVendedor = $respuestaVenta["id_vendedor"];
$respuestaVendedor = ControladorUsuarios::ctrMostrarUsuarios($itemVendedor, $valorVendedor);


$cantProds = count($productos);
$multiplicador = $cantProds <= 5 ? 0 : ($cantProds-5)+1;
//REQUERIMOS LA CLASE TCPDF
require_once('tcpdf_include.php');
// PDF_MARGIN_LEFT = 15;
// PDF_MARGIN_RIGHT = 15;
$ancho = 58;
$largo = 58+5*$multiplicador;
$medidas = array($ancho, $largo); // Ajustar aqui segun los milimetros necesarios;
$pdf = new TCPDF('P', 'mm', $medidas, true, 'UTF-8', false);
$pdf->SetMargins(2, 4, 2);
$pdf->SetAutoPageBreak(false, PDF_MARGIN_BOTTOM); 
// $pdf->SetFooterMargin($PDF_MARGIN_FOOTER);
// $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
$pdf-> setPrintHeader(false);
$pdf->startPageGroup();
$pdf->AddPage();

$html = '';
$html .= '<font size="9px" style="text-align:center"><b>FERRETERIA SAMA</b><br>COMPROBANTE DE VENTA</font>';
$html .= '<br>--------------------------------------';

foreach(array_reverse($productos) as $key => $item){ // PRODUCTOS
	$producto = ModeloProductos::mdlMostrarProductos('productos','id', $item['id'], 'fecha');
	$html .= '<br><font size="8px" class="text-center"><b>'.$item['cant'].'</b></font> <font size="6px">'.strtoupper($producto['desc_sii']).'</font> <font size="8px"><b style="float:right">$'.number_format($item['tot'],0,',','.').'</b></font>';
}
$html .= '<br><br><font size="10px" style="text-align:right">TOTAL: $<b>'.$total.'</font>';

$datosDespacho = explode(' // ', $respuestaVenta['detalle_flete']);
$despacho = $respuestaVenta['detalle_flete'] == '' ? '' : '<font size="10px"><b>DESPACHO:</b><br></font><font size="8px">'.$datosDespacho[0].'<br>'.$datosDespacho[1].'<br>'.$datosDespacho[2].'</font>';
$html .= '<br><br><font size="10px" style="text-align:left">'.$despacho.'</font>';
$html .= '<br><br><br><br><br>';

$pdf->writeHTML($html, false, false, false, false, '');

// ---------------------------------------------------------
//SALIDA DEL ARCHIVO 
// ---------------------------------------------------------
if($_GET['motivo']=='descarga'){
	if($respuestaVenta["id_cliente"]==0){
		$pdf->Output('Detalle Venta Nro.'.$respuestaVenta["cod_venta"].'.pdf', 'D');
	}else{
		if($respuestaCliente['id']!=1){
			$pdf->Output('Detalle Venta Nro. '.$respuestaVenta["cod_venta"].' a '.$respuestaCliente['nombre'].' '.$respuestaCliente['apellido'].'.pdf', 'D');
		}else{
			$pdf->Output('Detalle Venta Nro.'.$respuestaVenta["cod_venta"].'.pdf', 'D');
		}
	}
}else if($_GET['motivo']=='ver'){
	if($respuestaVenta["id_cliente"]==0){
		$pdf->Output('Detalle Venta Nro.'.$respuestaVenta["cod_venta"].'.pdf');
	}else{
		if($respuestaCliente['id']!=1){
			$pdf->Output('Detalle Venta Nro. '.$respuestaVenta["cod_venta"].' a '.$respuestaCliente['nombre'].' '.$respuestaCliente['apellido'].'.pdf');
		}else{
			$pdf->Output('Detalle Venta Nro.'.$respuestaVenta["cod_venta"].'.pdf');
		}
	}
}

}

}

$boletaCarta = new imprimirVenta();
// $boletaCarta -> codigo = $_GET["codigo"];
$boletaCarta -> traerImpresionVenta();

?>