<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use Mike42\Escpos\Printer;
use Mike42\Escpos\EscposImage;
use Mike42\Escpos\PrintConnectors\FilePrintConnector;
use Mike42\Escpos\PrintConnectors\WindowsPrintConnector;

class ControladorVentas{

	/*=============================================
	MOSTRAR VENTAS
	=============================================*/
	static public function ctrMostrarVentas($item, $valor, $compItem, $compEstado, $estado, $filOrden, $ord){
			$tabla = "ventas";
			$respuesta = ModeloVentas::mdlMostrarVentas($tabla, $item, $valor, $compItem, $compEstado, $estado, $filOrden, $ord);
			return $respuesta;
	}
	static public function ctrMostrarVentasMes(){
			$tabla = "ventas";
			$respuesta = ModeloVentas::mdlMostrarVentasMes($tabla, $_SESSION['perfil']);
			return $respuesta;
	}
	static public function ctrVentasPeriodo($columna, $hora1, $hora2){
			$tabla = "ventas";
			$respuesta = ModeloVentas::mdlVentasPeriodo($tabla, $columna, $hora1, $hora2);
			return $respuesta;
	}
	static public function ctrVentasPorHora($columna, $hora1, $hora2, $fecha, $compEstado, $estado){
			$tabla = "ventas";
			$respuesta = ModeloVentas::mdlVentasPorHora($tabla, $columna, $hora1, $hora2, $fecha, $compEstado, $estado);
			return $respuesta;
	}


	/*=============================================
	CREAR VENTA
	=============================================*/
	static public function ctrCrearVenta(){
		$sucursal = $_SESSION['sucursal'];
		function title(Printer $printer, $text){
    		$printer->selectPrintMode(Printer::MODE_EMPHASIZED);
    		$printer->text("\n" . $text);
    		$printer->selectPrintMode();
    	}

		if(isset($_POST["totalVenta"])){
			// $pasoAPaso = [];
			date_default_timezone_set("America/Santiago");
			/*=============================================
			ACTUALIZAR LAS COMPRAS DEL CLIENTE Y REDUCIR EL STOCK Y AUMENTAR LAS VENTAS DE LOS PRODUCTOS
			=============================================*/
			if($_POST["listaProductos"] == ""){
				echo'
				<script>
					Swal.fire({
					  	icon: "error",
					  	title: "La venta no se ha ejecuta si no hay productos",
					  	showConfirmButton: true,
					  	confirmButtonText: "Cerrar"
					  	}).then(function(result){
							if (result.value) {
								window.location = "ventas";
								}
							})
				</script>';
			return;
			}

			$listaProductos = json_decode($_POST["listaProductos"], true);
			$totalProductosComprados = array();
		    $total = 0;
		    $pComp = 0;
		    $ahorro = 0;
			$ultimoRegistro = ModeloProductos::mdlSeleccionarUltimoIdRegistro();
		    $montoExtraible = 0;
			$informarFlete = 0;

		    // $totalExtraible = [];
			foreach ($listaProductos as $key => $value) {
			    array_push($totalProductosComprados, $value["cant"]);
			   	$tablaProductos = "productos";

			   	// TRAER PRODUCTO
			    $item = "id";
			    $valor = $value["id"];
			    $orden = "id";
			    $traerProducto = ModeloProductos::mdlMostrarProductos($tablaProductos, $item, $valor, $orden);
			    
				// PRODUCTO CON MONTO VENDIDO EXTRAIBLE
				if($traerProducto['monto_extraible'] == 1){
					$montoExtraible += 1;
				}

			    //  SUMA VENTAS DEL PRODUCTO PASO 0
				$item1a = "ventas_".$sucursal;
				$valor1a = $value["cant"] + $traerProducto["ventas_".$sucursal];
			    $nuevasVentas = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1a, $valor1a, $valor);

			    //  ACTUALIZA EL STOCK DEL PRODUCTO
				$item1b = "stock_".$sucursal;
				$stockPosteriorVenta = $traerProducto["stock_".$sucursal] - $value["cant"];
				$nuevoStock = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1b, $stockPosteriorVenta, $valor);

				$stockBodegas = 0;
				$bodegasExtraccion = [];
				$bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");

				foreach ($bodegas as $key_1 => $value_1) {
					$nombreBodega = $value_1['nombre_sucursal'];
					$stockBodegas += $traerProducto['stock_'.$nombreBodega];
					if($traerProducto['stock_'.$nombreBodega] > 0){
						array_push($bodegasExtraccion, $nombreBodega);
					}
				}

			    $divisorIdeal = $traerProducto['control_inventario'] == 1 ? 2 : 3; // si es primera prioridad se alerta cuando falta la mitad, si no cuando falta 1/3

				// notificacion Bot Telegram
				$tipoLocal = ModeloSucursales::mdlMostrarSucursales("sucursales", "nombre_sucursal", $_SESSION['sucursal'])[0]['tipo_sucursal'];
			    if($tipoLocal == 'local'){ // solo si esta en local de ventas se notifica telegram

					if($stockPosteriorVenta == 0 && $stockBodegas > 0){
	        			$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
	        			$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
						$imagenDB = $traerProducto['imagen']; // Ruta de la imagen que deseas enviar

						$descSiiTG = $traerProducto['desc_sii'];
						$skuTG = $traerProducto['categoria'] < 10 ? '0'.$traerProducto['sku'] : $traerProducto['sku'];
						
						if(count($bodegas) == 1){
							$zonaTG = $traerProducto['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto['zona_bodega1'].'</b>';
						}else{
							$zonaTG = '';
							for ($i=0; $i < count($bodegasExtraccion); $i++) { 
								$letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
								$nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números					
								$zonaMostrar = $traerProducto['zona_'.$bodegasExtraccion[$i]] == '' ? 's/ZONA' : $traerProducto['zona_'.$bodegasExtraccion[$i]];
								$zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.'</b>) ';
							}
						}

						$faltanteEnLocal = $traerProducto['stock_ideal_'.$sucursal] - $stockPosteriorVenta;
						$cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;


						$texto =	"‼️‼️‼️‼️ <b>REPONER URGENTE</b> ‼️‼️‼️‼️\n\n".
									"Descripción  : <b>".$descSiiTG."</b>\n".
									"SKU                  : <b>".$skuTG."</b>\n".
									"Zona                 : ".$zonaTG."\n".
									"Quedaron    : <b>".$stockPosteriorVenta.'/'.$traerProducto['stock_ideal_'.$sucursal]."</b>\n".
									"Reponer         : <b>".$cantSugerida."u</b>";
						$notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);
						// NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
						if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
							$notificarDB = ModeloProductos::mdlActualizarProducto($tablaProductos, 'notificacion_telegram_'.$sucursal, 1, $valor);
					    }
					}else if($stockPosteriorVenta <= ($traerProducto['stock_ideal_'.$sucursal]/$divisorIdeal) && $stockPosteriorVenta > 0 && $stockBodegas > 0 && $traerProducto['notificacion_telegram_'.$sucursal] == 0){

	        			$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
	        			$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
						$imagenDB = $traerProducto['imagen']; // Ruta de la imagen que deseas enviar

						$descSiiTG = $traerProducto['desc_sii'];
						$skuTG = $traerProducto['categoria'] < 10 ? '0'.$traerProducto['sku'] : $traerProducto['sku'];

						if(count($bodegas) == 1){
							$zonaTG = $traerProducto['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto['zona_bodega1'].'</b>';
						}else{
							$zonaTG = '';
							for ($i=0; $i < count($bodegasExtraccion); $i++) { 
								$letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
								$nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números					
								$zonaMostrar = $traerProducto['zona_'.$bodegasExtraccion[$i]] == '' ? 's/ZONA' : $traerProducto['zona_'.$bodegasExtraccion[$i]];
								$zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.'</b>) ';
							}
						}

						
						$faltanteEnLocal = $traerProducto['stock_ideal_'.$sucursal] - $stockPosteriorVenta;
						$cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;

						$texto =	"Descripción  : <b>".$descSiiTG."</b>\n".
						        	"SKU                  : <b>".$skuTG."</b>\n".
									"Zona                 : ".$zonaTG."\n".
									"Quedaron    : <b>".$stockPosteriorVenta.'/'.$traerProducto['stock_ideal_'.$sucursal]."</b>\n".
						        	"Reponer         : <b>".$cantSugerida."u</b>";
						$notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);
						// NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
						if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
							$notificarDB = ModeloProductos::mdlActualizarProducto($tablaProductos, 'notificacion_telegram_'.$sucursal, 1, $valor);
					    }
					}
			    }

			    //  ACTUALIZA FECHA MODIFICACION
				$item1b = "fecha_modif_".$sucursal;
				$valor1b = date('Y-m-d H:i:s');
				$fechaModif = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1b, $valor1b, $valor);
   				
				//REGISTRO ACTIVIDAD
				$regActividadVenta = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'venta', $value['cant'], '', $value['id'], $_SESSION['id'], $_SESSION['nombre']);


				$skuProdComun = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'sku_prod_comun')['ajuste'];
				$skuFlete = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'sku_flete')['ajuste'];

			    // UTILIDAD
				if($value['sku'] == '000000' || $value['sku'] == $skuProdComun || $value['sku'] == $skuFlete){ // NO SUMA UTILIDAD NI AHORRO EN PRODUCTOS (FLETE Y PRODUCTO COMUN) 
		      		if($value['sku'] == $skuFlete){
						$informarFlete += 1;
					}

		      		$total += 0; // UTILIDAD
		      		$pComp += 0; // UTILIDAD
				    $ahorro += 0; // AHORRO CLIENTE
				}else{				
		      		$total += $value['tot']; // UTILIDAD
		      		$pComp += $value['cant']*$value['pC']; // UTILIDAD
				    $ahorro += $value['cant']*round(($value['pV']*100/(100-$value['dcto']))-$value['pV']); // AHORRO CLIENTE
				}

				$ut = ceil($total-$pComp);
			    $utNeta = round($ut/1.19,0);
			}

			$tablaClientes = "clientes";
			$item = "id";
			$valor = $_POST["seleccionarCliente"];
			$traerCliente = ModeloClientes::mdlMostrarClientes($tablaClientes, $item, $valor);
			$vistaVendedor = $traerCliente['tipo_cliente'] == 'propietario' ? 0 : 1;

			$item1a = "prods_comprados";
			$valor1a = array_sum($totalProductosComprados) + $traerCliente["prods_comprados"];
			$comprasCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1a, $valor1a, $valor);

			$item1b = "ultima_compra";
			$fecha = date('Y-m-d');
			$hora = date('H:i:s');
			$valor1b = $fecha.' '.$hora;
			$fechaCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1b, $valor1b, $valor);

			// ACTUALIZAR DEUDA
			if($_POST["nuevoMetodoPago"] == 'Fiado'){				
				$item1_c = "deuda_cliente";
				$valor1_c = $traerCliente["deuda_cliente"] + $_POST["totalVenta"];
				$fechaCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1_c, $valor1_c, $valor);
			}


			$item1 = 'fecha';
	        $valor1 = date('Y-m-d');
			$item2 = 'tipo_mov';
	        $valor2 = 'saldo';
	        $diaCerrado = ControladorMovimientos::ctrMovSi2LI($item1, $valor1, $item2, $valor2);
	        if(count($diaCerrado)==0){
	        	$fechaCont = date('Y-m-d'); 
	        }else{
	        	$fechaCont =  date('Y-m-d', strtotime('+1 day')); 
	        }

	        $ultimaVenta = ModeloVentas::mdlUltimaVentaDia($fechaCont);

			/*=============================================
			GUARDAR LA COMPRA
			=============================================*/	
			$tabla = "ventas";
			$totalVenta = $_POST["totalVenta"];

			// REDONDEO
			if(isset($_POST["nuevoValorEfectivo"])){
				$resto = $_POST["totalVenta"] % 10;
				if($resto<6){
					$totalVenta = $_POST["totalVenta"]-$resto;
				}else{
					$totalVenta = $_POST["totalVenta"]+(10-$resto);
				}
			}

			if($ultimaVenta['ultimo']==null){
				$codVenta = substr(str_replace("-", "", $fechaCont),2)."001";
			}else{
				$correlativo = intval($ultimaVenta['ultimo'])+1;
				if($correlativo>9 && $correlativo<=99){
					$codVenta = substr(str_replace("-", "", $fechaCont),2)."0".$correlativo;
				}else if($correlativo>99){
					$codVenta = substr(str_replace("-", "", $fechaCont),2).$correlativo;					
				}else{
					$codVenta = substr(str_replace("-", "", $fechaCont),2)."00".$correlativo;										
				}
			}

			// REGISTRO MONTO EXTRAIBLE EN DB

			$deteccionExtraibles = $montoExtraible > 0 ? 1 : 0;
			
			// INSERTAR COD VENTA EN REGISTRO INVENTARIO
			$codVentaActividad = ModeloProductos::mdlActualizarProducto('actividad_inventario', 'detalle', $codVenta, $ultimoRegistro[0]+1);
			$detalleVenta = str_replace('"',"''",$_POST["detalleVenta"]); // QUITA COMILLAS DOBLES Y LAS REEMPLAZA POR 2 COMILLAS SIMPLES
		    $detalleVenta = str_replace(','," ",$detalleVenta); // QUITA COMAS
			$detalleVenta = strtoupper(preg_replace("/[\r\n|\n|\r]+/", ". ", $detalleVenta)); // ELIMINA SALTOS DE LINEA

			$detalleFlete = str_replace('"',"''",$_POST["detalleFlete"]); // QUITA COMILLAS DOBLES Y LAS REEMPLAZA POR 2 COMILLAS SIMPLES
		    $detalleFlete = str_replace(','," ",$detalleFlete); // QUITA COMAS
			$detalleFlete = strtoupper(preg_replace("/[\r\n|\n|\r]+/", ". ", $detalleFlete)); // ELIMINA SALTOS DE LINEA


			// PRODUCTOS SUGERIDOS
			$prodsSugeridos = $_POST['listaVentaProdsRelacionados'];
			$listaProdsSugeridos = json_decode($_POST["listaVentaProdsRelacionados"], true);
			$totalProdsSugeridos = 0;
			foreach ($listaProdsSugeridos as $key_1 => $value_1) {
				$totalProdsSugeridos += $value_1['tot'];
			}


			$fechaHora = ControladorAjustes::ctrFechaHora();
			
			// DATOS 
			$datos = array("id_vendedor"=>$_POST["idVend"],
						   "cod_venta"=>$codVenta,
						   "nom_vend"=>$_POST["nomVend"],
						   "estado"=>1,
						   "vista_vendedor"=>$vistaVendedor,
						   "id_cliente"=>$_POST["seleccionarCliente"],
						   "nom_client"=>$_POST["nomClient"],
						   "rut_factura"=>$_POST["rutFactura"],
						   "productos"=>$_POST["listaProductos"],
						   "impuesto"=>$totalVenta-round($totalVenta/1.19),
						   "neto"=>round($totalVenta/1.19),
						   "total"=>$totalVenta,
						   "monto_extraible"=>$deteccionExtraibles,
						   "descuentos"=>$ahorro,
						   "detalle_venta"=>$detalleVenta,
						   "detalle_flete"=>$detalleFlete,
						   "prods_sugeridos_vendidos"=>$prodsSugeridos,
						   "total_prods_sugeridos"=>$totalProdsSugeridos,
						   "fecha_venta"=>$fechaHora,
						   "fecha_cont"=>$fechaCont,
						   "fecha"=>$fechaHora,
						   "utilidad_total"=>$ut,
						   "utilidad_neta"=>$utNeta,
						   "tipo_pago"=>$_POST['nuevoMetodoPago'],
						   "metodo_pago"=>$_POST["listaMetodoPago"]);
			$respuesta = ModeloVentas::mdlIngresarVenta($tabla, $datos);


			
			if($respuesta == "ok"){
				
				if($informarFlete == 1){

					$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
					$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_despachos')['ajuste'];
					require_once(dirname(__FILE__).'/../extensiones/tcpdf/tcpdf.php');
					$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
					$pdf-> setPrintHeader(false);
					$pdf->startPageGroup();
					$pdf->AddPage();

					$nombreComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_comercial')['ajuste']);
					$nombreReal = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_real')['ajuste']);
					$rutComercio = explode('-',ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_comercial')['ajuste']);
					$rutMostrar = number_format($rutComercio[0],0,',','.').'-'.$rutComercio[1];
					$direccionComercio = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'direccion_comercial')['ajuste']);
					$wsp = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_ventas')['ajuste'];
					$fonoVenta = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'] == '' ? '' : 'Fono-Ventas: '.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'].'<br>';
					$correo = strtolower(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_ventas')['ajuste']);
					$logo = 'src="'.dirname(__FILE__).'/../extensiones/tcpdf/pdf/'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"';

					$bloque1 = '
						<table>
						    <tr>
						      	<td style="width:150px"><img '.$logo.'></td>
						      	<td style="background-color:white; width:140px">
						        	<div style="font-size:8.5px; text-align:right; line-height:15px;">
						        		<br>'.$nombreComercio.'<br>'.$nombreReal.'<br>'.$rutMostrar.'<br>Dirección: '.$direccionComercio.'
						        	</div>
						      	</td>
						      	<td style="background-color:white; width:140px">
						        	<div style="font-size:8.5px; text-align:right; line-height:15px;">
						          		<br>Whatsapp: '.$wsp.'<br>'.$fonoVenta.'<br>'.$correo.'
						        	</div>
						      	</td>
						      	<td style="background-color:white; width:110px; text-align:center"><br><br>Venta Nro. <br>'.$codVenta.'</td>
						    </tr>
						</table>';
					$pdf->writeHTML($bloque1, false, false, false, false, '');

					// ---------------------------------------------------------

					$bloque2 = '
					  	<table><tr><td style="width:540px"><img src="images/back.jpg"></td></tr></table>

					  	<table style="font-size:10px; padding:5px 10px;">
					    	<tr>
					      		<td style="border: 1px solid #666; background-color:white; width:390px">Cliente: '.$_POST["nomClient"].'</td>
					      		<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">Fecha: '.$fechaHora.'</td>
					    	</tr>
					    	<tr>
					      		<td style="border: 1px solid #666; background-color:white; width:540px">Vendedor: '.$_POST["nomVend"].'</td>
					    	</tr>
					    	<tr>
					      		<td style="border-bottom: 1px solid #666; background-color:white; width:540px"></td>
					    	</tr>
					  	</table>';
					$pdf->writeHTML($bloque2, false, false, false, false, '');


					// ENCABEZADOS COLUMNAS
					$bloque3 = '

					  	<table style="font-size:10px; padding:5px 10px;">
					    	<tr>
								<td style="border: 1px solid #333; background-color:white; width:50px; text-align:center; font-size:9px"><b>CANT</b></td>
								<td style="border: 1px solid #333; background-color:white; width:55px; text-align:left; font-size:9px"><b>COD</b></td>
								<td style="border: 1px solid #333; background-color:white; width:270px; text-align:left; font-size:9px"><b>PRODUCTOS</b></td>
								<td style="border: 1px solid #333; background-color:white; width:80px; text-align:center; font-size:9px"><b>$ UNIT. C/IVA</b></td>
								<td style="border: 1px solid #333; background-color:white; width:85px; text-align:center; font-size:9px"><b>VALOR TOTAL</b></td>
					    	</tr>
					  	</table>';
					$pdf->writeHTML($bloque3, false, false, false, false, '');


					foreach(array_reverse($listaProductos) as $key => $item) {
						$valorUnitarioNeto = number_format(($item["tot"]/$item["cant"])/1.19, 2,',','.');
						$valorUnitario = number_format($item["tot"]/$item["cant"], 0,',','.');
						$precioUnitario = '$ '.$valorUnitario;
						$dcto = $item["dcto"] > 0 ? "<b>(Dcto: ".$item["dcto"]."%)</b>" : "";
						$precioTotal = number_format($item["tot"], 0,',','.');

						$bloque4 = '
					    	<table style="font-size:10px; padding:5px 10px;">
					      		<tr>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:50px; text-align:center; font-size:9px">'.$item['cant'].'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:55px; text-align:left; font-size:9px">'.$item['sku'].'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:270px; text-align:left; font-size:9px">'.$item['prod'].' '.$dcto.'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:80px; text-align:center; font-size:9px">'.$precioUnitario.'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:85px; text-align:center; font-size:9px">$ '.$precioTotal.'</td>
					      		</tr>
					    	</table>';
						$pdf->writeHTML($bloque4, false, false, false, false, '');
					}

					$bloque5 = '
						<table style="font-size:10px; padding:5px 10px;">
					    	<tr>
					      		<td style="color:#333; background-color:white; width:340px; text-align:center"></td>
					      		<td style="border-bottom: 1px solid #666; background-color:white; width:100px; text-align:center"></td>
					      		<td style="border-bottom: 1px solid #666; color:#333; background-color:white; width:100px; text-align:center"></td>
					    	</tr>
					    	<tr>
					      		<td style="border-right: 1px solid #666; color:#333; background-color:white; width:340px; text-align:center"></td>
								<td style="border: 1px solid #666; background-color:white; width:100px; text-align:center">TOTAL:</td>
								<td style="border: 1px solid #666; color:#333; background-color:white; width:100px; text-align:center">$ '.number_format($totalVenta,0,',','.').'</td>
					    	</tr>
					  	</table>';
					$pdf->writeHTML($bloque5, false, false, false, false, '');

					// DETALLES Y METODO DE PAGO
					$metPago = json_decode($_POST["listaMetodoPago"]);
					$filaObservaciones = $detalleVenta == '' ? '' : '<tr><td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">OBSERVACIONES:</td><td style="font-size:13px; color:#333; background-color:white; width:390px; text-align:left">'.strtoupper($detalleVenta).'</td></tr>';

					if($_POST['nuevoMetodoPago']=="Efectivo"){
						$cash = number_format($metPago[0]->cash,0,',','.');
						$total = number_format($metPago[0]->total,0,',','.');
						$vuelto = number_format($metPago[0]->vuelto,0,',','.');

						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
								'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:340px; text-align:left">METODO PAGO:</td>
									<td style="font-size:10px; background-color:white; width:100px; text-align:right">CASH<br>TOTAL<br>VUELTO</td>
									<td style="font-size:10px; color:#333; background-color:white; width:100px; text-align:center">:$ '.$cash.'<br>:$ '.$total.'<br>:$ '.$vuelto.'</td>
					    		</tr>
					  		</table>';
					}else if($_POST['nuevoMetodoPago']=="Transferencia"){
						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
					      			<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
					      			<td style="font-size:13px; background-color:white; width:390px; text-align:left">SE PAGÓ VÍA TRANSFERENCIA ELECTRÓNICA</td>
					    		</tr>
					  		</table>';
					}else if($_POST['nuevoMetodoPago']=="TD"){
						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">'.$_POST["listaMetodoPago"].'</td>
					    		</tr>
							</table>';
					}else if($_POST['nuevoMetodoPago']=="TC"){
						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">'.$_POST["listaMetodoPago"].'</td>
					    		</tr>
					  		</table>';
					}else if($_POST['nuevoMetodoPago']=="E_TC" || $_POST['nuevoMetodoPago']=="E_TD"){
						$bloque6 = '
							<table style="padding:5px 10px;">
								<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">SE PAGÓ CON PAGO COMBINADO</td>
					    		</tr>
					  		</table>';
					}else if($_POST['nuevoMetodoPago']=="Fiado"){
						$bloque6 = '
							<table style="padding:5px 10px;">
								<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">CRÉDITO INTERNO</td>
								</tr>
							</table>';
					}else if($_POST['nuevoMetodoPago']=="Pend"){
						$bloque6 = '
							<table style="padding:5px 10px;">
								<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">COBRAR EN REPARTO</td>
								</tr>
							</table>';
					}


					$pdfOutput = dirname(__FILE__).'/'.$codVenta.'.pdf';
					$pdf->Output($pdfOutput, 'F'); // 'F' es para guardar el archivo en el servidor

			        $nombreClienteDespacho = explode(' // ', $detalleFlete)[0];
			        $nroClienteDespacho = explode(' // ', $detalleFlete)[1];
			        $direccionDespacho = explode(' // ', $detalleFlete)[2];
			        $metodoPago = $_POST['nuevoMetodoPago'] == 'Pend' ? "COBRAR EN DESPACHO *$".number_format($totalVenta,0,',','.')."*" : "EL PEDIDO YA ESTÁ PAGADO";

			                // NOTIFICACION TELEGRAM
			        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
			        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_despachos')['ajuste'];

			        $mensajeWhatsapp = 'Hola, le hablamos de Ferretería SAMA por su pedido';
	    			$linkWhatsapp = "[Enviar Whatsapp](https://api.whatsapp.com/send?phone=+56".$nroClienteDespacho."&text=".urlencode($mensajeWhatsapp).")\n\n";

			        $texto =  "🚛 🚛 🚛 *DESPACHO* 🚛 🚛 🚛\n\n\n*VENTA NRO. ".$codVenta."*\n\nNOMBRE   : *".strtoupper($nombreClienteDespacho)."*\nTELEFONO : +56".$nroClienteDespacho."\nDIRECCION: *".strtoupper($direccionDespacho)."*\n".$linkWhatsapp."\n\n".$metodoPago;
			        $formato = 'Markdown';
					notificarTelegramPDFTexto($chatID, $texto, $pdfOutput, $token, $formato);

				}				

				$ultimaVenta = extraerUltimoID('ventas');
				
				echo'
				<script>

					function esDispositivoMovil() {
					  return /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);
					}

					localStorage.removeItem("rango");
				    var audio = new Audio("componentes/sonidos/success.mp3");
				    audio.play();

					if($("#conexionImpresoraTermica").val() == 1 && esDispositivoMovil() == false){
  						extraerDatosVentaTicket('.$ultimaVenta.');
						setTimeout(function () {
	  						window.location = "crear-venta";
						}, 2000);

					}else{
						window.location = "crear-venta";
					}

				</script>';
				
			}
		}
	}

	/*=============================================
	INGRESAR VENTA-COT
	=============================================*/
	static public function ctrIngresarVentaCot(){
	    $sucursal = $_SESSION['sucursal'];
		if(isset($_POST["totalVentaCot"])){

			if($_POST["listaProdsVentaCot"] == ""){
				echo'
				<script>
					Swal.fire({
					  	icon: "error",
					  	title: "La venta no se ha ejecuta si no hay productos",
					  	showConfirmButton: true,
					  	confirmButtonText: "Cerrar"
					  	}).then(function(result){
							if (result.value) {
								window.location = "ventas";
								}
							})
				</script>';
			return;
			}

			$listaProductos = json_decode($_POST["listaProdsVentaCot"], true);
			$totalProductosComprados = array();
		    $total = 0;
		    $pComp = 0;
		    $ahorro = 0;			
			$ultimoRegistro = ModeloProductos::mdlSeleccionarUltimoIdRegistro();//
			$montoExtraible = 0;
			$informarFlete = 0;
			
			foreach ($listaProductos as $key => $value) {
			    array_push($totalProductosComprados, $value["cant"]);
			   	$tablaProductos = "productos";

			   	// TRAER PRODUCTO
			    $item = "id";
			    $valor = $value["id"];
			    $orden = "id";
			    $traerProducto = ModeloProductos::mdlMostrarProductos($tablaProductos, $item, $valor, $orden);
			    
				// PRODUCTO CON MONTO VENDIDO EXTRAIBLE
				if($traerProducto['monto_extraible'] == 1){
					$montoExtraible += 1;
				}
			    //  SUMA VENTAS DEL PRODUCTO
				$item1a = "ventas_".$sucursal;
				$valor1a = $value["cant"] + $traerProducto["ventas_".$sucursal];
			    $nuevasVentas = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1a, $valor1a, $valor);

			    //  ACTUALIZA EL STOCK DEL PRODUCTO
				$item1b = "stock_".$sucursal;
				$stockPosteriorVenta = $traerProducto["stock_".$sucursal] - $value["cant"];
				$nuevoStock = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1b, $stockPosteriorVenta, $valor);



				// notificacion Bot Telegram
				$stockBodegas = 0;
				$bodegasExtraccion = [];
				$bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");
				foreach ($bodegas as $key_1 => $value_1) {
					$nombreBodega = $value_1['nombre_sucursal'];
					$stockBodegas += $traerProducto['stock_'.$nombreBodega];
					if($traerProducto['stock_'.$nombreBodega] > 0){
						array_push($bodegasExtraccion, $nombreBodega);
					}					
				}
			
			    $divisorIdeal = $traerProducto['control_inventario'] == 1 ? 2 : 3; // si es primera prioridad se alerta cuando falta la mitad, si no cuando falta 1/3

				$tipoLocal = ModeloSucursales::mdlMostrarSucursales("sucursales", "nombre_sucursal", $_SESSION['sucursal'])[0]['tipo_sucursal'];
			    if($tipoLocal == 'local'){ // solo si esta en local de ventas se notifica telegram
					if($stockPosteriorVenta == 0 && $stockBodegas > 0){
						
	        			$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
	        			$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
						$imagenDB = $traerProducto['imagen']; // Ruta de la imagen que deseas enviar

						$descSiiTG = $traerProducto['desc_sii'];
						$skuTG = $traerProducto['categoria'] < 10 ? '0'.$traerProducto['sku'] : $traerProducto['sku'];

						if(count($bodegas) == 1){
							$zonaTG = $traerProducto['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto['zona_bodega1'].'</b>';
						}else{
							$zonaTG = '';
							for ($i=0; $i < count($bodegasExtraccion); $i++) { 
								$letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
								$nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números					
								$zonaMostrar = $traerProducto['zona_'.$bodegasExtraccion[$i]] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto['zona_'.$bodegasExtraccion[$i]].'</b>';
								$zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.')</b> ';
							}
						}
						
						$faltanteEnLocal = $traerProducto['stock_ideal_'.$sucursal] - $stockPosteriorVenta;
						$cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;

						$texto =	"‼️‼️‼️‼️ <b>REPONER URGENTE</b> ‼️‼️‼️‼️\n\n".
									"Descripción  : <b>".$descSiiTG."</b>\n".
									"SKU                  : <b>".$skuTG."</b>\n".
									"Zona                 : ".$zonaTG."\n".
									"Quedaron    : <b>".$stockPosteriorVenta.'/'.$traerProducto['stock_ideal_'.$sucursal]."</b>\n".
									"Reponer         : <b>".$cantSugerida."u</b>";
						$notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);
						// NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
						if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
							$notificarDB = ModeloProductos::mdlActualizarProducto($tablaProductos, 'notificacion_telegram_'.$sucursal, 1, $valor);
					    }
					}else if($stockPosteriorVenta <= ($traerProducto['stock_ideal_'.$sucursal]/$divisorIdeal) && $stockPosteriorVenta > 0 && $stockBodegas > 0 && $traerProducto['notificacion_telegram_'.$sucursal] == 0){ 

	        			$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
	        			$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
						$imagenDB = $traerProducto['imagen']; // Ruta de la imagen que deseas enviar

						$descSiiTG = $traerProducto['desc_sii'];
						$skuTG = $traerProducto['categoria'] < 10 ? '0'.$traerProducto['sku'] : $traerProducto['sku'];


						if(count($bodegas) == 1){
							$zonaTG = $traerProducto['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto['zona_bodega1'].'</b>';
						}else{
							$zonaTG = '';
							for ($i=0; $i < count($bodegasExtraccion); $i++) { 
								$letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
								$nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números					
								$zonaMostrar = $traerProducto['zona_'.$bodegasExtraccion[$i]] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto['zona_'.$bodegasExtraccion[$i]].'</b>';
								$zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.')</b> ';
							}
						}
						
						$faltanteEnLocal = $traerProducto['stock_ideal_'.$sucursal] - $stockPosteriorVenta;
						$cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;

						$texto =	"Descripción  : <b>".$descSiiTG."</b>\n".
						        	"SKU                  : <b>".$skuTG."</b>\n".
									"Zona                 : ".$zonaTG."\n".
									"Quedaron    : <b>".$stockPosteriorVenta.'/'.$traerProducto['stock_ideal_'.$sucursal]."</b>\n".
						        	"Reponer         : <b>".$cantSugerida."u</b>";
						$notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);								
						// NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
						if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
							$notificarDB = ModeloProductos::mdlActualizarProducto($tablaProductos, 'notificacion_telegram_'.$sucursal, 1, $valor);
					    }
					}
				}

			    //  ACTUALIZA FECHA MODIFICACION
				$item1b = "fecha_modif_".$sucursal;
				$valor1b = date('Y-m-d H:i:s');
				$fechaModif = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1b, $valor1b, $valor);
   				
				//REGISTRO ACTIVIDAD
				$regActividadVenta = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'venta', $value['cant'], '', $value['id'], $_SESSION['id'], $_SESSION['nombre']);//

				$skuProdComun = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'sku_prod_comun')['ajuste'];
				$skuFlete = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'sku_flete')['ajuste'];

			    // UTILIDAD
				if($value['sku'] == '000000' || $value['sku'] == $skuProdComun || $value['sku'] == $skuFlete){ // NO SUMA UTILIDAD NI AHORRO EN PRODUCTOS (FLETE Y PRODUCTO COMUN)
		      
		      		if($value['sku'] == $skuFlete){
						$informarFlete += 1;
					}					
		      
		      		$total += 0; // UTILIDAD
		      		$pComp += 0; // UTILIDAD
				    $ahorro += 0; // AHORRO CLIENTE
				}else{				
		      		$total += $value['tot']; // UTILIDAD
		      		$pComp += $value['cant']*$value['pC']; // UTILIDAD
				    $ahorro += $value['cant']*round(($value['pV']*100/(100-$value['dcto']))-$value['pV']); // AHORRO CLIENTE
				}

				$ut = ceil($total-$pComp);
			    $utNeta = round($ut/1.19,0);

			    // AHORRO CLIENTE
			    $ahorro += $value['cant']*round(($value['pV']*100/(100-$value['dcto']))-$value['pV']);
			}


			$tablaClientes = "clientes";
			$item = "id";
			$valor = $_POST["selecClientVentaCot"];
			$traerCliente = ModeloClientes::mdlMostrarClientes($tablaClientes, $item, $valor);
			$vistaVendedor = $traerCliente['tipo_cliente'] == 'propietario' ? 0 : 1;


			$item1a = "prods_comprados";
			$valor1a = array_sum($totalProductosComprados) + $traerCliente["prods_comprados"];
			$comprasCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1a, $valor1a, $valor);

			$item1b = "ultima_compra";
			date_default_timezone_set("America/Santiago");
			$fecha = date('Y-m-d');
			$hora = date('H:i:s');
			$valor1b = $fecha.' '.$hora;
			$fechaCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1b, $valor1b, $valor);

			// ACTUALIZAR DEUDA
			if(isset($_POST["fiadoVentaCot"]) && $_POST["fiadoVentaCot"] != ''){				
				$item1_c = "deuda_cliente";
				$valor1_c = $traerCliente["deuda_cliente"] + $_POST["totalVentaCot"];
				$fechaCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1_c, $valor1_c, $valor);
			}


			$item1 = 'fecha';
	        $valor1 = date('Y-m-d');
			$item2 = 'tipo_mov';
	        $valor2 = 'saldo';
	        $diaCerrado = ControladorMovimientos::ctrMovSi2LI($item1, $valor1, $item2, $valor2);
	        if(count($diaCerrado)==0){
	        	$fechaCont = date('Y-m-d'); 
	        }else{
	        	$fechaCont =  date('Y-m-d', strtotime('+1 day')); 
	        }

	        $ultimaVenta = ModeloVentas::mdlUltimaVentaDia($fechaCont);

			/*=============================================
			GUARDAR LA COMPRA
			=============================================*/	
			$tabla = "ventas";
			$totalVenta = $_POST["totalVentaCot"];

			// REDONDEO
			if(isset($_POST["efectivoVentaCot"])){
				$resto = $_POST["totalVentaCot"] % 10;
				if($resto<6){
					$totalVenta = $_POST["totalVentaCot"]-$resto;
				}else{
					$totalVenta = $_POST["totalVentaCot"]+(10-$resto);
				}
			}

			if($ultimaVenta['ultimo']==null){
				$codVenta = substr(str_replace("-", "", $fechaCont),2)."001";
			}else{
				$correlativo = intval($ultimaVenta['ultimo'])+1;
				if($correlativo>9 && $correlativo<=99){
					$codVenta = substr(str_replace("-", "", $fechaCont),2)."0".$correlativo;
				}else if($correlativo>99){
					$codVenta = substr(str_replace("-", "", $fechaCont),2).$correlativo;					
				}else{
					$codVenta = substr(str_replace("-", "", $fechaCont),2)."00".$correlativo;										
				}
			}

			// INSERTAR COD VENTA EN REGISTRO INVENTARIO
			$codVentaActividad = ModeloProductos::mdlActualizarProducto('actividad_inventario', 'detalle', $codVenta, $ultimoRegistro[0]+1);//
			$detalleVentaCot = str_replace('"',"''",$_POST["detalleVentaCot"]); // QUITA COMILLAS DOBLES Y LAS REEMPLAZA POR 2 COMILLAS SIMPLES
			$detalleVentaCot = strtoupper(preg_replace("/[\r\n|\n|\r]+/", ". ", $detalleVentaCot)); // ELIMINA SALTOS DE LINEA

			$detalleFleteVentaCot = str_replace('"',"''",$_POST["detalleFleteVentaCot"]); // QUITA COMILLAS DOBLES Y LAS REEMPLAZA POR 2 COMILLAS SIMPLES
			$detalleFleteVentaCot = strtoupper(preg_replace("/[\r\n|\n|\r]+/", ". ", $detalleFleteVentaCot)); // ELIMINA SALTOS DE LINEA

			$fechaHora = ControladorAjustes::ctrFechaHora();
			$deteccionExtraibles = $montoExtraible > 0 ? 1 : 0;

			// DATOS
			$datos = array("id_vendedor"=>$_POST["idVendVentaCot"],
						   "cod_venta"=>$codVenta,
						   "nom_vend"=>$_POST["nomVendVentaCot"],
						   "estado"=>1,
						   "vista_vendedor"=>$vistaVendedor,						   
						   "id_cliente"=>$_POST["selecClientVentaCot"],
						   "nom_client"=>$_POST["nomClientVentaCot"],
						   "rut_factura"=>$_POST["rutFacturaVentaCot"],
						   "productos"=>$_POST["listaProdsVentaCot"],
						   "impuesto"=>$totalVenta-round($totalVenta/1.19),
						   "neto"=>round($totalVenta/1.19),
						   "total"=>$totalVenta,
						   "monto_extraible"=>$deteccionExtraibles,
						   "descuentos"=>$ahorro,
						   "detalle_venta"=>$detalleVentaCot,
						   "detalle_flete"=>$detalleFleteVentaCot,
						   "prods_sugeridos_vendidos"=>'',
						   "total_prods_sugeridos"=>0,
						   "fecha_venta"=>$fechaHora,
						   "fecha_cont"=>$fechaCont,
						   "fecha"=>$fechaHora,
						   "utilidad_total"=>$ut,
						   "utilidad_neta"=>$utNeta,
						   "tipo_pago"=>$_POST['metodoPagoVentaCot'],
						   "metodo_pago"=>$_POST["detPagoVentaCot"]);
			$respuesta = ModeloVentas::mdlIngresarVenta($tabla, $datos);
			
			// ASIGNAR NRO DE VENTA EN COT
			$tabla = 'cotizaciones';
			$item1 = "venta";
			$valor1 = $codVenta;
			$valor = $_POST['idCot'];
			$nroVenta = ModeloCotizaciones::mdlActualizarCot($tabla, $item1, $valor1, $valor); // ingresar nro de venta en cotización

			if($respuesta == "ok"){


				if($informarFlete == 1){

					$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
					$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_despachos')['ajuste'];
					require_once(dirname(__FILE__).'/../extensiones/tcpdf/tcpdf.php');
					$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
					$pdf-> setPrintHeader(false);
					$pdf->startPageGroup();
					$pdf->AddPage();

					$nombreComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_comercial')['ajuste']);
					$nombreReal = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_real')['ajuste']);
					$rutComercio = explode('-',ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_comercial')['ajuste']);
					$rutMostrar = number_format($rutComercio[0],0,',','.').'-'.$rutComercio[1];
					$direccionComercio = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'direccion_comercial')['ajuste']);
					$wsp = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_ventas')['ajuste'];
					$fonoVenta = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'] == '' ? '' : 'Fono-Ventas: '.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'].'<br>';
					$correo = strtolower(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_ventas')['ajuste']);
					$logo = 'src="'.dirname(__FILE__).'/../extensiones/tcpdf/pdf/'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"';

					$bloque1 = '
						<table>
						    <tr>
						      	<td style="width:150px"><img '.$logo.'></td>
						      	<td style="background-color:white; width:140px">
						        	<div style="font-size:8.5px; text-align:right; line-height:15px;">
						        		<br>'.$nombreComercio.'<br>'.$nombreReal.'<br>'.$rutMostrar.'<br>Dirección: '.$direccionComercio.'
						        	</div>
						      	</td>
						      	<td style="background-color:white; width:140px">
						        	<div style="font-size:8.5px; text-align:right; line-height:15px;">
						          		<br>Whatsapp: '.$wsp.'<br>'.$fonoVenta.'<br>'.$correo.'
						        	</div>
						      	</td>
						      	<td style="background-color:white; width:110px; text-align:center"><br><br>Venta Nro. <br>'.$codVenta.'</td>
						    </tr>
						</table>';
					$pdf->writeHTML($bloque1, false, false, false, false, '');

					// ---------------------------------------------------------

					$bloque2 = '
					  	<table><tr><td style="width:540px"><img src="images/back.jpg"></td></tr></table>

					  	<table style="font-size:10px; padding:5px 10px;">
					    	<tr>
					      		<td style="border: 1px solid #666; background-color:white; width:390px">Cliente: '.$_POST["nomClientVentaCot"].'</td>
					      		<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">Fecha: '.$fechaHora.'</td>
					    	</tr>
					    	<tr>
					      		<td style="border: 1px solid #666; background-color:white; width:540px">Vendedor: '.$_POST["nomVendVentaCot"].'</td>
					    	</tr>
					    	<tr>
					      		<td style="border-bottom: 1px solid #666; background-color:white; width:540px"></td>
					    	</tr>
					  	</table>';
					$pdf->writeHTML($bloque2, false, false, false, false, '');


					// ENCABEZADOS COLUMNAS
					$bloque3 = '

					  	<table style="font-size:10px; padding:5px 10px;">
					    	<tr>
								<td style="border: 1px solid #333; background-color:white; width:50px; text-align:center; font-size:9px"><b>CANT</b></td>
								<td style="border: 1px solid #333; background-color:white; width:55px; text-align:left; font-size:9px"><b>COD</b></td>
								<td style="border: 1px solid #333; background-color:white; width:270px; text-align:left; font-size:9px"><b>PRODUCTOS</b></td>
								<td style="border: 1px solid #333; background-color:white; width:80px; text-align:center; font-size:9px"><b>$ UNIT. C/IVA</b></td>
								<td style="border: 1px solid #333; background-color:white; width:85px; text-align:center; font-size:9px"><b>VALOR TOTAL</b></td>
					    	</tr>
					  	</table>';
					$pdf->writeHTML($bloque3, false, false, false, false, '');

					foreach(array_reverse($listaProductos) as $key => $item) {
						$valorUnitarioNeto = number_format(($item["tot"]/$item["cant"])/1.19, 2,',','.');
						$valorUnitario = number_format($item["tot"]/$item["cant"], 0,',','.');
						$precioUnitario = '$ '.$valorUnitario;
						$dcto = $item["dcto"] > 0 ? "<b>(Dcto: ".$item["dcto"]."%)</b>" : "";
						$precioTotal = number_format($item["tot"], 0,',','.');

						$bloque4 = '
					    	<table style="font-size:10px; padding:5px 10px;">
					      		<tr>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:50px; text-align:center; font-size:9px">'.$item['cant'].'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:55px; text-align:left; font-size:9px">'.$item['sku'].'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:270px; text-align:left; font-size:9px">'.$item['prod'].' '.$dcto.'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:80px; text-align:center; font-size:9px">'.$precioUnitario.'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:85px; text-align:center; font-size:9px">$ '.$precioTotal.'</td>
					      		</tr>
					    	</table>';
						$pdf->writeHTML($bloque4, false, false, false, false, '');
					}

					$bloque5 = '
						<table style="font-size:10px; padding:5px 10px;">
					    	<tr>
					      		<td style="color:#333; background-color:white; width:340px; text-align:center"></td>
					      		<td style="border-bottom: 1px solid #666; background-color:white; width:100px; text-align:center"></td>
					      		<td style="border-bottom: 1px solid #666; color:#333; background-color:white; width:100px; text-align:center"></td>
					    	</tr>
					    	<tr>
					      		<td style="border-right: 1px solid #666; color:#333; background-color:white; width:340px; text-align:center"></td>
								<td style="border: 1px solid #666; background-color:white; width:100px; text-align:center">TOTAL:</td>
								<td style="border: 1px solid #666; color:#333; background-color:white; width:100px; text-align:center">$ '.number_format($totalVenta,0,',','.').'</td>
					    	</tr>
					  	</table>';
					$pdf->writeHTML($bloque5, false, false, false, false, '');

					// DETALLES Y METODO DE PAGO
					$metPago = json_decode($_POST["listaMetodoPago"]);
					$filaObservaciones = $detalleVentaCot == '' ? '' : '<tr><td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">OBSERVACIONES:</td><td style="font-size:13px; color:#333; background-color:white; width:390px; text-align:left">'.strtoupper($detalleVentaCot).'</td></tr>';

					if($_POST['metodoPagoVentaCot']=="Efectivo"){
						$cash = number_format($metPago[0]->cash,0,',','.');
						$total = number_format($metPago[0]->total,0,',','.');
						$vuelto = number_format($metPago[0]->vuelto,0,',','.');

						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
								'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:340px; text-align:left">METODO PAGO:</td>
									<td style="font-size:10px; background-color:white; width:100px; text-align:right">CASH<br>TOTAL<br>VUELTO</td>
									<td style="font-size:10px; color:#333; background-color:white; width:100px; text-align:center">:$ '.$cash.'<br>:$ '.$total.'<br>:$ '.$vuelto.'</td>
					    		</tr>
					  		</table>';
					}else if($_POST['metodoPagoVentaCot']=="Transferencia"){
						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
					      			<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
					      			<td style="font-size:13px; background-color:white; width:390px; text-align:left">SE PAGÓ VÍA TRANSFERENCIA ELECTRÓNICA</td>
					    		</tr>
					  		</table>';
					}else if($_POST['metodoPagoVentaCot']=="TD"){
						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">'.$_POST["listaMetodoPago"].'</td>
					    		</tr>
							</table>';
					}else if($_POST['metodoPagoVentaCot']=="TC"){
						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">'.$_POST["listaMetodoPago"].'</td>
					    		</tr>
					  		</table>';
					}else if($_POST['metodoPagoVentaCot']=="E_TC" || $_POST['metodoPagoVentaCot']=="E_TD"){
						$bloque6 = '
							<table style="padding:5px 10px;">
								<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">SE PAGÓ CON PAGO COMBINADO</td>
					    		</tr>
					  		</table>';
					}else if($_POST['metodoPagoVentaCot']=="Fiado"){
						$bloque6 = '
							<table style="padding:5px 10px;">
								<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">CRÉDITO INTERNO</td>
								</tr>
							</table>';
					}else if($_POST['metodoPagoVentaCot']=="Pend"){
						$bloque6 = '
							<table style="padding:5px 10px;">
								<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">COBRAR EN REPARTO</td>
								</tr>
							</table>';
					}


					$pdfOutput = dirname(__FILE__).'/'.$codVenta.'.pdf';
					$pdf->Output($pdfOutput, 'F'); // 'F' es para guardar el archivo en el servidor

			        $nombreClienteDespacho = explode(' // ', $detalleFleteVentaCot)[0];
			        $nroClienteDespacho = explode(' // ', $detalleFleteVentaCot)[1];
			        $direccionDespacho = explode(' // ', $detalleFleteVentaCot)[2];
			        $metodoPago = $_POST['metodoPagoVentaCot'] == 'Pend' ? "COBRAR EN DESPACHO *$".number_format($totalVenta,0,',','.')."*" : "EL PEDIDO YA ESTÁ PAGADO";

			                // NOTIFICACION TELEGRAM
			        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
			        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_despachos')['ajuste'];

			        $mensajeWhatsapp = 'Hola, le hablamos de Ferretería SAMA por su pedido';
	    			$linkWhatsapp = "[Enviar Whatsapp](https://api.whatsapp.com/send?phone=+56".$nroClienteDespacho."&text=".urlencode($mensajeWhatsapp).")\n\n";

			        $texto =  "🚛 🚛 🚛 *DESPACHO* 🚛 🚛 🚛\n\n\n*VENTA NRO. ".$codVenta."*\n\nNOMBRE   : *".strtoupper($nombreClienteDespacho)."*\nTELEFONO : +56".$nroClienteDespacho."\nDIRECCION: *".strtoupper($direccionDespacho)."*\n".$linkWhatsapp."\n\n".$metodoPago;
			        $formato = 'Markdown';
					notificarTelegramPDFTexto($chatID, $texto, $pdfOutput, $token, $formato);

				}


				$ultimaVenta = extraerUltimoID('ventas');				
				if(isset($_POST["efectivoVentaCot"])){

					if($resto<6){
						$resto1= -$resto;
						$vuelto = $_POST["vueltoEfectivoVentaCot"]+$resto;
					}else{
						$resto1= 10-$resto;
						$vuelto = $_POST["vueltoEfectivoVentaCot"]-$resto1;
					}
					$dinero = $_POST["efectivoVentaCot"];
					$redondeoFinal = $_POST["totalVentaCot"]+$resto1;

					echo'
					<script>
						localStorage.removeItem("rango");
						var detalleDelPago="<table style=\"margin-left: auto;margin-right: auto;\">'.
												'<tbody>'.
													'<tr>'.
														'<td>'.
															'<h2><b>VENTA INGRESADA CON ÉXITO</b></h2>'.
															'<h2><i>Detalle del Pago</i></h2>'.
														'</td>'.
													'</tr>'.
												'</tbody>'.
											'</table>'.

											'<table>'.
												'<tbody>'.
													'<tr>'.
														'<td>                                            </td>'.
														'<td style=\"text-align:left\">Dinero:</td>'.
														'<td>    </td>'.
														'<td style=\"text-align:left\">$ '.number_format($dinero,0,',','.').'</td>'.
													'</tr>'.
												'</tbody>'.
											'</table>'.

											'<table>'.
												'<tbody>'.
													'<tr>'.
														'<td>                                                </td>'.
														'<td style=\"text-align:left\">Total:</td>'.
														'<td>    </td>'.
														'<td style=\"text-align:left\">$ '.number_format($_POST["totalVentaCot"],0,',','.').'</td>'.
													'</tr>'.
												'</tbody>'.
											'</table>'.

											'<table>'.
												'<tbody>'.
													'<tr>'.
														'<td>                                     </td>'.
														'<td style=\"text-align:left\">Redondeo:</td>'.
														'<td>    </td>'.
														'<td style=\"text-align:left\">$ '.number_format($resto1,0,',','.').'</td>'.
													'</tr>'.
												'</tbody>'.
											'</table>'.
											
											'<br>'.

											'<table style=\"margin-left: auto;margin-right: auto;\">'.
												'<tbody>'.
													'<tr>'.
														'<td>'.
															'<h3>Total Redondeado: <b>$ '.number_format($redondeoFinal,0,',','.').'</b></h3>'.
														'</td>'.
													'</tr>'.
												'</tbody>'.
											'</table>'.

											'<table style=\"margin-left: auto;margin-right: auto;\">'.
												'<tbody>'.
													'<tr>'.
														'<td>'.
															'<h1><i><b>Vuelto: $ '.number_format($vuelto,0,',','.').'</b></i></h1>'.
														'</td>'.
													'</tr>'.
												'</tbody>'.
											'</table>";


					    var audio = new Audio("componentes/sonidos/success.mp3");
					    audio.play();
						
						Swal.fire({
							icon: "success",
							html: detalleDelPago,
							showConfirmButton: true,
							confirmButtonText: "Ok",
							focusConfirm: true,
							confirmButtonAttributes: {
							    autofocus: "autofocus"
							}
							}).then(function(result){

							if('.$_SESSION["conexionImpresoraLocal"].' == 1 && esDispositivoMovil() == false){

					  						extraerDatosVentaTicket('.$ultimaVenta.');
											setTimeout(function () {
						  						window.location = "crear-venta";
											}, 2000);
							}else{
								window.location = "crear-venta";
							}
						})
					</script>';
				}else{
					

					echo'
					<script>
					localStorage.removeItem("rango");
				    var audio = new Audio("componentes/sonidos/success.mp3");
				    audio.play();
					Swal.fire({
						icon: "success",
						title: "La venta ha sido guardada correctamente",
						showConfirmButton: true,
						confirmButtonText: "Cerrar"
						}).then(function(result){

							if('.$_SESSION["conexionImpresoraLocal"].' == 1 && esDispositivoMovil() == false){
					  						extraerDatosVentaTicket('.$ultimaVenta.');
											setTimeout(function () {
						  						window.location = "crear-venta";
											}, 2000);
							}else{
								window.location = "crear-venta";
							}
						})
					</script>';
				}
			}
		}
	}

	/*=============================================
	EDITAR VENTA
	=============================================*/
	static public function ctrEditarVenta($ventaRedireccion){
	    $sucursal = $_SESSION['sucursal'];
		if(isset($_POST["idVentaEdit"])){
	    // echo $_POST['idVentaEdit'];
			date_default_timezone_set('America/Santiago');
			/*=============================================
			FORMATEAR TABLA DE PRODUCTOS Y LA DE CLIENTES
			=============================================*/
			$tabla = "ventas";
			$item = "id";
			$valor = $_POST["idVentaEdit"];
	    	$compItem = '=';
            $compEstado = '!=';
            $estado = 0;
            $filOrden = 'fecha_cont';
            $ord = 'DESC';                    
            $traerVenta = ControladorVentas::ctrMostrarVentas($item, $valor, $compItem, $compEstado, $estado, $filOrden, $ord);
            $codVenta = $traerVenta['cod_venta'];
            $nomVend = $traerVenta['nom_vend'];

			$skuProdComun = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'sku_prod_comun')['ajuste'];
			$skuFlete = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'sku_flete')['ajuste'];


			// REVISAR SI VIENE PRODUCTOS EDITADOS
			if($_POST["listaProductosEditVenta"] != $traerVenta["productos"] || $_POST['seleccionarClienteEditVenta'] != $traerVenta['id_cliente'] || $_POST['editarDetalleVenta'] != $traerVenta['detalle_venta'] || $_POST['editarMetodoPago'] != $traerVenta['tipo_pago'] || $_POST['editarTotalVenta'] != $traerVenta['total']){
				$cambiosDetectadosVenta = true;
			}else{
				$cambiosDetectadosVenta = false;
			}

			if($cambiosDetectadosVenta){ //TRUE
				$productos =  json_decode($traerVenta["productos"], true);
				$totalProductosComprados = array();			    		
				$ultimoRegistro = ModeloProductos::mdlSeleccionarUltimoIdRegistro();
				$informarFlete = 0;
				
				foreach ($productos as $key => $value) {
					array_push($totalProductosComprados, $value["cant"]);
					$tablaProductos = "productos";
			   		// TRAER PRODUCTO
					$item = "id";
					$valor = $value["id"];
					$orden = "id";
					$traerProducto = ModeloProductos::mdlMostrarProductos($tablaProductos, $item, $valor, $orden);
			    	//  RESTA VENTAS DEL PRODUCTO
					$item1a = "ventas_".$sucursal;
					$valor1a = $traerProducto["ventas_".$sucursal] - $value["cant"];
					$nuevasVentas = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1a, $valor1a, $valor);
			    	//  ACTUALIZA EL STOCK DEL PRODUCTO
					$item1b = "stock_".$sucursal;
					$valor1b = $value["cant"] + $traerProducto["stock_".$sucursal];
					$nuevoStock = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1b, $valor1b, $valor);
					// REGISTRO ACTIVIDAD INVENTARIO
					$regActividadEditVenta = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'editVentaMenos', $value['cant'], $traerVenta["cod_venta"], $value['id'], $_SESSION['id'], $_SESSION['nombre']);//

			      	if($value['sku'] == $skuFlete){
						$informarFlete -= 1;
					}


				}
				// TRAER CLIENTE
				$tablaClientes = "clientes";
				$itemCliente = "id";
				$valorCliente = $traerVenta["id_cliente"];
				$traerCliente = ModeloClientes::mdlMostrarClientes($tablaClientes, $itemCliente, $valorCliente);
				// RESTA DE PRODUCTOS EN VENTA
				$item1a = "prods_comprados";
				$valor1a = $traerCliente["prods_comprados"] - array_sum($totalProductosComprados);		
				$comprasCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1a, $valor1a, $valorCliente);
				// RESTA DEUDA POR VENTA ACTUALIZADA
				if($traerVenta['tipo_pago'] == 'Fiado'){
					$item1c = "deuda_cliente";
					$valor1c = $traerCliente["deuda_cliente"] - $traerVenta['total'];		
					$restarDeuda = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1c, $valor1c, $traerVenta["id_cliente"]);
				}

				/*=============================================
				ACTUALIZAR LAS COMPRAS DEL CLIENTE Y REDUCIR EL STOCK Y AUMENTAR LAS VENTAS DE LOS PRODUCTOS
				=============================================*/
				$listaProductos_2 = json_decode($_POST["listaProductosEditVenta"], true);
				$totalProductosComprados_2 = array();

			    $total = 0;
			    $pComp = 0;
			    $ahorro = 0;
				$montoExtraible = 0;

				foreach ($listaProductos_2 as $key => $value) {
					array_push($totalProductosComprados_2, $value["cant"]);
					$tablaProductos_2 = "productos";
					// TRAE LOS PRODUCTOS COMPRADOS
					$item_2 = "id";
					$valor_2 = $value["id"];
					$orden = "id";
					$traerProducto_2 = ModeloProductos::mdlMostrarProductos($tablaProductos_2, $item_2, $valor_2, $orden);

					// PRODUCTO CON MONTO VENDIDO EXTRAIBLE
					if($traerProducto_2['monto_extraible'] == 1){
						$montoExtraible += 1;
					}			    

					// SUMA VENTAS DEL PRODUCTO
					$item1a_2 = "ventas_".$sucursal;
					$valor1a_2 = $value["cant"] + $traerProducto_2["ventas_".$sucursal];
					$nuevasVentas_2 = ModeloProductos::mdlActualizarProducto($tablaProductos_2, $item1a_2, $valor1a_2, $valor_2);

					// ACTUALIZA EL STOCK
					$item1b_2 = "stock_".$sucursal;
					$stockPosteriorVenta = $traerProducto_2["stock_".$sucursal] - $value["cant"];
					$nuevoStock_2 = ModeloProductos::mdlActualizarProducto($tablaProductos_2, $item1b_2, $stockPosteriorVenta, $valor_2);


					$stockBodegas = 0;
					$bodegasExtraccion = [];

					$bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");
					foreach ($bodegas as $key => $value_1) {
						$nombreBodega = $value_1['nombre_sucursal'];
						$stockBodegas += $traerProducto_2['stock_'.$nombreBodega];
						if($traerProducto_2['stock_'.$nombreBodega] > 0){
							array_push($bodegasExtraccion, $nombreBodega);
						}
					}

				    $divisorIdeal = $traerProducto['control_inventario'] == 1 ? 2 : 3; // si es primera prioridad se alerta cuando falta la mitad, si no cuando falta 1/3

					// notificacion Bot Telegram
					$tipoLocal = ModeloSucursales::mdlMostrarSucursales("sucursales", "nombre_sucursal", $_SESSION['sucursal'])[0]['tipo_sucursal'];
				    if($tipoLocal == 'local'){ // solo si esta en local de ventas se notifica telegram

						if($stockPosteriorVenta == 0 && $stockBodegas > 0){

		        			$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
		        			$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
							$imagenDB = $traerProducto_2['imagen']; // Ruta de la imagen que deseas enviar

							$descSiiTG = $traerProducto_2['desc_sii'];
							$skuTG = $traerProducto_2['categoria'] < 10 ? '0'.$traerProducto_2['sku'] : $traerProducto_2['sku'];

							if(count($bodegas) == 1){
								$zonaTG = $traerProducto_2['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto_2['zona_bodega1'].'</b>';
							}else{
								$zonaTG = '';
								for ($i=0; $i < count($bodegasExtraccion); $i++) { 
									$letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
									$nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números					
									$zonaMostrar = $traerProducto_2['zona_'.$bodegasExtraccion[$i]] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto_2['zona_'.$bodegasExtraccion[$i]].'</b>';
									$zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.')</b> ';
								}
							}
							
							$faltanteEnLocal = $traerProducto_2['stock_ideal_'.$sucursal] - $stockPosteriorVenta;
							$cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;


							$texto =	"‼️‼️‼️‼️ <b>REPONER URGENTE</b> ‼️‼️‼️‼️\n\n".
										"Descripción  : <b>".$descSiiTG."</b>\n".
										"SKU                  : <b>".$skuTG."</b>\n".
										"Zona                 : ".$zonaTG."\n".
										"Quedaron    : <b>".$stockPosteriorVenta.'/'.$traerProducto_2['stock_ideal_'.$sucursal]."</b>\n".
										"Reponer         : <b>".$cantSugerida."u</b>";
							$notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);
							// NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
							if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
								$notificarDB = ModeloProductos::mdlActualizarProducto($tablaProductos, 'notificacion_telegram_'.$sucursal, 1, $valor);
						    }
						}else if($stockPosteriorVenta <= ($traerProducto_2['stock_ideal_'.$sucursal]/$divisorIdeal) && $stockPosteriorVenta > 0 && $stockBodegas > 0 && $traerProducto_2['notificacion_telegram_'.$sucursal] == 0){

		        			$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
		        			$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
							$imagenDB = $traerProducto_2['imagen']; // Ruta de la imagen que deseas enviar

							$descSiiTG = $traerProducto_2['desc_sii'];
							$skuTG = $traerProducto_2['categoria'] < 10 ? '0'.$traerProducto_2['sku'] : $traerProducto_2['sku'];

							if(count($bodegas) == 1){
								$zonaTG = $traerProducto_2['zona_bodega1'] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto_2['zona_bodega1'].'</b>';
							}else{
								$zonaTG = '';
								for ($i=0; $i < count($bodegasExtraccion); $i++) { 
									$letraInicial = strtoupper(substr($bodegasExtraccion[$i], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
									$nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i]); // Extraer solo los números					
									$zonaMostrar = $traerProducto_2['zona_'.$bodegasExtraccion[$i]] == '' ? '<b>s/ZONA</b>' : '<b>'.$traerProducto_2['zona_'.$bodegasExtraccion[$i]].'</b>';
									$zonaTG .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.')</b> ';
								}
							}
							
							$faltanteEnLocal = $traerProducto_2['stock_ideal_'.$sucursal] - $stockPosteriorVenta;
							$cantSugerida = $stockBodegas >= $faltanteEnLocal ? $faltanteEnLocal : $stockBodegas;

							$texto =	"Descripción  : <b>".$descSiiTG."</b>\n".
							        	"SKU                  : <b>".$skuTG."</b>\n".
										"Zona                 : ".$zonaTG."\n".
										"Quedaron    : <b>".$stockPosteriorVenta.'/'.$traerProducto_2['stock_ideal_'.$sucursal]."</b>\n".
							        	"Reponer         : <b>".$cantSugerida."u</b>";
							$notificar = notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token);								
							// NOTIFICAR A DB (1: YA SE NOTIFICÓ, 0: NO SE HA NOTIFICADO)
							if(json_decode($notificar,true)['ok'] == true){ // mensaje enviado exitosamente
								$notificarDB = ModeloProductos::mdlActualizarProducto($tablaProductos, 'notificacion_telegram_'.$sucursal, 1, $valor);
						    }
						}
					}

					// $skuProdComun = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'sku_prod_comun')['ajuste'];
					// $skuFlete = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'sku_flete')['ajuste'];

				    // UTILIDAD
					if($value['sku'] == '000000' || $value['sku'] == $skuProdComun || $value['sku'] == $skuFlete){ // NO SUMA UTILIDAD NI AHORRO EN PRODUCTOS (FLETE Y PRODUCTO COMUN) 

			      		if($value['sku'] == $skuFlete){
							$informarFlete += 1;
						}

			      		$total += 0; // UTILIDAD
			      		$pComp += 0; // UTILIDAD
					    $ahorro += 0; // AHORRO CLIENTE
					}else{				
			      		$total += $value['tot']; // UTILIDAD
			      		$pComp += $value['cant']*$value['pC']; // UTILIDAD
					    $ahorro += $value['cant']*round(($value['pV']*100/(100-$value['dcto']))-$value['pV']); // AHORRO CLIENTE
					}

					// REGISTRO ACTIVIDAD INVENTARIO
					$regActividadEditVenta = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'editVentaMas', $value['cant'], $traerVenta["cod_venta"], $value['id'], $_SESSION['id'], $_SESSION['nombre']);//

				    //  ACTUALIZA FECHA MODIFICACION
					$item1b = "fecha_modif_".$sucursal;
					$valor1b = date('Y-m-d H:i:s');
					$fechaModif = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1b, $valor1b, $valor_2);

				}
				$ut = ceil($total-$pComp);
			    $utNeta = round($ut/1.19,0);

				// TRAER CLIENTE
				$tablaClientes_2 = "clientes";
				$item_2 = "id";
				$valor_2 = $_POST["seleccionarClienteEditVenta"];
				$traerCliente_2 = ModeloClientes::mdlMostrarClientes($tablaClientes_2, $item_2, $valor_2);
				$vistaVendedor = $traerCliente_2['tipo_cliente'] == 'propietario' ? 0 : 1;

				// ACTUALIZAR PRODS COMPRADOS POR EL CLIENTE
				$item1a_2 = "prods_comprados";
				$valor1a_2 = array_sum($totalProductosComprados_2) + $traerCliente_2["prods_comprados"];
				$comprasCliente_2 = ModeloClientes::mdlActualizarCliente($tablaClientes_2, $item1a_2, $valor1a_2, $valor_2);
				
				// ACTUALIZAR FECHA ULTIMA COMPRA 
				$item1b_2 = "ultima_compra";
				date_default_timezone_set('America/Santiago');
				$fecha = date('Y-m-d');
				$hora = date('H:i:s');
				$valor1b_2 = $fecha.' '.$hora;
				$fechaCliente_2 = ModeloClientes::mdlActualizarCliente($tablaClientes_2, $item1b_2, $valor1b_2, $valor_2);

				// SUMA DEUDA POR VENTA ACTUALIZADA
				if($_POST['editarMetodoPago'] == 'Fiado'){
					$item1c_2 = "deuda_cliente";
					$valor1c_2 = $traerCliente_2["deuda_cliente"] + $_POST['editarTotalVenta'];
					$valorCliente1c_2 = $_POST['seleccionarClienteEditVenta'];
					$sumarDeuda = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1c_2, $valor1c_2, $valorCliente1c_2);
				}

			}

			// REDONDEO
			if(isset($_POST["editValorEfectivo"])){
				$resto = $_POST["editarTotalVenta"] % 10;
				if($resto<6){
					$totalVenta = $_POST["editarTotalVenta"]-$resto;
				}else{
					$totalVenta = $_POST["editarTotalVenta"]+(10-$resto);
				}
			}else{
				$totalVenta = $_POST["editarTotalVenta"];
			}

			$editarDetalleVenta = str_replace('"',"''",$_POST["editarDetalleVenta"]); // QUITA COMILLAS DOBLES Y LAS REEMPLAZA POR 2 COMILLAS SIMPLES
			$editarDetalleVenta = strtoupper(preg_replace("/[\r\n|\n|\r]+/", ". ", $editarDetalleVenta)); // ELIMINA SALTOS DE LINEA

			$editarDetalleFlete = str_replace('"',"''",$_POST["detalleFleteEdit"]); // QUITA COMILLAS DOBLES Y LAS REEMPLAZA POR 2 COMILLAS SIMPLES
			$editarDetalleFlete = strtoupper(preg_replace("/[\r\n|\n|\r]+/", ". ", $editarDetalleFlete)); // ELIMINA SALTOS DE LINEA

			/*=============================================
			AUTOANALISIS EDICION DE VENTA
			=============================================*/
  			$autoAnalisisCodigo = '';
			
			$originales = json_decode($_POST['listaProductosOriginal'],true);
			$anteriores = json_decode($_POST['listaProductosAntiguos'],true);
			$adicionales = json_decode($_POST['listaProductosAdicionales'],true);
			$finales = json_decode($$_POST['listaProductosEditVenta'],true);

			$prodsOriginales = [];
			$totalOriginal = 0;
			foreach ($originales as $key => $value) {
			  	array_push($prodsOriginales, $value["cant"]);
			  	$totalOriginal += $value['tot'];
			}
			$prodsAnteriores = [];
			foreach ($anteriores as $key => $value) {
				array_push($prodsAnteriores, $value["cant"]);
			}
			$prodsFinales = [];
			$totalFinal = 0;
			foreach ($finales as $key => $value) {
				$totalFinal += $value['tot'];
			}

			// DETECCION DE ELIMINACION DE PRODUCTOS ORIGINALES
			$diferenciaProdsOriginales = count($prodsOriginales) - count($prodsAnteriores);
			if($diferenciaProdsOriginales >= 1){
				$autoAnalisisCodigo .= '-1';
			}else{
				$autoAnalisisCodigo .= '-0';
			}

			// DETECCION DE INCORPORACION DE NUEVOS PRODUCTOS
			// if($postAdicionales != ""){  
			$prodsAdicionales = [];
		    foreach ($adicionales as $key => $value) {
		    	array_push($prodsAdicionales, $value["cant"]);
		    }
		    if(count($prodsAdicionales) >= 1){
				$autoAnalisisCodigo .= '-1';
			}else{
				$autoAnalisisCodigo .= '-0';
			}
			// }

  			// DETECCION DE VARIACION DE STOCK DE PRODUCTOS ORIGINALES SI NO HAY ELIMINACION DE PRODUCTOS
			$cantProdsConVariacionStock = 0;
		  	for ($i=0; $i < count($prodsOriginales); $i++){ 
		    	if($prodsOriginales[$i] - $prodsAnteriores[$i] > 0){
		      		$cantProdsConVariacionStock += 1;
		    	}else if($prodsOriginales[$i] - $prodsAnteriores[$i] < 0){
			      	$cantProdsConVariacionStock += 1;
			    }
		  	}
			if($diferenciaProdsOriginales == 0 && $cantProdsConVariacionStock > 0){
				$autoAnalisisCodigo .= '-1';
			}else{
				$autoAnalisisCodigo .= '-0';
			}

			// DETECCION VARIACION DE TOTAL VENTA
		    if($totalOriginal != $_POST['editarTotalVenta']){
				$autoAnalisisCodigo .= '-1';
			}else{
				$autoAnalisisCodigo .= '-0';
			}


		  	if($_POST['seleccionarClienteEditVenta'] != $traerVenta['id_cliente']){
				$autoAnalisisCodigo .= '-1';
			}else{
				$autoAnalisisCodigo .= '-0';
			}

				
		    if($_POST['editarMetodoPago'] != $traerVenta['tipo_pago']){
				$autoAnalisisCodigo .= '-1';
			}else{
				$autoAnalisisCodigo .= '-0';
			}

			if($_POST['editarDetalleVenta'] != $traerVenta['detalle_venta']){
				$autoAnalisisCodigo .= '-1';
			}else{
				$autoAnalisisCodigo .= '-0';
			}

			$autoAnalisisCodigo = substr($autoAnalisisCodigo, 1); // elimina el primer '-'

			// REGISTRO DE DETALLE DE EDICIÓN
			$infoEdicionVenta = json_decode($traerVenta['info_edicion'],true) == NULL ? '' : json_decode($traerVenta['info_edicion'],true);
			$listasProdsOriginalesEdiciones = json_decode($traerVenta['prods_edit_orig'],true)  == NULL ? '' : json_decode($traerVenta['prods_edit_orig'],true);
			$listasProdsFinalesEdiciones = json_decode($traerVenta['prods_edit_final'],true) == NULL ? '' : json_decode($traerVenta['prods_edit_final'],true);

			if($infoEdicionVenta == ""){ // SI ES PRIMERA EDICION
				$motivoEdicion = '[{"id":"'.$_SESSION['id'].'","responsable":"'.$_SESSION['nombre'].'","motivo":"'.$_POST['motivoEdicion'].'","autoAnalisis":"'.$autoAnalisisCodigo.'","fechaEdit":"'.date("Y-m-d H:i").'"}]';
			}else{ // DE 2DA EDICION EN ADELANTE
				$motivoEdicion = substr($traerVenta['info_edicion'],0,-1).','.'{"id":"'.$_SESSION['id'].'","responsable":"'.$_SESSION['nombre'].'","motivo":"'.$_POST['motivoEdicion'].'","autoAnalisis":"'.$autoAnalisisCodigo.'","fechaEdit":"'.date("Y-m-d H:i").'"}]';
			}
			
			// SE DETECTAN 7 MODIFICACIONES AUTOMATICAMENTE:
			// 1 Eliminación de productos originales
			// 2 Incorporación de nuevos productos en venta
			// 3 Variación de stock en productos originales
			// 4 Baja en total venta, Alza en total venta
			// 5 Modificación de cliente
			// 6 Modificación de metodo de pago
			// 7 Modificación en detalle de venta
				
			// CODIGO QUE DECODIFICA AUTOANALISIS
			//         $traduccionAutoAnalisis = ['Eliminación de productos originales','Incorporación de nuevos productos en venta','Variación de stock en productos originales', 'Variación en total Venta','Modificación de cliente','Modificación de metodo de pago','Modificación en detalle de venta'];
			//         $str = '1-0-0-1-1-1-0';
			//         $str1 = explode('-',$str);

			//         $autoAnalisisTraducido = '<b>Autoanálisis</b>. Se detecta:<br>';
			//         for ($i=0; $i < count($str1) ; $i++) { 
			//             if($str1[$i] == 1){
			//              $autoAnalisisTraducido .= $traduccionAutoAnalisis[$i].'<br>';
			//             }    
			//         }
			// echo $autoAnalisisTraducido;

			$deteccionExtraibles = $montoExtraible > 0 ? 1 : 0;
			$fechaHora = ControladorAjustes::ctrFechaHora();


			/*=============================================
			GUARDAR CAMBIOS DE LA COMPRA
			=============================================*/	
			$datos = array("id"=>$_POST["idVentaEdit"],
						   "estado"=>2,
						   "vista_vendedor"=>$vistaVendedor,
						   "id_cliente"=>$_POST["seleccionarClienteEditVenta"],
						   "nom_client"=>$_POST["nomClientEditVenta"],
						   "info_edicion"=>$motivoEdicion,
						   "prods_edit_orig"=>$_POST['listaProductosOriginal'],
						   "productos"=>$_POST["listaProductosEditVenta"],
						   "impuesto"=>$totalVenta-round($totalVenta/1.19),
						   "neto"=>round($totalVenta/1.19),
						   "total"=>$totalVenta,
						   "monto_extraible"=>$deteccionExtraibles,
						   "descuentos"=>$ahorro,
						   "detalle_venta"=>$editarDetalleVenta,
						   "detalle_flete"=>$editarDetalleFlete,
						   "utilidad_total"=>$ut,
						   "utilidad_neta"=>$utNeta,
						   "fecha"=>$fechaHora,
						   "tipo_pago"=>$_POST['editarMetodoPago'],
						   "metodo_pago"=>$_POST["listaMetodoPagoEditVenta"]);
			$respuesta = ModeloVentas::mdlEditarVenta($tabla, $datos);

			if($respuesta == "ok"){


				if($informarFlete == 1){

					$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
					$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_despachos')['ajuste'];
					require_once(dirname(__FILE__).'/../extensiones/tcpdf/tcpdf.php');
					$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
					$pdf-> setPrintHeader(false);
					$pdf->startPageGroup();
					$pdf->AddPage();

					$nombreComercio = strtoupper(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_comercial')['ajuste']);
					$nombreReal = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'nombre_real')['ajuste']);
					$rutComercio = explode('-',ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'rut_comercial')['ajuste']);
					$rutMostrar = number_format($rutComercio[0],0,',','.').'-'.$rutComercio[1];
					$direccionComercio = ucwords(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'direccion_comercial')['ajuste']);
					$wsp = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_ventas')['ajuste'];
					$fonoVenta = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'] == '' ? '' : 'Fono-Ventas: '.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'fono_ventas')['ajuste'].'<br>';
					$correo = strtolower(ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'correo_ventas')['ajuste']);
					$logo = 'src="'.dirname(__FILE__).'/../extensiones/tcpdf/pdf/'.ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'logotipo_ventas')['ajuste'].'"';

					$bloque1 = '
						<table>
						    <tr>
						      	<td style="width:150px"><img '.$logo.'></td>
						      	<td style="background-color:white; width:140px">
						        	<div style="font-size:8.5px; text-align:right; line-height:15px;">
						        		<br>'.$nombreComercio.'<br>'.$nombreReal.'<br>'.$rutMostrar.'<br>Dirección: '.$direccionComercio.'
						        	</div>
						      	</td>
						      	<td style="background-color:white; width:140px">
						        	<div style="font-size:8.5px; text-align:right; line-height:15px;">
						          		<br>Whatsapp: '.$wsp.'<br>'.$fonoVenta.'<br>'.$correo.'
						        	</div>
						      	</td>
						      	<td style="background-color:white; width:110px; text-align:center"><br><br>Venta Nro. <br>'.$codVenta.'</td>
						    </tr>
						</table>';
					$pdf->writeHTML($bloque1, false, false, false, false, '');

					// ---------------------------------------------------------

					$bloque2 = '
					  	<table><tr><td style="width:540px"><img src="images/back.jpg"></td></tr></table>

					  	<table style="font-size:10px; padding:5px 10px;">
					    	<tr>
					      		<td style="border: 1px solid #666; background-color:white; width:390px">Cliente: '.$_POST["nomClientEditVenta"].'</td>
					      		<td style="border: 1px solid #666; background-color:white; width:150px; text-align:right">Fecha: '.$fechaHora.'</td>
					    	</tr>
					    	<tr>
					      		<td style="border: 1px solid #666; background-color:white; width:540px">Vendedor: '.$nomVend.'</td>
					    	</tr>
					    	<tr>
					      		<td style="border-bottom: 1px solid #666; background-color:white; width:540px"></td>
					    	</tr>
					  	</table>';
					$pdf->writeHTML($bloque2, false, false, false, false, '');


					// ENCABEZADOS COLUMNAS
					$bloque3 = '

					  	<table style="font-size:10px; padding:5px 10px;">
					    	<tr>
								<td style="border: 1px solid #333; background-color:white; width:50px; text-align:center; font-size:9px"><b>CANT</b></td>
								<td style="border: 1px solid #333; background-color:white; width:55px; text-align:left; font-size:9px"><b>COD</b></td>
								<td style="border: 1px solid #333; background-color:white; width:270px; text-align:left; font-size:9px"><b>PRODUCTOS</b></td>
								<td style="border: 1px solid #333; background-color:white; width:80px; text-align:center; font-size:9px"><b>$ UNIT. C/IVA</b></td>
								<td style="border: 1px solid #333; background-color:white; width:85px; text-align:center; font-size:9px"><b>VALOR TOTAL</b></td>
					    	</tr>
					  	</table>';
					$pdf->writeHTML($bloque3, false, false, false, false, '');

					foreach(array_reverse($listaProductos_2) as $key => $item) {
						$valorUnitarioNeto = number_format(($item["tot"]/$item["cant"])/1.19, 2,',','.');
						$valorUnitario = number_format($item["tot"]/$item["cant"], 0,',','.');
						$precioUnitario = '$ '.$valorUnitario;
						$dcto = $item["dcto"] > 0 ? "<b>(Dcto: ".$item["dcto"]."%)</b>" : "";
						$precioTotal = number_format($item["tot"], 0,',','.');

						$bloque4 = '
					    	<table style="font-size:10px; padding:5px 10px;">
					      		<tr>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:50px; text-align:center; font-size:9px">'.$item['cant'].'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:55px; text-align:left; font-size:9px">'.$item['sku'].'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:270px; text-align:left; font-size:9px">'.$item['prod'].' '.$dcto.'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:80px; text-align:center; font-size:9px">'.$precioUnitario.'</td>
					        		<td style="border: 1px solid #333; color:#333; background-color:white; width:85px; text-align:center; font-size:9px">$ '.$precioTotal.'</td>
					      		</tr>
					    	</table>';
						$pdf->writeHTML($bloque4, false, false, false, false, '');
					}

					$bloque5 = '
						<table style="font-size:10px; padding:5px 10px;">
					    	<tr>
					      		<td style="color:#333; background-color:white; width:340px; text-align:center"></td>
					      		<td style="border-bottom: 1px solid #666; background-color:white; width:100px; text-align:center"></td>
					      		<td style="border-bottom: 1px solid #666; color:#333; background-color:white; width:100px; text-align:center"></td>
					    	</tr>
					    	<tr>
					      		<td style="border-right: 1px solid #666; color:#333; background-color:white; width:340px; text-align:center"></td>
								<td style="border: 1px solid #666; background-color:white; width:100px; text-align:center">TOTAL:</td>
								<td style="border: 1px solid #666; color:#333; background-color:white; width:100px; text-align:center">$ '.number_format($totalVenta,0,',','.').'</td>
					    	</tr>
					  	</table>';
					$pdf->writeHTML($bloque5, false, false, false, false, '');

					// DETALLES Y METODO DE PAGO
					$metPago = json_decode($_POST["editarMetodoPago"]);
					$filaObservaciones = $editarDetalleVenta == '' ? '' : '<tr><td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">OBSERVACIONES:</td><td style="font-size:13px; color:#333; background-color:white; width:390px; text-align:left">'.strtoupper($editarDetalleVenta).'</td></tr>';

					if($_POST['metodoPagoVentaCot']=="Efectivo"){
						$cash = number_format($metPago[0]->cash,0,',','.');
						$total = number_format($metPago[0]->total,0,',','.');
						$vuelto = number_format($metPago[0]->vuelto,0,',','.');

						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
								'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:340px; text-align:left">METODO PAGO:</td>
									<td style="font-size:10px; background-color:white; width:100px; text-align:right">CASH<br>TOTAL<br>VUELTO</td>
									<td style="font-size:10px; color:#333; background-color:white; width:100px; text-align:center">:$ '.$cash.'<br>:$ '.$total.'<br>:$ '.$vuelto.'</td>
					    		</tr>
					  		</table>';
					}else if($_POST['metodoPagoVentaCot']=="Transferencia"){
						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
					      			<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
					      			<td style="font-size:13px; background-color:white; width:390px; text-align:left">SE PAGÓ VÍA TRANSFERENCIA ELECTRÓNICA</td>
					    		</tr>
					  		</table>';
					}else if($_POST['metodoPagoVentaCot']=="TD"){
						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">'.$_POST["editarMetodoPago"].'</td>
					    		</tr>
							</table>';
					}else if($_POST['metodoPagoVentaCot']=="TC"){
						$bloque6 = '
					  		<table style="padding:5px 10px;">
					    		<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">'.$_POST["editarMetodoPago"].'</td>
					    		</tr>
					  		</table>';
					}else if($_POST['metodoPagoVentaCot']=="E_TC" || $_POST['metodoPagoVentaCot']=="E_TD"){
						$bloque6 = '
							<table style="padding:5px 10px;">
								<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">SE PAGÓ CON PAGO COMBINADO</td>
					    		</tr>
					  		</table>';
					}else if($_POST['metodoPagoVentaCot']=="Fiado"){
						$bloque6 = '
							<table style="padding:5px 10px;">
								<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">CRÉDITO INTERNO</td>
								</tr>
							</table>';
					}else if($_POST['metodoPagoVentaCot']=="Pend"){
						$bloque6 = '
							<table style="padding:5px 10px;">
								<tr><td></td></tr>
					    		'.$filaObservaciones.'
					    		<tr>
									<td style="font-size:13px; color:#333; background-color:white; width:150px; text-align:left">METODO PAGO:</td>
									<td style="font-size:13px; background-color:white; width:390px; text-align:left">COBRAR EN REPARTO</td>
								</tr>
							</table>';
					}


					$pdfOutput = dirname(__FILE__).'/'.$codVenta.'.pdf';
					$pdf->Output($pdfOutput, 'F'); // 'F' es para guardar el archivo en el servidor

			        $nombreClienteDespacho = explode(' // ', $editarDetalleFlete)[0];
			        $nroClienteDespacho = explode(' // ', $editarDetalleFlete)[1];
			        $direccionDespacho = explode(' // ', $editarDetalleFlete)[2];
			        $metodoPago = $_POST['metodoPagoVentaCot'] == 'Pend' ? "COBRAR EN DESPACHO *$".number_format($totalVenta,0,',','.')."*" : "EL PEDIDO YA ESTÁ PAGADO";

			                // NOTIFICACION TELEGRAM
			        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
			        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_despachos')['ajuste'];

			        $mensajeWhatsapp = 'Hola, le hablamos de Ferretería SAMA por su pedido';
	    			$linkWhatsapp = "[Enviar Whatsapp](https://api.whatsapp.com/send?phone=+56".$nroClienteDespacho."&text=".urlencode($mensajeWhatsapp).")\n\n";

			        $texto =  "🚛 🚛 🚛 *DESPACHO* 🚛 🚛 🚛\n\n\n*VENTA NRO. ".$codVenta."*\n\nNOMBRE   : *".strtoupper($nombreClienteDespacho)."*\nTELEFONO : +56".$nroClienteDespacho."\nDIRECCION: *".strtoupper($direccionDespacho)."*\n".$linkWhatsapp."\n\n".$metodoPago;
			        $formato = 'Markdown';
					notificarTelegramPDFTexto($chatID, $texto, $pdfOutput, $token, $formato);

				}



				$idVenta = $_POST["idVentaEdit"];
				// if($vistaVendedor == 1){
				// 	imprimirBoletaPHP($fechaHora,$traerVenta["nom_vend"],$_POST["listaProductosEditVenta"],$_POST["nomClientEditVenta"],$totalVenta,$traerVenta["cod_venta"],$_POST["listaMetodoPagoEditVenta"],$_POST['editarMetodoPago'],$editarDetalleFlete);
				// }
				
				echo'
				<script>
					localStorage.removeItem("rango");
				    var audio = new Audio("componentes/sonidos/success.mp3");
				    audio.play();
					Swal.fire({
					  	icon: "success",
						title: "La venta ha sido editada correctamente",
						showConfirmButton: true,
						confirmButtonText: "Cerrar"
						}).then((result) => {

							if('.$_SESSION["conexionImpresoraLocal"].' == 1 && esDispositivoMovil() == false){

								if (result.value) {
									Swal.fire({
										icon:"question",
					  					title: "<h1>¿Imprimir Ticket?</h1>",
					  					showDenyButton: true,
										confirmButtonText: "SI",
										denyButtonText: "NO",
										customClass: {
					    					actions: "my-actions",
											cancelButton: "order-1 right-gap boton-cancelar",
											confirmButton: "order-2 btn boton-confirmar",
											denyButton: "order-3 btn boton-denegar",
											title: "titulo-modif",
					  					}
									}).then((result) => {
					  					if (result.isConfirmed) {
					  						extraerDatosVentaTicket('.$idVenta.');
											setTimeout(function () {
						  						window.location = "'.$ventaRedireccion.'";
											}, 2000);

									  	} else if (result.isDenied) {
					  						window.location = "'.$ventaRedireccion.'";
					  					}
					  				})
								}
							}else{
								window.location = "'.$ventaRedireccion.'";
							}
						})
				</script>';
			}
		}
	}

	/*=============================================
	ELIMINAR VENTA
	=============================================*/
	static public function ctrEliminarVenta(){
    	$sucursal = $_SESSION['sucursal'];
    	$ventana = $_GET['ruta'];
		if(isset($_GET["idVenta"])){
			$tabla = "ventas";
			$item = "id";
			$valor = $_GET["idVenta"];
			$compItem = '=';
            $compEstado = '!=';
            $estado = 0;
            $filOrden = 'fecha_cont';
            $ord = 'DESC';                    
            $traerVenta = ControladorVentas::ctrMostrarVentas($item, $valor, $compItem, $compEstado, $estado, $filOrden, $ord);
			/*=============================================
			ACTUALIZAR FECHA ÚLTIMA COMPRA
			=============================================*/
			$tablaClientes = "clientes";
			$itemVentas = null;
			$valorVentas = null;
			$compItem = '=';
            $compEstado = '!=';
            $estado = 0;
            $filOrden = 'fecha_cont';
            $ord = 'DESC';                    
            $traerVentas = ControladorVentas::ctrMostrarVentas($itemVentas, $valorVentas, $compItem, $compEstado, $estado, $filOrden, $ord);				
			$guardarFechas = array();
			foreach ($traerVentas as $key => $value) {
				if($value["id_cliente"] == $traerVenta["id_cliente"]){
					array_push($guardarFechas, $value["fecha"]);
				}
			}

			if(count($guardarFechas) > 1){
				if($traerVenta["fecha"] > $guardarFechas[count($guardarFechas)-2]){
					$item = "ultima_compra";
					$valor = $guardarFechas[count($guardarFechas)-2];
					$valorIdCliente = $traerVenta["id_cliente"];
					$comprasCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item, $valor, $valorIdCliente);
				}else{
					$item = "ultima_compra";
					$valor = $guardarFechas[count($guardarFechas)-1];
					$valorIdCliente = $traerVenta["id_cliente"];
					$comprasCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item, $valor, $valorIdCliente);
				}
			}else{
				$item = "ultima_compra";
				$valor = null;
				$valorIdCliente = $traerVenta["id_cliente"];
				$comprasCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item, $valor, $valorIdCliente);
			}



			/*=============================================
			FORMATEAR TABLA DE PRODUCTOS Y LA DE CLIENTES
			=============================================*/
			$productos =  json_decode($traerVenta["productos"], true);
			$totalProductosComprados = array();
			$ultimoRegistro = ModeloProductos::mdlSeleccionarUltimoIdRegistro();//
			foreach ($productos as $key => $value) {
				array_push($totalProductosComprados, $value["cant"]);
				$tablaProductos = "productos";
				$item = "id";
				$valor = $value["id"];
				$orden = "id";
				$traerProducto = ModeloProductos::mdlMostrarProductos($tablaProductos, $item, $valor, $orden);

				$item1a = "ventas_".$sucursal;
				$valor1a = $traerProducto["ventas_".$sucursal] - $value["cant"];
				$nuevasVentas = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1a, $valor1a, $valor);

				$item1b = "stock_".$sucursal;
				$valor1b = $value["cant"] + $traerProducto["stock_".$sucursal];
				$nuevoStock = ModeloProductos::mdlActualizarProducto($tablaProductos, $item1b, $valor1b, $valor);

				// REGISTRO ACTIVIDAD INVENTARIO
				$regActividadElimVenta = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistro[0]+1, $sucursal, 'elimVenta', $value['cant'], $traerVenta["cod_venta"], $value['id'], $_SESSION['id'], $_SESSION['nombre']);//
			}

			$tablaClientes = "clientes";
			$itemCliente = "id";
			$valorCliente = $traerVenta["id_cliente"];
			$traerCliente = ModeloClientes::mdlMostrarClientes($tablaClientes, $itemCliente, $valorCliente);

			$item1a = "prods_comprados";
			$valor1a = $traerCliente["prods_comprados"] - array_sum($totalProductosComprados);
			$comprasCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1a, $valor1a, $valorCliente);

			// RESTAR SALDO DEUDA SI FUE COMPRADO CON CREDITO
			if($traerVenta["tipo_pago"]=='Fiado'){
				$item1a = "deuda_cliente";
				$valor1a = $traerCliente["deuda_cliente"] - $traerVenta["total"]; 
				$deudaCliente = ModeloClientes::mdlActualizarCliente($tablaClientes, $item1a, $valor1a, $valorCliente);
			}

			/*=============================================
			ELIMINAR VENTA
			=============================================*/
			$respuesta = ModeloVentas::mdlEliminarVenta($tabla, $_GET["idVenta"]);
			if($respuesta == "ok"){
				echo'
				<script>
					Swal.fire({
					icon: "success",
					title: "La venta ha sido borrada correctamente",
					showConfirmButton: true,
					confirmButtonText: "Cerrar"
					}).then(function(result){
						if (result.value) {
							window.location = "'.$ventana.'";
						}
					})
				</script>';
			}		
		}

	}

	/*=============================================
	RANGO FECHAS
	=============================================*/	
	static public function ctrRangoFechasVentas($fechaInicial, $fechaFinal, $rol, $idUsuario){

		$tabla = "ventas";
		$respuesta = ModeloVentas::mdlRangoFechasVentas($tabla, $fechaInicial, $fechaFinal, $rol, $idUsuario);
		return $respuesta;

	}

	/*=============================================
	DESCARGAR EXCEL
	=============================================*/
	// public function ctrDescargarReporte(){
	// 	if(isset($_GET["reporte"])){
	// 		$tabla = "ventas";
	// 		if(isset($_GET["fechaInicial"]) && isset($_GET["fechaFinal"])){
	// 			$ventas = ModeloVentas::mdlRangoFechasVentas($tabla, $_GET["fechaInicial"], $_GET["fechaFinal"], $rol, $idUsuario);
	// 		}else{
			// $itemVentas = null;
			// $valorVentas = null;
   //          $compEstado = '!=';
   //          $estado = 0;
   //          $filOrden = 'fecha_cont';
   //          $ord = 'DESC';                    
   //          $traerVentas = ControladorVentas::ctrMostrarVentas($itemVentas, $valorVentas, $compEstado, $estado, $filOrden, $ord);	
	// 		}

	// 		/*=============================================
	// 		CREAMOS EL ARCHIVO DE EXCEL
	// 		=============================================*/
	// 		$Name = $_GET["reporte"].'.xls';
	// 		header('Expires: 0');
	// 		header('Cache-control: private');
	// 		header("Content-type: application/vnd.ms-excel"); // Archivo de Excel
	// 		header("Cache-Control: cache, must-revalidate"); 
	// 		header('Content-Description: File Transfer');
	// 		header('Last-Modified: '.date('D, d M Y H:i:s'));
	// 		header("Pragma: public"); 
	// 		header('Content-Disposition:; filename="'.$Name.'"');
	// 		header("Content-Transfer-Encoding: binary");

	// 		echo utf8_decode("<table border='0'> 
	// 			<tr> 
	// 				<td style='font-weight:bold; border:1px solid #eee;'>FECHA</td>		
	// 				<td style='font-weight:bold; border:1px solid #eee;'>CÓDIGO</td> 
	// 				<td style='font-weight:bold; border:1px solid #eee;'>CLIENTE</td>
	// 				<td style='font-weight:bold; border:1px solid #eee;'>VENDEDOR</td>
	// 				<td style='font-weight:bold; border:1px solid #eee;'>LUGAR</td>
	// 				<td style='font-weight:bold; border:1px solid #eee;'>PRODUCTOS</td>
	// 				<td style='font-weight:bold; border:1px solid #eee;'>TOTAL</td>		
	// 				<td style='font-weight:bold; border:1px solid #eee;'>METODO DE PAGO</td	
	// 			</tr>");

	// 		foreach ($ventas as $row => $item){
	// 			echo utf8_decode("
	// 				<tr>
	// 					<td style='border:1px solid #eee;'>".substr($item["fecha"],0,10)."</td>		
	// 					<td style='border:1px solid #eee;'>".$item["codigo"]."</td> 
	// 		 			<td style='border:1px solid #eee;'>".$item["nom_client"]."</td>
	// 		 			<td style='border:1px solid #eee;'>".$item["nom_vend"]."</td>
	// 		 			<td style='border:1px solid #eee;'>".$item["detalle_venta"]."</td>
	// 		 			<td style='border:1px solid #eee;'>");
	// 				 	$productos =  json_decode($item["productos"], true);
	// 				 	// foreach ($productos as $key => $valueProductos) {
	// 			 		// 	echo utf8_decode($valueProductos["cant"]." ".$valueProductos["prod"]."<br>");
	// 			 		// }
	// 				 	// echo utf8_decode("</td><td style='border:1px solid #eee;'>");	
	// 			 		foreach ($productos as $key => $valueProductos) {
	// 			 			echo utf8_decode($valueProductos["cant"]." ".$valueProductos["prod"]." <b>$ ".number_format($valueProductos["tot"],0,',','.')."</b><br>");
	// 			 		}
	// 			 		echo utf8_decode("</td>
	// 					<td style='border:1px solid #eee;'>$ ".number_format($item["total"],0,',','.')."</td>
	// 					<td style='border:1px solid #eee;'>".$item["tipo_pago"]."</td>
	// 	 			</tr>");
	// 		}
	// 		echo "</table>";
	// 	}
	// }
	

	public function ctrDescargarReporte(){
		if(isset($_GET["reporte"])){
			$tabla = "ventas";
			if(isset($_GET["fechaInicial"]) && isset($_GET["fechaFinal"])){
				$ventas = ModeloVentas::mdlRangoFechasVentas($tabla, $_GET["fechaInicial"], $_GET["fechaFinal"], $rol, $idUsuario);
			}else{
				$item = null;
				$valor = null;
				$compItem = '=';
	            $compEstado = '!=';
	            $estado = 0;
	            $filOrden = 'fecha_cont';
	            $ord = 'DESC';                    
	            $ventas = ControladorVentas::ctrMostrarVentas($itemVentas, $valorVentas, $compItem, $compEstado, $estado, $filOrden, $ord);				
			}

			/*=============================================
			CREAMOS EL ARCHIVO DE EXCEL
			=============================================*/
			$Name = $_GET["reporte"].'.xls';
			header('Expires: 0');
			header('Cache-control: private');
			header("Content-type: application/vnd.ms-excel"); // Archivo de Excel
			header("Cache-Control: cache, must-revalidate"); 
			header('Content-Description: File Transfer');
			header('Last-Modified: '.date('D, d M Y H:i:s'));
			header("Pragma: public"); 
			header('Content-Disposition:; filename="'.$Name.'"');
			header("Content-Transfer-Encoding: binary");

			echo utf8_decode("<table border='0'> 
				<tr> 
					<td style='font-weight:bold; border:1px solid #eee;'>CÓDIGO</td> 
					<td style='font-weight:bold; border:1px solid #eee;'>CLIENTE</td>
					<td style='font-weight:bold; border:1px solid #eee;'>VENDEDOR</td>
					<td style='font-weight:bold; border:1px solid #eee;'>CANTIDAD</td>
					<td style='font-weight:bold; border:1px solid #eee;'>PRODUCTOS</td>
					<td style='font-weight:bold; border:1px solid #eee;'>IMPUESTO</td>
					<td style='font-weight:bold; border:1px solid #eee;'>NETO</td>		
					<td style='font-weight:bold; border:1px solid #eee;'>TOTAL</td>		
					<td style='font-weight:bold; border:1px solid #eee;'>METODO DE PAGO</td	
					<td style='font-weight:bold; border:1px solid #eee;'>FECHA</td>		
				</tr>");

			foreach ($ventas as $row => $item){
				$cliente = ControladorClientes::ctrMostrarClientes("id", $item["id_cliente"]);
				$vendedor = ControladorUsuarios::ctrMostrarUsuarios("id", $item["id_vendedor"]);
				echo utf8_decode("
					<tr>
						<td style='border:1px solid #eee;'>".$item["codigo"]."</td> 
			 			<td style='border:1px solid #eee;'>".$cliente["nombre"]."</td>
			 			<td style='border:1px solid #eee;'>".$vendedor["nombre"]."</td>
			 			<td style='border:1px solid #eee;'>");
					 	$productos =  json_decode($item["productos"], true);
					 	foreach ($productos as $key => $valueProductos) {
				 			echo utf8_decode($valueProductos["cant"]."<br>");
				 		}
					 	echo utf8_decode("</td><td style='border:1px solid #eee;'>");	
				 		foreach ($productos as $key => $valueProductos) {
				 			echo utf8_decode($valueProductos["prod"]."<br>");
				 		}
				 		echo utf8_decode("</td>
						<td style='border:1px solid #eee;'>$ ".number_format($item["impuesto"],0)."</td>
						<td style='border:1px solid #eee;'>$ ".number_format($item["neto"],0)."</td>	
						<td style='border:1px solid #eee;'>$ ".number_format($item["total"],0)."</td>
						<td style='border:1px solid #eee;'>".$item["metodo_pago"]."</td>
						<td style='border:1px solid #eee;'>".substr($item["fecha"],0,10)."</td>		
		 			</tr>");
			}
			echo "</table>";
		}
	}
	/*=============================================
	DESCARGAR EXCEL
	=============================================*/
	// public function ctrVentasCliente(){
	// 	if(isset($_GET["cliente"])){
	// 		$tabla = "ventas";
	// 		if(isset($_GET["fechaInicial"]) && isset($_GET["fechaFinal"])){
	// 			$ventas = ModeloVentas::mdlRangoFechasVentas($tabla, $_GET["fechaInicial"], $_GET["fechaFinal"], $rol, $idUsuario);
	// 		}else{
			// $itemVentas = null;
			// $valorVentas = null;
   //          $compEstado = '!=';
   //          $estado = 0;
   //          $filOrden = 'fecha_cont';
   //          $ord = 'DESC';                    
   //          $traerVentas = ControladorVentas::ctrMostrarVentas($itemVentas, $valorVentas, $compEstado, $estado, $filOrden, $ord);	
	// 		}

	// 		/*=============================================
	// 		CREAMOS EL ARCHIVO DE EXCEL
	// 		=============================================*/
	// 		$Name = $_GET["reporte"].'.xls';
	// 		header('Expires: 0');
	// 		header('Cache-control: private');
	// 		header("Content-type: application/vnd.ms-excel"); // Archivo de Excel
	// 		header("Cache-Control: cache, must-revalidate"); 
	// 		header('Content-Description: File Transfer');
	// 		header('Last-Modified: '.date('D, d M Y H:i:s'));
	// 		header("Pragma: public"); 
	// 		header('Content-Disposition:; filename="'.$Name.'"');
	// 		header("Content-Transfer-Encoding: binary");

	// 		echo utf8_decode("<table border='0'> 
	// 			<tr> 
	// 				<td style='font-weight:bold; border:1px solid #eee;'>CÓDIGO</td> 
	// 				<td style='font-weight:bold; border:1px solid #eee;'>CLIENTE</td>
	// 				<td style='font-weight:bold; border:1px solid #eee;'>VENDEDOR</td>
	// 				<td style='font-weight:bold; border:1px solid #eee;'>CANTIDAD</td>
	// 				<td style='font-weight:bold; border:1px solid #eee;'>PRODUCTOS</td>
	// 				<td style='font-weight:bold; border:1px solid #eee;'>IMPUESTO</td>
	// 				<td style='font-weight:bold; border:1px solid #eee;'>NETO</td>		
	// 				<td style='font-weight:bold; border:1px solid #eee;'>TOTAL</td>		
	// 				<td style='font-weight:bold; border:1px solid #eee;'>METODO DE PAGO</td	
	// 				<td style='font-weight:bold; border:1px solid #eee;'>FECHA</td>		
	// 			</tr>");

	// 		foreach ($ventas as $row => $item){
	// 			$cliente = ControladorClientes::ctrMostrarClientes("id", $item["id_cliente"]);
	// 			$vendedor = ControladorUsuarios::ctrMostrarUsuarios("id", $item["id_vendedor"]);
	// 			echo utf8_decode("
	// 				<tr>
	// 					<td style='border:1px solid #eee;'>".$item["codigo"]."</td> 
	// 		 			<td style='border:1px solid #eee;'>".$cliente["nombre"]."</td>
	// 		 			<td style='border:1px solid #eee;'>".$vendedor["nombre"]."</td>
	// 		 			<td style='border:1px solid #eee;'>");
	// 				 	$productos =  json_decode($item["productos"], true);
	// 				 	foreach ($productos as $key => $valueProductos) {
	// 			 			echo utf8_decode($valueProductos["cantidad"]."<br>");
	// 			 		}
	// 				 	echo utf8_decode("</td><td style='border:1px solid #eee;'>");	
	// 			 		foreach ($productos as $key => $valueProductos) {
	// 			 			echo utf8_decode($valueProductos["descripcion"]."<br>");
	// 			 		}
	// 			 		echo utf8_decode("</td>
	// 					<td style='border:1px solid #eee;'>$ ".number_format($item["impuesto"],2)."</td>
	// 					<td style='border:1px solid #eee;'>$ ".number_format($item["neto"],2)."</td>	
	// 					<td style='border:1px solid #eee;'>$ ".number_format($item["total"],2)."</td>
	// 					<td style='border:1px solid #eee;'>".$item["metodo_pago"]."</td>
	// 					<td style='border:1px solid #eee;'>".substr($item["fecha"],0,10)."</td>		
	// 	 			</tr>");
	// 		}
	// 		echo "</table>";
	// 	}
	// }

	/*=============================================
	SUMA TOTAL VENTAS
	=============================================*/
	static public function ctrSumaTotalVentas(){
		$tabla = "ventas";
		$respuesta = ModeloVentas::mdlSumaTotalVentas($tabla);
		return $respuesta;
	}

	/*=============================================
	SUMA TOTAL VENTAS DIA
	=============================================*/
	static public function ctrSumaTotalVentasDia1($item, $valor){
		$tabla = "ventas";
		$respuesta = ModeloVentas::mdlSumaTotalVentasDia1($tabla, $item, $valor);
		return $respuesta;
	}
	static public function ctrSumaTotalVentasDia2($item1, $valor1, $item2, $valor2){
		$tabla = "ventas";
		$respuesta = ModeloVentas::mdlSumaTotalVentasDia2($tabla, $item1, $valor1, $item2, $valor2);
		return $respuesta;
	}

	/*=============================================
	DETALLE PAGO COMBINADO 
	=============================================*/
	static public function ctrVentasE_TD2($item1, $valor1, $item2, $valor2){
		$tabla = "ventas";
		$respuesta = ModeloVentas::mdlVentasE_TD2($tabla, $item1, $valor1, $item2, $valor2);
		return $respuesta;
	}

	/*=============================================
	SUMA TOTAL VENTAS MES
	=============================================*/
	static public function ctrSumaTotalVentasMes($rol, $idUsuario){

		$tabla = "ventas";
		$respuesta = ModeloVentas::mdlSumaTotalVentasMes($tabla, $rol, $idUsuario);
		return $respuesta;

	}

	/*=============================================
	SUMA TOTAL VENTAS MES ANTERIOR
	=============================================*/
	static public function ctrSumaTotalVentasMesAnt($rol, $idUsuario){

		$tabla = "ventas";
		$respuesta = ModeloVentas::mdlSumaTotalVentasMesAnt($tabla, $rol, $idUsuario);
		return $respuesta;

	}



	/*=============================================
	SUMA TOTAL UTILIDADES
	=============================================*/
	static public function ctrSumaTotalUtilidad(){

		$tabla = "ventas";
		$respuesta = ModeloVentas::mdlSumaTotalUtilidades($tabla);
		return $respuesta;

	}

	/*=============================================
	SUMA TOTAL UTILIDADES MES
	=============================================*/
	static public function ctrSumaTotalUtilidadMes(){

		$tabla = "ventas";
		$respuesta = ModeloVentas::mdlSumaTotalUtilidadesMes($tabla);
		return $respuesta;

	}

	/*=============================================
	DESCARGAR XML
	=============================================*/
	static public function ctrDescargarXML(){

		if(isset($_GET["xml"])){
			$tabla = "ventas";
			$item = "codigo";
			$valor = $_GET["xml"];
			$compItem = '=';
            $compEstado = '!=';
            $estado = 0;
            $filOrden = 'fecha_cont';
            $ord = 'DESC';                
            $ventas = ControladorVentas::ctrMostrarVentas($item, $valor, $compItem, $compEstado, $estado, $filOrden, $ord);		   

			// PRODUCTOS
			$listaProductos = json_decode($ventas["productos"], true);

			// CLIENTE
			$tablaClientes = "clientes";
			$item = "id";
			$valor = $ventas["id_cliente"];
			$traerCliente = ModeloClientes::mdlMostrarClientes($tablaClientes, $item, $valor);

			// VENDEDOR
			$tablaVendedor = "usuarios";
			$item = "id";
			$valor = $ventas["id_vendedor"];
			$traerVendedor = ModeloUsuarios::mdlMostrarUsuarios($tablaVendedor, $item, $valor);

			//http://php.net/manual/es/book.xmlwriter.php
			$objetoXML = new XMLWriter();
			$objetoXML->openURI($_GET["xml"].".xml"); //Creación del archivo XML
			$objetoXML->setIndent(true); //recibe un valor booleano para establecer si los distintos niveles de nodos XML deben quedar indentados o no.
			$objetoXML->setIndentString("\t"); // carácter \t, que corresponde a una tabulación
			$objetoXML->startDocument('1.0', 'utf-8');// Inicio del documento
			// $objetoXML->startElement("etiquetaPrincipal");// Inicio del nodo raíz
			// $objetoXML->writeAttribute("atributoEtiquetaPPal", "valor atributo etiqueta PPal"); // Atributo etiqueta principal
			// 	$objetoXML->startElement("etiquetaInterna");// Inicio del nodo hijo
			// 		$objetoXML->writeAttribute("atributoEtiquetaInterna", "valor atributo etiqueta Interna"); // Atributo etiqueta interna
			// 		$objetoXML->text("Texto interno");// Inicio del nodo hijo
			// 	$objetoXML->endElement(); // Final del nodo hijo
			// $objetoXML->endElement(); // Final del nodo raíz

			$objetoXML->writeRaw('<fe:Invoice xmlns:fe="http://www.dian.gov.co/contratos/facturaelectronica/v1" xmlns:cac="urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2" xmlns:cbc="urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2" xmlns:clm54217="urn:un:unece:uncefact:codelist:specification:54217:2001" xmlns:clm66411="urn:un:unece:uncefact:codelist:specification:66411:2001" xmlns:clmIANAMIMEMediaType="urn:un:unece:uncefact:codelist:specification:IANAMIMEMediaType:2003" xmlns:ext="urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2" xmlns:qdt="urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2" xmlns:sts="http://www.dian.gov.co/contratos/facturaelectronica/v1/Structures" xmlns:udt="urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.dian.gov.co/contratos/facturaelectronica/v1 ../xsd/DIAN_UBL.xsd urn:un:unece:uncefact:data:specification:UnqualifiedDataTypesSchemaModule:2 ../../ubl2/common/UnqualifiedDataTypeSchemaModule-2.0.xsd urn:oasis:names:specification:ubl:schema:xsd:QualifiedDatatypes-2 ../../ubl2/common/UBL-QualifiedDatatypes-2.0.xsd">');

			$objetoXML->writeRaw('<ext:UBLExtensions>');
			foreach ($listaProductos as $key => $value) {
				$objetoXML->text($value["descripcion"].", ");
			}

			$objetoXML->writeRaw('</ext:UBLExtensions>');
			$objetoXML->writeRaw('</fe:Invoice>');
			$objetoXML->endDocument(); // Final del documento
			return true;	
		}
	}

}