<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

class ControladorMovimientos{
	// SE CREA "ctrTraducirMovimiento" PARA REUTILIZAR CUANDO SE REQUIERE EN NUEVAS FUNCIONES
	static public function ctrTraducirMovimiento($id_0,$cargo_0,$abono_0,$tipoMov_0,$moneda_0,$detalle_0,$nomClient_0,$saldo_0,$saldoAnt_0,$nomProv_0,$nroFact_0,$nomEmpleado_0,$nomSocio_0,$nomDistrib_0){
		$detalle_ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $detalle_0);
	 	if($cargo_0!=0){
		 	$cargo = "<font style='color:red'>&darr; $ ".number_format($cargo_0, 0, ',', '.')."</font>";
		 	$abono = '';
	 	}else if($abono_0!=0){
	 		$cargo = '';
	 		$abono = "<font style='color:blue'>&uarr; $ ".number_format($abono_0, 0, ',', '.')."</font>";
	 	}else if($abono_0==0 && $tipoMov_0=='sinVent'){
	 		$cargo = '';
	 		$abono = "<font style='color:blue'>&uarr; $ ".number_format($abono_0, 0, ',', '.')."</font>";
	 	}else{
	 		$cargo = '';
	 		$abono = '';
	 	}


		if($tipoMov_0=='abClient'){
	 		if ($moneda_0=='ef'){
	 			$det0 = 'Abono en Efectivo<br>(<b>';
	 		}else if($moneda_0=='transf'){
	 			$det0 = 'Abono con Transferencia<br>(<b>';
	 		}else if($moneda_0=='td'){
	 			$det0 = 'Abono con '.strtoupper($detalle_ESCAPE).'<br>(<b>';
	 		}else if($moneda_0=='tc'){
	 			$det0 = 'Abono con '.strtoupper($detalle_ESCAPE).'<br>(<b>';
			}
	 		$detail = $det0.$nomClient_0.'</b>)';		 		
	 		if($saldo_0==0 && $saldoAnt_0==0){
		 		$saldo = '-';
		 		$saldo_ant = '-';
	 		}else if($saldo_0<0 && $saldoAnt_0<0){
		 		$saldo = "$ ".number_format(-$saldo_0, 0, ',', '.').' <i>A Favor</i>';
		 		$saldo_ant = "$ ".number_format(-$saldoAnt_0, 0, ',', '.').' <i>A Favor</i>';
	 		}else if($saldo_0<0){
		 		$saldo = "$ ".number_format(-$saldo_0, 0, ',', '.').' <i>A Favor</i>';
		 		$saldo_ant = "$ ".number_format($saldoAnt_0, 0, ',', '.');		 			
	 		}else if($saldoAnt_0<0){
		 		$saldo = "$ ".number_format($saldo_0, 0, ',', '.');
		 		$saldo_ant = "$ ".number_format(-$saldoAnt_0, 0, ',', '.').' <i>A Favor</i>';
	 		}else{
		 		$saldo = "$ ".number_format($saldo_0, 0, ',', '.');
		 		$saldo_ant = "$ ".number_format($saldoAnt_0, 0, ',', '.');		 			
	 		}
		
	 	}else if($tipoMov_0=='anticipoClient'){
	 		if ($moneda_0=='ef'){
	 			$det0 = 'Anticipo en Efectivo<br>(<b>';
	 		}else if($moneda_0=='transf'){
	 			$det0 = 'Anticipo con Transferencia<br>(<b>';
	 		}else if($moneda_0=='td'){
	 			$det0 = 'Anticipo con '.strtoupper($detalle_ESCAPE).'<br>(<b>';
	 		}else if($moneda_0=='tc'){
	 			$det0 = 'Anticipo con '.strtoupper($detalle_ESCAPE).'<br>(<b>';
			}
	 		$detail = $det0.$nomClient_0.'</b>)';		 		
	 		if($saldo_0==0 && $saldoAnt_0==0){
		 		$saldo = '-';
		 		$saldo_ant = '-';
	 		}else if($saldo_0<0 && $saldoAnt_0<0){
		 		$saldo = "<b>$ ".number_format(-$saldo_0, 0, ',', '.').'</b> <i>A Favor</i>';
		 		$saldo_ant = "<b>$ ".number_format(-$saldoAnt_0, 0, ',', '.').'</b> <i>A Favor</i>';
	 		}else if($saldo_0<0){
		 		$saldo = "<b>$ ".number_format(-$saldo_0, 0, ',', '.').'</b> <i>A Favor</i>';
		 		$saldo_ant = "<b>$ ".number_format($saldoAnt_0, 0, ',', '.')."</b>";		 			
	 		}else if($saldoAnt_0<0){
		 		$saldo = "<b>$ ".number_format($saldo_0, 0, ',', '.')."</b>";
		 		$saldo_ant = "<b>$ ".number_format(-$saldoAnt_0, 0, ',', '.').'</b> <i>A Favor</i>';
	 		}else{
		 		$saldo = "<b>$ ".number_format($saldo_0, 0, ',', '.')."</b>";
		 		$saldo_ant = "<b>$ ".number_format($saldoAnt_0, 0, ',', '.')."</b>";		 			
	 		}

	 	}else if($tipoMov_0=='apCaja'){
	 		$detail = 'Aporte Caja';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='efVent' && $abono_0!=0){
	 		$detail = 'Ventas en Efectivo';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='tdVent'){
	 		$detail = 'Ventas Tarjeta Débito';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='tcVent'){
	 		$detail = 'Ventas Tarjeta Crédito';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='transfVent'){
	 		$detail = 'Ventas con Transferencia Electrónica';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='ciVent'){
	 		$detail = 'Ventas con Crédito Interno';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='retCfCh'){
	 		$detail = 'Retiro hacia Caja Chica';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='prestTerc'){
	 		$detail = 'Préstamo a <b>'.$nomClient_0.'</b><br><i>'.ucfirst($detalle_ESCAPE).'</i>';
	 		$saldo = "<b>$ ".number_format($saldo_0, 0, ',', '.')."</b>";
	 		$saldo_ant = "<b>$ ".number_format($saldoAnt_0, 0, ',', '.')."</b>";
	 	}else if($tipoMov_0=='retCfGde'){
	 		$detail = 'Retiro a Caja Fuerte';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='pagProv'){
	 		$detail = 'Pago Proveedor (<b>'.$nomProv_0.'</b>) Factura Nro. <b>'.$nroFact_0.'</b>';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='peaje'){
	 		$detail = 'Peaje';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='pagTrab'){
	 		$detail = 'Pago a <b>'.$nomEmpleado_0.'</b> por <b>'.$detalle_ESCAPE.'</b>';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='compActiv'){
	 		$detail = 'Compra Activo (<b>'.$detalle_ESCAPE.'</b>)';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='pagJobs'){
	 		$detail = 'Reparaciones (<b>'.$detalle_ESCAPE.'</b>)';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='mantActiv'){
	 		$detail = 'Mantención Activo (<b>'.$detalle_ESCAPE.'</b>)';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='retSocio'){
	 		$detail = 'Retiro Dinero (<b>'.$nomSocio_0.'</b>)<br><i>'.ucfirst($detalle_ESCAPE).'</i>';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='otroCargo'){
	 		$detail = $detalle_ESCAPE;
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='otroAbono'){
	 		$detail = $detalle_ESCAPE;
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='abPrest'){
	 		$detail = 'Abono Préstamo '.$nomClient_0;
	 		$saldo = "<b>$ ".number_format($saldo_0, 0, ',', '.')."</b>";
	 		$saldo_ant = "<b>$ ".number_format($saldoAnt_0, 0, ',', '.')."</b>";
	 	}else if($tipoMov_0=='sinVent'){
	 		$detail = 'Sin Ventas';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='prop'){
	 		$detail = 'Propina';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='dctoClient'){
	 		$detail = 'Descuento por: <i>'.$detalle_ESCAPE.'</i> aplicado a <b>'.$nomClient_0.'</b>';
	 		$saldo = "<b>$ ".number_format($saldo_0, 0, ',', '.')."</b>";
	 		$saldo_ant = "<b>$ ".number_format($saldoAnt_0, 0, ',', '.')."</b>";
	 	}else if($tipoMov_0=='devClient'){
	 		$detail = 'Devolución por: <i>'.$detalle_ESCAPE.'</i> aplicado a <b>'.$nomClient_0.'</b>';
	 		$saldo = "<b>$ ".number_format($saldo_0, 0, ',', '.')."</b>";
	 		$saldo_ant = "<b>$ ".number_format($saldoAnt_0, 0, ',', '.')."</b>";
	 	}else if($tipoMov_0=='pagFlete'){
	 		$detail = 'Pago Flete';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='flete'){
	 		$detail = $detalle_ESCAPE;
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='gps'){
	 		$detail = $detalle_ESCAPE;
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='saldo'){
	 		$detail = 'Saldo en Caja';
	 		$saldo = '$ '.number_format($saldo_0, 0, ',', '.');
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='provAmbul'){
	 		$detail = 'Compra '.$detalle_ESCAPE;
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='petroCam'){
	 		$detail = 'Petroleo Camión';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='rentCar'){
	 		$detail = 'Rent a Car';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='gpsEasy'){
	 		$detail = 'GPSEasy';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='apCapit'){
	 		$detail = '<b>APORTE CAPITAL </b>('.$detalle_ESCAPE.')';
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}else if($tipoMov_0=='comiDist'){
	 		$detail = 'PAGO COMISIÓN a <b>'.$nomDistrib_0.'</b> por '.$detalle_ESCAPE;
	 		$saldo = '-';
	 		$saldo_ant = '-';
	 	}

	 	// else{
	 	// 	$detail = 'ERROR';
	 	// 	$saldo = '-';
	 	// 	$saldo_ant = '-';
	 	// }

	 	if($moneda_0=='ef'){
	 		$money = 'Efectivo';
	 	}else if($moneda_0=='td'){
	 		$money = 'Tarjeta Débito';
	 	}else if($moneda_0=='tc'){
	 		$money = 'Tarjeta Crédito';
	 	}else if($moneda_0=='transf'){
	 		$money = 'Transferencia';
	 	}else if($moneda_0=='ci'){
	 		$money = 'Crédito Interno';
	 	}else if($moneda_0=='rc'){
	 		$money = 'Registro Contable';
	 	}else if($moneda_0=='dcto'){
	 		$money = 'Descuento';
	 	}

		return $detail.','.$money.','.$cargo.','.$abono.','.$saldo.','.$saldo_ant.','.$cargo_0.','.$abono_0;

	}


	/*=============================================
	ENVIO EMAIL CON BASE DE DATOS ADJUNTA Y CON INFORME EN PDF
	=============================================*/
	static public function ctrEmailInformePDFyDB($ventEf, $ventTD, $ventTC, $ventTransf, $ventCI, $saldoCaja, $grafVentas){

		require_once(dirname(__FILE__).'/../extensiones/tcpdf/tcpdf.php');
		$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$pdf-> setPrintHeader(false);
		$pdf->startPageGroup();
		$pdf->AddPage();
		$fecha = date('d').'-'.date('M').'-'.date('Y');

		$bloque0 = '
			<table>	
				<tr>
					<td style="width:540px; text-align:center;">
						<h1>Reporte de Ventas y Movimientos $fecha</h1>
					</td>
				</tr>
			</table>
			<br>';	

		$pdf->writeHTML($bloque0, false, false, false, false, '');

		$imgGrafVentas = $grafVentas;

		$img = '<img style="height:auto; width:540px" src="@' . preg_replace('#^data:image/[^;]+;base64,#', '', $imgGrafVentas) . '">';

		$pdf->writeHTML($img, true, false, true, false, '');

		$attachment = $pdf->Output('informe.pdf', 'S'); //PDF A BASE64

		require_once(dirname(__FILE__).'/../extensiones/phpMailer/Exception.php');
		require_once(dirname(__FILE__).'/../extensiones/phpMailer/PHPMailer.php');
		require_once(dirname(__FILE__).'/../extensiones/phpMailer/SMTP.php');

		$mail = new PHPMailer(true);

        $orden = 'id';
        $item1 = 'tipo_mov';
        $valor1 = 'saldo';
		$saldoAyer = ControladorMovimientos::ctrSegundoSaldoAnterior($item1, $valor1, $orden);

		try {
		    //DATOS CUENTA SERVIDOR
		    $mail->SMTPDebug = 0;
		    $mail->isSMTP();
		    $mail->Host       = 'mail.ferreteriasama.cl';
		    $mail->SMTPAuth   = true;
		    $mail->Username   = 'informes@ferreteriasama.cl';
		    $mail->Password   = 'InformesSama0507';
		    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
		    $mail->Port       = 587;

		    //RECEPTORES
		    $mail->setFrom('informes@ferreteriasama.cl', 'Informes');
		    $mail->addAddress('cdinamarca@ferreteriasama.cl', 'Carlos Dinamarca');
		    $mail->addAddress('edinamarca@ferreteriasama.cl', 'Eduardo Dinamarca');

		    // Attachments
		    $mail->addAttachment('respaldosDB/backup-'.DBNAME.'-'.date("Ymd").'.sql.gz');    // Optional name
    		$mail->AddStringAttachment($attachment, 'informe.pdf', 'base64', 'application/pdf');
	
		    // Content
		    $mail->isHTML(true);
		    $mail->Subject = 	'Resumen '.date('d-m-Y');
		    $mail->Body    = 	'<h1>Informe Movimientos '.date('d-m-Y').'</h1><br><br>'.
		    				 	'APERTURA DIA : $'.number_format($saldoAyer['saldo'], 0, ',', '.').'<br>'.
		    				 	'VENTAS EN EFECTIVO: $'.number_format($ventEf, 0, ',', '.').'<br>'.
		    				 	'VENTAS POR TRANSFERENCIA: $'.number_format($ventTransf, 0, ',', '.').'<br>'.
		    				 	'VENTAS CON TD: $'.number_format($ventTD, 0, ',', '.').'<br>'.
		    				 	'VENTAS CON TC: $'.number_format($ventTC, 0, ',', '.').'<br>'.
		    				 	'VENTAS CON CREDITO INTERNO: $'.number_format($ventCI, 0, ',', '.').'<br>'.
		    				 	'SALDO EN CAJA: $'.number_format($saldoCaja, 0, ',', '.').'<br>';
		    $mail->Body    = 	'<h1>Informe Movimientos '.date('d-m-Y').'</h1><br><br>';
		    $mail->send();

		}catch (Exception $e) {
		}

	}



	// TODOS
	static public function ctrMostrarMovimientos($item, $valor, $orden, $ventana){

		$tabla = "movimientos";
		$respuesta = ModeloMovimientos::mdlMostrarMovimientos($tabla, $item, $valor, $orden, $ventana);
		return $respuesta;
	}

	static public function ctrMovSi2LI($item1, $valor1, $item2, $valor2){
		$tabla = "movimientos";
		$respuesta = ModeloMovimientos::mdlMovSi2LI($tabla, $item1, $valor1, $item2, $valor2);
		return $respuesta;
	}

	static public function ctrUltimoItem($item, $valor, $orden){
		$tabla = "movimientos";
		$respuesta = ModeloMovimientos::mdlUltimoItem($tabla, $item, $valor, $orden);
		return $respuesta;
	}

	static public function ctrSegundoSaldoAnterior($item, $valor, $orden){
		$tabla = "movimientos";
		$respuesta = ModeloMovimientos::mdlSegundoSaldoAnterior($tabla, $item, $valor, $orden);
		return $respuesta;
	}

	// /*=============================================
	// SUMA TOTAL ITEMS DIA
	// =============================================*/
	// public static function ctrSumaMovimientosDia($item1, $valor1, $item2, $valor2, $item3){
	// 	$tabla = "movimientos";
	// 	$respuesta = ModeloMovimientos::mdlSumaMovimientosDia($tabla, $item1, $valor1, $item2, $valor2, $item3);
	// 	return $respuesta;

	// }

	/*=============================================
	SUMA 2 CONDICIONES
	=============================================*/
	public static function ctrSumaSi2LI($item1, $valor1, $item2, $valor2, $sumar){
		$tabla = "movimientos";
		$respuesta = ModeloMovimientos::mdlSumaSi2LI($tabla, $item1, $valor1, $item2, $valor2, $sumar);
		return $respuesta;
	}

	/*=============================================
	SUMA 3 CONDICIONES
	=============================================*/
	public static function ctrSumaSi3DLI($item1, $valor1, $item2, $valor2, $item3, $valor3, $sumar){
		$tabla = "movimientos";
		$respuesta = ModeloMovimientos::mdlSumaSi3DLI($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3, $sumar);
		return $respuesta;
	}

	/*=============================================
	CIERRE DIA
	=============================================*/
	public function ctrCerrarDia($ventEf, $ventTD, $ventTC, $ventTransf, $ventCI, $ventasPend, $cantVentasPend, $pag, $montoVendido, $cantVentasDia, $utilidad_dia, $dia_evaluado){


		if(isset($_POST["totalCaja"])){


	      	$productosAbastecer = ModeloProductos::mdlAbastecimientoInterno_AlCierre();

	      	$bodegasExtraccion = [];
	      	$bodegas = ModeloSucursales::mdlMostrarSucursales("sucursales", "tipo_sucursal", "bodega");

			foreach ($bodegas as $key_1 => $value_1) {
	        	$nombreBodega = $value_1['nombre_sucursal'];
	       		array_push($bodegasExtraccion, $nombreBodega);
			}
	      
	      	$texto = "‼️‼️‼️‼️ <b>REPONER MAÑANA</b> ‼️‼️‼️‼️\n\n";

	      	for ($i=0; $i < count($productosAbastecer) ; $i++) { 

	        	if(count($bodegasExtraccion) == 1){
	          		$zona = $productosAbastecer[$i]['zona_bodega1'] == '' ? 's/ZONA' : $productosAbastecer[$i]['zona_bodega1'];
	        	}else{
	          		$zona = '';
	          		for ($i_1=0; $i_1 < count($bodegasExtraccion); $i_1++) { 
						$letraInicial = strtoupper(substr($bodegasExtraccion[$i_1], 0, 1)); // Extraer la primera letra y convertirla a mayúscula
						$nroBodega = preg_replace('/[^0-9]/', '', $bodegasExtraccion[$i_1]); // Extraer solo los números          
						$zonaMostrar = $productosAbastecer[$i_1]['zona_'.$bodegasExtraccion[$i_1]] == '' ? 's/ZONA' : $productosAbastecer[$i_1]['zona_'.$bodegasExtraccion[$i_1]];
						$zona .= '('.$letraInicial.$nroBodega.': <b>'.$zonaMostrar.'</b>) ';
	          		}
	        	}
	          	$sku = $productosAbastecer[$i]['categoria'] < 10 ? '0'.$productosAbastecer[$i]['sku'] : $productosAbastecer[$i]['sku'];
	          	$texto .= '<b>'.$sku."</b> ".strtoupper($productosAbastecer[$i]['desc_sii'])." (".strtoupper($zona).")\n\n";
	      	}


			$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
			$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_reponer')['ajuste'];
	        $formato = 'HTML';
	        $notificar = notificarTelegramTexto($chatID, $texto, $token, $formato);



		    $fechaApi = ControladorAjustes::ctrFechaHora();
		    $fechaHora = new DateTime($fechaApi); // crea un objeto DateTime con la fecha y hora actual


	        $fechaCont = $dia_evaluado;
	        if($dia_evaluado != $fechaHora->format('Y-m-d')){
	        	$fechaIngreso = $dia_evaluado.' 23:59:59';
	        }else{
	    		date_add($fechaHora, date_interval_create_from_date_string("+1 seconds"));
	        	$fechaIngreso = $fechaHora->format('Y-m-d H:i:s');
	        }


	        $diaCerrado = ControladorMovimientos::ctrMovSi2LI('fecha', $dia_evaluado, 'tipo_mov', 'saldo');
			$reporteTelegramCierreDia = "`  VENTAS ".$fechaCont." ".strtoupper($_SESSION['sucursal'])."`\n💵💵💵💵💵💵💵💵💵💵💵💵\n\n";

			$tabla = "movimientos";

			// VENTAS EFECTIVO
			if($ventEf > 0){
			   	$datos = array(	"fecha"=>$fechaIngreso,
						        "fecha_cont"=>$fechaCont,
						        "tipo_mov"=>'efVent',
						        "id_prov"=>0,
						        "nom_prov"=>'-',
						        "nro_fact"=>'-',
						        "id_socio"=>0,
						        "nom_socio"=>'-',
						        "id_empleado"=>0,
						        "nom_empleado"=>'-',
						        "user"=>$_SESSION["id"],
								"nom_user"=>$_SESSION["nombre"],
								"cargo"=>0,
								"abono"=>$ventEf,
						        "detalle"=>'-',
								"moneda"=>'ef',
							    "id_client"=>0,
							    "nom_client"=>'-',
							    "id_distrib"=>0,
							    "nom_distrib"=>'-',
						    	"saldo"=>0,
						    	"saldo_ant"=>0);
				$efectivo = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
				$reporteTelegramCierreDia .= "`Efectivo       : $".number_format($ventEf,0,',','.')."`\n";
			}

			// VENTAS TD
			if($ventTD > 0){
			   	$datos = array(	"fecha"=>(new DateTime($fechaIngreso))->modify('+1 seconds')->format('Y-m-d H:i:s'),
						        "fecha_cont"=>$fechaCont,
						        "tipo_mov"=>'tdVent',
						        "id_prov"=>0,
						        "nom_prov"=>'-',
						        "nro_fact"=>'-',
						        "id_socio"=>0,
						        "nom_socio"=>'-',
						        "id_empleado"=>0,
						        "nom_empleado"=>'-',
						        "user"=>$_SESSION["id"],
								"nom_user"=>$_SESSION["nombre"],
								"cargo"=>0,
								"abono"=>$ventTD,
						        "detalle"=>'-',
								"moneda"=>'td',
							    "id_client"=>0,
							    "nom_client"=>'-',
							    "id_distrib"=>0,
							    "nom_distrib"=>'-',
						    	"saldo"=>0,
						    	"saldo_ant"=>0);
				$td = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
				$reporteTelegramCierreDia .= "`Tarjeta Débito : $".number_format($ventTD,0,',','.')."`\n";
			}

			// VENTAS TC
			if($ventTC > 0){
			   	$datos = array(	"fecha"=>(new DateTime($fechaIngreso))->modify('+2 seconds')->format('Y-m-d H:i:s'),
						        "fecha_cont"=>$fechaCont,
						        "tipo_mov"=>'tcVent',
						        "id_prov"=>0,
						        "nom_prov"=>'-',
						        "nro_fact"=>'-',
						        "id_socio"=>0,
						        "nom_socio"=>'-',
						        "id_empleado"=>0,
						        "nom_empleado"=>'-',
						        "user"=>$_SESSION["id"],
								"nom_user"=>$_SESSION["nombre"],
								"cargo"=>0,
								"abono"=>$ventTC,
						        "detalle"=>'-',
								"moneda"=>'tc',
							    "id_client"=>0,
							    "nom_client"=>'-',
							    "id_distrib"=>0,
							    "nom_distrib"=>'-',
						    	"saldo"=>0,
						    	"saldo_ant"=>0);
				$tc = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
				$reporteTelegramCierreDia .= "`Tarjeta Crédito: $".number_format($ventTC,0,',','.')."`\n";
			}

			// VENTAS TRANSFERENCIA
			if($ventTransf > 0){
			   	$datos = array(	"fecha"=>(new DateTime($fechaIngreso))->modify('+3 seconds')->format('Y-m-d H:i:s'),
						        "fecha_cont"=>$fechaCont,
						        "tipo_mov"=>'transfVent',
						        "id_prov"=>0,
						        "nom_prov"=>'-',
						        "nro_fact"=>'-',
						        "id_socio"=>0,
						        "nom_socio"=>'-',
						        "id_empleado"=>0,
						        "nom_empleado"=>'-',
						        "user"=>$_SESSION["id"],
								"nom_user"=>$_SESSION["nombre"],
								"cargo"=>0,
								"abono"=>$ventTransf,
						        "detalle"=>'-',
								"moneda"=>'transf',
							    "id_client"=>0,
							    "nom_client"=>'-',
							    "id_distrib"=>0,
							    "nom_distrib"=>'-',
						    	"saldo"=>0,
						    	"saldo_ant"=>0);
				$transf = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
				$reporteTelegramCierreDia .= "`Transferencias : $".number_format($ventTransf,0,',','.')."`\n";
			}

			// VENTAS CREDITO INTERNO
			if($ventCI > 0){
			   	$datos = array(	"fecha"=>(new DateTime($fechaIngreso))->modify('+4 seconds')->format('Y-m-d H:i:s'),
						        "fecha_cont"=>$fechaCont,
						        "tipo_mov"=>'ciVent',
						        "id_prov"=>0,
						        "nom_prov"=>'-',
						        "nro_fact"=>'-',
						        "id_socio"=>0,
						        "nom_socio"=>'-',
						        "id_empleado"=>0,
						        "nom_empleado"=>'-',
						        "user"=>$_SESSION["id"],
								"nom_user"=>$_SESSION["nombre"],
								"cargo"=>0,
								"abono"=>$ventCI,
						        "detalle"=>'-',
								"moneda"=>'ci',
							    "id_client"=>0,
							    "nom_client"=>'-',
							    "id_distrib"=>0,
							    "nom_distrib"=>'-',
						    	"saldo"=>0,
						    	"saldo_ant"=>0);
				$ci = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
				$reporteTelegramCierreDia .= "`Crédito Interno: $".number_format($ventCI,0,',','.')."`\n";
			}

			if($cantVentasPend > 0){
				$reporteTelegramCierreDia .= "`Pendientes     : $".number_format($ventasPend,0,',','.')."`\n";				
			}

			$totalVendidoHoy = $ventEf+$ventTD+$ventTC+$ventTransf+$ventCI+$ventasPend;

			$reporteTelegramCierreDia .= "`_______________________________`\n";
			$reporteTelegramCierreDia .= "`TOTAL VENDIDO  : $".number_format($totalVendidoHoy,0,',','.')." (".$cantVentasDia.")`\n";
			$reporteTelegramCierreDia .= "`UTILIDAD DÍA 👉 $".number_format($utilidad_dia,0,',','.')."`";



			$token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
			$chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_cierres')['ajuste'];
	        $formato = 'markdown';
	        $notificar = notificarTelegramTexto($chatID, $reporteTelegramCierreDia, $token, $formato);

			//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
			// // EXTRAER UF DIA SIGUIENTE API
			// $fechaBuscar = date('d-m-Y', strtotime('+1 day'));
			// $apiUrl = 'https://mindicador.cl/api/uf/'.$fechaBuscar;
			// if(ini_get('allow_url_fopen')){
			//     $json = file_get_contents($apiUrl);
			// }else{
			//     //De otra forma utilizamos cURL
			//     $curl = curl_init($apiUrl);
			//     curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			//     $json = curl_exec($curl);
			//     curl_close($curl);
			// }
			// $dailyIndicators = json_decode($json);
			// $valorUFDia = $dailyIndicators->serie[0]->valor;
			// $registrarUF = ModeloMovimientosBancarios::mdlRegistrarUF($valorUFDia);
			//---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

			// CIERRE DIA
          	$sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
    		$inversionTotal = 0;
            foreach ($sucursales as $key => $value){
				$inversionTotal += round(ControladorProductos::ctrMostrarInversion('stock_'.$value['nombre_sucursal'], 'precio_compra')['inversion']); // suma (precio_compra*stock_sucursal) en todos los locales
            }

            $fiadoTotal = round(ModeloClientes::mdlCuentasPorCobrar()['total']);

      		$compromisosMes = ModeloMovimientosBancarios::mdlMostrarCompromisosPagoAtrasadosDashboard('compromisos_pago','id');
      		$hoy = $dia_evaluado;

      		$compromisosAtrasados = 0;
      		foreach ($compromisosMes as $key => $value) {
        		if($value['fecha_vencimiento'] < $hoy && $value['tipo_compromiso'] != 'hipotecario'){
          			$compromisosAtrasados += $value['monto'];
        		}else if($value['fecha_vencimiento'] < $hoy && $value['tipo_compromiso'] == 'hipotecario'){
          			$valorUF = ModeloMovimientosBancarios::mdlValorUF($value['fecha_vencimiento'])['valor'];
          			$compromisosAtrasados += $value['monto']*$valorUF;
        		}
      		}

	        $cajaFuerteTotal=40000;
	        $bancoTotal=50000;

			// require_once "modelos/backup-db.php"; // BACKUP DB
			// $informeEmailVentas = ControladorMovimientos::ctrInformeCierreVentas($ventEf, $ventTD, $ventTC, $ventTransf, $ventCI, $ventasPend, $cantVentasPend, $_POST['totalCaja'], $_POST['grafVentas'], $_POST['retCf'], $montoVendido, $cantVentasDia);
			// $informeEmailInventario = ControladorMovimientos::ctrInformeCierreInventario();

	      //   if($dia_evaluado != explode(' ', $fechaHora->format('Y-m-d H:i:s')[0])){
	      //   	$fechaIngreso = $dia_evaluado.' 23:59:59';
	      //   	$fechaCont = $dia_evaluado;
	      //   }else{
	    		// date_add($fechaHora, date_interval_create_from_date_string("+1 seconds"));
	      //   	$fechaIngreso = $fechaHora->format('Y-m-d H:i:s');
	      //   }

	        $detalleCierre = array(
	        				"bodega"=>$inversionTotal,
					        "cred_int"=>$fiadoTotal,
					        "atrasado"=>round($compromisosAtrasados),
					        "cajaFuerteTotal"=>$cajaFuerteTotal,
					        "banco"=>$bancoTotal,
					        "efectivo_cierre"=>array(	'20k' => str_replace('.', '', $_POST['cuadrar20000']),
														'10k' => str_replace('.', '', $_POST['cuadrar10000']),
														'5k' => str_replace('.', '', $_POST['cuadrar5000']),
														'2k' => str_replace('.', '', $_POST['cuadrar2000']),
														'1k' => str_replace('.', '', $_POST['cuadrar1000']),
														'500' => str_replace('.', '', $_POST['cuadrar500']),
														'100' => str_replace('.', '', $_POST['cuadrar100']),
														'50' => str_replace('.', '', $_POST['cuadrar50']),
														'10' => str_replace('.', '', $_POST['cuadrar10'])));

    		// date_add($fechaHora, date_interval_create_from_date_string("+1 seconds"));
		   	$datos = array(	"fecha"=>(new DateTime($fechaIngreso))->modify('+5 seconds')->format('Y-m-d H:i:s'),
					        "fecha_cont"=>$fechaCont,
					        "tipo_mov"=>'saldo',
					        "id_prov"=>0,
					        "nom_prov"=>'-',
					        "nro_fact"=>'-',
					        "id_socio"=>0,
					        "nom_socio"=>'-',
					        "id_empleado"=>0,
					        "nom_empleado"=>'-',
					        "user"=>$_SESSION["id"],
							"nom_user"=>$_SESSION["nombre"],
							"cargo"=>0,
							"abono"=>0,
					        // "detalle"=>'[{"bodega":"'.$inversionTotal.'","cred_int":"'.$fiadoTotal.'","atrasado":"'.round($compromisosAtrasados).'","cf":"'.$cajaFuerteTotal.'","banco":"'.$bancoTotal.'"}]',
					        "detalle"=>'['.json_encode($detalleCierre).']',
							"moneda"=>'ef',
						    "id_client"=>0,
						    "nom_client"=>'-',
						    "id_distrib"=>0,
						    "nom_distrib"=>'-',
					    	"saldo"=>$_POST['totalCaja'],
					    	"saldo_ant"=>0);
		   	$cierre = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);

		   	if($cierre == "ok"){
				
				echo'<script>

				Swal.fire({
					  icon: "success",
					  title: "Día cerrado correctamente",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar"
					  }).then(function(result){
								if (result.value) {

								window.location = "movimientos-dia";

								}
							})

				</script>';

			}else{

				echo'<script>

				Swal.fire({
					  icon: "error",
					  title: "NO SE CONCRETÓ",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar"
					  }).then(function(result){
								if (result.value) {
								window.location = "'.$pag.'";
								}
							})
				</script>';
			}
		}
	}

	/*=============================================
	INFORME INVENTARIO DIARIO
	=============================================*/
	static public function ctrInformeCierreInventario(){

		require_once(dirname(__FILE__).'/../extensiones/phpMailer/Exception.php');
		require_once(dirname(__FILE__).'/../extensiones/phpMailer/PHPMailer.php');
		require_once(dirname(__FILE__).'/../extensiones/phpMailer/SMTP.php');

		$mail = new PHPMailer(true);
        date_default_timezone_set("America/Santiago");

        // COMPROMISOS DE PAGO CERCANOS, SE ENVÍA SOLO LOS MIÉRCOLES
	    $diaSemana = getdate()['weekday'];
	    $compromisosProxSemana = ModeloMovimientosBancarios::mdlMostrarCompromisosPagoEmail();
	    $tablaCompromisosProxSemana = ''; 
      	$sucursal = $_SESSION['sucursal'];


      	////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      	//----------------------------------------------------------------------------------------------------------------------------------------
      	// INFORME DE PERDIDAS OPTIMIZADAS, CON TOTAL DE PERDIDA Y AVANCE EN CONTROL DE INVENTARIO
      	//----------------------------------------------------------------------------------------------------------------------------------------
        $prodsPerdidos = ModeloActividadInventario::mdlMostrarPerdidasStock(date('Y-m-d'));
        $idsProdsPerdidos = [];

        foreach ($prodsPerdidos as $key => $value) {
          	array_push($idsProdsPerdidos, $value['id_prod']); // agregamos todos los ids
    	}
        $idsUnicosPerdidas = array_values(array_unique($idsProdsPerdidos)); // solo ids unicos

        $cantidadPerdidas = [];
        $idTrabajador = [];
        $conteoPerdidas = 0;

        foreach($idsUnicosPerdidas as $clave) { 
          	foreach ($prodsPerdidos as $key_1 => $value_1) {
              	if($value_1['id_prod'] == $clave){ // revisa si IDS son iguales
                	$conteoPerdidas += $value_1['actividad']; // suma para calcular pérdida
                	$precioCompraPRoducto = $value_1['id_trab'];
              	}
          	}
          	array_push($idTrabajador, $precioCompraPRoducto); // precio de compra de cada producto
          	array_push($cantidadPerdidas, $conteoPerdidas); // ingresa la suma de pérdida
          	$conteoPerdidas = 0; // vuelve a cero conteo para seguir con el siguiente prod
        }
        //----------------------------------------------------------------------------------------------------------------------------------------
        // EJEMPLO RESPUESTA
        // ARRAY_IDS      = [ 113,351,443,1187,2091]
        // ARRAY_PERDIDAS     = [   3,-15, 10,  -4, 109]
        // ARRAY_ID_TRABAJADOR  = [   2,  1,  2,   2,   2]
        //----------------------------------------------------------------------------------------------------------------------------------------

    	$totalPerdidaProd = 0;
    	$totalPerdidaDia = 0;
      	if(count($idsUnicosPerdidas)==0){
        	$tablaProdsPerdidos = '';
      	}else{
      		$tablaProdsPerdidos = '<table><tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:70%"><b>DESCRIPCIÓN</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center"><b>CANT</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center"><b>$ UNIT</b></td><td style="border-bottom: 1px solid #666; background-color:white; width:10%; text-align:center"><b>TOTAL ($)</b></td>';

      		for ($i=0; $i < count($idsUnicosPerdidas); $i++) { 

            	$datosProd = ControladorProductos::ctrMostrarProducto('id', $idsUnicosPerdidas[$i], 'id');
            	$color = $cantidadPerdidas[$i] < 0 ? 'red' :'blue';
            	$totalPerdidaProd = $datosProd['precio_compra']*$cantidadPerdidas[$i];
            	$totalPerdidaDia += $totalPerdidaProd;
            	$idTrab = $idTrabajador[$i];
            	$trabajador = ControladorUsuarios::ctrMostrarUsuarios('id', $idTrab);

          		$tablaProdsPerdidos .= '<tr style="color:'.$color.'"><td style="border-right: 1px solid #666; background-color:white; width:70%"> <i>'.strtoupper(substr(explode(' ',$trabajador['nombre'])[0],0,1)).'. '.ucfirst(explode(' ',$trabajador['nombre'])[1]).'</i> - '.strtoupper($datosProd['descripcion']).'</td><td style="border-right: 1px solid #666; background-color:white; width:10%; text-align:center">'.number_format($cantidadPerdidas[$i], 0, ',', '.').'</td><td style="border-right: 1px solid #666; background-color:white; width:10%; text-align:center">'.number_format($datosProd['precio_compra'], 0, ',', '.').'</td><td style="background-color:white; width:10%; text-align:center"><b>'.number_format($totalPerdidaProd, 0, ',', '.').'</b></td></tr>';
        	}
        	$tablaProdsPerdidos .= '</table>';
      	}

	    if($totalPerdidaDia == 0){
			$perdidaDia = '';	    	
	    }else if($totalPerdidaDia < 0){
	    	$perdidaDia = '<div style="height:3px"><font style="color:red">EL CONTEO REGISTRA PÉRDIDAS POR:<b> $'.number_format($totalPerdidaDia, 0, ',', '.').'.-</b> EN PRODUCTOS</font>';
	    }else{
	     	$perdidaDia = '<div style="height:3px"><font style="color:blue">CONTEO PRODUCTIVO, SE SUMA A STOCK:<b> $'.number_format($totalPerdidaDia, 0, ',', '.').'.-</b> EN PRODUCTOS</font>';
	    }

	    $avanceConteo = ModeloProductos::mdlAvanceConteo('estado_'.$sucursal, 'check_stock_'.$sucursal, 'descripcion');
	    $cantidadProductosContar = ControladorProductos::ctrMostrarProductos('estado_'.$sucursal, 1, 'descripcion');
	    $totalMonetarioPerdidaMes = ModeloActividadInventario::mdlSumarPerdidasMes(date('Y-m'),$sucursal);
	    $porcentajeAvanceConteo = number_format(count($avanceConteo)/count($cantidadProductosContar)*100, 2, ',', '.');

	    $perdidaConteo = $totalMonetarioPerdidaMes['total'] < 0 ? '<font style="color:red">SE HA CONTADO EL <b>'.$porcentajeAvanceConteo.' %</b> DE LOS PRODUCTOS, REGISTRANDO UNA PÉRDIDA GLOBAL DE <b>$'.number_format($totalMonetarioPerdidaMes['total'], 0, ',', '.').'</b> EN PRODUCTOS</font>' : '<br><font style="color:blue">SE HA CONTADO EL <b>'.$porcentajeAvanceConteo.' %</b> DE LOS PRODUCTOS, REGISTRANDO UNA SUMA MONETARIA DE <b>$'.number_format($totalMonetarioPerdidaMes['total'], 0, ',', '.').'</b> EN PRODUCTOS</font>';

		// '<h2>CONTEO DE PRODUCTOS</h2>'.
		// $tablaProdsPerdidos.
		// $perdidaDia.$perdidaConteo.'<br>'.

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      	//----------------------------------------------------------------------------------------------------------------------------------------
      	// INFORME DE PRODUCTOS QUE NO HAN SIDO SURTIDOS (STOCK_PROD_BASE > 0 && STOCK_PROD_SURTIR < 1/3(STOCK_IDEAL))
      	//----------------------------------------------------------------------------------------------------------------------------------------
      	$productosSurtirConBajoStock = ModeloProductos::mdlSeleccionarTransformablesBajoStock();
      	if(count($productosSurtirConBajoStock) == 0){
      		$informeProductosSurtir = '';	
      		$linkWhatsapp = '';
      	}else{
      		$informeProductosSurtir = '<br><h4>FALTA SURTIR LOS SIGUIENTES PRODUCTOS</h4>';
          	foreach ($productosSurtirConBajoStock as $key => $value) {
            	$prodBase = ModeloProductos::mdlMostrarProducto('productos', 'id', $value['id_transf']);
            	if($prodBase['stock_'.$sucursal] >= 1){
                	$informeProductosSurtir .= $value['descripcion'].' <i><b>('.$value['sku'].')</b></i><br>';
            	}
          	}
        	$msjeWhatsapp = str_replace('</h4>','*%0A',str_replace('<h4>','*',str_replace('</i>','_',str_replace('<i>','_',str_replace('</b>','*',str_replace('<b>','*',str_replace('<br>', '%0A ', $informeProductosSurtir)))))));
      		$nroWsp = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'wsp_'.$sucursal)['ajuste'];
			$linkWhatsapp = '<br><a href="https://api.whatsapp.com/send?phone='.$nroWsp.'&text='.$msjeWhatsapp.'" target="_blanck">Enviar Whatsapp a '.strtoupper($sucursal).'</a>';
      	}

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      	//----------------------------------------------------------------------------------------------------------------------------------------
      	// INFORME DE PRODUCTOS A ABASTECER DESDE BODEGA A LOCAL
      	//----------------------------------------------------------------------------------------------------------------------------------------
      	$bodega = 'bodega1';
        $productosAbastecer = ModeloProductos::mdlAbastecimientoDesdeBodega();
        if(count($productosAbastecer) == 0){
        	$informeAbastecimientoDesdeBodega = '';
        	$tablaAbastecimientoDesdeBodega = '';		
        }else{    	
	      	$informeAbastecimientoDesdeBodega = '<h4>Abastecimiento desde <b>'.strtoupper($bodega).'</b> a <b>'.strtoupper($sucursal).'</b><h4>';
	      	$tablaAbastecimientoDesdeBodega = '<table><tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center"><b>CANT</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:20%; text-align:center"><b>SKU</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:50%; text-align:center"><b>DESCRIPCIÓN</b></td><td style="border-bottom: 1px solid #666; background-color:white; width:20%; text-align:center"><b>UBICACIÓN</b></td></tr>';

	        foreach ($productosAbastecer as $key => $value){
	          	$stockAbastecer = $value['stock_ideal_'.$sucursal]-$value['stock_'.$sucursal];
	          	$stockSugerido = $value['stock_'.$bodega] >= $stockAbastecer ? $stockAbastecer : $value['stock_'.$bodega];

	          	$tablaAbastecimientoDesdeBodega .= '<tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center">'.number_format($stockSugerido,0,',','.').'</td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:20%; text-align:center">'.$value['sku'].'</td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:50%; text-align:left"> '.$value['descripcion'].'</td><td style="border-bottom: 1px solid #666; background-color:white; width:20%; text-align:center">'.$value['zona_'.$bodega].'</td></tr>';
	        }
	        $tablaAbastecimientoDesdeBodega .= '</table>';
        }

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      	//----------------------------------------------------------------------------------------------------------------------------------------
      	// INFORME DE COMPRAS MUY URGENTES
      	//----------------------------------------------------------------------------------------------------------------------------------------
		$productosCompraMuyUrgente = ModeloProductos::mdlComprasMuyUrgentes();
        $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
        $locales = [];
    	foreach ($sucursales as $key => $value){
          array_push($locales, $value['nombre_sucursal']);
        }

        $presupuestoEstimadoMuyUrgenteAbastecerIdeal = 0;
        $presupuestoEstimadoMuyUrgenteAbastecerLocales = 0;

        if(count($productosCompraMuyUrgente) == 0){
          $informeComprasMuyUrgentes = '';
        }else{
            $informeComprasMuyUrgentes = '<h3 style="color:red">COMPRAS MUY URGENTES</h3><table style="color:red"><tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:60%; text-align:left"><b>PRODUCTO</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:10%; text-align:center"><b>LOCALES</b></td><td style="border-bottom: 1px solid #666; width:10%; text-align:center"><b>IDEAL</b></td>'; // CABECERA
            foreach ($productosCompraMuyUrgente as $key => $value) { // RECORRE PRODUCTOS URGENTES
              	$sumaProdTodosLosLocales = 0;
              	foreach ($locales as $i) {
                	$sumaProdTodosLosLocales += $value['stock_'.$i];
              	}
            	$stockAbastecerIdeal = $value['stock_ideal_'.$bodega]*2-$sumaProdTodosLosLocales;
            	$presupuestoEstimadoMuyUrgenteAbastecerIdeal += $stockAbastecerIdeal * $value['precio_compra'];
            	
            	$stockAbastecer = $value['stock_ideal_'.$bodega]-$sumaProdTodosLosLocales;
            	$presupuestoEstimadoMuyUrgenteAbastecerLocales += $stockAbastecer * $value['precio_compra'];

              	$informeComprasMuyUrgentes .= '<tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:60%; text-align:left">'.$value['descripcion'].'</td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:10%; text-align:center">'.$stockAbastecer.'</td><td style="border-bottom: 1px solid #666; width:10%; text-align:center">'.$stockAbastecerIdeal.'</td>';
            }
            $informeComprasMuyUrgentes .= '</table>';
            $informeComprasMuyUrgentes .= 'Presupuesto Estimado Abastecer Locales: <b>$ '.number_format($presupuestoEstimadoMuyUrgenteAbastecerLocales,0,',','.').'</b>';
            $informeComprasMuyUrgentes .= '<br>Presupuesto Estimado Abastecer Ideal: <b>$ '.number_format($presupuestoEstimadoMuyUrgenteAbastecerIdeal,0,',','.').'</b>';
        }



      	//----------------------------------------------------------------------------------------------------------------------------------------
      	// INFORME DE COMPRAS URGENTES
      	//----------------------------------------------------------------------------------------------------------------------------------------
		$productosCompraUrgente = ModeloProductos::mdlComprasUrgentes();
        $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
        $locales = [];
    	foreach ($sucursales as $key => $value){
          array_push($locales, $value['nombre_sucursal']);
        }

        $presupuestoEstimadoUrgenteAbastecerIdeal = 0;
        $presupuestoEstimadoUrgenteAbastecerLocales = 0;

        if(count($productosCompraUrgente) == 0){
          $informeComprasUrgentes = '';
        }else{
            $informeComprasUrgentes = '<h3 style="color:rgb(187, 143, 206)">COMPRAS URGENTES</h3><table style="color:rgb(187, 143, 206)><tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:60%; text-align:left"><b>PRODUCTO</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:10%; text-align:center"><b>LOCALES</b></td><td style="border-bottom: 1px solid #666; width:10%; text-align:center"><b>IDEAL</b></td>'; // CABECERA
            foreach ($productosCompraUrgente as $key => $value) { // RECORRE PRODUCTOS URGENTES
              	$sumaProdTodosLosLocales = 0;
              	foreach ($locales as $i) {
                	$sumaProdTodosLosLocales += $value['stock_'.$i];
              	}
            	$stockAbastecerIdeal = $value['stock_ideal_'.$bodega]*2-$sumaProdTodosLosLocales;
            	$presupuestoEstimadoUrgenteAbastecerIdeal += $stockAbastecerIdeal * $value['precio_compra'];
            	
            	$stockAbastecer = $value['stock_ideal_'.$bodega]-$sumaProdTodosLosLocales;
            	$presupuestoEstimadoUrgenteAbastecerLocales += $stockAbastecer * $value['precio_compra'];

              	$informeComprasUrgentes .= '<tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:60%; text-align:left">'.$value['descripcion'].'</td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:10%; text-align:center">'.$stockAbastecer.'</td><td style="border-bottom: 1px solid #666; width:10%; text-align:center">'.$stockAbastecerIdeal.'</td>';
            }
            $informeComprasUrgentes .= '</table>';
            $informeComprasUrgentes .= 'Presupuesto Estimado Abastecer Locales: <b>$ '.number_format($presupuestoEstimadoUrgenteAbastecerLocales,0,',','.').'</b>';
            $informeComprasUrgentes .= '<br>Presupuesto Estimado Abastecer Ideal: <b>$ '.number_format($presupuestoEstimadoUrgenteAbastecerIdeal,0,',','.').'</b>';
        }

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      	//----------------------------------------------------------------------------------------------------------------------------------------
      	// INFORME DE COMPRAS NECESARIAS
      	//----------------------------------------------------------------------------------------------------------------------------------------
        $productosCompraNoUrgente = ModeloProductos::mdlComprasNecesarias();

        $presupuestoEstimadoNoUrgenteAbastecerLocales = 0;

        if(count($productosCompraNoUrgente) == 0){
          	$informeComprasNecesarias = '';
        }else{
          	$informeComprasNecesarias = '<h3 style="color:rgb(26, 82, 118)">COMPRAS NECESARIAS</h3><table style="color:rgb(26, 82, 118)><tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:60%; text-align:left"><b>PRODUCTO</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:20%; text-align:center"><b>LOCALES</b></td>';
          	foreach ($productosCompraNoUrgente as $key => $value){
              	$cantIdealProdLocales = 0;
              	$sumaProdTodosLosLocales = 0;
              	foreach ($locales as $i) {
                	if (strpos($i, 'local') !== false) { // detecta locales
                  		$cantIdealProdLocales += $value['stock_ideal_'.$i];
                	}
                	$sumaProdTodosLosLocales += $value['stock_'.$i];
              	}
              	$stockAbastecer = $value['stock_ideal_'.$bodega]-$sumaProdTodosLosLocales;
              	$presupuestoEstimadoNoUrgenteAbastecerLocales += $stockAbastecer * $value['precio_compra'];
              	$informeComprasNecesarias .= '<tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:60%; text-align:left">'.$value['descripcion'].'</td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:20%; text-align:center">'.$stockAbastecer.'</td>';
          	}
          	$informeComprasNecesarias .= '</table>';
          	$informeComprasNecesarias .= 'Presupuesto Estimado Abastecer Locales: <b>$ '.number_format($presupuestoEstimadoNoUrgenteAbastecerLocales,0,',','.').'</b>';
        }



      	//----------------------------------------------------------------------------------------------------------------------------------------
      	// INFORME DE COMPRAS NECESARIAS
      	//----------------------------------------------------------------------------------------------------------------------------------------
        $productosCompraNoUrgente = ModeloProductos::mdlComprasNoUrgentes();

        $presupuestoEstimadoNoUrgenteAbastecerLocales = 0;

        if(count($productosCompraNoUrgente) == 0){
          	$informeComprasNoUrgentes = '';
        }else{
          	$informeComprasNoUrgentes = '<h3 style="color:blue">COMPRAS NO URGENTES</h3><table style="color:blue"><tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:60%; text-align:left"><b>PRODUCTO</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:20%; text-align:center"><b>LOCALES</b></td>';
          	foreach ($productosCompraNoUrgente as $key => $value){
              	$cantIdealProdLocales = 0;
              	$sumaProdTodosLosLocales = 0;
              	foreach ($locales as $i) {
                	if (strpos($i, 'local') !== false) { // detecta locales
                  		$cantIdealProdLocales += $value['stock_ideal_'.$i];
                	}
                	$sumaProdTodosLosLocales += $value['stock_'.$i];
              	}
              	$stockAbastecer = $value['stock_ideal_'.$bodega]-$sumaProdTodosLosLocales;
              	$presupuestoEstimadoNoUrgenteAbastecerLocales += $stockAbastecer * $value['precio_compra'];
              	$informeComprasNoUrgentes .= '<tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:60%; text-align:left">'.$value['descripcion'].'</td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; width:20%; text-align:center">'.$stockAbastecer.'</td>';
          	}
          	$informeComprasNoUrgentes .= '</table>';
          	$informeComprasNoUrgentes .= 'Presupuesto Estimado Abastecer Locales: <b>$ '.number_format($presupuestoEstimadoNoUrgenteAbastecerLocales,0,',','.').'</b>';
        }

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      	//----------------------------------------------------------------------------------------------------------------------------------------
      	// INFORME DE CORREO ELECTRONICO
      	//----------------------------------------------------------------------------------------------------------------------------------------

		try {
		    //DATOS CUENTA SERVIDOR
		    $mail->SMTPDebug = 0;
		    $mail->isSMTP();
		    $mail->Host       = 'mail.ferreteriasama.cl';
		    $mail->SMTPAuth   = true;
		    $mail->Username   = 'informes@ferreteriasama.cl';
		    $mail->Password   = 'InformesSama0507';
		    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
		    $mail->Port       = 587;

		    // RECEPTORES
		    $mail->setFrom('informes@ferreteriasama.cl', 'Informes');
		    $mail->addAddress('inventario@ferreteriasama.cl', 'INVENTARIO SAMA');
	
		    // CONTENIDO
		    $mail->isHTML(true);
		    $mail->Subject = 'Informe Inventario '.date('Y-m-d');

		    $textoMail = 
		    	'<h4>CONTEO DE PRODUCTOS</h4><br>'.$tablaProdsPerdidos.$perdidaDia.$perdidaConteo.'<br>'. 		
	      			$informeProductosSurtir.
					$informeAbastecimientoDesdeBodega.$tablaAbastecimientoDesdeBodega.
					$informeComprasMuyUrgentes.
					$informeComprasUrgentes.
					$informeComprasNecesarias.
					$informeComprasNoUrgentes;

					// CONTEO PRODUCTOS
					// PRODUCTOS FALTANTES DE SURTIR EN LOCAL
					// ABASTECIMIENTO DESDE BODEGA A LOCAL
					// COMPRAS URGENTES
					// COMPRAS NO URGENTES
			
			$mail->Body = mb_convert_encoding($textoMail, "ISO-8859-1", "UTF-8");

		    $mail->send();
		}catch (Exception $e) {
		}
	}


	/*=============================================
	INFORME CIERRE DIA
	=============================================*/
	static public function ctrInformeCierreVentas($ventEf, $ventTD, $ventTC, $ventTransf, $ventCI, $ventasPend, $cantVentasPend, $saldoCaja, $grafVentas, $retiroAlCierre, $montoVendido, $cantVentasDia){

		require_once(dirname(__FILE__).'/../extensiones/phpMailer/Exception.php');
		require_once(dirname(__FILE__).'/../extensiones/phpMailer/PHPMailer.php');
		require_once(dirname(__FILE__).'/../extensiones/phpMailer/SMTP.php');

		$mail = new PHPMailer(true);

        date_default_timezone_set("America/Santiago");

        // COMPROMISOS DE PAGO CERCANOS, SE ENVÍA SOLO LOS MIÉRCOLES
	    $diaSemana = getdate()['weekday'];
	    $compromisosProxSemana = ModeloMovimientosBancarios::mdlMostrarCompromisosPagoEmail();
	    $tablaCompromisosProxSemana = ''; 

	    if($diaSemana == 'Wednesday'){
	      $totalPagosProxSemana = 0;
	      if(count($compromisosProxSemana)!=0){
	        $tablaCompromisosProxSemana = '<h2>COMPROMISOS DE PAGO CERCANOS</h2><table><tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:20%; text-align:center"><b>FECHA</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:60%; text-align:left"><b>DESCRIPCION</b></td><td style="border-bottom: 1px solid #666; background-color:white; width:20%; text-align:center"><b>$ MONTO</b></td>';
	        foreach ($compromisosProxSemana as $key => $value){
	          $tablaCompromisosProxSemana .= '<tr><td style="border-right: 1px solid #666; background-color:white; width:20%; text-align:center">  '.$value['fecha_vencimiento'].'  </td><td style="border-right: 1px solid #666; background-color:white; width:60%; text-align:left">  '.ucfirst($value['descripcion']).'</td><td style="background-color:white; width:20%; text-align:center">  '.number_format($value['monto'], 0, ',', '.').'  </td></tr>';
	        }
	        $tablaCompromisosProxSemana .= '</table>';
	      }
	    }


	    // PERDIDAS DE STOCK DEL DIA
        $orden = 'id';
        $item1 = 'tipo_mov';
        $valor1 = 'saldo';
		$saldoAyer = ControladorMovimientos::ctrSegundoSaldoAnterior($item1, $valor1, $orden);
	    $prodsPerdidos = ModeloActividadInventario::mdlMostrarPerdidasStock(date('Y-m-d'));
		
		$totalPerdidaDia = 0;
	    if(count($prodsPerdidos)==0){
	    	$tablaProdsPerdidos = '';	
	    }else{
			$tablaProdsPerdidos = '<table><tr><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:70%"><b>DESCRIPCIÓN</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center"><b>CANT</b></td><td style="border-bottom: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center"><b>$ UNIT</b></td><td style="border-bottom: 1px solid #666; background-color:white; width:10%; text-align:center"><b>TOTAL ($)</b></td>';

		    foreach ($prodsPerdidos as $key => $value) {
		        $nombreProd = ControladorProductos::ctrMostrarProducto('id', $value['id_prod'], 'id')['descripcion'];
		        $color = $value['actividad'] < 0 ? 'red' :'blue';
		        $totalPerdidaDia += $value['total'];
		        $idTrab = $value['id_trab'];
		        $trabajador = ControladorUsuarios::ctrMostrarUsuarios('id', $idTrab);
		    	$tablaProdsPerdidos .= '<tr style="color:'.$color.'"><td style="border-right: 1px solid #666; background-color:white; width:70%"> <i>'.strtoupper(substr(explode(' ',$trabajador['nombre'])[0],0,1)).'. '.ucfirst(explode(' ',$trabajador['nombre'])[1]).'</i> - '.strtoupper($nombreProd).'</td><td style="border-right: 1px solid #666; background-color:white; width:10%; text-align:center">'.number_format($value['actividad'], 0, ',', '.').'</td><td style="border-right: 1px solid #666; background-color:white; width:10%; text-align:center">'.number_format($value['precio_compra'], 0, ',', '.').'</td><td style="background-color:white; width:10%; text-align:center"><b>'.number_format($value['total'], 0, ',', '.').'</b></td></tr>';
		    }
		    $tablaProdsPerdidos .= '</table>';
	    }

	    if($totalPerdidaDia == 0){
			$perdidaDia = '';	    	
	    }else if($totalPerdidaDia < 0){
	    	$perdidaDia = '<br><font style="color:red">EL CONTEO REGISTRA PÉRDIDAS POR:<b> $'.number_format($totalPerdidaDia, 0, ',', '.').'.-</b> EN PRODUCTOS</font><br>';
	    }else{
	     	$perdidaDia = '<br><font style="color:blue">CONTEO PRODUCTIVO, SE SUMA A STOCK:<b> $'.number_format($totalPerdidaDia, 0, ',', '.').'.-</b> EN PRODUCTOS</font><br>';
	    }

	    $avanceConteo = ModeloProductos::mdlAvanceConteo('estado_'.$_SESSION['sucursal'], 'check_stock_'.$_SESSION['sucursal'], 'descripcion');
	    $cantidadProductosContar = ControladorProductos::ctrMostrarProductos('estado_'.$_SESSION['sucursal'], 1, 'descripcion');
	    $totalMonetarioPerdidaMes = ModeloActividadInventario::mdlSumarPerdidasMes(date('Y-m'),$_SESSION['sucursal']);
	    $porcentajeAvanceConteo = number_format(count($avanceConteo)/count($cantidadProductosContar)*100, 2, ',', '.');

	    $perdidaConteo = $totalMonetarioPerdidaMes['total'] < 0 ? '<font style="color:red">SE HA CONTADO EL <b>'.$porcentajeAvanceConteo.' %</b> DE LOS PRODUCTOS, REGISTRANDO UNA PÉRDIDA GLOBAL DE <b>$'.number_format($totalMonetarioPerdidaMes['total'], 0, ',', '.').'</b> EN PRODUCTOS</font>' : '<br><font style="color:blue">SE HA CONTADO EL <b>'.$porcentajeAvanceConteo.' %</b> DE LOS PRODUCTOS, REGISTRANDO UNA SUMA MONETARIA DE <b>$'.number_format($totalMonetarioPerdidaMes['total'], 0, ',', '.').'</b> EN PRODUCTOS</font>';

	    $tabla = 'movimientos';
	    $item = 'fecha_cont';
	    $fechaInicial = date('Y-m-d');
	    $hoy = date('Y-m-d');
	    $mov = ModeloMovimientos::mdlMostrarMovimientos30($tabla, $item, $fechaInicial, $hoy);


		// DETALLE MOVIMIENTOS
	    if(count($mov)!=0){
			$movimientosDia = '<h2>DETALLE MOVIMIENTOS</h2><table><tr><td style="border-right: 1px solid #666; background-color:white;width:5%"><b>HORA</b></td><td style="border-right: 1px solid #666; background-color:white; text-align:left; width:70%"><b>DETALLE</b></td><td style="border-right: 1px solid #666; background-color:white; text-align:center; width:10%"><b>MONEDA</b></td><td style="background-color:white; text-align:center; width:10%"><b>MONTO</b></td></tr>';
			foreach ($mov as $i => $value) {
		        $color = $value['cargo'] == 0 ? 'blue' :'red';				
				if($value['tipo_mov']!='saldo' && $value['tipo_mov']!='efVent' && $value['tipo_mov']!='tdVent' && $value['tipo_mov']!='tcVent' && $value['tipo_mov']!='transfVent' && $value['tipo_mov']!='ciVent'){		
				    $traducir = ControladorMovimientos::ctrTraducirMovimiento($value['id'],$value['cargo'],$value['abono'],$value['tipo_mov'],$value['moneda'],$value['detalle'],$value['nom_client'],$value['saldo'],$value['saldo_ant'],$value['nom_prov'],$value['nro_fact'],$value['nom_empleado'],$value['nom_socio'],$value['nom_distrib']);
				    $movTraducido = explode(',', $traducir);
				    $hora = explode(' ',$value['fecha'])[1];
				    $detalle = ' <i>'.strtoupper(substr(explode(' ',$value["nom_user"])[0],0,1)).'. '.ucfirst(explode(' ',$value["nom_user"])[1]).'</i> - '.$movTraducido[0].' <b>(ID:'.$value['id'].')</b>';
				    $monto = $movTraducido[6] == 0 ? number_format($movTraducido[7], 0, ',', '.') : number_format($movTraducido[6], 0, ',', '.');
				    $movimientosDia .= '<tr style="color:'.$color.'"><td style="border-top: 1px solid #666; border-right: 1px solid #666; background-color:white; width:5%">'.$hora.'</td><td style="border-top: 1px solid #666; border-right: 1px solid #666; background-color:white; width:70%">'.$detalle.'</td><td style="border-top: 1px solid #666; border-right: 1px solid #666; background-color:white; width:10%; text-align:center">'.$movTraducido[1].'</td><td style="border-top: 1px solid #666; background-color:white; width:10%; text-align:center">$'.$monto.'</td></tr>'; 
				}
			}
			$movimientosDia .= '</table>';
		}else{
			$movimientosDia = '';

		}

		// VENTAS SIN UTILIDAD
		$ventasSinUtilidad = ModeloVentas::mdlMostrarVentasSinUtilidad(date('Y-m-d'));
		$cantidadVentasSinUtilidad = count($ventasSinUtilidad);
		
		$ventas = ControladorVentas::ctrMostrarVentas('fecha_cont', date('Y-m-d'), '=', '!=', 0, 'cod_venta', 'DESC'); 
		$cantidadVentas = count($ventas);
		
		if($cantidadVentasSinUtilidad == 0){
			$tablaProdsPropietario = '';			
		}else{
			$tablaProdsPropietario = '<h2>VENTAS SIN UTILIDAD</h2><table><tr><td style="border-right: 1px solid #666; background-color:white; width:25%; text-align:center"><b>VENDEDOR</b></td><td style="border-right: 1px solid #666; background-color:white;width:25%; text-align:center"><b>CLIENTE</b></td><td style="background-color:white; text-align:left; width:50%"><b>PRODUCTOS</b></td></tr>';
			foreach ($ventas as $key => $value) {
				$listaProds = '';
			 	if($value['vista_vendedor']==0){
			    	$productos=json_decode($value["productos"]);
			    	for($ia=0;$ia<count($productos);$ia++){
			      		$listaProds .= $productos[$ia]->cant." ".$productos[$ia]->prod.'<br>';
			    	}
			    	$tablaProdsPropietario .= '<tr><td style="border-top: 1px solid #666; border-right: 1px solid #666; background-color:white; width:25%; text-align:center">'.$value['nom_vend'].'</td><td style="border-top: 1px solid #666; border-right: 1px solid #666; background-color:white; width:25%; text-align:center">'.$value['nom_client'].'</td><td style="border-top: 1px solid #666; background-color:white; width:50%; text-align:left">'.$listaProds.'</td></tr>'; 
			  	}
			}
			$tablaProdsPropietario .= '</table>';			
		}


		// DETECCION DE VENTAS EDITADAS
		$ventasEditadas = ModeloVentas::mdlMostrarVentasEditadas(date('Y-m-d')); 
		$cantidadVentasEditadas = count($ventasEditadas);

		if($cantidadVentasEditadas == 0){
			$tablaVentasEditadas = '';
		}else{

			$tablaVentasEditadas = '<h2>VENTAS EDITADAS</h2><table><tr><td style="border-right: 1px solid #666; background-color:white; width:20%; text-align:center"><b>VENTA</b></td><td style="border-right: 1px solid #666; background-color:white;width:40%; text-align:center"><b>JUSTIFICACIÓN</b></td><td style="background-color:white; text-align:left; width:40%"><b>AUTOANALISIS</b></td></tr>';

			foreach ($ventasEditadas as $key => $value) {
				$ediciones = json_decode($value["info_edicion"]);
				$horaVenta = date("H:i", strtotime($value['fecha_venta']));
				$horaUltimaEdicion = date("H:i", strtotime($ediciones[count($ediciones)-1]->fechaEdit));
				$diferenciaTiempoEdicion = (date("H", strtotime($horaUltimaEdicion))-date("H", strtotime($horaVenta)))*60+(date("i", strtotime($horaUltimaEdicion))-date("i", strtotime($horaVenta)));
    			$datosEdicion = '<b>'.$value['cod_venta'].'<br>'.ucfirst($ediciones[count($ediciones)-1]->responsable).'</b><br>Desfase: <b>'.$diferenciaTiempoEdicion.' min</b><br>Nro Ediciones: <b>'.count($ediciones).'</b>';

				// SE DETECTAN 7 MODIFICACIONES AUTOMATICAMENTE:
				// 1 Eliminación de productos originales
				// 2 Incorporación de nuevos productos en venta
				// 3 Variación de stock en productos originales
				// 4 Baja en total venta, Alza en total venta
				// 5 Modificación de cliente
				// 6 Modificación de metodo de pago
				// 7 Modificación en detalle de venta

			    // CODIGO QUE DECODIFICA AUTOANALISIS


   				$traduccionAutoAnalisis = ['-Eliminación de productos originales','-Incorporación de nuevos productos en venta','-Variación de stock en productos originales', '-Variación en total Venta','-Modificación de cliente','-Modificación de metodo de pago','-Modificación en detalle de venta'];
			    for($ia = 0; $ia < count($ediciones); $ia++){
    				$str1 = explode('-',$ediciones[$ia]->autoAnalisis);

      				$autoAnalisisTraducido = '<b>Se detecta:</b><br>';
      				for ($i=0; $i < count($str1) ; $i++) { 
          				if($str1[$i] == 1){
           					$autoAnalisisTraducido .= $traduccionAutoAnalisis[$i].'<br>';
          				}    
      				}
			    
			    	$tablaVentasEditadas .= 
				        '<tr>'.
				          '<td style="border-top: 1px solid #666; border-right: 1px solid #666; background-color:white; width:25%; text-align:left">'.$datosEdicion.'</td>'.
				          '<td style="border-top: 1px solid #666; border-right: 1px solid #666; background-color:white; width:35%; text-align:left"><i>"'.strtoupper($ediciones[count($ediciones)-1]->motivo).'"</i></td>'.
				          '<td style="border-top: 1px solid #666; background-color:white; width:40%; text-align:left">'.$autoAnalisisTraducido.'</td>'.
				        '</tr>'; 
    			}
			}
  			$tablaVentasEditadas .= '</table>';     
		}



		// // DETECCION DE VENTAS MONTO EXTRAIBLE
		// $ventasMontoExtraible = ModeloVentas::mdlMostrarVentasMontoExtraible(date('Y-m-d')); 
		// $cantidadVentasMontoExtraible = count($ventasMontoExtraible);

		// if($cantidadVentasMontoExtraible == 0){
		// 	$montoExtraerParaCubrirCheque = '';
		// }else{

		//     $ventasMontoExtraible = ModeloVentas::mdlMostrarVentasMontoExtraible(date('Y-m-d')); // DETECTA VENTAS CON MONTO EXTRAIBLE
		//     $totalExtraerCheque = 0;
		//     $totalFletes = 0;

		//     $skuFlete = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'sku_flete')['ajuste'];

		//     foreach ($ventasMontoExtraible as $key => $value){ // RECORRE VENTAS CON MONTO EXTRAIBLE
		//       	$productos=json_decode($value["productos"]); //EXTRAE PRODUCTOS VENDIDOS 
		//       	foreach ($productos as $key => $value) { // RECORRE PRODUCTOS VENDIDOS
		//         	$datosProd = ControladorProductos::ctrMostrarProducto('id', $productos[$key]->id, 'id'); // INFO DEL PROD
		//         	if($datosProd['monto_extraible'] == 1 && $datosProd['sku'] != $skuFlete){ // DETECTA SI EL PROD TIENE MONTO EXTRAIBLE y NO ES FLETE
		//           		$totalExtraerCheque += $productos[$key]->tot;
		//         	}else if($datosProd['monto_extraible'] == 1 && $datosProd['sku'] == $skuFlete){ // DETECTA SI EL PROD TIENE MONTO EXTRAIBLE y ES FLETE
		//           		$totalFletes += $productos[$key]->tot;
		//         	}
		//       	}
		//     }

		//     if($totalFletes > 0){
		// 	    $montoExtraerPorFletes = 		'<br><br>'.
		// 	    								'<tr>'.
		// 			 								'<td style="background-color:white; width:50%">MONTO POR FLETES</td>'.
		// 			 								'<td style="background-color:white; width:50%">: $ '.number_format($totalFletes, 0, ',', '.').'</td>'.
		// 			 							'</tr>';		    
		//     }

		//     if($totalExtraerCheque > 0){
		// 	    $montoExtraerParaCubrirCheque = '<tr>'.
		// 			 								'<td style="background-color:white; width:50%">MONTO PARA CUBRIR CHEQUE</td>'.
		// 			 								'<td style="background-color:white; width:50%">: $ '.number_format($totalExtraerCheque, 0, ',', '.').'</td>'.
		// 			 							'</tr>';
		//     }

		// }


		// DETECTAR PRODUCTOS POR INGRESAR AL LOCAL
		// DETECTAR PRODUCTOS QUE NO ESTÁN SURTIDOS Y HAY STOCK
		// REALIZAR PRE-PEDIDO DE PRODUCTOS POR COMPRAR A PROVEEDORES


        $meses = array("Ene","Feb","Mar","Abr","May","Jun","Jul","Ago","Sep","Oct","Nov","Dic");
        $mes = $meses[intval(date('m', strtotime('-1 month')))];

        if($retiroAlCierre != ''){
        	$mostrarRetiroAlCierre =
	 		'<tr>'.
		 		'<td style="background-color:white; width:50%">RETIRO EN CIERRE</td>'.
		 		'<td style="background-color:white; width:50%">: $ '.number_format($retiroAlCierre, 0, ',', '.').'</td>'.
		 	'</tr>';
		 	$saldoAlCierre = $saldoCaja-$retiroAlCierre;
        }else{
        	$mostrarRetiroAlCierre = '';
		 	$saldoAlCierre = $saldoCaja;        	
        }

		try {
		    //DATOS CUENTA SERVIDOR
		    $mail->SMTPDebug = 0;
		    $mail->isSMTP();
		    $mail->Host       = 'mail.ferreteriasama.cl';
		    $mail->SMTPAuth   = true;
		    $mail->Username   = 'informes@ferreteriasama.cl';
		    $mail->Password   = 'InformesSama0507';
		    $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
		    $mail->Port       = 587;

		    // RECEPTORES
		    $mail->setFrom('informes@ferreteriasama.cl', 'Informes');
		    $mail->addAddress('informes@ferreteriasama.cl', 'Informes SAMA');
		    // $mail->addAddress('edinamarca@ferreteriasama.cl', 'Eduardo Dinamarca');
			
			$img = base64_decode(str_replace('data:image/jpeg;base64,','',$grafVentas));
			$mail->addStringEmbeddedImage($img, "graficoVentasMail", "graficoVentasMail", "base64", "image/jpeg");


	
		    // CONTENIDO
		    $mail->isHTML(true);
		    $mail->Subject = strtoupper($_SESSION['sucursal']).' Resumen '.date('d').'-'.$mes.'-'.date('Y');
		    // utf8_decode(texto) //PERMITE TILDES Y Ñ (TEXTO LATINO)



		    $textoMail = 
			    '<h2>'.strtoupper($_SESSION['sucursal']).' Resumen '.date('d-M-Y').' ('.$cantVentasDia.' VENTAS - $'.number_format($montoVendido,0,',','.').')</h2><br>'.

			 	'<table>'.
			 		'<tr>'.
				 		'<td style="background-color:white; width:50%">APERTURA DÍA</td>'.
				 		'<td style="background-color:white; width:50%">: $ '.number_format($saldoAyer['saldo'], 0, ',', '.').'</td>'.
				 	'</tr>'.
			 		'<tr>'.
				 		'<td style="background-color:white; width:50%; color:blue">VENTAS CON EFECTIVO</td>'.
				 		'<td style="background-color:white; width:50%; color:blue">: $ '.number_format($ventEf, 0, ',', '.').'</td>'.
				 	'</tr>'.
			 		'<tr>'.
				 		'<td style="background-color:white; width:50%; color:blue">VENTAS CON TRANSFERENCIA</td>'.
				 		'<td style="background-color:white; width:50%; color:blue">: $ '.number_format($ventTransf, 0, ',', '.').'</td>'.
				 	'</tr>'.
			 		'<tr>'.
				 		'<td style="background-color:white; width:50%; color:blue">VENTAS CON TD</td>'.
				 		'<td style="background-color:white; width:50%; color:blue">: $ '.number_format($ventTD, 0, ',', '.').'</td>'.
				 	'</tr>'.
			 		'<tr>'.
				 		'<td style="background-color:white; width:50%; color:blue">VENTAS CON TC</td>'.
				 		'<td style="background-color:white; width:50%; color:blue">: $ '.number_format($ventTC, 0, ',', '.').'</td>'.
				 	'</tr>'.
			 		'<tr>'.
				 		'<td style="background-color:white; width:50%">VENTAS CON CRÉDITO INTERNO</td>'.
				 		'<td style="background-color:white; width:50%">: $ '.number_format($ventCI, 0, ',', '.').'</td>'.
				 	'</tr>'.
			 		'<tr>'.
				 		'<td style="background-color:white; width:50%"; color:red>VENTAS PENDIENTES (<b>'.$cantVentasPend.'</b>)</td>'.
				 		'<td style="background-color:white; width:50%"; color:red>: $ '.number_format($ventasPend, 0, ',', '.').'</td>'.
				 	'</tr>'.
				 	$mostrarRetiroAlCierre.
			 		'<tr>'.
				 		'<td style="background-color:white; width:50%">SALDO EN CAJA</td>'.
				 		'<td style="background-color:white; width:50%">: $ '.number_format($saldoAlCierre, 0, ',', '.').'</td>'.
				 	'</tr>'.
				 	// $montoExtraerPorFletes.
				 	// $montoExtraerParaCubrirCheque.

				'</table>'.
				'<br><br>'.
				'<img src="cid:graficoVentasMail"><br><br>'.
				$movimientosDia.
				$tablaProdsPropietario.'<br>'.
				$tablaVentasEditadas.'<br>'.
				$tablaCompromisosProxSemana;

			$mail->Body = mb_convert_encoding($textoMail, "ISO-8859-1", "UTF-8");


		    $mail->send();
		}catch (Exception $e) {
		}
	}
}