<?php

    function reemplazarEspacios($texto) {
        $texto = preg_replace('/\s+/', ' ', $texto); // Reemplazar múltiples espacios por un solo espacio
        $texto = str_replace("\xc2\xa0", ' ', $texto);// Reemplazar el carácter de espacio no separable por un espacio regular
        return $texto;
    }
    
    function verificarDeudaCliente($idCliente){
        $movimientosCredito = ModeloMovimientos::mdlHistorialCredIntCliente($idCliente, 'ASC');
        date_default_timezone_set("America/Santiago");
        $saldo = 0;
        foreach($movimientosCredito as $key => $value) {
            $fecha = date("d/m/Y", strtotime($value['fecha_cont']));
            if($value['estado']=='abClient'){
                $saldo -= $value['total'];
            }else if($value['estado']=='dctoClient'){
                $saldo -= $value['total'];
            }else if($value['estado']=='anticipoClient'){
                $saldo -= $value['total'];
            }else if($value['estado']=='abPrest'){
                $saldo -= $value['total'];
            }else if($value['estado']=='prestTerc'){
                $saldo += $value['total'];
            }else{
                $saldo += $value['total'];
            }
        }
        $cliente = ControladorClientes::ctrMostrarClientes('id', $idCliente);
        $deudaCliente = $cliente['deuda_cliente'];
        if($deudaCliente != $saldo){
          $actualizarDeuda = ModeloClientes::mdlActualizarCliente1('clientes', 'deuda_cliente', $saldo, 'id', $idCliente);
        }
        return $saldo;
    }

    function reemplazaTildes($cadena){
        $texto_con_tildes = $cadena;
        $traducciones = array(
            'á' => 'a',
            'é' => 'e',
            'í' => 'i',
            'ó' => 'o',
            'ú' => 'u',
            'Á' => 'A',
            'É' => 'E',
            'Í' => 'I',
            'Ó' => 'O',
            'Ú' => 'U'
        );
        $texto_sin_tildes = strtr($texto_con_tildes, $traducciones);
        return $texto_sin_tildes;
    }

    function imprimirBoletaPHP($fechaHora,$nomVend,$listaProductos,$nomCliente,$totalVenta,$codVenta,$listaMetodoPago,$tipoPago,$infoFlete){
        // DATOS EXTRAIDOS DE AJUSTES
        $nombreComercial = strtoupper(reemplazaTildes(ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'nombre_comercial')['ajuste']));
        $nombreReal = strtoupper(reemplazaTildes(ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'nombre_real')['ajuste']));
        $direccion = ucfirst(reemplazaTildes(ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'direccion_comercial')['ajuste']));
        $wspLocal1 = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'wsp_local1')['ajuste'];
        $impresora = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'nombre_impresora_termica')['ajuste'];
        $keyImpresora = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'api_key_impresora_termica')['ajuste'];


        // VENDEDOR Y FECHA
        $fechaTicket = date("d/m/Y", strtotime(explode(' ', $fechaHora)[0]));
        $horaTicket = explode(' ', $fechaHora)[1];
        $vendedor = 'Vend: '.strtoupper(substr(substr(explode(' ', $nomVend)[0], 0, 1).'.'.explode(' ', $nomVend)[1],0,22));
        $nroEspaciosVendedor = 28 - strlen($vendedor);
        $vendedorTicket = str_pad($vendedor, strlen($vendedor) + $nroEspaciosVendedor, " ");
        $vendedor_FechaVenta_Ticket = $vendedorTicket.' '.$fechaTicket.' '.$horaTicket;

        // LISTA PRODUCTOS
        $listaProductosTicket = json_decode($listaProductos, true);
        
        // CLIENTE
        $clienteTicket = substr('Cliente: '.strtoupper($nomCliente),0,22);
        
        // TOTAL VENTA
        $totalVentaTicket = number_format($totalVenta,0,',','.');

        $listaProductosTicketJS = '';

        $productosMesonID = [];
        $productosMesonCANT = [];
        $productosMesonPV = [];
        $productosMesonTOT = [];
        $productosMesonPROD = [];

        $productosPatioID = [];
        $productosPatioCANT = [];
        $productosPatioPV = [];
        $productosPatioTOT = [];

        $productos_Finales_ID = [];
        $productos_Finales_CANT = [];
        $productos_Finales_PV = [];
        $productos_Finales_TOT = [];

        $skuProdComun = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'sku_prod_comun')['ajuste'];
        $skuFlete = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'sku_flete')['ajuste'];
        $skuInteres = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'sku_interes')['ajuste'];

        // SE ANALIZA SI HAY PRODUCTOS DE PATIO ANTES
        foreach ($listaProductosTicket as $key => $value) {
            
            $traerProducto = ModeloProductos::mdlMostrarProductos('productos', 'id', $value['id'], 'id');

            if($traerProducto['sku'] == $skuFlete || $traerProducto['sku'] == $skuInteres){ // PRIMERO REVISA SI HAY FLETES O INTERES
                array_push($productos_Finales_ID, $value['id']);
                array_push($productos_Finales_CANT, $value['cant']);
                array_push($productos_Finales_PV, $value['pV']);
                array_push($productos_Finales_TOT, $value['tot']);
            }else{

              if($traerProducto['zona_prod'] == 'patio'){  // TODOS LOS PRODUCTOS DE PATIO, EXCLUYENDO FLETE E INTERES (SE DEJARAN AL FINAL)
                  array_push($productosPatioID, $value['id']);
                  array_push($productosPatioCANT, $value['cant']);
                  array_push($productosPatioPV, $value['pV']);
                  array_push($productosPatioTOT, $value['tot']);
              }else{
                  array_push($productosMesonID, $value['id']);
                  array_push($productosMesonCANT, $value['cant']);
                  array_push($productosMesonPV, $value['pV']);
                  array_push($productosMesonTOT, $value['tot']);
                  array_push($productosMesonPROD, $value['prod']);
              }
            }
        }

        $cantProdsMeson = count($productosMesonCANT);

        if($cantProdsMeson > 0){ // SI HAY PRODUCTOS EN MESON
            $listaProductosTicketJS .= 'conector.text("------------------------------------------------");
                                        conector.fontsize("2");
                                        conector.text("PRODUCTOS MESON");
                                        conector.fontsize("1");
                                        conector.textaling("left");
                                        conector.text("SKU     DESCRIPCION               CANT*($)PRECIO");
                                        conector.text("------------------------------------------------");';

            for ($i=0; $i < count($productosMesonID); $i++){
                $traerProducto = ModeloProductos::mdlMostrarProductos('productos', 'id', $productosMesonID[$i], 'id'); 

                // SKU                  
                if($traerProducto["sku"] == $skuProdComun){ // detecta prod comun (SKU=000000 y DESCRIPCION=ESCRITO EN DOC)
                    $sku = '000000';
                    $descSII = strtoupper($productosMesonPROD[$i]);
                }else{
                    $sku = $traerProducto["categoria"] <= 9 ? '0'.$traerProducto["sku"] : $traerProducto["sku"]; // agrega "0" si catergoria es <= 9
                    $descSII = $traerProducto["desc_sii"];
                }
                $skuTicket = strlen($sku) == 6 ? $sku.'  ' : $sku.' '; // si el largo es 6 agrega 2 espacios, si no agrega 1 espacio

                // DESCRIPCION
                $nroEspaciosDescripcion = 25 - strlen($descSII);
                $descSIITicket = str_pad($descSII, strlen($descSII) + $nroEspaciosDescripcion + 1, " ");

                // CANTIDAD (CONTEMPLA MAX 4 CIFRAS)
                $cant = $productosMesonCANT[$i];
                $cant_string = (string) $cant; // convertimos el número a una cadena de caracteres
                $cantidad_digitos = strlen($cant_string);
                $nroEspaciosCantItem = 4 - $cantidad_digitos;
                $cantidadTicket = str_pad($cant, strlen($cant) + $nroEspaciosCantItem, " ", STR_PAD_LEFT).'*';


                // PRECIO VENTA PRODUCTO
                $precioVenta = $traerProducto["sku"] == $skuProdComun ? number_format($productosMesonTOT[$i],0,',','.') : number_format($traerProducto['precio_venta'],0,',','.');
                $precioVenta_string = (string) $precioVenta; // convertimos el número a una cadena de caracteres
                $cantidad_digitos_PV = strlen($precioVenta_string);
                $nroEspaciosPV = 9 - $cantidad_digitos_PV;
                $precioVentaTicket = str_pad($precioVenta, strlen($precioVenta) + $nroEspaciosPV, " ", STR_PAD_LEFT);
                $linea1 = $skuTicket.$descSIITicket.$cantidadTicket.$precioVentaTicket;


                // TOTAL PRECIO VENTA ITEM
                $zonaProd = $traerProducto["zona_".$_SESSION['sucursal']];
                $largoZona = strlen($zonaProd);
                $totalNormal = $productosMesonCANT[$i]*$traerProducto['precio_venta'];
                $descuento = $totalNormal - $productosMesonTOT[$i];

                if($descuento < 0){

                    $totalItem = "$ ".number_format($productosMesonTOT[$i],0,',','.');
                    $largoTotal = strlen($totalItem);
                    $nroEspaciosTotalItem = 48 - $largoTotal - $largoZona;

                    $linea2 = $zonaProd.str_pad($totalItem, strlen($totalItem) + $nroEspaciosTotalItem, " ", STR_PAD_LEFT);
    
                    $listaProductosTicketJS .= 'conector.textaling("left");
                                                conector.text("'.$linea1.'");
                                                conector.text("'.$linea2.'");
                                                conector.feed("1");';


                }else{

                    $dctoItem = "- ".number_format($descuento,0,',','.');
                    $largoDcto = strlen($dctoItem);
                    $nroEspaciosDctoItem = 48 - $largoDcto - $largoZona;

                    $linea2 = $zonaProd.str_pad($dctoItem, strlen($dctoItem) + $nroEspaciosDctoItem, " ", STR_PAD_LEFT);
                    $linea3 = "$ ".number_format($productosMesonTOT[$i],0,',','.');;


                    $listaProductosTicketJS .= 'conector.textaling("left");
                                                conector.text("'.$linea1.'");
                                                conector.text("'.$linea2.'");
                                                conector.textaling("right");
                                                conector.text("'.$linea3.'");
                                                conector.feed("1");';
                }
            }

        }

        if(count($productosPatioID) > 0){
            
            $cantProdsMeson = count($listaProductosTicket) - count($productosPatioCANT);

            if($cantProdsMeson > 0){
                $listaProductosTicketJS .= 'conector.feed("4");';
            }

            if(count($listaProductosTicket) > 0){
                $listaProductosTicketJS .= 'conector.text("------------------------------------------------");';
            }

            $listaProductosTicketJS .= 'conector.fontsize("2");
                                        conector.textaling("left");
                                        conector.text("PRODUCTOS PATIO");
                                        conector.fontsize("1");
                                        conector.text("SKU     DESCRIPCION               CANT*($)PRECIO");
                                        conector.text("------------------------------------------------");';

            

            for ($i=0; $i < count($productosPatioID); $i++){
                $traerProducto = ModeloProductos::mdlMostrarProductos('productos', 'id', $productosPatioID[$i], 'id'); 

                // SKU                  
                $sku = $traerProducto["categoria"] <= 9 ? '0'.$traerProducto["sku"] : $traerProducto["sku"]; // agrega "0" si catergoria es <= 9
                $skuTicket = strlen($sku) == 6 ? $sku.'  ' : $sku.' '; // si el largo es 6 agrega 2 espacios, si no agrega 1 espacio

                // DESCRIPCION
                $descSII = $traerProducto["desc_sii"];
                $nroEspaciosDescripcion = 25 - strlen($descSII);
                $descSIITicket = str_pad($descSII, strlen($descSII) + $nroEspaciosDescripcion + 1, " ");

                // CANTIDAD (CONTEMPLA MAX 4 CIFRAS)
                $cant = $productosPatioCANT[$i];
                $cant_string = (string) $cant; // convertimos el número a una cadena de caracteres
                $cantidad_digitos = strlen($cant_string);
                $nroEspaciosCantItem = 4 - $cantidad_digitos;
                $cantidadTicket = str_pad($cant, strlen($cant) + $nroEspaciosCantItem, " ", STR_PAD_LEFT).'*';


                // PRECIO VENTA PRODUCTO
                $precioVenta = number_format($traerProducto['precio_venta'],0,',','.');
                $precioVenta_string = (string) $precioVenta; // convertimos el número a una cadena de caracteres
                $cantidad_digitos_PV = strlen($precioVenta_string);
                $nroEspaciosPV = 9 - $cantidad_digitos_PV;
                $precioVentaTicket = str_pad($precioVenta, strlen($precioVenta) + $nroEspaciosPV, " ", STR_PAD_LEFT);
                $linea1 = $skuTicket.$descSIITicket.$cantidadTicket.$precioVentaTicket;

                // TOTAL PRECIO VENTA ITEM
                $zonaProd = $traerProducto["zona_".$_SESSION['sucursal']];
                $largoZona = strlen($zonaProd);
                $totalNormal = $productosPatioCANT[$i]*$traerProducto['precio_venta'];
                $descuento = $totalNormal - $productosPatioTOT[$i];

                if($descuento == 0){

                    $totalItem = "$ ".number_format($productosPatioTOT[$i],0,',','.');
                    $largoTotal = strlen($totalItem);
                    $nroEspaciosTotalItem = 48 - $largoTotal - $largoZona;

                    $linea2 = $zonaProd.str_pad($totalItem, strlen($totalItem) + $nroEspaciosTotalItem, " ", STR_PAD_LEFT);

                    $listaProductosTicketJS .= 'conector.textaling("left");
                                                conector.text("'.$linea1.'");
                                                conector.text("'.$linea2.'");
                                                conector.feed("1");';

                }else{

                    $dctoItem = "- ".number_format($descuento,0,',','.');
                    $largoDcto = strlen($dctoItem);
                    $nroEspaciosDctoItem = 48 - $largoDcto - $largoZona;

                    $linea2 = $zonaProd.str_pad($dctoItem, strlen($dctoItem) + $nroEspaciosDctoItem, " ", STR_PAD_LEFT);
                    $linea3 = "$ ".number_format($productosPatioTOT[$i],0,',','.');;

                    $listaProductosTicketJS .= 'conector.textaling("left");
                                                conector.text("'.$linea1.'");
                                                conector.text("'.$linea2.'");
                                                conector.textaling("right");
                                                conector.text("'.$linea3.'");
                                                conector.feed("1");';
                }

            }
        }



        // INCORPORACION DE PRODUCTOS FINALES
        if(count($productos_Finales_ID) > 0){

            $listaProductosTicketJS .= 'conector.text("------------------------------------------------");';
                
            for ($i=0; $i < count($productos_Finales_ID); $i++){

                $traerProducto = ModeloProductos::mdlMostrarProductos('productos', 'id', $productos_Finales_ID[$i], 'id'); 

                // SKU                  
                $sku = $traerProducto["categoria"] <= 9 ? '0'.$traerProducto["sku"] : $traerProducto["sku"]; // agrega "0" si catergoria es <= 9
                $skuTicket = strlen($sku) == 6 ? $sku.'  ' : $sku.' '; // si el largo es 6 agrega 2 espacios, si no agrega 1 espacio

                // DESCRIPCION
                if($traerProducto['sku'] == $skuInteres && $productos_Finales_TOT[$i] < 0){
                    $descSII = 'DESCUENTO ADICIONAL';
                }else{
                    $descSII = $traerProducto["desc_sii"];
                }
                $nroEspaciosDescripcion = 25 - strlen($descSII);
                $descSIITicket = str_pad($descSII, strlen($descSII) + $nroEspaciosDescripcion + 1, " ");

                // CANTIDAD (CONTEMPLA MAX 4 CIFRAS)
                $cant = $productos_Finales_CANT[$i];
                $cant_string = (string) $cant; // convertimos el número a una cadena de caracteres
                $cantidad_digitos = strlen($cant_string);
                $nroEspaciosCantItem = 4 - $cantidad_digitos;
                $cantidadTicket = str_pad($cant, strlen($cant) + $nroEspaciosCantItem, " ", STR_PAD_LEFT).'*';


                // PRECIO VENTA PRODUCTO
                $precioVenta = number_format($productos_Finales_PV[$i],0,',','.');
                $precioVenta_string = (string) $precioVenta; // convertimos el número a una cadena de caracteres
                $cantidad_digitos_PV = strlen($precioVenta_string);
                $nroEspaciosPV = 9 - $cantidad_digitos_PV;
                $precioVentaTicket = str_pad($precioVenta, strlen($precioVenta) + $nroEspaciosPV, " ", STR_PAD_LEFT);
                $linea1 = $skuTicket.$descSIITicket.$cantidadTicket.$precioVentaTicket;

                // TOTAL PRECIO VENTA ITEM
                $totalItem = "$ ".number_format($productos_Finales_TOT[$i],0,',','.');
                $largoTotal = strlen($totalItem);

                $zonaProd = "";
                $largoZona = strlen($zonaProd);

                $nroEspaciosTotalItem = 48 - $largoTotal - $largoZona;
                $linea2 = $zonaProd.str_pad($totalItem, strlen($totalItem) + $nroEspaciosTotalItem, " ", STR_PAD_LEFT);

                $listaProductosTicketJS .= 'conector.text("'.$linea1.'");
                                            conector.text("'.$linea2.'");';
            }
        }

        $detallesPagoTicket = '';
        $metPago = $listaMetodoPago;
        if($tipoPago=="Efectivo"){

            $cash = substr(explode('","',$metPago)[0],10);
            $cash_string = (string) $cash; // convertimos el número a una cadena de caracteres
            $cantidad_digitos_cash = strlen($cash_string);
            $nroEspaciosCash = 9 - $cantidad_digitos_cash;
            $cashTicket = str_pad(number_format($cash,0,',','.'), strlen($cash) + $nroEspaciosCash, " ", STR_PAD_LEFT);

            $total = substr(explode('","',$metPago)[1],8);
            $total_string = (string) $total; // convertimos el número a una cadena de caracteres
            $cantidad_digitos_total = strlen($total_string);
            $nroEspaciostotal = 9 - $cantidad_digitos_total;
            $totalTicket = str_pad(number_format($total,0,',','.'), strlen($total) + $nroEspaciostotal, " ", STR_PAD_LEFT);

            $vuelto = substr(explode('","',$metPago)[2],9,-3);
            $vuelto_string = (string) $vuelto; // convertimos el número a una cadena de caracteres
            $cantidad_digitos_vuelto = strlen($vuelto_string);
            $nroEspaciosvuelto = 9 - $cantidad_digitos_vuelto;
            $vueltoTicket = str_pad(number_format($vuelto,0,',','.'), strlen($vuelto) + $nroEspaciosvuelto, " ", STR_PAD_LEFT);
            $detallesPagoTicket .= 'conector.text("                               CASH: $ '.$cashTicket.'");
                                    conector.text("                              TOTAL: $ '.$totalTicket.'");
                                    conector.text("                             -------------------");
                                    conector.text("                             VUELTO: $ '.$vueltoTicket.'");';

        }else if($tipoPago=="Transferencia"){
            
            $detallesPagoTicket .= 'conector.textaling("right");
                                    conector.text("PAGADO VIA TRANSFERENCIA ELECTRONICA");';
        
        }else if($tipoPago=="TD"){
        
            $detallesPagoTicket .= 'conector.textaling("right");
                                    conector.text("PAGADO CON TARJETA DEBITO: '.$listaMetodoPago.'");';

        }else if($tipoPago=="TC"){
        
            $detallesPagoTicket .= 'conector.textaling("right");
                                    conector.text("PAGADO CON TARJETA CREDITO: '.$listaMetodoPago.'");';

        }else if($tipoPago=="E_TC" || $tipoPago=="E_TD"){

            $detallesPagoTicket .= 'conector.textaling("right");
                                    conector.text("SE PAGA CON PAGO COMBINADO");';

        }else if($tipoPago=="Fiado"){

            $detallesPagoTicket .= 'conector.textaling("right");
                                    conector.text("SE PAGA CON CREDITO INTERNO");';
        
        }else if($tipoPago=="Pend"){

            $detallesPagoTicket .= 'conector.textaling("right");
                                    conector.feed("1")
                                    conector.fontsize("2");
                                    conector.text("COBRAR EN REPARTO");
                                    conector.fontsize("1");';
        
        }

        if($infoFlete != ''){


            $nombreFlete = explode('// ', $infoFlete)[0];
            $nroFlete = explode('// ', $infoFlete)[1];
            $direccionFlete = explode('// ', $infoFlete)[2];
            

            $detalleFleteTicket =  'conector.feed("1")
                                    conector.text("------------------------------------------------");
                                    conector.fontsize("2");
                                    conector.textaling("center");
                                    conector.text("DATOS DESPACHO");
                                    conector.textaling("left");
                                    conector.fontsize("1");
                                    conector.text("NOMBRE    : '.strtoupper($nombreFlete).'");
                                    conector.text("FONO      : '.strtoupper($nroFlete).'");
                                    conector.text("DIRECCION : '.strtoupper($direccionFlete).'");
                                    conector.text("------------------------------------------------");';
        }else{
            $detalleFleteTicket = '';
        }

        echo'
            <script src="vistas/js/conectorImpresoraTermica.js"></script>
            <script>
                async function imprimirBoletaJS(){

                    var nombreImpresora = "'.$impresora.'";
                    var api_key = "'.$keyImpresora.'";

                    const conector = new connetor_plugin()
                    conector.feed("1")
                    conector.fontsize("3")
                    conector.textaling("center")
                    conector.text("'.$nombreComercial.'")
                    conector.fontsize("1")
                    conector.text("'.$nombreReal.'")
                    conector.text("'.$direccion.'")
                    conector.fontsize("2")
                    conector.textaling("center")
                    conector.text("VENTA: '.$codVenta.'")
                    conector.feed("1")
                    conector.fontsize("1")
                    conector.textaling("left")
                    conector.text("'.$vendedor_FechaVenta_Ticket.'")
                    conector.feed("1")
                    conector.text("'.$clienteTicket.'")
                    '.$listaProductosTicketJS.'
                    conector.feed("4")
                    conector.text("------------------------------------------------")
                    conector.fontsize("2")
                    conector.textaling("center")
                    conector.text("TOTAL: $ '.$totalVentaTicket.'")
                    conector.feed("1")
                    conector.textaling("left")
                    conector.fontsize("1")
                    '.$detallesPagoTicket.$detalleFleteTicket.'
                    conector.feed("2")
                    conector.textaling("center")
                    conector.fontsize("2")
                    conector.text("WHATSAPP: +56'.$wspLocal1.'")
                    conector.feed("2")
                    conector.fontsize("1")
                    conector.text("GRACIAS POR SU COMPRA...")

                    conector.feed("8")
                    conector.cut("0") 

                    const resp = await conector.imprimir(nombreImpresora, api_key);
                }
                imprimirBoletaJS();

            </script>';
    }

    function extraerUltimoID($tabla){
        $stmt = Conexion::conectar()->prepare("SELECT MAX(id) as id FROM $tabla");
        $stmt -> execute();
        return $stmt -> fetch()['id'];
        $stmt -> close();
        $stmt = null;
    }

    function extraerUltimaVenta(){
        $sucursal = $_SESSION['sucursal'];
        $stmt = Conexion::conectar()->prepare("SELECT MAX(id) as id FROM ventas WHERE sucursal_venta = '$sucursal'");
        $stmt -> execute();
        return $stmt -> fetch()['id'];
        $stmt -> close();
        $stmt = null;
    }

    function extraerUltimoID_1($tabla,$item,$valor){
        $stmt = Conexion::conectar()->prepare("SELECT MAX(id) as id FROM $tabla WHERE $item = '$valor'");
        $stmt -> execute();
        return $stmt -> fetch()['id'];
        $stmt -> close();
        $stmt = null;
    }    

    function infoPorID($tabla,$valor){
        $stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE id = $valor");
        $stmt -> execute();
        return $stmt -> fetch();
        $stmt -> close();
        $stmt = null;
    }    

    function imprimirCotizacionPHP($fecha,$nomVend,$listaProdsCot,$nomCliente,$totalCot,$nroCot,$fechaExpiracion){

        // DATOS EXTRAIDOS DE AJUSTES
        $nombreComercial = strtoupper(reemplazaTildes(ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'nombre_comercial')['ajuste']));
        $nombreReal = strtoupper(reemplazaTildes(ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'nombre_real')['ajuste']));
        $direccion = ucfirst(reemplazaTildes(ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'direccion_comercial')['ajuste']));
        $wspLocal1 = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'wsp_local1')['ajuste'];
        $impresora = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'nombre_impresora_termica')['ajuste'];
        $keyImpresora = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'api_key_impresora_termica')['ajuste'];


        // VENDEDOR Y FECHA
        $fechaTicket = date("d/m/Y", strtotime($fecha));
        $fechaExpiracionTicket = date("d/m/Y", strtotime($fechaExpiracion));
        $vendedor = 'Vend: '.strtoupper(substr(substr(explode(' ', $nomVend)[0], 0, 1).'.'.explode(' ', $nomVend)[1],0,22));
        $nroEspaciosVendedor = 48 - 11 - strlen($vendedor);
        $vendedorTicket = str_pad($vendedor, strlen($vendedor) + $nroEspaciosVendedor, " ");
        $vendedor_FechaCot_Ticket = $vendedorTicket.' '.$fechaTicket;

        // LISTA PRODUCTOS
        $listaProductosCotTicket = json_decode($listaProdsCot, true);
        
        // CLIENTE
        $clienteTicket = substr('Cliente: '.strtoupper($nomCliente),0,22);
        
        // TOTAL VENTA
        $totalCotTicket = number_format($totalCot,0,',','.');

        $listaProductosCotTicketJS = '';
        foreach ($listaProductosCotTicket as $key => $value) {

            // TRAER PRODUCTO
            $traerProducto = ModeloProductos::mdlMostrarProductos('productos', 'id', $value['id'], 'id');

            // SKU                  
            $sku = $traerProducto["categoria"] <= 9 ? '0'.$traerProducto["sku"] : $traerProducto["sku"]; // agrega "0" si catergoria es <= 9
            $skuTicket = strlen($sku) == 6 ? $sku.'  ' : $sku.' '; // si el largo es 6 agrega 2 espacios, si no agrega 1 espacio

            // DESCRIPCION
            $descSII = $traerProducto["desc_sii"];
            $nroEspaciosDescripcion = 25 - strlen($descSII);
            $descSIITicket = str_pad($descSII, strlen($descSII) + $nroEspaciosDescripcion + 1, " ");

            // CANTIDAD (CONTEMPLA MAX 4 CIFRAS)
            $cant = $value["cant"];
            $cant_string = (string) $cant; // convertimos el número a una cadena de caracteres
            $cantidad_digitos = strlen($cant_string);
            $nroEspaciosCantItem = 4 - $cantidad_digitos;
            $cantidadTicket = str_pad($cant, strlen($cant) + $nroEspaciosCantItem, " ", STR_PAD_LEFT).'*';

            // PRECIO VENTA PRODUCTO
            $precioVenta = number_format($value['pV'],0,',','.');
            $precioVenta_string = (string) $precioVenta; // convertimos el número a una cadena de caracteres
            $cantidad_digitos_PV = strlen($precioVenta_string);
            $nroEspaciosPV = 9 - $cantidad_digitos_PV;
            $precioVentaTicket = str_pad($precioVenta, strlen($precioVenta) + $nroEspaciosPV, " ", STR_PAD_LEFT);

            // TOTAL PRECIO VENTA ITEM
            $totalItemTicket = number_format($value['tot'],0,',','.');

            $linea1 = $skuTicket.$descSIITicket.$cantidadTicket.$precioVentaTicket;

            $listaProductosCotTicketJS .= 'conector.textaling("left");
                                        conector.text("'.$linea1.'");
                                        conector.textaling("right");
                                        conector.text("$ '.$totalItemTicket.'");
                                        conector.feed("1");';
        }


        echo'
            <script src="vistas/js/conectorImpresoraTermica.js"></script>
            <script>
                async function imprimirBoletaJS(){

                    var nombreImpresora = "'.$impresora.'";
                    var api_key = "'.$keyImpresora.'";

                    const conector = new connetor_plugin()
                    conector.feed("1")
                    conector.fontsize("1")
                    conector.textaling("center")
                    conector.text("'.$nombreComercial.'")
                    conector.fontsize("2")
                    conector.textaling("center")
                    conector.text("COTIZACION '.number_format($nroCot,0,',','.').'")
                    conector.feed("1")
                    conector.fontsize("1")
                    conector.textaling("left")
                    conector.text("'.$vendedor_FechaCot_Ticket.'")
                    conector.textaling("right")
                    conector.feed("1")
                    conector.text("VALIDA HASTA: '.$fechaExpiracionTicket.'")
                    conector.textaling("left")
                    conector.feed("1")
                    conector.text("'.$clienteTicket.'")
                    conector.feed("1")
                    conector.text("SKU     DESCRIPCION               CANT*($)PRECIO")
                    conector.text("------------------------------------------------")
                    '.$listaProductosCotTicketJS.'
                    conector.fontsize("2")
                    conector.textaling("center")
                    conector.text("TOTAL: $ '.$totalCotTicket.'")
                    conector.feed("1")
                    conector.textaling("left")
                    conector.fontsize("1")
                    conector.feed("2")
                    conector.textaling("center")
                    conector.fontsize("2")
                    conector.text("WHATSAPP: +56'.$wspLocal1.'")
                    conector.feed("2")
                    conector.fontsize("1")
                    conector.text("GRACIAS POR COTIZAR...")
                    conector.feed("8")
                    conector.cut("0") 

                    const resp = await conector.imprimir(nombreImpresora, api_key);
                }
                imprimirBoletaJS();

            </script>';
    }    


?>