<?php

function notificarTelegramAccion($chatID, $accion){
	$acciones = array(
		'typing',
		'upload_photo',
		'record_video',
		'upload_video',
		'record_audio',
		'upload_audio',
		'upload_document',
		'find_location',
	);
	if (isset($accion) && in_array($accion, $acciones)) {
		$params = compact('chatID', 'action');
		return $this->sendRequest('notificarTelegramAccion', $params);
	}
	throw new TelegramException('Invalid Action! Accepted value: '.implode(', ', $acciones));
}


function notificarTelegramTexto($chatID, $texto, $token,$formato,&$sk = ''){
    $url = "https://api.telegram.org/bot".$token."/sendMessage?disable_web_page_preview=false&parse_mode=".$formato."&chat_id=".$chatID;
    $url = $url."&text=".urlencode($texto);
    $ch = curl_init();
    $optArray = array(
		CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true
    );
    curl_setopt_array($ch, $optArray);
    $result = curl_exec($ch);
    curl_close($ch);
}


function notificarTelegramImagenTexto($chatID, $texto, $imagenDB, $token,&$sk = ''){
	$rutaImagen = __DIR__."/../".$imagenDB;
	if (!file_exists($rutaImagen)) {
		$rutaImagen = __DIR__.'\..\componentes\img\productos\default\anonymous.png'; // Ruta de la imagen que deseas enviar
	}
	$extensionImagen = pathinfo($rutaImagen, PATHINFO_EXTENSION);

	// Determinar la función adecuada para cargar la imagen
	switch ($extensionImagen) {
		case 'jpg':
		case 'jpeg':
			$funcionImagen = 'imagecreatefromjpeg';
			$content_type = 'image/jpeg';
			break;
		case 'png':
			$funcionImagen = 'imagecreatefrompng';
			$content_type = 'image/png';
			break;
		default:
			echo "Formato de imagen no compatible.";
			exit;
	}

	// Cargar la imagen original
	$imagenOriginal = $funcionImagen($rutaImagen);
	// print $imagenOriginal;

	// Obtener las dimensiones originales de la imagen
	$anchoOriginal = imagesx($imagenOriginal);
	$altoOriginal = imagesy($imagenOriginal);

	// Calcular las nuevas dimensiones para la redimension
	$nuevoAncho = 300;
	$nuevoAlto = 300;

	// Crear una nueva imagen redimensionada
	$imagenRedimensionada = imagecreatetruecolor($nuevoAncho, $nuevoAlto);


	$white_color = imagecolorallocate($imagenRedimensionada, 255, 255, 255);
	imagefill($imagenRedimensionada, 0, 0, $white_color);

	// poner la imagen original en la nueva imagen redimensionada
	imagecopyresampled($imagenRedimensionada, $imagenOriginal, 0, 0, 0, 0, $nuevoAncho, $nuevoAlto, $anchoOriginal, $altoOriginal);

	// Guardar la imagen redimensionada en un archivo temporal
	$imagenTemporal = tempnam(sys_get_temp_dir(), 'telegram_image_');
	
	switch ($extensionImagen) {
		case 'jpg':
		case 'jpeg':
			imagejpeg($imagenRedimensionada, $imagenTemporal);
		break;
		
		case 'png':
			imagepng($imagenRedimensionada, $imagenTemporal);
		break;
	}

	$url = "https://api.telegram.org/bot{$token}/sendPhoto";
	$params = [
		'chat_id' => $chatID,
		'photo' => new CURLFile($imagenTemporal, $content_type, 'photo.' . $extensionImagen),
		'caption' => $texto,
		'parse_mode' => 'HTML', // Especificar que el mensaje tiene formato HTML
	];

	// Inicializar cURL
	$ch = curl_init();
	// Configurar las opciones de la solicitud
	curl_setopt_array($ch, [
	    CURLOPT_URL => $url,
	    CURLOPT_POST => true,
	    CURLOPT_POSTFIELDS => $params,
	    CURLOPT_RETURNTRANSFER => true,
	]);
	// Ejecutar la solicitud
	$response = curl_exec($ch);
	// Cerrar la conexión cURL
	curl_close($ch);
	return $response;

}



function notificarTelegramPDFTexto($chatID, $texto, $docPDF, $token, $formato, &$sk = ''){
	$url = "https://api.telegram.org/bot".$token."/sendDocument";
	// Configurar los datos que se enviarán a Telegram
	$parametros = [
	    'chat_id'   => $chatID,
	    'document'  => new CURLFile(realpath($docPDF)),
	    'caption'  => $texto,
	    'parse_mode' => $formato, // Especificar que el mensaje tiene formato HTML
	];
	$ch = curl_init(); 
	curl_setopt($ch, CURLOPT_HTTPHEADER, array(
	    "Content-Type:multipart/form-data"
	));
	curl_setopt($ch, CURLOPT_URL, $url); 
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
	curl_setopt($ch, CURLOPT_POSTFIELDS, $parametros); 
	$result = curl_exec($ch);
	curl_close($ch);
	$eliminarArchivo = unlink($docPDF);
}