<?php

class ControladorCotizaciones{

	/*=============================================
	MOSTRAR COTIZACIONES
	=============================================*/

	static public function ctrMostrarCotizaciones($item, $valor){
		$tabla = "cotizaciones";
		$respuesta = ModeloCotizaciones::mdlMostrarCotizaciones($tabla, $item, $valor);
		return $respuesta;
	}

	static public function ctrMostrarCotizacionesOrdenado($item, $valor){

		$tabla = "cotizaciones";

		$respuesta = ModeloCotizaciones::mdlMostrarCotizacionesOrdenado($tabla, $item, $valor);

		return $respuesta;

	}



	/*=============================================
	CREAR COTIZACION
	=============================================*/

	static public function ctrCrearCotizacion($ventanaRedireccion){

		if(isset($_POST["totCot"])){

			/*=============================================
			GUARDAR LA COTIZACION
			=============================================*/	
			$tabla = "cotizaciones";
			date_default_timezone_set('America/Santiago');
			$fechaIngreso = date("Ymd");

			/*=============================================
			FECHA EXPIRACION
			=============================================*/	
			$mes = date("m");
			$dia = date("d");
			$ano = date("Y");
			$anoBisiesto = $ano % 4;

			$diasVigenciaCotizacion = ControladorAjustes::ctrMostrarAjuste('tipo_ajuste', 'vigencia_cot')['ajuste']; // DIAS DE VIGENCIA COT DESDE AJUSTE BASE DE DATOS

			// PRIMERO VERIFICA SI ES BISIESTO, LUEGO CALCULA DIA, MES Y AÑO DE EXPIRACION
			if($mes==2 && $anoBisiesto==0){
				$diasMes=29;				
			}else if($mes==2 && $anoBisiesto!=0){
				$diasMes=28;
			}else if($mes==4 || $mes==6 || $mes==9 || $mes==11){
				$diasMes=30;
			}else{
				$diasMes=31;
			}

			// DIA, MES Y AÑO DE LA FECHA DE EXPIRACION
			// SI LA VIGENCIA NO PASA AL MES SIGUIENTE 
			if($dia<=$diasMes-$diasVigenciaCotizacion){

				$diaExpiracion = $dia + $diasVigenciaCotizacion;
				$mesExpiracion = $mes;
				$anoExpiracion = $ano;
			// SI LA VIGENCIA PASA AL MES SIGUIENTE
			}else{

				$diaExpiracion = $dia + $diasVigenciaCotizacion - $diasMes;
				// $diaExpiracion = $diasVigenciaCotizacion - $diferenciaDias;				

				if($mes!=12){
					$mesExpiracion = $mes+1;
					$anoExpiracion = $ano;
				}else{
					$mesExpiracion = 1;
					$anoExpiracion = $ano + 1;					
				}

			}
			$fechaExpiracion = $anoExpiracion."-".$mesExpiracion."-".$diaExpiracion;

			$datos = array("id_client"=>$_POST["seleccionarClienteCot"],
						   "nom_client"=>strtoupper($_POST["nomClientCot"]),
						   "id_vendedor"=>$_POST["idVendedorCot"],
						   "nom_vend"=>$_POST["nomVendCot"],
						   "productos"=>$_POST["listaProductosCot"],
						   "neto"=>round($_POST["totCot"]/1.19),
						   "iva"=>round($_POST["totCot"]*0.19/1.19),
						   "total"=>$_POST["totCot"],
						   "utilidad"=>$_POST['utTotCot'],
						   "fecha_ingreso"=>$fechaIngreso,
						   "fecha_expiracion"=>$fechaExpiracion);

			$respuesta = ModeloCotizaciones::mdlIngresarCotizacion($tabla, $datos);

			if($respuesta == "ok"){
				
				$ultimaCot = extraerUltimoID('cotizaciones');
				// imprimirCotizacionPHP($fechaIngreso,$_POST["nomVendCot"],$_POST["listaProductosCot"],$_POST["nomClientCot"],$_POST["totCot"],extraerUltimoID('cotizaciones'),$fechaExpiracion);

				echo '
				<script>

				    var audio = new Audio("componentes/sonidos/success.mp3");
				    audio.play();
					Swal.fire({

						icon: "success",
						title: "¡La cotización ha sido ingresada con éxito!",
						showConfirmButton: true,
						confirmButtonText: "Cerrar"

					}).then(function(result){


						if('.$_SESSION["conexionImpresoraLocal"].' == 1 && esDispositivoMovil() == false){

				  						extraerDatosCotTicket('.$ultimaCot.');
										setTimeout(function () {
					  						window.location = "'.$ventanaRedireccion.'";
										}, 2000);
						}else{
							window.location = "'.$ventanaRedireccion.'";
						}

					});
				

				</script>';

			}

		}

	}

}