<?php
session_start();
require_once "../modelos/conexion.php";
require_once "../controladores/ventas.controlador.php";
require_once "../controladores/funciones_generales.php";
require_once "../modelos/ajustes.modelo.php";
require_once "../modelos/productos.modelo.php";
require_once "../modelos/ventas.modelo.php";
require_once "../modelos/clientes.modelo.php";

class AjaxVentas{
  /*=============================================
  DATOS VENTA
  =============================================*/ 
  public function datosVenta(){
    $itemVenta = "id";
    $valorVenta = $_POST['datosVenta'] != 'ultima' ? $_POST['datosVenta'] : ModeloVentas::mdlSeleccionarUltimoIdVenta($_SESSION['perfil'])['id']; // entrega id de ultima venta que puede ver el vendedor o administrador
    $compItem = '=';
    $compEstado = '!=';
    $estado = 0;
    $filOrden = 'fecha_cont';
    $ord = 'DESC';
    $datosVenta = ControladorVentas::ctrMostrarVentas($itemVenta, $valorVenta, $compItem, $compEstado, $estado, $filOrden, $ord);
    echo json_encode($datosVenta);
  }

  /*=============================================
  CAMBIO PAGO VENTA
  =============================================*/ 
  public function cambioPago(){
    // INGRESO A COLUMNA metodo_pago EN DB
    if($_POST['tipoPago']=='Efectivo'){
      $valor2 = '[{"cash":"'.$_POST['cash'].'","total":"'.$_POST['total'].'","vuelto":"'.$_POST['vuelto'].'"}]';
    }else if($_POST['tipoPago']=='Transferencia'){
      $valor2 = $_POST['total'];
    }else if($_POST['tipoPago']=='TC'){
      $valor2 = 'TC-'.$_POST['codTC'];
    }else if($_POST['tipoPago']=='TD'){
      $valor2 = 'TD-'.$_POST['codTD'];            
    }else if($_POST['tipoPago']=='E_TD'){
      $valor2 = '[{"cash":"'.$_POST['cash'].'","tarjeta":"'.$_POST['montoTD'].'","cod":"'.$_POST['codTDComb'].'"}]';            
    }else if($_POST['tipoPago']=='E_TC'){
      $valor2 = '[{"cash":"'.$_POST['cash'].'","tarjeta":"'.$_POST['montoTC'].'","cod":"'.$_POST['codTCComb'].'"}]';            
    }else if($_POST['tipoPago']=='Fiado'){
      $valor2 = $_POST['total'];            
    }

    $tabla = 'ventas';
    $item1 = 'tipo_pago';
    $valor1 = $_POST['tipoPago'];
    $item2 = 'metodo_pago';
    $item3 = 'id';
    $valor3 = $_POST['cambioPago']; // ID VENTA
    echo $respuesta = ModeloVentas::mdlActualizar2($tabla, $item1, $valor1, $item2, $valor2, $item3, $valor3).','.date("Y-m-d H:i:s");
  } 

  /*=============================================
  CAMBIO PAGO VENTA
  =============================================*/ 
  public function modifDetalleVenta(){
    $tabla = 'ventas';
    $item1 = 'detalle_venta';
    $detalleModif = str_replace('"',"''",$_POST['detalleModif']); // QUITA COMILLAS DOBLES Y LAS REEMPLAZA POR 2 COMILLAS SIMPLES
    $detalleModif = str_replace(','," ",$detalleModif); // QUITA COMAS
    $valor1 = strtoupper(preg_replace("/[\r\n|\n|\r]+/", ". ", $detalleModif)); // ELIMINA SALTOS DE LINEA

    $valor2 = $_POST['modifDetalleVenta']; // ID VENTA
    echo $respuesta = ModeloVentas::mdlActualizar1($tabla, $item1, $valor1, $valor2).','.$valor1;
  } 

  /*=============================================
  INFO ELIMINACION VENTA
  =============================================*/ 
  public function infoEliminarVenta(){
    date_default_timezone_set("America/Santiago");
    $tabla = 'ventas';
    $item1 = 'info_eliminacion';
    $motivoEliminacion = str_replace('"',"''",$_POST['motivoEliminacion']); // QUITA COMILLAS DOBLES Y LAS REEMPLAZA POR 2 COMILLAS SIMPLES
    $motivoEliminacion = str_replace(','," ",$motivoEliminacion); // QUITA COMAS
    $valor1 = '[{"id":"'.$_SESSION['id'].'","responsable":"'.$_SESSION['nombre'].'","motivo":"'.strtoupper(preg_replace("/[\r\n|\n|\r]+/", ". ", $motivoEliminacion)).'","fechaElim":"'.date("Y-m-d H:i").'"}]';

    $valor2 = $_POST['infoEliminacionVenta']; // ID VENTA
    echo $respuesta = ModeloVentas::mdlActualizar1($tabla, $item1, $valor1, $valor2).','.$valor1;
  } 


  public function modifNroFactura(){
    $tabla = 'ventas';
    $item1 = 'nro_factura';
    $valor1 = $_POST['nroFactura'];
    $valor2 = $_POST['modifNroFactura']; // ID VENTA
    echo $respuesta = ModeloVentas::mdlActualizar1($tabla, $item1, $valor1, $valor2).','.$valor1;
  }

  public function subirFacturas(){

    // SUBIR FACTURAS A LA WEB    
    $conteo = count($_FILES["archivos"]["name"]);
    $nombreFacts = '';
    for ($i = 0; $i < $conteo; $i++) {
      $fecha = date('Y-m-d');
      $ubicacionTemporal = $_FILES["archivos"]["tmp_name"][$i];
      $nombreArchivo = $_FILES["archivos"]["name"][$i];
      $extension = pathinfo($nombreArchivo, PATHINFO_EXTENSION);









$nomCarpeta = substr($fecha, 0, 4) . substr($fecha, 5, 2);

// 1) Calcula ruta base al nivel de /pos
$sitioRaiz = dirname(__DIR__); // Esto hace /var/www/html/pos

// 2) Concatena
$rutaCarpeta = $sitioRaiz . "/sii/facturas/" . $nomCarpeta;

if (!is_dir($rutaCarpeta)) {
    mkdir($rutaCarpeta, 0755, true);
    chmod($rutaCarpeta, 0755);
}

$rutaArchivo = $rutaCarpeta . '/' . $nombreArchivo;

if (file_exists($rutaArchivo)) {
    unlink($rutaArchivo);
}

if (move_uploaded_file($ubicacionTemporal, $rutaArchivo)) {
    chmod($rutaArchivo, 0644);
} else {
    error_log("ERROR: No se pudo mover archivo a $rutaArchivo");
}








// $sitioRaiz = dirname(__DIR__); // pos
//       $nomCarpeta = substr($fecha, 0, 4).substr($fecha, 5, 2);
// $rutaCarpeta = $sitioRaiz . "/sii/facturas/" . $nomCarpeta;




//       // $rutaCarpeta = "../sii/facturas/".$nomCarpeta;

//       if(!is_dir($rutaCarpeta)){
//         mkdir($rutaCarpeta, 0755, true); // crea el directorio con permisos 755
//         chmod($rutaCarpeta, 0755); // asegura los permisos (por si acaso)
//       }

//       $rutaArchivo = $rutaCarpeta.'/'.$nombreArchivo;


//       if(file_exists($rutaArchivo)){
//         unlink($rutaArchivo); // Evita conflicto de permisos o sobrescritura
//       }


//       move_uploaded_file($ubicacionTemporal, $rutaArchivo);

      if($i == 0){
        $nombreFacts .= $nombreArchivo;
      }else{
        $nombreFacts .= ','.$nombreArchivo;        
      }
    }

    // REGISTRAR NROS DE FACTURAS
    $tabla = 'ventas';
    $item = 'nro_factura';
    $id = $_POST['subirFacturas'];
    $registrarDirectorio = ModeloVentas::mdlActualizar1($tabla, 'dir_factura', $nomCarpeta, $id);
    $soloNroFacts = str_replace('.'.$extension, '', $nombreFacts);
    $registrarNrosFacts = ModeloVentas::mdlActualizar1($tabla, $item, $soloNroFacts, $id);
    echo $soloNroFacts.','.$extension.','.$nomCarpeta;
    
  }

  public function modificarRutFactuar(){
    $tabla = 'ventas';
    $item1 = 'rut_factura';
    $valor1 = $_POST['rutFacturar'];
    $valor2 = $_POST['modificarRutFactuar']; // ID VENTA
    echo $respuesta = ModeloVentas::mdlActualizar1($tabla, $item1, $valor1, $valor2).','.$valor1;
  }

  public function mostrarVentasMes(){
    date_default_timezone_set("America/Santiago");
    $tabla = 'ventas';
    $item = 'fecha_cont';
    $fechaInicial = date('Y-m-d', strtotime('-1 month'));;
    $hoy = date('Y-m-d', strtotime('+1 day'));
    $ventas = ModeloVentas::mdlMostrarVentasIntervalo($tabla, $item, $fechaInicial, $hoy);
    echo json_encode($ventas);
  }
  
  /*=============================================
  VENTAS PENDIENTES CLIENTE
  =============================================*/ 
  public function ventasPendientesCliente(){
    $ventasPendientes = ModeloVentas::mdlMostrarVentasPendientes($_POST['ventasPendientesCliente']);
    echo json_encode($ventasPendientes);
  }

  /*=============================================
  FORZAR VENTAS PENDIENTES CLIENTE
  =============================================*/ 
  public function forzarCreditoInternoVentasPendientes(){
   
    $itemVenta = "id";
    $valorVenta = $_POST["forzarCreditoInterno"];
    $compItem = '=';
    $compEstado = '!=';
    $estado = 0;
    $filOrden = 'fecha_cont';
    $ord = 'DESC';
    $respuestaVenta = ControladorVentas::ctrMostrarVentas($itemVenta, $valorVenta, $compItem, $compEstado, $estado, $filOrden, $ord);
    $idCliente = $respuestaVenta['id_cliente'];
    $montoVenta = $respuestaVenta['total'];
    $forzarCI = ModeloVentas::mdlActualizar1('ventas', 'tipo_pago', 'Fiado', $valorVenta); // cambio de tipo pago en Venta

    $respuestaCliente = ModeloClientes::mdlMostrarClientes('clientes','id', $idCliente);
    $deudaCliente = $respuestaCliente['deuda_cliente'];
    $deudaActualizada = $deudaCliente + $montoVenta;
    $actualizarDeuda = ModeloClientes::mdlActualizarCliente1('clientes', 'deuda_cliente', $deudaActualizada, 'id', $valorVenta);
    
    if(is_numeric($actualizarDeuda)){
      echo 'ok';
    }else{
      echo 'error';
    }
  }

  /*=============================================
  QUITAR FACTURAS VENTA
  =============================================*/ 
  public function quitarFacturas(){
    $idVenta = $_POST["quitarFacturas"];
    $rutaFacturas = '../sii/facturas/';
    $facturasVenta = ControladorVentas::ctrMostrarVentas('id', $idVenta, '=', '!=', 0, 'fecha_cont', 'DESC');
    $facturasEnServidor = $facturasVenta['nro_factura'];
    $rutFactura = $facturasVenta['rut_factura'];
    $dirFactura = $facturasVenta['dir_factura'];
    $arrayFacturasServidor = explode(',', $facturasEnServidor);
    for ($i=0; $i < count($arrayFacturasServidor); $i++) { 
      unlink($rutaFacturas.$dirFactura.'/'.$arrayFacturasServidor[$i].'.pdf');
    }
    echo $eliminarFactDB = ModeloVentas::mdlActualizar1('ventas', 'nro_factura', '', $idVenta).','.$rutFactura;
  }  

  /*=============================================
  MODIFICAR DATOS DESPACHO
  =============================================*/ 
  public function editarDespacho(){
    $idVenta = $_POST["editarDespacho"];
    $datosDespacho = strtoupper($_POST['nombreContacto']).' // '.$_POST['nroContacto'].' // '.strtoupper($_POST['direccionContacto']);
    echo $respuesta = ModeloVentas::mdlActualizar1('ventas', 'detalle_flete', $datosDespacho, $idVenta);
  }  
}


/*=============================================
MODIFICAR DATOS DESPACHO
=============================================*/ 
if(isset($_POST["editarDespacho"])){
  $editarDespacho = new AjaxVentas();
  $editarDespacho -> editarDespacho();
}

/*=============================================
QUITAR FACTURAS VENTA
=============================================*/ 
if(isset($_POST["quitarFacturas"])){
  $quitarFacturas = new AjaxVentas();
  $quitarFacturas -> quitarFacturas();
}

/*=============================================
FORZAR VENTAS PENDIENTES CLIENTE
=============================================*/ 
if(isset($_POST["forzarCreditoInterno"])){
  $forzarCreditoInternoVentasPendientes = new AjaxVentas();
  $forzarCreditoInternoVentasPendientes -> forzarCreditoInternoVentasPendientes();
}

/*=============================================
VENTAS PENDIENTES
=============================================*/ 
if(isset($_POST["ventasPendientesCliente"])){
  $ventasPendientes = new AjaxVentas();
  $ventasPendientes -> ventasPendientesCliente();
}

/*=============================================
MOSTRAR VENTAS MES
=============================================*/ 
if(isset($_POST["mostrarVentasMes"])){
  $mostrarVentasMes = new AjaxVentas();
  $mostrarVentasMes -> mostrarVentasMes();
}

/*=============================================
MODIFICAR DETALLE VENTA
=============================================*/ 
if(isset($_POST["modificarRutFactuar"])){
  $modificar_1Item = new AjaxVentas();
  $modificar_1Item -> modificarRutFactuar();
}

/*=============================================
SUBIR FACTURAS AL SISTEMA
=============================================*/ 
if(isset($_POST["subirFacturas"])){
  $subirFacturas = new AjaxVentas();
  $subirFacturas -> subirFacturas();
}

/*=============================================
INFO ELIMINACION VENTA
=============================================*/ 
if(isset($_POST["infoEliminacionVenta"])){
  $infoEliminarVenta = new AjaxVentas();
  $infoEliminarVenta -> infoEliminarVenta();
}

/*=============================================
MODIFICAR DETALLE VENTA
=============================================*/ 
if(isset($_POST["modifNroFactura"])){
  $modifNroFactura = new AjaxVentas();
  $modifNroFactura -> modifNroFactura();
}

/*=============================================
MODIFICAR DETALLE VENTA
=============================================*/ 
if(isset($_POST["modifDetalleVenta"])){
  $cambiarPago = new AjaxVentas();
  $cambiarPago -> modifDetalleVenta();
}

/*=============================================
DATOS VENTA
=============================================*/ 
if(isset($_POST["datosVenta"])){
  $datosVenta = new AjaxVentas();
  $datosVenta -> datosVenta();
}

/*=============================================
CAMBIO PAGO VENTA
=============================================*/ 
if(isset($_POST["cambioPago"])){
  $cambiarPago = new AjaxVentas();
  $cambiarPago -> cambioPago();
}

