<?php
session_start();
require_once "../modelos/conexion.php";
require_once "../controladores/movimientos.controlador.php";
require_once "../modelos/movimientos.modelo.php";
require_once "../modelos/movimientos-bancarios.modelo.php";
require_once "../controladores/proveedores.controlador.php";
require_once "../modelos/proveedores.modelo.php";
require_once "../controladores/usuarios.controlador.php";
require_once "../modelos/usuarios.modelo.php";
require_once "../controladores/clientes.controlador.php";
require_once "../modelos/clientes.modelo.php";
require_once "../controladores/ajustes.controlador.php";
require_once "../modelos/ajustes.modelo.php";
require_once "../controladores/funciones_generales.php";
require_once "../controladores/funciones-bot-telegram.php";

class AjaxMovimientos{


    
    /*=============================================
    DEPOSITO BANCARIO
    =============================================*/ 
    public function depositoBanco(){

        $fecha = ControladorAjustes::ctrFechaHora();
        $saldoActualizado = ModeloMovimientosBancarios::mdlUltimoMov()['saldo']-$_POST["depositoBanco"];
        $datosBancarios = array("fecha"=>$fecha,
                                "tipo_mov"=>'depositoBanco',
                                "user"=>$_SESSION['id'],
                                "sucursal"=>$_SESSION['sucursal'],
                                "cargo"=>$_POST["depositoBanco"],
                                "abono"=>0,
                                "saldo"=>$saldoActualizado);
        $ingresarMovBancario = ModeloMovimientosBancarios::mdlRegistrarMovBancario('movimientos_bancarios', $datosBancarios);

        // NOTIFICACION TELEGRAM

        $idMov = extraerUltimoID('movimientos')+1;
        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_registros_cf')['ajuste'];
        $nombre= ucfirst(explode(' ',$_SESSION['nombre'])[0]).' '.strtoupper(substr(explode(' ',$_SESSION['nombre'])[1],0,1)).'.';
        $texto =  "✅✅✅ *DEPÓSITO* ✅✅✅\n\n_$".number_format($_POST["depositoBanco"], 0, ',', '.')."_ 👉 ".$nombre." (".ucfirst($_SESSION['sucursal']).")\nSALDO CF: *$ ".number_format($saldoActualizado,0,',','.')."* (ID:".$idMov.")";
        $formato = 'Markdown';
        $notificar = notificarTelegramTexto($chatID, $texto, $token, $formato);
        echo 'ok';
    }


    /*=============================================
    RETIRO CF
    =============================================*/ 
    public function retiroCF(){

        $fecha = ControladorAjustes::ctrFechaHora();
        $tabla = "movimientos";
        date_default_timezone_set("America/Santiago");
        // $fecha = date('Y-m-d H:i:s');
        $diaCerrado = ControladorMovimientos::ctrMovSi2LI('fecha', date('Y-m-d'), 'tipo_mov', 'saldo');
        if(count($diaCerrado)==0){
            $fechaCont = date('Y-m-d'); 
        }else{
            $fechaCont =  date('Y-m-d', strtotime('+1 day')); 
        }

        $saldoActualizado = ModeloMovimientosBancarios::mdlUltimoMov()['saldo']+$_POST["retCajaEf"];
        $datosBancarios = array("fecha"=>$fecha,
                                "tipo_mov"=>'retiroCF',
                                "user"=>$_SESSION['id'],
                                "sucursal"=>$_SESSION['sucursal'],
                                "cargo"=>0,
                                "abono"=>$_POST["retCajaEf"],
                                "saldo"=>$saldoActualizado);
        $ingresarMovBancario = ModeloMovimientosBancarios::mdlRegistrarMovBancario('movimientos_bancarios', $datosBancarios);

        // NOTIFICACION TELEGRAM
        $idMov = extraerUltimoID($tabla)+1;
        $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
        $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_registros_cf')['ajuste'];
        $nombre= ucfirst(explode(' ',$_SESSION['nombre'])[0]).' '.strtoupper(substr(explode(' ',$_SESSION['nombre'])[1],0,1)).'.';
        $texto =  "💰💰💰 RETIRO CF 💰💰💰\n\n_$".number_format($_POST["retCajaEf"], 0, ',', '.')."_ 👉 ".$nombre." (".ucfirst($_SESSION['sucursal']).")\nSALDO CF: *$ ".number_format($saldoActualizado,0,',','.')."* (ID:".$idMov.")";
        $formato = 'Markdown';
        $notificar = notificarTelegramTexto($chatID, $texto, $token, $formato);


        $datos = array( "fecha"=>$fecha,
                        "fecha_cont"=>$fechaCont,
                        "tipo_mov"=>'retCfGde',
                        "id_prov"=>0,
                        "nom_prov"=>'-',
                        "id_socio"=>0,
                        "nom_socio"=>'-',
                        "id_empleado"=>0,
                        "nom_empleado"=>'-',
                        "detalle"=>'-',
                        "nro_fact"=>'-',
                        "user"=>$_SESSION["id"],
                        "nom_user"=>$_SESSION["nombre"],
                        "cargo"=>$_POST["retCajaEf"],
                        "abono"=>0,
                        "moneda"=>'ef',
                        "id_client"=>0,
                        "nom_client"=>'-',
                        "id_distrib"=>0,
                        "nom_distrib"=>'-',
                        "saldo"=>0,
                        "saldo_ant"=>0);
        $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
        echo $respuesta;
    }


    /*=============================================
    REGISTRAR EGRESO DINERO
    =============================================*/
    public function egresosCaja(){
        $tabla = "movimientos";
        date_default_timezone_set("America/Santiago");
        // $fecha = date('Y-m-d H:i:s');
        $fecha = ControladorAjustes::ctrFechaHora();

        $fechaCont = $_POST['fechaEgresoCaja'];

        if(isset($_POST['pagFlete'])){
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'pagFlete',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>'-',
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST['pagFlete'],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Pago Flete registrado ($'.number_format($_POST['pagFlete'],0,',','.').')';

        }else if(isset($_POST["facturaNro"])){
            $item = "id";
            $valor = $_POST['proveedor_select_pago'];
            $prov =  ControladorProveedores::ctrMostrarProveedores($item, $valor, 'id');
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'pagProv',
                            "id_prov"=>$_POST['proveedor_select_pago'],
                            "nom_prov"=>$prov['alias_empresa'],
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>'-',
                            "nro_fact"=>$_POST['facturaNro'],
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST["montoFactura"],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Pago proveedor registrado con éxito ('.$prov['alias_empresa'].' : $'.number_format($_POST['montoFactura'],0,',','.').')';

        }else if(isset($_POST['pagoTrabajador'])){
            $trab = ControladorUsuarios::ctrMostrarUsuarios('id', $_POST["pagTrab"]);
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'pagTrab',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>$_POST['pagTrab'],
                            "nom_empleado"=>$trab['nombre'],
                            "detalle"=>$_POST['detPago'],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST["pagoTrabajador"],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Pago Trabajador registrado con éxito ('.$trab['nombre'].' : $'.number_format($_POST['pagoTrabajador'],0,',','.').')';

        }else if(isset($_POST['pagJobs'])){
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'pagJobs',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST['detJobs'],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST["pagJobs"],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Pago Trabajo Realizado con éxito ($'.number_format($_POST['pagJobs'],0,',','.').')';
        
        }else if(isset($_POST['retSocio'])){
            $socio = ControladorUsuarios::ctrMostrarUsuarios('id', $_POST["socio"]);
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'retSocio',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>$_POST["socio"],
                            "nom_socio"=>$socio['nombre'],
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST['detRetiroSocio'],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST["retSocio"],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Retiro Efectivo Socio exitoso ('.strtoupper($socio['nombre']).': $'.number_format($_POST['retSocio'],0,',','.').')';

        }else if(isset($_POST['propina'])){
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'prop',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>'-',
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST["propina"],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Pago de Propina registrado ($'.number_format($_POST['propina'],0,',','.').')';

        }else if(isset($_POST['montoOtroEgreso'])){
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'otroCargo',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST['detOtroEgreso'],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST["montoOtroEgreso"],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Egreso registrado exitosamente  ($'.number_format($_POST['montoOtroEgreso'],0,',','.').')';

        }else if(isset($_POST['pagActiv'])){
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'compActiv',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST['detActiv'],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST["pagActiv"],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Pago Activo exitoso ($'.number_format($_POST['pagActiv'],0,',','.').')';

        }else if(isset($_POST['pagMant'])){
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'mantActiv',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST['detMant'],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST["pagMant"],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Pago Mantención Activo exitoso ($'.number_format($_POST['pagMant'],0,',','.').')';

        }else if(isset($_POST['prestamo'])){
            $deudor = ControladorClientes::ctrMostrarClientes('id', $_POST["deudor"]);
            $apellidos = explode(" ", $deudor["apellido"]);
            $nomDeudor = $deudor["nombre"].' '.$apellidos[0].' ref. '.$deudor["referencia"];
            $actDeuda = ModeloClientes::mdlActualizarCliente('clientes', 'deuda_cliente', $deudor['deuda_cliente']+$_POST['prestamo'], $_POST["deudor"]);
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'prestTerc',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST['detPrestamo'],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST["prestamo"],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>$_POST['deudor'],
                            "nom_client"=>$nomDeudor,
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>$deudor['deuda_cliente']+$_POST['prestamo'],
                            "saldo_ant"=>$deudor['deuda_cliente']);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Prestamo a '.strtoupper($nomDeudor).' ingresado con éxito ($'.number_format($_POST['prestamo'],0,',','.').')';

        }else if(isset($_POST['montoDcto'])){
            $respClient = ControladorClientes::ctrMostrarClientes('id', $_POST["cliente_dcto"]);
            $apellidos = explode(" ", $respClient["apellido"]);
            $nombre = $respClient["nombre"].' '.$apellidos[0].' ref. '.$respClient["referencia"];
            $valor1 = $_POST["deudaDcto"]-$_POST['montoDcto'];
            $actDeuda = ModeloClientes::mdlActualizarCliente('clientes', 'deuda_cliente', $valor1, $_POST["cliente_dcto"]);
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'dctoClient',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST['detDcto'],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>0,
                            "abono"=>$_POST["montoDcto"],
                            "moneda"=>'dcto',
                            "id_client"=>$_POST["cliente_dcto"],
                            "nom_client"=>$nombre,
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>$valor1,
                            "saldo_ant"=>$_POST['deudaDcto']);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Descuento aplicado correctamente a '.strtoupper($nombre).' ($'.number_format($_POST['montoDcto'],0,',','.').')';

        }else if(isset($_POST['montoDev'])){
            $respClient = ControladorClientes::ctrMostrarClientes('id', $_POST["cliente_devolucion"]);
            $apellidos = explode(" ", $respClient["apellido"]);
            $nombre = $respClient["nombre"].' '.$apellidos[0].' ref. '.$respClient["referencia"];
            $valor1 = $_POST["deudaDev"]+$_POST['montoDev'];
            $actDeuda = ModeloClientes::mdlActualizarCliente('clientes', 'deuda_cliente', $valor1, $_POST["cliente_devolucion"]);
            
            // NOTIFICACION TELEGRAM
            $fechaContTelegram = date('d-m-Y', strtotime($fechaCont));
            $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
            $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_cobranza')['ajuste'];
            $nomUser= strtoupper(substr(explode(' ',$_SESSION['nombre'])[0],0,1)).' '.ucfirst(explode(' ',$_SESSION['nombre'])[1]);
            $texto =  "⛔️⛔️⛔️ DEVOLUCIÓN DINERO ⛔️⛔️⛔️\n\n".$fechaContTelegram."\n_".$respClient["nombre"].' '.$apellidos[0].' ('.$respClient["referencia"].")_\nMonto devuelto: $".number_format($_POST['montoDev'], 0, ',', '.')." 👉 ".$nomUser." (".ucfirst($_SESSION['sucursal']).")\nSALDO Actual: *$ ".number_format($valor1,0,',','.')."*";
            $formato = 'Markdown';
            $notificar = notificarTelegramTexto($chatID, $texto, $token, $formato);

            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'devClient',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST['detDev'],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>$_POST["montoDev"],
                            "abono"=>0,
                            "moneda"=>'ef',
                            "id_client"=>$_POST["cliente_devolucion"],
                            "nom_client"=>$nombre,
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>$valor1,
                            "saldo_ant"=>$_POST['deudaDev']);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Devolucion de Dinero a '.strtoupper($nombre).' ($'.number_format($_POST['montoDev'],0,',','.').')';

        }

    }

    /*=============================================
    REGISTRAR INGRESO DINERO
    =============================================*/
    public function ingresosCaja(){
        $tabla = "movimientos";
        date_default_timezone_set("America/Santiago");
        $fecha = ControladorAjustes::ctrFechaHora();

        $fechaCont = $_POST['fechaIngresoCaja'];

        if(isset($_POST["deudaCliente"])){
            if(isset($_POST["abonoEfectivo"])){
                $abono = $_POST["abonoEfectivo"];
                $metodoPagoAbono = $_POST["metodoPagoAbonoIngresos"];
                $moneda = 'Efectivo';
            }else if(isset($_POST["abonoTransferencia"])){
                $abono = $_POST["abonoTransferencia"];
                $metodoPagoAbono = $_POST["metodoPagoAbonoIngresos"];
                $moneda = 'Transferencia';
            }else if(isset($_POST["abonoTC"])){
                $abono = $_POST["abonoTC"];
                $metodoPagoAbono = $_POST["metodoPagoAbonoIngresos"].'-'.$_POST["codigoTC"];
                $moneda = 'T. Crédito';
            }else if(isset($_POST["abonoTD"])){
                $abono = $_POST["abonoTD"];
                $metodoPagoAbono = $_POST["metodoPagoAbonoIngresos"].'-'.$_POST["codigoTD"];
                $moneda = 'T. Débito';
            }
            $respClient = ControladorClientes::ctrMostrarClientes('id', $_POST["cliente_select_deuda"]);
            $apellidos = explode(" ", $respClient["apellido"]);
            $nombre = $respClient["nombre"].' '.$apellidos[0].' ref. '.$respClient["referencia"];
            $valor1 = $_POST["deudaCliente"]-$abono;
            $actDeuda = ModeloClientes::mdlActualizarCliente('clientes', 'deuda_cliente', $valor1, $_POST["cliente_select_deuda"]);
            // $actualizarFechaAbono = ModeloClientes::mdlActualizarCliente('clientes', 'ultimo_abono', $fechaCont, $_POST["cliente_select_deuda"]);

            // NOTIFICACION TELEGRAM
            $fechaContTelegram = date('d-m-Y', strtotime($fechaCont));
            $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
            $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_cobranza')['ajuste'];
            $nomUser= ucfirst(explode(' ',$_SESSION['nombre'])[0]).' '.strtoupper(substr(explode(' ',$_SESSION['nombre'])[1],0,1)).'.';
            $texto =  "✅✅✅ *ABONO CLIENTE* ✅✅✅\n\n".$fechaContTelegram."\n_".$respClient["nombre"].' '.$apellidos[0].' ('.$respClient["referencia"].")_\nAbono con ".$moneda.": $".number_format($abono, 0, ',', '.')." 👉 ".$nomUser." (".ucfirst($_SESSION['sucursal']).")\nSALDO Actual: *$ ".number_format($valor1,0,',','.')."*";
            $formato = 'Markdown';
            $notificar = notificarTelegramTexto($chatID, $texto, $token, $formato);

            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'abClient',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "nro_fact"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "detalle"=>$metodoPagoAbono,
                            "cargo"=>0,
                            "abono"=>$abono,
                            "moneda"=>$_POST["metodoPagoAbonoIngresos"],
                            "id_client"=>$_POST["cliente_select_deuda"],
                            "nom_client"=>$nombre,
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>$_POST["deudaCliente"]-$abono,
                            "saldo_ant"=>$_POST["deudaCliente"]);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Abono ingresado con éxito ('.strtoupper($nombre).': $'.number_format($abono,0,',','.').')';
        }else if(isset($_POST["cliente_anticipo"])){
            if(isset($_POST["anticipoEfectivo"])){
                $abono = $_POST["anticipoEfectivo"];
                $metodoPagoAbono = $_POST["metPagoAnticipo"];
                $moneda = 'Efectivo';
            }else if(isset($_POST["anticipoTransferencia"])){
                $abono = $_POST["anticipoTransferencia"];
                $metodoPagoAbono = $_POST["metPagoAnticipo"];
                $moneda = 'Transferencia';
            }else if(isset($_POST["anticipoTC"])){
                $abono = $_POST["anticipoTC"];
                $metodoPagoAbono = $_POST["metPagoAnticipo"].'-'.$_POST["codigoTC"];
                $moneda = 'T. Crédito';
            }else if(isset($_POST["anticipoTD"])){
                $abono = $_POST["anticipoTD"];
                $metodoPagoAbono = $_POST["metPagoAnticipo"].'-'.$_POST["codigoTD"];
                $moneda = 'T. Débito';
            }

            $respClient = ControladorClientes::ctrMostrarClientes('id', $_POST["cliente_anticipo"]);
            $apellidos = explode(" ", $respClient["apellido"]);
            $nombre = $respClient["nombre"].' '.$apellidos[0].' ref. '.$respClient["referencia"];
            $valor1 = $respClient['deuda_cliente']-$abono;
            $actDeuda = ModeloClientes::mdlActualizarCliente('clientes', 'deuda_cliente', $valor1, $_POST["cliente_anticipo"]);
            // $actualizarFechaAnticipo = ModeloClientes::mdlActualizarCliente('clientes', 'ultimo_abono', $fechaCont, $_POST["cliente_anticipo"]);

            // NOTIFICACION TELEGRAM
            $fechaContTelegram = date('d-m-Y', strtotime($fechaCont));
            $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
            $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_cobranza')['ajuste'];
            $nomUser= strtoupper(substr(explode(' ',$_SESSION['nombre'])[0],0,1)).' '.ucfirst(explode(' ',$_SESSION['nombre'])[1]);
            $texto =  "✅✅✅ *ANTICIPO COMPRA* ✅✅✅\n\n".$fechaContTelegram."\n_".$respClient["nombre"].' '.$apellidos[0].' ('.$respClient["referencia"].")_\nAnticipa con ".$moneda.": $".number_format($abono, 0, ',', '.')." 👉 ".$nomUser." (".ucfirst($_SESSION['sucursal']).")\nSaldo a Favor: *$".number_format($valor1,0,',','.')."*";
            $formato = 'Markdown';
            $notificar = notificarTelegramTexto($chatID, $texto, $token, $formato);
            
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'anticipoClient',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$metodoPagoAbono,
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>0,
                            "abono"=>$abono,
                            "moneda"=>$_POST["metPagoAnticipo"],
                            "id_client"=>$_POST["cliente_anticipo"],
                            "nom_client"=>$nombre,
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>$respClient['deuda_cliente']-$abono,
                            "saldo_ant"=>$respClient['deuda_cliente']);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Anticipo ingresado con éxito ('.strtoupper($nombre).': $'.number_format($abono,0,',','.').')';
        }else if(isset($_POST["aporteCaja"])){

            $saldoActualizado = ModeloMovimientosBancarios::mdlUltimoMov()['saldo']-$_POST["aporteCaja"];
            $datosBancarios = array("fecha"=>$fecha,
                                    "tipo_mov"=>'aporteCaja',
                                    "user"=>$_SESSION['id'],
                                    "sucursal"=>$_SESSION['sucursal'],
                                    "cargo"=>$_POST["aporteCaja"],
                                    "abono"=>0,
                                    "saldo"=>$saldoActualizado);
            $ingresarMovBancario = ModeloMovimientosBancarios::mdlRegistrarMovBancario('movimientos_bancarios', $datosBancarios);
            // NOTIFICACION TELEGRAM

            $idMov = extraerUltimoID($tabla)+1;            
            $token = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_bot_telegram')['ajuste'];
            $chatID = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'id_grupo_registros_cf')['ajuste'];
            $nombre = strtoupper(substr(explode(' ',$_SESSION['nombre'])[0],0,1)).' '.ucfirst(explode(' ',$_SESSION['nombre'])[1]);
            $texto =  "⛔️⛔️⛔️ APORTE CAJA ⛔️⛔️⛔️\n\n_$".number_format($_POST["aporteCaja"], 0, ',', '.')."_ 👉 ".$nombre." (".ucfirst($_SESSION['sucursal']).")\nSALDO CF: *$ ".number_format($saldoActualizado,0,',','.')."* (ID:".$idMov.")";
            $formato = 'Markdown';
            $notificar = notificarTelegramTexto($chatID, $texto, $token, $formato);

            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'apCaja',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>'-',
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>0,
                            "abono"=>$_POST["aporteCaja"],
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Aporte de caja exitoso ('.number_format($_POST["aporteCaja"],0,',','.').')';
        }else if(isset($_POST["montoOtroIngreso"])){
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'otroAbono',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST["detOtroIngreso"],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>0,
                            "abono"=>$_POST["montoOtroIngreso"],
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Ingreso registrado con éxito ('.number_format($_POST["montoOtroIngreso"],0,',','.').')';
        }else if(isset($_POST["montFlete"])){
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'flete',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST["detFlete"],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>0,
                            "abono"=>$_POST["montFlete"],
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Ingreso por flete exitoso ('.number_format($_POST["montFlete"],0,',','.').')';
        }else if(isset($_POST["detApCap"])){
            $datos = array( "fecha"=>$fecha,
                            "fecha_cont"=>$fechaCont,
                            "tipo_mov"=>'apCapit',
                            "id_prov"=>0,
                            "nom_prov"=>'-',
                            "id_socio"=>0,
                            "nom_socio"=>'-',
                            "id_empleado"=>0,
                            "nom_empleado"=>'-',
                            "detalle"=>$_POST["detApCap"],
                            "nro_fact"=>'-',
                            "user"=>$_SESSION["id"],
                            "nom_user"=>$_SESSION["nombre"],
                            "cargo"=>0,
                            "abono"=>$_POST["montApCap"],
                            "moneda"=>'ef',
                            "id_client"=>0,
                            "nom_client"=>'-',
                            "id_distrib"=>0,
                            "nom_distrib"=>'-',
                            "saldo"=>0,
                            "saldo_ant"=>0);
            $respuesta = ModeloMovimientos::mdlRegistrarMovimiento($tabla, $datos);
            echo $respuesta.',Aporte Capital registrado con éxito ('.number_format($_POST['montApCap'],0,',','.').')';
        }
    }

    /*=============================================
    INFO MOVIMIENTO
    =============================================*/ 
    public function infoMovimientoUltimoAbonoCliente(){
        $id = extraerUltimoID_1('movimientos','tipo_mov',$_POST["ultimoAbono"]);                
        $datosMov = infoPorID('movimientos',$id);
        echo json_encode($datosMov);
    }

    /*=============================================
    ELIMINAR MOVIMIENTO
    =============================================*/ 
    public function eliminarMov(){
        $idMov = $_POST["eliminarMov"];
        echo $eliminarMovAjax = ModeloMovimientos::mdlEliminarMov('movimientos',$idMov);                    
    }

    /*=============================================
    DATOS MOVIMIENTO
    =============================================*/ 
    public function datosMov(){
        $idMov = $_POST["datosMov"];
        $datosMov = infoPorID('movimientos',$idMov);
        $traducir = ControladorMovimientos::ctrTraducirMovimiento($datosMov['id'],$datosMov['cargo'],$datosMov['abono'],$datosMov['tipo_mov'],$datosMov['moneda'],$datosMov['detalle'],$datosMov['nom_client'],$datosMov['saldo'],$datosMov['saldo_ant'],$datosMov['nom_prov'],$datosMov['nro_fact'],$datosMov['nom_empleado'],$datosMov['nom_socio'],$datosMov['nom_distrib']);
        $detalleTraducido = explode(',', $traducir)[0];
        $detalle_sin_html = strip_tags($detalleTraducido);
        $agregarDetalle = ["detalle_traducido" => $detalle_sin_html.' (ID:'.$idMov.')'];
        $datosMov[] = $agregarDetalle;
        echo json_encode($datosMov);
    }

    /*=============================================
    EDITAR MOVIMIENTO
    =============================================*/ 
    public function modifMov(){
        $moneda = $_POST['moneda'];
        $idMov = $_POST["modifMov"];

        if($moneda == 'td' || $moneda == 'tc'){
            $codTransaccion = $_POST['moneda'].'-'.$_POST['codTransaccion'];
            echo $modificarMov = ModeloMovimientos::mdlActualizar3('movimientos', 'fecha_cont', $_POST['fechaCont'], 'moneda', $_POST['moneda'], 'detalle', $codTransaccion, 'id', $idMov);
        }else{
            echo $modificarMov = ModeloMovimientos::mdlActualizar2('movimientos', 'fecha_cont', $_POST['fechaCont'], 'moneda', $_POST['moneda'], 'id', $idMov);
        }
    }

    /*=============================================
    VERIFICAR CIERRE
    =============================================*/ 
    public function verificarCierre(){
        echo count(ControladorMovimientos::ctrMovSi2LI('fecha_cont', $_POST['verificarCierre'], 'tipo_mov', 'saldo'));
    }

}


/*=============================================
VERIFICAR CIERRE
=============================================*/ 
if(isset($_POST["verificarCierre"])){
  $modifMov = new AjaxMovimientos();
  $modifMov -> verificarCierre();
}


/*=============================================
EDITAR MOVIMIENTO0
=============================================*/ 
if(isset($_POST["modifMov"])){
  $modifMov = new AjaxMovimientos();
  $modifMov -> modifMov();
}

/*=============================================
DATOS MOVIMIENTO0
=============================================*/ 
if(isset($_POST["datosMov"])){
  $datosMov = new AjaxMovimientos();
  $datosMov -> datosMov();
}

/*=============================================
ELIMINAR MOVIMIENTO
=============================================*/ 
if(isset($_POST["eliminarMov"])){
  $eliminarMov = new AjaxMovimientos();
  $eliminarMov -> eliminarMov();
}

/*=============================================
INFO MOVIMIENTO
=============================================*/ 
if(isset($_POST["ultimoAbono"])){
  $infoMov = new AjaxMovimientos();
  $infoMov -> infoMovimientoUltimoAbonoCliente();
}

/*=============================================
RETIRO CF
=============================================*/ 
if(isset($_POST["retCajaEf"])){
  $retiroCF = new AjaxMovimientos();
  $retiroCF -> retiroCF();
}

/*=============================================
DEPOSITO BANCARIO
=============================================*/ 
if(isset($_POST["depositoBanco"])){
  $depositoBanco = new AjaxMovimientos();
  $depositoBanco -> depositoBanco();
}

/*=============================================
REGISTRAR EGRESO DINERO
=============================================*/ 
if(isset($_POST["tipoEgreso"])){
  $egresosCaja = new AjaxMovimientos();
  $egresosCaja -> egresosCaja();
}

/*=============================================
REGISTRAR INGRESO DINERO
=============================================*/ 
if(isset($_POST["tipoIngreso"])){
  $egresosCaja = new AjaxMovimientos();
  $egresosCaja -> ingresosCaja();
}



