<?php
session_start();
require_once "../modelos/conexion.php";
require_once "../controladores/proveedores.controlador.php";
require_once "../modelos/proveedores.modelo.php";
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";
require_once "../controladores/categorias.controlador.php";
require_once "../modelos/categorias.modelo.php";
require_once "../modelos/compras.modelo.php";

class AjaxInformes{

	/*=============================================
	TRAER PROVEEDORES
	=============================================*/	
	public $idProveedor;
	public function ajaxTraerProveedor(){

		$item = null;
		$valor = $this->idProveedor;
		$respuesta = ControladorProveedores::ctrMostrarProveedores($item, $valor);

		echo json_encode($respuesta);
	}

	/*=============================================
	TRAER CATEGORIAS
	=============================================*/	
	public $idCategoria;
	public function ajaxTraerCategorias(){

		$item = null;
		$valor = $this->idCategoria;
		$respuesta = ControladorCategorias::ctrMostrarCategorias($item, $valor);

		echo json_encode($respuesta);
	}

	/*=============================================
	TRAER SUBCATEGORIAS
	=============================================*/	
	public $idSubcategoria;
	public function ajaxTraerSubcategorias(){

		$item = "categoria_padre";
		$valor = $_POST["idSubcategoria"];
		$respuesta = ControladorCategorias::ctrMostrarSubcategorias1($item, $valor);

		echo json_encode($respuesta);
	}

	/*=============================================
	TRAER SUBCATEGORIAS ABASTECIMIENTO
	=============================================*/	
	public $idSubcategoriaAbast;
	public function ajaxTraerSubcategoriasAbast(){

		$item = "categoria_padre";
		$valor = $this->idSubcategoriaAbast;
		$respuesta = ControladorCategorias::ctrMostrarSubcategorias1($item, $valor);

		echo json_encode($respuesta);
	}

	/*=============================================
	CANTIDAD PEDIDO TABLA
	=============================================*/	
	public $cantidadPedido;
	public function actualizarCantPedido(){
		$id =  $_POST['id'];
		$cant_pedido =  $_POST['cant_pedido'];
		if($cant_pedido == ''){
			$cant_pedido = 0;
		}

		$stockCompra = ModeloProductos::mdlActualizarProducto('productos', 'stock_compra', $cant_pedido, $id);
		echo $stockCompra.','.$cant_pedido;
	}

	public function resetInformeAbastecimiento(){
		$valor2 = $_POST['item1'];
		$valor3 = $_POST['item2'];
		if($_POST["resetAbastecimiento"] == 1){ // SUBCATEGORIA
			$reset = ModeloProductos::mdlActualizar1_2('productos', 'stock_compra', 0, 'categoria', $valor2, 'subcategoria', $valor3);
		}else if($_POST["resetAbastecimiento"] == 2){ // PROVEEDOR
			$reset = ModeloProductos::mdlResetStockCompraProveedor('productos', 'stock_compra', 0, 'lista_proveedores', $valor2);
		}else if($_POST["resetAbastecimiento"] == 3){ // TODOS LOS PRODUCTOS
			$reset = ModeloProductos::mdlActualizar1_0('productos', 'stock_compra', 0);
		}
		echo $reset;
	}


	public function textoWhatsappInforme(){ // reducir código redundante
		$tipoAbast = $_POST['textoWhatsappInforme'];
		$valor0_1 = $_POST['item1'];
		$valor0_2 = $_POST['item2'];
		$sucursal = $_POST['sucursal'];
		$prov = $_POST['idProv'];
		
		if($tipoAbast == 1){ // SUBCATEGORIA

			$item_1 = 'sub_cod_int';
			$valor1_a = str_pad($valor0_1, 2, "0", STR_PAD_LEFT);      
			$valor2_b = str_pad($valor0_2, 2, "0", STR_PAD_LEFT);      
			$valor_1 = $valor1_a.$valor2_b;
			$item_2 = 'estado_'.$sucursal;
			$valor_2 = 1;     
			$orden = 'descripcion';
			$prodsSubcategoria = ModeloProductos::mdlMostrarProductosPedido2('productos', $item_1, $valor_1, $item_2, $valor_2, $orden);

			$totalFinalNeto = 0;
			$textoWsp = '';
			foreach(array_reverse($prodsSubcategoria) as $key => $item) {
				if($item['stock_compra']>0){
					$idProd = $item['id']; 
					$infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);

					// BUSCA SKU PROVEEDOR
					$arrayProvs = json_decode($infoProd['lista_provs_json'], true);
					$codProv = $prov == 0 ? '' : '(SINCOD)';
					$precioNetoProveedor = 0;
					for ($i=0; $i < count($arrayProvs); $i++) { 
						if($arrayProvs[$i]['prov'] == $prov){
							$codProv = '('.$arrayProvs[$i]['cod_prov'].')'; // si es que se ha comprado al proveedor extrae sku_prov
							$precioNetoProveedor = $arrayProvs[$i]['pc_neto'];
						}
					}

					// busca ultimo precio de compra
			        $ultimaCompraProd = ModeloCompras::mdlUltimaCompraProd('compras', 'abastecimiento', '%"id":"'.$idProd.'"%');
					if(isset($ultimaCompraProd['abastecimiento'])){ // REVISA SI SE HA COMPRADO ANTES
			          	$datosCompra = json_decode($ultimaCompraProd['abastecimiento'], true);
			          	foreach ($datosCompra as $elemento) {
			            	if(isset($elemento['id']) && $elemento['id'] === "$idProd") {
			              		$precioCompraNetoUnit = $elemento['pCNetoActual']; // ultimo precio comprado indistinto del proveedor
			              		break; // Terminar el bucle una vez que se encuentra el elemento
			            	}
			          	}
			        }else{
						$precioCompraNetoUnit = $infoProd['pc_neto']; // precio neto seteado
			        }
			        $netoFinalUnit = $precioNetoProveedor <= $precioCompraNetoUnit && $precioNetoProveedor > 0 ? $precioNetoProveedor : $precioCompraNetoUnit; // elige el menor precio para enviar a proveedor
					$textoWsp .= '*'.$item['stock_compra'] .'* '.$codProv.'  ```'.$infoProd['descripcion']. '```  *$ '.number_format($netoFinalUnit,0,',','.').'*\n' ;
					$totalFinalNeto += $netoFinalUnit*$infoProd['stock_compra'];
				}
			}
			echo $textoWsp.'////'.round($totalFinalNeto);

		}else if($tipoAbast == 2){ // PROVEEDOR
			
			$item1 = "lista_proveedores";
			$valor1 = $valor0_1; // $item1 = proveedor
			$item2 = "estado_".$sucursal;
			$valor2 = 1;     
			$orden = "descripcion";
			$prodsProveedor = ModeloProductos::mdlMostrarProductosPedidoProveedor2('productos', $item1, $valor1, $item2, $valor2, $orden);

			$totalFinalNeto = 0;
			$textoWsp = '';
			foreach(array_reverse($prodsProveedor) as $key => $item) {
				if($item['stock_compra']>0){
					$idProd = $item['id']; 
					$infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);

					// BUSCA SKU PROVEEDOR
					$arrayProvs = json_decode($infoProd['lista_provs_json'], true);
					$codProv = 'SINCOD';
					$precioNetoProveedor = 0;
					for ($i=0; $i < count($arrayProvs); $i++) { 
						if($arrayProvs[$i]['prov'] == $valor1){
							$codProv = $arrayProvs[$i]['cod_prov']; // si es que se ha comprado al proveedor extrae sku_prov
							$precioNetoProveedor = $arrayProvs[$i]['pc_neto'];
						}
					}

					// busca ultimo precio de compra
			        $ultimaCompraProd = ModeloCompras::mdlUltimaCompraProd('compras', 'abastecimiento', '%"id":"'.$idProd.'"%');
					if(isset($ultimaCompraProd['abastecimiento'])){ // REVISA SI SE HA COMPRADO ANTES
			          	$datosCompra = json_decode($ultimaCompraProd['abastecimiento'], true);
			          	foreach ($datosCompra as $elemento) {
			            	if(isset($elemento['id']) && $elemento['id'] === "$idProd") {
			              		$precioCompraNetoUnit = $elemento['pCNetoActual']; // ultimo precio comprado indistinto del proveedor
			              		break; // Terminar el bucle una vez que se encuentra el elemento
			            	}
			          	}
			        }else{
						$precioCompraNetoUnit = $infoProd['pc_neto']; // precio neto seteado
			        }
			        $netoFinalUnit = $precioNetoProveedor <= $precioCompraNetoUnit && $precioNetoProveedor > 0 ? $precioNetoProveedor : $precioCompraNetoUnit; // elige el menor precio para enviar a proveedor
					$textoWsp .= '*'.$item['stock_compra'] .'* ('.$codProv.')  ```'.$infoProd['descripcion']. '```  *$ '.number_format($netoFinalUnit,0,',','.').'*\n' ;
					$totalFinalNeto += $netoFinalUnit*$infoProd['stock_compra'];
				}
			}
			echo $textoWsp.'////'.round($totalFinalNeto);

		}else if($tipoAbast == 3){ // todos los productos
		
			$item = "estado_".$sucursal;
			$valor = 1;     
			$orden = "descripcion";
			$prodsAll = ModeloProductos::mdlMostrarProductosPedidoAll($item, $valor, $orden); 

			$totalFinalNeto = 0;
			$textoWsp = '';
			foreach(array_reverse($prodsAll) as $key => $item) {
				if($item['stock_compra']>0){
					$idProd = $item['id']; 
					$infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $idProd);

					// BUSCA SKU PROVEEDOR
					$arrayProvs = json_decode($infoProd['lista_provs_json'], true);
					$codProv = 'SINCOD';
					$precioNetoProveedor = 0;
					for ($i=0; $i < count($arrayProvs); $i++) { 
						if($arrayProvs[$i]['prov'] == $prov){
							$codProv = $arrayProvs[$i]['cod_prov']; // si es que se ha comprado al proveedor extrae sku_prov
							$precioNetoProveedor = $arrayProvs[$i]['pc_neto'];
						}
					}

					// busca ultimo precio de compra
			        $ultimaCompraProd = ModeloCompras::mdlUltimaCompraProd('compras', 'abastecimiento', '%"id":"'.$idProd.'"%');
					if(isset($ultimaCompraProd['abastecimiento'])){ // REVISA SI SE HA COMPRADO ANTES
			          	$datosCompra = json_decode($ultimaCompraProd['abastecimiento'], true);
			          	foreach ($datosCompra as $elemento) {
			            	if(isset($elemento['id']) && $elemento['id'] === "$idProd") {
			              		$precioCompraNetoUnit = $elemento['pCNetoActual']; // ultimo precio comprado indistinto del proveedor
			              		break; // Terminar el bucle una vez que se encuentra el elemento
			            	}
			          	}
			        }else{
						$precioCompraNetoUnit = $infoProd['pc_neto']; // precio neto seteado
			        }
			        $netoFinalUnit = $precioNetoProveedor <= $precioCompraNetoUnit && $precioNetoProveedor > 0 ? $precioNetoProveedor : $precioCompraNetoUnit; // elige el menor precio para enviar a proveedor
					$textoWsp .= '*'.$item['stock_compra'] .'* ('.$codProv.')  ```'.$infoProd['descripcion']. '```  *$ '.number_format($netoFinalUnit,0,',','.').'*\n' ;
					$totalFinalNeto += $netoFinalUnit*$infoProd['stock_compra'];
				}
			}
			echo $textoWsp.'////'.round($totalFinalNeto);

		}
	}

	public function totalPedido(){
		$sucursal = $_SESSION['sucursal'];
		$abastecimiento = $_POST['totalPedido'];
		$item1= $_POST['item1'];
		$item2= $_POST['item2'];
		if($abastecimiento == 1){ // categoria
			$item_1 = 'sub_cod_int';
			$valor1_a = str_pad($item1, 2, "0", STR_PAD_LEFT);      
			$valor2_b = str_pad($item2, 2, "0", STR_PAD_LEFT);      
			$valor_1 = $valor1_a.$valor2_b;
			$item_2 = 'estado_'.$sucursal;
			$valor_2 = 1;
			$item_3 = 'stock_'.$sucursal;
			$valor_3 = 'stock_ideal_'.$sucursal;
			$item_4 = 'stock_compra';
			$item_5 = 'precio_compra';
			$orden = 'descripcion';
			$totalEstimadoPedido = round(ModeloProductos::mdlMostrarTotalPedido('productos',$item_1, $valor_1, $item_2, $valor_2, $item_3, $valor_3, $item_4, $item_5)['totalPedido']);
			$totalNetoEstimado = round($totalEstimadoPedido/1.19);
			echo 'ok,'.$totalNetoEstimado.','.$totalEstimadoPedido;
		}else if($_POST['totalPedido'] == 2){ // proveedor
		    $item_1 = "lista_proveedores";
		    $valor_1 = $item1; // $item1 = proveedor
		    $item_2 = "estado_".$sucursal;
		    $valor_2 = 1;
		    $item_4 = 'stock_compra';
		    $item_5 = 'precio_compra';
		    $totalEstimadoPedido = ModeloProductos::mdlMostrarTotalPedido2('productos', $item_1, $valor_1, $item_2, $valor_2, $item_4, $item_5)['totalPedido']; 
		    $totalNetoEstimado = round($totalEstimadoPedido/1.19);
			echo 'ok,'.$totalNetoEstimado.','.$totalEstimadoPedido;
		}else if($_POST['totalPedido'] == 3){ // todos
  			$item = "estado_".$sucursal;
  			$valor = 1;     
  			$orden = "descripcion";
  			$productos = ControladorProductos::ctrMostrarProductos1($item, $valor, $orden);

  			$item1_a = "stock_compra";
  			$item2_a = "precio_compra";
  			$totalEstimadoPedido = ControladorProductos::ctrMultiplicar2Coincidir1($item1_a, $item2_a, $item, $valor)['total'] == 0 ? 0 : round(ControladorProductos::ctrMultiplicar2Coincidir1($item1_a, $item2_a, $item, $valor)['total']);
  			$totalNetoEstimado = round($totalEstimadoPedido/1.19);
			echo 'ok,'.$totalNetoEstimado.','.$totalEstimadoPedido;
		}
	}
}

/*=============================================
TOTAL ABASTECIMIENTO
=============================================*/
if(isset($_POST["totalPedido"])){
	$totalPedido = new AjaxInformes();
	$totalPedido -> totalPedido();
}

/*=============================================
TEXTO WHATSAPP
=============================================*/
if(isset($_POST["textoWhatsappInforme"])){
	$textoWhatsappInforme = new AjaxInformes();
	$textoWhatsappInforme -> textoWhatsappInforme();
}

/*=============================================
RESET INFORME
=============================================*/
if(isset($_POST["resetAbastecimiento"])){
	$resetInformeAbastecimiento = new AjaxInformes();
	$resetInformeAbastecimiento -> resetInformeAbastecimiento();
}

/*=============================================
TRAER PROVEEDORES
=============================================*/	
if(isset($_POST["idProveedor"])){
	$proveedores = new AjaxInformes();
	$proveedores -> idProveedor = $_POST["idProveedor"];
	$proveedores -> ajaxTraerProveedor();
}

/*=============================================
TRAER CATEGORIAS
=============================================*/
if(isset( $_POST["idCategoria"])){
	$categorias = new AjaxInformes();
	$categorias -> idCategoria = $_POST["idCategoria"];
	$categorias -> ajaxTraerCategorias();
}

/*=============================================
TRAER SUBCATEGORIAS
=============================================*/
if(isset( $_POST["idSubcategoria"])){
	$categorias = new AjaxInformes();
	$categorias -> ajaxTraerSubcategorias();
}

/*=============================================
TRAER SUBCATEGORIAS ABASTECIMIENTO
=============================================*/
if(isset( $_POST["idSubcategoriaAbast"])){
	$categorias = new AjaxInformes();
	$categorias -> idSubcategoriaAbast = $_POST["idSubcategoriaAbast"];
	$categorias -> ajaxTraerSubcategoriasAbast();
}

/*=============================================
CANTIDAD PEDIDO TABLA
=============================================*/
if(isset( $_POST["cant_pedido"])){
	$cantidadPedido = new AjaxInformes();
	$cantidadPedido -> actualizarCantPedido();
}


/*=============================================
CANTIDAD PEDIDO TABLA
=============================================*/
// if(isset( $_POST["total"])){
// 	$totalPedido = new AjaxInformes();
// 	$totalPedido -> totalPedido();
// }