<?php
session_start();
require_once '../controladores/ventas.controlador.php';
require_once '../modelos/ventas.modelo.php';

class TablaVentas{

 	/*=============================================
 	 MOSTRAR LA TABLA DE VENTAS
  	=============================================*/ 

	public function mostrarTablaVentas(){
		$sucursal = $_SESSION['sucursal'];
		$ultCierre = $_GET['ultCierre'];
		$ventana = $_GET['ventana'];
		$skuInteres = $_GET['skuInteres'];

		$tabla = 'ventas';
		$item = 'fecha_cont';
		if(isset($_GET['fechaInicial']) && $_GET['fechaInicial'] != 'undefined'){
			$fechaInicial = $_GET['fechaInicial'];
			$fechaFinal = $_GET['fechaFinal'];
		}else{
			$fechaInicial = date('Y-m-d', strtotime('-1 month'));
			$fechaFinal = date('Y-m-d', strtotime('+1 day'));
		}
		$ventas = ModeloVentas::mdlMostrarVentasIntervalo($tabla, $item, $fechaInicial, $fechaFinal);
		
  		if(count($ventas) == 0){
  			echo '{"data": []}';
		  	return;
  		}	
		
  		$datosJson = '{
		  "data": [';


	  	foreach ($ventas as $i => $value) {

	  		if($value['estado']!=0 && $value['sucursal_venta'] == $sucursal){  // FILTRA TODAS LAS VENTAS NO ELIMINADAS Y QUE SEAN DE LA MISMA SUCURSAL

	            if(($value['fecha_cont'] > $ultCierre && $_SESSION['perfil']=='Vendedor')|| $_SESSION['perfil']=='Administrador'){ // permite editar y eliminar ventas del día a vendedores y todas las ventas a administradores
	            	$botonEditar = "<button class='btn btn-sm btn-warning btnEditarVenta info' idVenta='".$value['id']."' data-original-title='Editar'><i class='fas fa-pen'></i></button>";
	            	$botonEliminar = "<button class='btn btn-sm btn-danger btnEliminarVenta info' idVenta='".$value['id']."' data-original-title='Eliminar Venta'><i class='fa fa-times'></i></button>";	            	
	            }else{
	            	$botonEditar = '';
	            	$botonEliminar = '';
	            }


              	$productos=json_decode($value["productos"]);
				$listaProds = "";

				/*--------------------------------- FILTRO PARA NO MOSTRAR INFO DE VENTAS A PRECIO COMPRA A FERRETERIA Y SOCIOS -------------------------------------------*/
				if(is_array($productos)){
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){
						if($productos[0]->sku == $skuInteres && $productos[0]->tot < 0){
							$listaProds = $productos[0]->cant." <b>(".$productos[0]->sku.")</b> DESCUENTO";
						}else{
							$listaProds = $productos[0]->cant." <b>(".$productos[0]->sku.")</b> ".$productos[0]->prod;
						}
					}else{
						if($productos[0]->sku == $skuInteres && $productos[0]->tot < 0){
							$listaProds = $productos[0]->cant." <b>(".$productos[0]->sku.")</b> DESCUENTO →<i><b>$".number_format($productos[0]->pV, 0, ',', '.')." c/u</b></i>";
						}else{
							$listaProds = $productos[0]->cant." <b>(".$productos[0]->sku.")</b> ".$productos[0]->prod." →<i><b>$".number_format( (float) $productos[0]->pV, 0, ',', '.')." c/u</b></i>";
						}
					}
				
	            	for($ia=1;$ia<count($productos);$ia++){ 
	    	            $cantidad = "<br>".$productos[$ia]->cant;
		                $descripcion = $productos[$ia]->prod;
		                $pV = $productos[$ia]->pV;
						if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){
							if($productos[$ia]->sku == $skuInteres && $productos[$ia]->tot < 0){
		                		$productosComprados[$ia] = $cantidad." <b>(".$productos[$ia]->sku.")</b> DESCUENTO";
							}else{
		                		$productosComprados[$ia] = $cantidad." <b>(".$productos[$ia]->sku.")</b> ".$descripcion;
							}
						}else{
							if($productos[$ia]->sku == $skuInteres && $productos[$ia]->tot < 0){
			                	$productosComprados[$ia] = $cantidad." <b>(".$productos[$ia]->sku.")</b> DESCUENTO →<i><b>$".number_format($pV, 0, ',', '.')." c/u</b></i>";
			                }else{
			                	$productosComprados[$ia] = $cantidad." <b>(".$productos[$ia]->sku.")</b> ".$descripcion." →<i><b>$".number_format($pV, 0, ',', '.')." c/u</b></i>";		                	
			                }
						}
		                // JUNTAMOS VARIABLES EN UNA MISMA LISTA
						$listaProds .= $productosComprados[$ia];               	
	            	}
				}

				$met_pago=json_decode($value["metodo_pago"]);
				$idMetPago = 'metPago'.$value['id'];
				
				// FORZAR CI
				if($_SESSION['perfil'] == 'Administrador' && $value["tipo_pago"] == 'Pend' && $value["id_cliente"] > 1){
					$botonForzarCI = "<button class='btn btn-warning btn-sm ventaAForzarTabla' id='forzarCIVentaTabla".$value['id']."' totalVenta='".$value['total']."' idCliente='".$value['id_cliente']."' idVenta='".$value['id']."'>Forzar CI</button>";
				}else{
					$botonForzarCI = '';
				}				
				$cambiarPago = ($_SESSION['perfil'] == 'Administrador' && $value['tipo_pago'] != 'Fiado') || ($_SESSION['perfil'] == 'Vendedor' && $value['tipo_pago'] == 'Pend') ? "<br><div class='btn-group'><button class='btn btn-xs btnCambiarPago info' data-toggle='modal' data-target='#cambiarPagoVenta' style='background-color:fuchsia; color:white' codigoVenta='".$value['id']."' total='".$value['total']."' data-original-title='Cambiar Pago'><i class='fa fa-cash-register'></i></button>":''; // EL ADM PUEDE EDITAR METODO DE PAGO DE TODAS LAS VENTAS EXCEPTO LAS VENTAS CON CREDITO INTERNO, QUE POR ESTE METODO NO DESCUENTA DEUDA AL CLIENTE SI SE PASA DE CREDITO INTERNO A OTRO. EL VENDEDOR PUEDE EDITAR SOLO VENTAS PENDIENTES (COBRO EN REPARTO)

				if($value["tipo_pago"] == "Efectivo"){
					$cash = number_format( (float) $met_pago[0]->cash, 0, ',', '.');
					$vuelto = number_format( (float) $met_pago[0]->vuelto, 0, ',', '.');
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
		                $metodo_pago = '<div id='.$idMetPago.'><b>Efectivo</b></div>';
						$total = '';
					}else{
						$total = number_format($met_pago[0]->total, 0, ',', '.');
		                $metodo_pago = '<div id='.$idMetPago.'><b>Efectivo</b><br>Cash: $ '.$cash."<br>Total: $ ".$total."<br>Vuelto: $ ".$vuelto.$cambiarPago.'</div><br><br>'.$botonForzarCI;
					}
				}else if($value["tipo_pago"] == "Transferencia"){
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<div id='.$idMetPago.'><b>Transferencia</b></div>';
					}else{
						$metodo_pago = '<div id='.$idMetPago.'><b>Transferencia</b><br>Monto: $ '.number_format($value["metodo_pago"], 0, ',', '.').$cambiarPago.'</div><br><br>'.$botonForzarCI;						
					}
				}else if($value["tipo_pago"] == "TD"){
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<div id='.$idMetPago.'><b>Tarjeta Debito</b></div>';
					}else{
						$metodo_pago = '<div id='.$idMetPago.'><b>Tarjeta Debito</b><br>'.$value["metodo_pago"].$cambiarPago.'</div><br><br>'.$botonForzarCI;
					}
				}else if($value["tipo_pago"] == "TC"){
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<div id='.$idMetPago.'><b>Tarjeta Credito</b></div>';
					}else{
						$metodo_pago = '<div id='.$idMetPago.'><b>Tarjeta Credito</b><br>'.$value["metodo_pago"].$cambiarPago.'</div><br><br>'.$botonForzarCI;
					}
				}else if($value["tipo_pago"] == "E_TD"){
					$cash = number_format($met_pago[0]->cash, 0, ',', '.');
					$tarjeta = number_format($met_pago[0]->tarjeta, 0, ',', '.');
					$codigo = $met_pago[0]->cod;
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<div id='.$idMetPago.'><b>Pago Combinado</b></div>';
					}else{
						$metodo_pago = '<div id='.$idMetPago.'><b>Pago Combinado</b><br>Cash: $ '.$cash."<br>TD-".$codigo." ($ ".$tarjeta.")".$cambiarPago.'</div><br><br>'.$botonForzarCI;
					}
				}else if($value["tipo_pago"] == "E_TC"){
					$cash = number_format($met_pago[0]->cash, 0, ',', '.');
					$tarjeta = number_format($met_pago[0]->tarjeta, 0, ',', '.');
					$codigo = $met_pago[0]->cod;
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<div id='.$idMetPago.'><b>Pago Combinado</b></div>';
					}else{
						$metodo_pago = '<div id='.$idMetPago.'><b>Pago Combinado</b><br>Cash: $ '.$cash."<br>TC-".$codigo." ($ ".$tarjeta.")".$cambiarPago.'</div><br><br>'.$botonForzarCI;
					}
				}else if($value["tipo_pago"] == "Fiado"){
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<div id='.$idMetPago.'><b>Credito Interno</b></div>';
					}else{
						$metodo_pago = '<div id='.$idMetPago.'><b>Credito Interno</b><br>Monto: $ '.number_format($value["total"], 0, ',', '.').$cambiarPago.'</div><br><br>'.$botonForzarCI;
					}
				}else if($value["tipo_pago"] == "Pend"){
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$metodo_pago = '<div id='.$idMetPago.'><b>Pendiente</b></div>';
					}else{
						$metodo_pago = '<div id='.$idMetPago.'><b>Pendiente</b><br>Monto: $ '.number_format($value["total"], 0, ',', '.').$cambiarPago.'</div><br><br>'.$botonForzarCI;
					}
				}

				// TOTAL CON O SIN DESCUENTO
				if($value["descuentos"]!=0){
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$total = '';
					}else{
						$total = "<font class='pull-right'>$ ".number_format(($value["total"]+$value["descuentos"]), 0, ',', '.')."</font><br><font class='pull-right' color='red'>-$ " .number_format($value["descuentos"], 0, ',', '.')."</font><br><b class='pull-right'>$ ".number_format($value["total"], 0, ',', '.')."</b>";
					}					
				}else{
					if($value['vista_vendedor']==0 && $_SESSION['perfil']!='Administrador'){ // OCULTA A VENDEDOR PRECIO VENTA A SOCIOS Y FERRETERIA
						$total = '';
					}else{
						$total = "<b class='pull-right'>$ ".number_format($value["total"], 0, ',', '.')."</b>";
					}
				}

			  	/*=============================================
	 	 		ACCIONES
	  			=============================================*/ 
		  		$pos = explode('"prod":"',$value["productos"]);
		  		$productosGET0 = $pos[0];

				for ($i0=1; $i0<count($pos); $i0++){
					$pos1 = strpos($pos[$i0], '","');
					$largo = strlen($pos[$i0]);
					$productosGET0 .= '"prod":"';
					$productosGET0 .= substr($pos[$i0],0,15);
					$productosGET0 .= substr($pos[$i0],$pos1,$largo);
				}
				$productosGET1 = str_replace("'", "+", $productosGET0); //reemplaza por (¿) el caracter (') en descripción del producto
              	$productosGET2 = str_replace("\"", "?", $productosGET1); // reemplaza las (") por (')
              	$productosGET3 = str_replace(" ", "_", $productosGET2); // reemplaza espacios ( ) por (_)




              	// CONTEO DE CARACTERES DE URL (LIMITE 5380 CARACTERES)
	  			$g0 = strlen('http://localhost/pos/extensiones/tcpdf/pdf/ticketGET.php?cliente=&vendedor=&productos=&codigo=&fecha=');
	  			$g1 = strlen($value['nom_client'])+strlen($value['nom_vend'])+strlen($productosGET3)+strlen($value['id'])+strlen($value['fecha_venta']);
	  			$g2 = substr_count($productosGET3, "'")*2+substr_count($value['nom_client'], " ")*2+substr_count($value['nom_vend'], " ")*2+substr_count($productosGET3, "¿")*4;
	  			$largoURL = $g0+$g1+$g2;


	  			$botonAsignarFactura = $value['nro_factura'] != "" ? "" : "<div style='height:3px'></div><button data-original-title='Asignar Rut Facturar' data-placement='bottom' id='botonAsignarRutFactura' class='btn btn-secondary btn-sm info' idCliente='".$value['id_cliente']."' idVenta='".$value['id']."' data-toggle='modal' data-target='#modalRutFacturar'><i class='fas fa-file-invoice'></i></button>";
                $botonSii = $value['rut_factura'] != '' && $value['nro_factura'] == '' ? "<div id='botonDatosSII".$value['id']."'><button class='btn btn-sm btnVentaSii listaFactura info' data-original-title='Datos Factura SII' style='background-color:gray; color:white' codigoVenta='".$value['id']."' data-original-title='PDF Sii'><span class='d-none spinner-border spinner-border-sm'></span><font id='textoSII'>SII</font></button></div>" : "<div id='botonDatosSII".$value['id']."'></div>";
				
				$mostrarImprimirTicket = $_SESSION["conexionImpresoraLocal"] == 1 ? '' : 'd-none';
                $botonReimprimirTicketVenta = "<button data-original-title='Reimprimir Ticket' data-placement='bottom' class='".$mostrarImprimirTicket." imprimirTicketVenta btn btn-info btn-sm info float-right reimprimirTicketVenta' idVenta='".$value['id']."'><i class='fas fa-print'></i></button>";

                if($_SESSION["perfil"] == "Administrador"){
			  		$botones =  "<div class='btn-group'><button class='btn btn-info btn-sm btnImprimirVentaCarta info' codigoVenta='".$value['id']."' data-original-title='Ver PDF'><i class='fa fa-file'></i></button><button class='btn btn-sm btnDescargaVenta info' style='background-color:purple; color:white' codigoVenta='".$value['id']."' data-original-title='Descargar Venta'><i class='fa fa-file-download'></i></button>".$botonSii.$botonEditar.$botonEliminar."</div>".$botonAsignarFactura.$botonReimprimirTicketVenta;
			  	}else if($value['vista_vendedor']==0 && $_SESSION["perfil"]=="Vendedor"){
			  		$botones =  "<div class='btn-group'><button class='btn btn-info btn-sm btnImprimirVentaCarta info' codigoVenta='".$value['id']."' data-original-title='Ver PDF'><i class='fa fa-file'></i></button><button class='btn btn-sm btnDescargaVenta info' style='background-color:purple; color:white' codigoVenta='".$value['id']."' data-original-title='Descargar Venta'><i class='fa fa-file-download'></i></button></div>";
			  	}else{
			  		$botonEditarDentroDia = $value['fecha_cont'] == date('Y-m-d') ? $botonEditar : '';
			  		$botonEliminarDentroDia = $value['fecha_cont'] == date('Y-m-d') ? $botonEliminar : '';
			  		$botones =  "<div class='btn-group'><button class='btn btn-info btn-sm btnImprimirVentaCarta info' codigoVenta='".$value['id']."' data-original-title='Ver PDF'><i class='fa fa-file'></i></button><button class='btn btn-sm btnDescargaVenta info' style='background-color:purple; color:white' codigoVenta='".$value['id']."' data-original-title='Descargar Venta'><i class='fa fa-file-download'></i></button>".$botonSii.$botonEditarDentroDia.$botonEliminarDentroDia."</div>".$botonAsignarFactura.$botonReimprimirTicketVenta;
			  	}

                $fecha = explode(" ",$value["fecha_venta"]);
                $fechaVent = "<b>".$fecha[0]."</b><br>".$fecha[1];
				
                $fechaModif = explode(" ",$value["fecha"]);
                $fechaModifMostrar = "<b>".$fechaModif[0]."</b><br>".$fechaModif[1];

                $detalleFlete = $value['detalle_flete'] == '' ? '' : '<hr><font size=\"-1\" idVenta=\"'.$value['id'].'\" class=\"detalleDespacho\" id=\"detalleDespacho'.$value['id'].'\">Despacho:<br><b>'.$value['detalle_flete'].'</b></font>';

				if($value['rut_factura'] == ''){
					$detalleFactura = '';
				}else if($value['rut_factura'] != '' && $value['nro_factura'] == ''){
					$botonAgregarNroFactura = '<br><button class=\"btn btn-primary btn-xs btnSubirFactura\" idVenta=\"'.$value['id'].'\" rut=\"'.$value['rut_factura'].'\">Subir Factura(s)</button>';
					// $detalleFactura = '<input type=\"file\" name=\"file[]\" multiple>';
					$detalleFactura = '<hr><font size=\"-1\" style=\"color:red\">Facturar:<br><b>'.$value['rut_factura'].'</b></font>'.$botonAgregarNroFactura;
				
				}else{

		            $facturas = explode(',', $value['nro_factura']);
		            $facturasMostar = '';
					
		            $saltoLinea = count($facturas) == 1 ? '' : '<br>';
		            $plural = count($facturas) == 1 ? '' : 'S';

		            for ($ib=0; $ib < count($facturas); $ib++) { 
		            	$dirBase = '/pos/sii/facturas/';
		            	$dirFactura = $value['dir_factura'] == '' ? '' : $value['dir_factura'].'/';

		            	if($ib == 0){
							$facturasMostar .= '<button class=\"btn btn-dark btn-sm\" onclick=\"window.open(\''.$dirBase.$dirFactura.$facturas[$ib].'.pdf\')\">'.$facturas[$ib].'</button>';
		            	}else{
							$facturasMostar .= ' <button class=\"btn btn-dark btn-sm\" onclick=\"window.open(\''.$dirBase.$dirFactura.$facturas[$ib].'.pdf\')\">'.$facturas[$ib].'</button>';
		            	}

		            }

		            $botonEliminarFacts = "<button type='button' class='btn btn-danger btn-circle btn-sm quitarFactsVenta float-right info' idVenta='".$value['id']."'><i class='fa fa-times'></i></button>";

					$detalleFactura = '<hr><font size=\"-1\" class=\"text-primary\">FACTURA'.$plural.' ASOCIADA'.$plural.':   '.$botonEliminarFacts.'</font><br>'.$facturasMostar;


				}
                // $detalleFactura = $value['rut_factura'] == '' ? '' : 

                $detalleVenta = $value['detalle_venta'] == '' ? "<button class='btn btn-success btn-xs btnAgregarDetalleVentaAjax info' data-original-title='Agregar Detalle' data-placement='bottom' idVenta='".$value['id']."'>+</button>" : "<font class='editDetalleVentaAjax' idVenta='".$value['id']."'>".$value['detalle_venta']."</font>";



            	$porcentajeUtilidad = number_format($value['utilidad_total']*pow(($value['total']-$value['utilidad_total']), -1)*100,2,',','.');
				$utilidad = '<font style=\"color:blue\"><b>$ '.number_format($value['utilidad_total'], 0, ',', '.').'</b><br>('.$porcentajeUtilidad.'%)</font>';

				$estadoVenta = $value['estado'] == 2 ? "<br><img id='expirado".$value['id']."' style='position:absolute; z-index:1; height:40px' src='componentes/img/extras/venta_editada.png'>" : '';


				if($_SESSION['perfil'] == 'Administrador'){

				  	$datosJson .='[
						"'.($i+1).'",
						"'.$value["nom_client"].'",
						"'.$listaProds.'",
						"<div id='."detalleVenta".$value['id'].'><i>'.$detalleVenta.'</i>'.$detalleFlete.'<div id=\"facturas'.$value['id'].'\">'.$detalleFactura.'</div></div>",
						"'.$total.' <font size=\"-2\" style=\"visibility:hidden\">'.$value['total'].'</font>",
						"'.$utilidad.'",
						"'.$metodo_pago.'",
						"'.$value["nom_vend"].'",
						"'.$value["cod_venta"].'",
						"'.$fechaVent.'",
						"'.$value["fecha_cont"].'",
						"'.$fechaModifMostrar.$estadoVenta.'",
						"'.$botones.'"
					],';

				}else{
				  	$datosJson .='[
						"'.($i+1).'",
						"'.$value["nom_client"].'",
						"'.$listaProds.'",
						"<div id='."detalleVenta".$value['id'].'><i>'.$detalleVenta.'</i>'.$detalleFlete.'<div id=\"facturas'.$value['id'].'\">'.$detalleFactura.'</div></div>",
						"'.$total.'",
						"'.$metodo_pago.'",
						"'.$value["nom_vend"].'",
						"'.$value["cod_venta"].'",
						"'.$fechaVent.'",
						"'.$value["fecha_cont"].'",
						"'.$botones.'"
					],';
				}

			}
				
		}

		$datosJson = substr($datosJson, 0, -1);

		$datosJson .=   '] 

		}';
		
		echo $datosJson;


	}


}

/*=============================================
ACTIVAR TABLA DE VENTAS
=============================================*/ 
$actTblVentas = new TablaVentas();
$actTblVentas -> mostrarTablaVentas();