<?php
session_start();
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";
require_once "../modelos/sucursales.modelo.php";


class TablaProductosVentas{

	public function mostrarTablaProductosVentas(){

		$sucursal = $_SESSION['sucursal'];
		$perfil = $_GET['perfil'];
		$item = "estado_".$sucursal;
    	$valor = 1;
    	$orden = "fecha";
  		$productos = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);

   		$sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
	    $nombre_y_alias = array();
	    $locales = array();

		$skuProductoComun = $_GET['skuProdComun'];
		$skuInteres = $_GET['skuInteres'];

            
        foreach ($sucursales as $key => $value){
        	if($value['nombre_sucursal'] != $sucursal){
	        	array_push($nombre_y_alias, $value["nombre_sucursal"]); 
	        	array_push($nombre_y_alias, $value["alias_sucursal"]);
	        	array_push($locales, $nombre_y_alias);
		    	$nombre_y_alias = array(); // vaciamos array
        	}
        }

 		
  		if(count($productos) == 0){

  			echo '{"data": []}';

		  	return;
  		}	
		
  		$datosJson = '{
		  "data": [';


		foreach ($productos as $key => $value) {
			if(($value['sku'] != $skuInteres && $perfil == 'Vendedor') || $perfil == 'Administrador'){
	
				$descripcionESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $value["descripcion"]);
				$descripcion2ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $value["descripcion2"]);

				$stockActual = $value["stock_".$sucursal];
			  	$imagen = "<img id='imagenZoom' src='".$value["imagen"]."' alt='".$descripcionESCAPE."' class='imagenZoom' width='40px' idProducto='".$value["id"]."' data-toggle='modal' data-target='#modalZoomProducto'>";
				$ubicacion = $value['maneja_stock'] == 'NO' ? '' : $value["zona_".$sucursal]."-";
				$oferta = $value["mayor_sobre"]; // oferta== 1 -> EN OFERTA - oferta>1 -> SIN OFERTA
				$descripcion = "<b>".$descripcionESCAPE."</b><br><font size=-2'>".$descripcion2ESCAPE."</font>";
				$sku = $value["categoria"] <= 9 ? '0'.$value["sku"] : $value["sku"];
				$codigoAgotado = 	"<div class='position-relative p-3 bg-gray'>".
	              						"<div class='ribbon-wrapper'>".
	                						"<div class='ribbon bg-danger text-md'>".
	                  							"Agotado".
	                						"</div>".
	              						"</div>".
	              						"<b>".$ubicacion.$sku."</b> (".$value["codigo"].")<br>".$descripcionESCAPE."<br>".
	              						"<small>".$descripcion2ESCAPE."</small>".
	            					"</div>";

				$codigoOferta = 	"<div class='position-relative p-3 bg-info'>".
	              						"<div class='ribbon-wrapper'>".
	                						"<div class='ribbon bg-lime text-md'>".
	                  							"OFERTA".
	                						"</div>".
	              						"</div>".
	              						"<b>".$ubicacion.$sku."</b> (".$value["codigo"].")<br>".$descripcionESCAPE."<br>".
	              						"<small>".$descripcion2ESCAPE."</small>".
	            					"</div>";

				$codigoOfertaAgotado = 	"<div class='position-relative p-3 bg-gray'>".
	              						"<div class='ribbon-wrapper'>".
	              						"<div class='ribbon-wrapper'>".
	                						"<div class='ribbon bg-danger text-md'>".
	                  							"Agotado".
	                						"</div>".
	              						"</div>".
	                						"<div class='ribbon bg-lime text-md'>".
	                  							"OFERTA".
	                						"</div>".
	              						"</div>".
	              						"<b>".$ubicacion.$sku."</b> (".$value["codigo"].")<br>".$descripcionESCAPE."<br>".
	              						"<small>".$descripcion2ESCAPE."</small>".
	            					"</div>";

				$precioCompra = $value["precio_compra"];
				$manejaStock = $value["maneja_stock"];

				if($stockActual == 0  && $manejaStock == 'SI' && $oferta != 1){ // SIN STOCK, MANEJA STOCK Y SIN OFERTA
					$codigos = $codigoAgotado;
					if($manejaStock == "SI" && $value['precio_venta'] == $value['precio_mayor']){ // precio unico
	  					$precioVenta = "<b class='text-primary'>Único: $ ".number_format($value["precio_mayor"],0,',','.')." c/u</b>";
		  			}else{
	  					$precioVenta = "<div><b>$ ".number_format($value["precio_venta"], 0, ',', '.')." c/u</b> (".$value["descuento"]."%)<br><b style='color:rgb(92,184,92)' class='varMayor' idProd='".$value["id"]."'>&uarr; ".$value["mayor_sobre"]."u $ ".number_format($value["precio_mayor"],0,',','.')." c/u</b></div>";
		  			}

				}else if($stockActual == 0 && $manejaStock == 'SI' && $oferta == 1){ // SIN STOCK, MANEJA STOCK Y EN OFERTA
					$codigos = $codigoOfertaAgotado;
	  				$precioVenta = "<div><strike>Antes: $ ".number_format($value["precio_venta"], 0, ',', '.')." c/u</strike><br><b class='text-danger'>Ahora: $ ".number_format($value["precio_mayor"],0,',','.')." c/u</b></div>";
				}else if($stockActual > 0 && $manejaStock == 'SI' && $oferta == 1){ // CON STOCK, MANEJA STOCK Y EN OFERTA
					$codigos = $codigoOferta;
	  				$precioVenta = "<div><strike>Antes: $ ".number_format($value["precio_venta"], 0, ',', '.')." c/u</strike><br><b class='text-danger'>Ahora: $ ".number_format($value["precio_mayor"],0,',','.')." c/u</b></div>";
				}else{
					$codigos = "<b>".$ubicacion.$sku."</b> (".$value["codigo"].")<br>".$descripcion;
		  			if($manejaStock == "SI" && $value['precio_venta'] != $value['precio_mayor']){
		  				$precioVenta = "<div><b>$ ".number_format($value["precio_venta"], 0, ',', '.')." c/u</b> (".$value["descuento"]."%)<br><b style='color:rgb(92,184,92)' class='varMayor' idProd='".$value["id"]."'>&uarr; ".$value["mayor_sobre"]."u $ ".number_format($value["precio_mayor"],0,',','.')." c/u</b><br><button class='btn btn-warning btn-xs btnEditPVentVivo float-left' idProd='".$value["id"]."'><i class='fa fa-pen'></i></button></div>";
		  			}else if($manejaStock == "SI" && $value['precio_venta'] == $value['precio_mayor']){ // precio unico
		  				if($perfil == 'Administrador'){
		  					$precioVenta = "<div><b class='text-primary'>Único: $ ".number_format($value["precio_mayor"],0,',','.')." c/u</b><br><button class='btn btn-warning btn-xs btnEditPVentVivo float-left' idProd='".$value["id"]."'><i class='fa fa-pen'></i></button></div>";
		  				}else{
		  					$precioVenta = "<b class='text-primary'>Único: $ ".number_format($value["precio_mayor"],0,',','.')." c/u</b>";
		  				}
		  			}else{
		  				$precioVenta = "Precio Estimado <b>$".number_format($value["precio_venta"], 0, ',', '.')." c/u</b>";
		  			}
				}


	  			$idStock = 'stock'.$value['id'];
	  			$stockIdeal = $value['stock_ideal_'.$sucursal];
				if($stockActual == 0){ 
	  				$color = 'bg-black'; // agotado
	  			}else if($stockActual <= $stockIdeal/3 && $stockActual > 0){
					$color = 'btn-danger'; // stock bajo 
	  			}else if($stockActual > $stockIdeal/3 && $stockActual <= $stockIdeal*2/3){
					$color = 'btn-warning'; // stock medio
	  			}else if($stockActual > $stockIdeal*2/3){
					$color = 'btn-success'; // stock alto
	  			}

				$classAgregarProducto = $oferta == 1 ? 'agregarOferta' : 'agregarProducto';

				// TIPO BOTON
				if($manejaStock == "SI" && $stockActual > 0 && $value['precio_venta'] != $value['precio_mayor']){ // MANEJA STOCK y CON STOCK
					$colorStk = "<button class='btn btn-sm ".$color."' id='".$idStock."'>";
				  	$btnAgregar =  "<div class='btn-group'><button class='btn btn-primary btn-sm ".$classAgregarProducto." recuperarBoton' id='agregarProducto0' idProducto='".$value["id"]."'>Agregar</button></div>"; 
				}else if($manejaStock == "SI" && $stockActual == 0 && $value['precio_venta'] != $value['precio_mayor']){ // MANEJA STOCK Y SIN STOCK
					$colorStk = "<button class='btn btn-sm ".$color."' id='".$idStock."'>";
				  	$btnAgregar =  "<div class='btn-group'><button class='btn ".$color." btn-sm recuperarBoton' id='agregarProducto0' idProducto='".$value["id"]."'>Agotado</button></div>"; 
				}else if($manejaStock == "SI" && $stockActual == 0 && $value['precio_venta'] == $value['precio_mayor']){ // MANEJA STOCK Y SIN STOCK
					$colorStk = "<button class='btn btn-sm ".$color."' id='".$idStock."'>";
				  	$btnAgregar =  "<div class='btn-group'><button class='btn ".$color." btn-sm recuperarBoton' id='agregarProducto0' idProducto='".$value["id"]."'>Agotado</button></div>"; 
				}else if($manejaStock == "SI" && $stockActual > 0 && $value['precio_venta'] == $value['precio_mayor']){ // PRECIO UNICO
					$colorStk = "<button class='btn btn-sm ".$color."' id='".$idStock."'>";
				  	$btnAgregar =  "<div class='btn-group'><button class='btn btn-primary btn-sm recuperarBoton agregarUnico' pMay='".$value['precio_mayor']."' id='agregarProducto0' idProducto='".$value["id"]."'>Agregar</button></div>"; 
				}else if($manejaStock == "NO" && $value['sku'] == $skuProductoComun){ // DETECTA PROD COMUN
				  	$btnAgregar =  "<div class='btn-group'><button class='btn btn-primary btn-sm agregarProducto recuperarBoton prodComun' id='agregarProducto0' idProducto='".$value["id"]."'>Agregar</button></div>";				 
				}else{ // DETECTA PROD SIN MANEJO DE STOCK
				  	$btnAgregar =  "<div class='btn-group'><button class='btn btn-primary btn-sm agregarProducto recuperarBoton noManejaStock' id='agregarProducto0' idProducto='".$value["id"]."'>Agregar</button></div>"; 				
				}
				
				// PERMITE QUE EL BOTON SURTIR APAREZCA SI CUMPLE CON: QUE SEA EL PRODUCTO A SURTIR(TRANSFORMABLE=2), QUE EL STOCK DEL PRODUCTO BASE SEA MAYOR QUE CERO Y QUE LAS UNIDADES QUE TIENE EL PRODUCTO SEAN MENORES AL INTERCAMBIO 
				if($value['transformable']==2){
					$prodBase = ModeloProductos::mdlMostrarProducto('productos', 'id', $value['id_transf']);
					if($prodBase['stock_'.$sucursal]>0 && $value['stock_'.$sucursal]<$value['cant_transf']){ // proBase con stock y que stock_prodSurtible sea menor a Cantidad Surtible 
						$surtir = "<button style='color:white; background-color:lightseagreen' class='btn btn-xs surtirAlChicoxD info' idProd='".$value['id']."' id='surtirAlChicoxD' data-original-title='Sumar ".$value['cant_transf']."u'>SURTIR</button>";
					}else{
						$surtir = '';
					}
				}else{
					$surtir = '';
				}

				//GENERA LEYENDA QUE APARECE EN TOOLTIP CUANDO HAY STOCK >0 EN OTRAS SUCURSALES
				$stockOtrosLocales = '';
				for ($i_1=0; $i_1 < count($locales); $i_1++){
					if($value['stock_'.$locales[$i_1][0]] > 0){
						$stockOtrosLocales .= strtoupper($locales[$i_1][0])." (".$value['zona_'.$locales[$i_1][0]].") &rarr; ".number_format($value['stock_'.$locales[$i_1][0]],0,',','.')."u&#10;"; // EJ. BODEGA1 (C17N5) -> 1000u
					} 
				}

				// FALTA STOCK EN OTRAS SUCURSALES Y BODEGAS
				if($manejaStock =="SI" && $stockOtrosLocales != ''){
					$stock = "<div>".$colorStk.$stockActual."</button>".$surtir."</div><button style='color:white; background-color:purple' class='btn btn-xs stockBodega info' data-original-title='".$stockOtrosLocales."'>OTROS LOCALES</button>";
				}else if($manejaStock =="SI" && $stockOtrosLocales == ''){
					$stock = "<div>".$colorStk.$stockActual."</button><div class='mb-1'></div><div>".$surtir."</div>";
				}else{
					$stock = "<div class='btn-group'><button class='btn btn-info'><font size='+1'>&infin;</font></button></div>";
				}

			  	$datosJson .='[
				      "'.$imagen.'",
				      "'.$codigos.'",
				      "'.$precioVenta.'",
				      "'.$stock.'",
				      "'.$btnAgregar.'"
				    ],';
			}

		}

		$datosJson = substr($datosJson, 0, -1);

		$datosJson .=   '] 

		}';
		
		echo $datosJson;
	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$activarProductosVentas = new TablaProductosVentas();
$activarProductosVentas -> mostrarTablaProductosVentas();

