<?php
session_start();
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";

class TablaProductos{

 	/*=============================================
 	 MOSTRAR LA TABLA DE PRODUCTOS
  	=============================================*/ 

	public function mostrarTablaProductos(){

	    $sucursal = $_SESSION['sucursal'];
		$item = "estado_".$sucursal;
    	$valor = 1;
    	$orden = "fecha";
  		$productos = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);	

  		if(count($productos) == 0){

  			echo '{"data": []}';

		  	return;
  		}
		
  		$datosJson = '{
		  "data": [';
		  for($i = 0; $i < count($productos); $i++){
		  	
			$descripcionESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productos[$i]["descripcion"]);
			$descripcion2ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productos[$i]["descripcion2"]);
			$descripcion2 = $descripcion2ESCAPE == '' ? 'Sin Nombre Alternativo ' : $descripcion2ESCAPE;
			$descSII_ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productos[$i]["desc_sii"]);


		  	$imagen = "<img id='imagenZoom' src='".$productos[$i]["imagen"]."' alt='".$descripcionESCAPE."' class='imagenZoom' width='40px' idProducto='".$productos[$i]["id"]."' data-toggle='modal' data-target='#modalZoomProducto'>";
			$descripcion = 	"<div class='d-none d-lg-block' id='descripcionProd".$productos[$i]['id']."'><font size='+1'><b>".$descripcionESCAPE."</b></font><br><font size='-1' class='editNameAltProd' idProd='".$productos[$i]['id']."'>".$descripcion2."</font></div>";

			$idCodigos = 'codigos'.$productos[$i]["id"];

			$ubicacion = $productos[$i]['maneja_stock'] == 'NO' ? '' : strtoupper($productos[$i]["zona_".$sucursal])."-";
			$btnEditUbic = $productos[$i]['maneja_stock'] == 'NO' ? '' : " <i style='color:rgb(224,142,11)' class='fa fa-pen btnEditUbic' idProducto='".$productos[$i]["id"]."' codInt='".$productos[$i]["sku"]."' prov='".$productos[$i]["cod_proveedor"]."' ubic='".$productos[$i]["zona_".$sucursal]."' codBar='".$productos[$i]["codigo"]."'></i>";
  			$codigos = "<div id=".$idCodigos."><b>".$ubicacion.$productos[$i]["sku"]."</b>".$btnEditUbic."<br>".$productos[$i]["codigo"]."</div>";


		  	// STOCK CON COLORES DINAMICO 
  			$stockIdeal = $productos[$i]['stock_ideal_'.$sucursal];
  			$stock = $productos[$i]["stock_".$sucursal];
  			if($stock <= $stockIdeal/3){
				$estado_stock = 1;
  			}else if($stock > $stockIdeal/3 && $stock <= $stockIdeal*2/3){
				$estado_stock = 2;
  			}else{
				$estado_stock = 3;
  			}

 			$descuento = "<b>".$productos[$i]["descuento"]." %</b>";
		
 	 		// PRECIO VENTA
  			if($productos[$i]["maneja_stock"]=="SI"){
	  			$precioVenta = "<div><font>$ ".number_format($productos[$i]["precio_venta"], 0, ',', '.')." c/u<br><font style='color:rgb(92,184,92)'>&uarr; ".$productos[$i]["mayor_sobre"]."u $ ".number_format($productos[$i]["precio_mayor"],0,',','.')." c/u<br></font><font><b>MAX DCTO: ".$productos[$i]["descuento"]."%</b></font></font></div>";
  			}else{
  				$precioVenta = "Limache Viejo <b>$ ".number_format($productos[$i]["precio_venta"], 0, ',', '.')." c/u</b>";
  			}


			$checkStock = $productos[$i]["check_stock_".$sucursal] == 1 || $productos[$i]["maneja_stock"] == 'NO' ? '' : "<div style='height:3px'></div><div id='btnCheckStock".$productos[$i]["id"]."'><button class='btn btn-warning info' data-original-title='Check Stock' data-placement='bottom' onclick='checkeoStock(".$productos[$i]['id'].")' idProd='".$productos[$i]['id']."'><i class='fa fa-check-square'></i></button></div>";
			// STOCK
			$idStock = 'stkVis'.$productos[$i]["id"];
			$btnBajaStock = 'btnRestStock'.$productos[$i]["id"];
			$btnSubeStock = 'btnSumStock'.$productos[$i]["id"];
			$btnBajaIdeal = 'btnBajarStkIdeal'.$productos[$i]["id"];
			$btnSubeIdeal = 'btnSubirStkIdeal'.$productos[$i]["id"];

            if($stock < $stockIdeal/3){
            	$color = 'danger';
            }else if($stock >= $stockIdeal/3 && ($stock < (2*$stockIdeal/3))){
            	$color = 'warning';
            }else{
            	$color = 'success';           	
            }

			if($productos[$i]["maneja_stock"]=="SI"){
				$stock_vista = "<div id=".$idStock." class='btn-group'><button class='btn btn-default btnRestStock info' data-original-title='-1' id=".$btnBajaStock." ideal='".$productos[$i]["stock_ideal_".$sucursal]."' idProd='".$productos[$i]["id"]."'>&darr;</button><button style='text-align:right' class='btn btn-".$color." stockVista info' data-original-title='Editar Stock' stk='".$stock."' ideal='".$productos[$i]["stock_ideal_".$sucursal]."' idProd='".$productos[$i]["id"]."' style='width:50px'>".$stock."/".$stockIdeal."</button><button class='btn btn-default btnSumStock info' data-original-title='+1' id=".$btnSubeStock." ideal='".$productos[$i]["stock_ideal_".$sucursal]."' idProd='".$productos[$i]["id"]."'>&uarr;</button></div>";
			}else{
				$stock_vista = "<div class='btn-group'><button class='btn btn-info'><font size='+1'>&infin;</font></button></button></div>";		
			}

  			$cats = '<b>'.$productos[$i]["cat_nom"].'</b><br>'.$productos[$i]["subcat_nom"];

		  	$datosJson .='[
			      "'.$productos[$i]['id'].'",
			      "'.($i+1).'",
			      "'.$imagen.'",
			      "'.$cats.'",
			      "'.$descripcion.'",
			      "'.$codigos.'",
			      "'.$stock_vista.$checkStock.'",
			      "'.$precioVenta.'"
			    ],';

		  }
		  // elimina el último caracter que es la coma de la fila 96, para evitar el error de sistaxis que no debe terminar con coma
		  $datosJson = substr($datosJson, 0, -1);
		 // concateno el corchete cerrado y la llave cerrada 
		 $datosJson .=   ']

		 }';
		
		echo $datosJson;


	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$activarProductos = new TablaProductos();
$activarProductos -> mostrarTablaProductos();
