<?php
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";



class TablaProductosFaltantes{

 	/*=============================================
 	 MOSTRAR LA TABLA DE PRODUCTOS FALTANTES
  	=============================================*/ 

	public function mostrarTablaProductosFaltantes(){

		$item = null;
    	$valor = null;
    	$orden = "id";

  		$productos = ControladorProductos::ctrMostrarProductosFaltantes($item, $valor, $orden);	

  		if(count($productos) == 0){

  			echo '{"data": []}';

		  	return;
  		}
		
  		$datosJson = '{
		  "data": [';
		  // count trae la cantidad de productos
		  for($i = 0; $i < count($productos); $i++){

		  	$productoFaltante = mb_strtoupper($productos[$i]["producto_faltante"]);
		 	// llenado de la estructura
		  	$datosJson .='[
			      "'.($i+1).'",
			      "'.$productoFaltante.'",
			      "'.$productos[$i]["fecha"].'"
			    ],';

		  }
		  // elimina el último caracter que es la coma de la fila 96, para evitar el error de sistaxis que no debe terminar con coma
		  $datosJson = substr($datosJson, 0, -1);
		 // concateno el corchete cerrado y la llave cerrada 
		 $datosJson .=   ']

		 }';
		
		echo $datosJson;


	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$productosFaltantes = new TablaProductosFaltantes();
$productosFaltantes -> mostrarTablaProductosFaltantes();

