<?php
session_start();
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";
require_once "../modelos/sucursales.modelo.php";

class TablaProductos{
 	/*=============================================
 	 MOSTRAR LA TABLA DE PRODUCTOS
  	=============================================*/ 



	public function mostrarTablaProductos(){

	    $sucursal = $_SESSION['sucursal'];
		$item = "estado_".$sucursal;
    	$valor = 1;
    	$orden = "fecha_modif_".$sucursal;
  		$productos = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);
   		


   		$sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
	    $nombre_y_alias = array();
	    $locales = array();
            
        foreach ($sucursales as $key => $value){
        	if($value['nombre_sucursal'] != $sucursal){
	        	array_push($nombre_y_alias, $value["nombre_sucursal"]); 
	        	array_push($nombre_y_alias, $value["alias_sucursal"]);
	        	array_push($locales, $nombre_y_alias);
		    	$nombre_y_alias = array(); // vaciamos array
        	}
        }  		

  		if(count($productos) == 0){

  			echo '{"data": []}';

		  	return;
  		}

		
  		$datosJson = '{
		  "data": [';
		foreach ($productos as $key => $value) {

			$descripcionESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $value["descripcion"]);
			$descripcion2ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $value["descripcion2"]);
			$descripcion2 = $descripcion2ESCAPE == '' ? '+ Nombre Alternativo ' : $descripcion2ESCAPE;
			$descSII_ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $value["desc_sii"]);

		  	$imagen = "<img id='imagenZoom' src='".$value["imagen"]."' alt='".$descripcionESCAPE."' class='imagenZoom' width='40px' idProducto='".$value["id"]."' data-toggle='modal' data-target='#modalZoomProducto'>";

			$idCodigos = 'codigos'.$value["id"];
  			if($value["cod_proveedor"]!=''){
  				$codProveedor = "<i>PROV (<b>".$value["cod_proveedor"]."</b>)</i><br><b class='listaProvs' idProd='".$value['id']."'>".strtoupper($value['nom_prov'])."</b>";
  			}else{  				
  				$codProveedor = "<b class='listaProvs' idProd='".$value['id']."'>".strtoupper($value['nom_prov'])."</b>";
  			}

			// EMBALAJE
			$embalajeCompra = "<br><br><div class='embalajeCompra' idProd='".$value['id']."' embalajeCompra='".$value['embalaje_compra']."'><font>Embalaje: <b>".number_format($value['embalaje_compra'],0,',','.')."</b>u</font></div>";

  			$sku = $value["categoria"] <= 9 ? '0'.$value["sku"] : $value["sku"];
  			$ubicacion = $value['maneja_stock'] == 'NO' ? '' : strtoupper($value["zona_".$sucursal])."-";
			$btnEditUbic = $value['maneja_stock'] == 'NO' ? '' : " <i style='color:rgb(224,142,11)' class='fa fa-pen btnEditUbic' idProducto='".$value["id"]."' codInt='".$value["sku"]."' prov='".$value["cod_proveedor"]."' ubic='".$value["zona_".$sucursal]."' codBar='".$value["codigo"]."'></i>";
  			$codigos = "<div id=".$idCodigos."><b>".$ubicacion.$sku."</b>".$btnEditUbic."<br>".$value["codigo"]."<br>".$codProveedor.$embalajeCompra."</div>";

		  	// STOCK CON COLORES DINAMICO 
  			$stock = $value["stock_".$sucursal];
  			$stockIdeal = $value['stock_ideal_'.$sucursal];
  			if($stock <= $stockIdeal/3){
				$estado_stock = 1;
  			}else if($stock > $stockIdeal/3 && $stock <= $stockIdeal*2/3){
				$estado_stock = 2;
  			}else{
				$estado_stock = 3;
  			}



 			$descuento = "<b>".$value["descuento"]." %</b>";

		 	$agotado = ($stock == 0 && $value["maneja_stock"] == 'SI') ? "<span style='z-index:1; height:40px' class='float-right-container'><small class='label bg-red'>AGOTADO</small></span><br>" : "";
		 	$oferta = ($value['mayor_sobre'] == 1 && $value["maneja_stock"] == 'SI') ? "<span style='z-index:1; height:40px' class='float-right-container'><small class='label bg-success'>EN OFERTA</small></span><br>" : "";

			$descripcion = "<font size='+1'><b class='editNameProd' idProd='".$value['id']."'>".$descripcionESCAPE."</b></font><br><font size='-1' class='editNameAltProd' idProd='".$value['id']."'>".$descripcion2."</font>";			
			$descripcionSII = strlen($descSII_ESCAPE) <= 25 ? "<b>SII:</b><br><font color='blue' class='editDescSII' idProd='".$value['id']."'>".$descSII_ESCAPE."</font>" : "<b>SII:</b><br><font color='white' class='editDescSII' idProd='".$value['id']."'>".$descSII_ESCAPE."</font>"; // filtro de color si supera los 25 caracteres
			$bg_desc_sii = strlen($descSII_ESCAPE) <= 25 ? "" : "bg-danger";



			$descripcionCompleta = 	"<div class='d-none d-lg-block' id='descripcionProd".$value['id']."'>".$descripcion."</div><hr>".
									"<div id='descripcionSII".$value['id']."'>".
										"<div class='".$bg_desc_sii."'>".
											"<div class='d-none d-lg-block'>".$descripcionSII."</div>".
										"</div>".
									"</div>";
			
 	 		// PRECIO VENTA
 	 		$idPVenta = 'pVenta'.$value["id"];

  			if($value["maneja_stock"]=="SI" && $value['mayor_sobre'] != 1){	// MANEJA STOCK Y SIN OFERTA
	  			$precioVenta = 
	  			"<div id=".$idPVenta.">".
	  				"<div class='btnEditPVenta' idProd='".$value['id']."'><b>VENTA</b><br>".
	  					"$ ".number_format($value["precio_venta"], 0, ',', '.')."<br>".
	  					"<font style='color:blue'><b>&uarr;".$value["mayor_sobre"]."u $ ".number_format($value["precio_mayor"],0,',','.')."</b><br></font>".
	  					"<font size='-1'>MAX DCTO: ".$value["descuento"]."%</font></font><br>".	
	  				"</div>".
  					"<div class='btn-group float-right'>".
  						"<button class='btn btn-default btn-xs btnMayDesdMenos info' data-original-title='Bajar Mayoreo' idProd='".$value["id"]."'>&darr;</button>".
  						"<button class='btn btn-default btn-xs btnMayDesdMas info' data-original-title='Subir Mayoreo' idProd='".$value["id"]."'>&uarr;</button>".
  					"</div>".
	  			"</div>";
	  		}else if($value["maneja_stock"]=="SI" && $value['mayor_sobre'] == 1){ // OFERTA
  				$precioVenta = 
	  			"<div id=".$idPVenta.">".
  					"<div class='btnEditPVenta' idProd='".$value['id']."'><b>VENTA</b><br>".
						"<strike>Antes: $ ".number_format($value["precio_venta"], 0, ',', '.')."</strike><br>".
						"<b class='text-danger'>Ahora: $ ".number_format($value["precio_mayor"],0,',','.')."</b>".
					"</div>".
  					"<div class='btn-group float-right'>".
  						"<button class='btn btn-info btn-xs finalizarOferta info' data-original-title='Finalizar Oferta' idProd='".$value["id"]."'>Finalizar Oferta</button>".
  					"</div>".
	  			"</div>";


  			}else{ // PROD VIRTUAL
  				$precioVenta = "Precio Estimado <b>$ ".number_format($value["precio_venta"], 0, ',', '.')."</b>";
  			}

			// PRECIO COMPRA
 	 		$idPCompra = 'pCompra'.$value["id"];
  			if($value["maneja_stock"]=="SI"){	// MANEJA STOCK Y SIN OFERTA
				$decimalesNeto = strpos(strval($value['pc_neto']), '.') !== false ? 2 : 0;
				$precioCompra = 
				"<div  id=".$idPCompra.">".
					"<div class='editPCompraProd' idProd='".$value['id']."'>".
						"<font size='-1'>".
							"<p style='color:rgb(128,139,150)'>COMPRA<br>".
							"<b>$".number_format($value["pc_neto"],$decimalesNeto,',','.')." / $".number_format($value["precio_compra"],0,',','.')."</b></p>".
						"</font>".
					"</div>".
				"</div>".
				"<hr>";
			}else{
				$precioCompra = "";
			}

			$preciosVista = $precioCompra.$precioVenta;


			//GENERA LEYENDA QUE APARECE EN TOOLTIP CUANDO HAY STOCK >0 EN OTRAS SUCURSALES
			$stockOtrosLocales = '';
			for ($i_1=0; $i_1 < count($locales); $i_1++){
				if($value['stock_'.$locales[$i_1][0]] > 0){
					$stockOtrosLocales .= strtoupper($locales[$i_1][0])." (".$value['zona_'.$locales[$i_1][0]].") &rarr; ".number_format($value['stock_'.$locales[$i_1][0]],0,',','.')."u&#10;"; // EJ. BODEGA1 (C17N5) -> 1000u
				} 
			}

			if($stockOtrosLocales == ''){
				$stockOtrasSucursales = '';
			}else{
				$stockOtrasSucursales = "<button style='color:white; background-color:purple' class='btn btn-xs stockBodega info mb-1' data-original-title='".$stockOtrosLocales."'>OTROS LOCALES</button>";
			}

			// STOCK
			$idStock = 'stkVis'.$value["id"];
			$btnBajaStock = 'btnRestStock'.$value["id"];
			$btnSubeStock = 'btnSumStock'.$value["id"];
			$btnBajaIdeal = 'btnBajarStkIdeal'.$value["id"];
			$btnSubeIdeal = 'btnSubirStkIdeal'.$value["id"];

            if($stock < $stockIdeal/3){
            	$color = 'danger';
            }else if($stock >= $stockIdeal/3 && ($stock < (2*$stockIdeal/3))){
            	$color = 'warning';
            }else{
            	$color = 'success';
            }

            // CONTROL INVENTARIO
            $mostrarControl = ['A Pedido','Primera Prioridad','Controlar Inventario'];
            $colorControl = ['','bg-success','bg-primary'];
            $claveArray = $value['control_inventario'];
            $opciones = "<option value='".$claveArray."'>".$mostrarControl[$claveArray]."</option>";
			for($ia=0;$ia<count($mostrarControl);$ia++){
            	if($ia != $claveArray){ // CARGA TODOS LOS DEMAS ELEMENTOS
            		$opciones .= "<option value='".$ia."'>".$mostrarControl[$ia]."</option>";
            	}
            }
			$selectControlInventario = "<select style='font-size:13px' class='form-control info controlInvetario ".$colorControl[$claveArray]."' id='controlInvetario".$value["id"]."' idProd='".$value["id"]."' data-original-title='CONTROL INVENTARIO?' data-placement='bottom'>".$opciones."</select>";
            $controlInventario = $value["transformable"] == 2 ? "" : $selectControlInventario;

            // ZONA ENTREGA PRODUCTO
            $zonaEntregaProd = ['patio','local'];
            $claveEntregaProd = $value['zona_prod'];
            $opcionesEntregaProd = "<option value='".$claveEntregaProd."'>".strtoupper($zonaEntregaProd[array_search($claveEntregaProd, $zonaEntregaProd)])."</option>";
			for($ib=0;$ib<count($zonaEntregaProd);$ib++){
            	if($zonaEntregaProd[$ib] != $claveEntregaProd){ // CARGA TODOS LOS DEMAS ELEMENTOS
            		$opcionesEntregaProd .= "<option value='".$zonaEntregaProd[$ib]."'>".strtoupper($zonaEntregaProd[$ib])."</option>";
            	}
            }
			$selectEntregaProd = "<br><label for='entregaProd'>Entrega:</label><select style='font-size:13px' class='form-control info entregaProd' id='entregaProd".$value["id"]."' idProd='".$value["id"]."' data-original-title='CONTROL INVENTARIO?' data-placement='bottom'>".$opcionesEntregaProd."</select>";

			$btnCheckStock = 'btnCheckStock'.$value["id"];
			if($value['check_stock_'.$sucursal] == 0 && $value['maneja_stock'] == 'SI'){
				$historial_check = "<div><button class='btn btn-info historialProducto info' data-original-title='Ver Historial' idProd='".$value['id']."'><i class='fa fa-history'></i></button></div><div style='height:3px'></div><div id=".$btnCheckStock."><button class='btn btn-warning info' data-original-title='Checkear Stock' onclick='checkeoStock(".$value['id'].")' idProd='".$value['id']."'><i class='fa fa-check-square'></i></button></div>";
			}else{
				$historial_check = "<div><button class='btn btn-info historialProducto info' data-original-title='Ver Historial' idProd='".$value['id']."'><i class='fa fa-history'></i></button></div>";				
			}

            $botonesVariarIdeal = $sucursal == 'bodega1' ? "" : "<font style='font-size:10px'>STOCK IDEAL</font><div class='btn-group float-right botonesStkIdeal'><button class='btn btn-default btn-xs btnBajarStkIdeal info' data-original-title='Bajar Ideal' id=".$btnBajaIdeal." stockActual='".$value['stock_'.$sucursal]."' stkIdeal='".$value['stock_ideal_'.$sucursal]."' idProd='".$value["id"]."'>&darr;</button><button class='btn btn-default btn-xs btnSubirStkIdeal info' data-original-title='Subir Ideal' id=".$btnSubeIdeal." stockActual='".$value['stock_'.$sucursal]."' stkIdeal='".$value['stock_ideal_'.$sucursal]."' idProd='".$value["id"]."'>&uarr;</button></div>";

			if($value["maneja_stock"]=="SI"){
				$stock_vista = "<div id=".$idStock." class='btn-group'><button class='btn btn-default btnRestStock info' data-original-title='-1' id=".$btnBajaStock." ideal='".$value["stock_ideal_".$sucursal]."' idProd='".$value["id"]."'>&darr;</button><button style='text-align:right' class='btn btn-".$color." stockVista' stk='".$stock."' ideal='".$value["stock_ideal_".$sucursal]."' idProd='".$value["id"]."' style='width:50px'>".$stock."/".$stockIdeal."</button><button class='btn btn-default btnSumStock info' data-original-title='+1' id=".$btnSubeStock." ideal='".$value["stock_ideal_".$sucursal]."' idProd='".$value["id"]."'>&uarr;</button></div><div style='height:3px'></div>".$botonesVariarIdeal."<div style='height:3px'></div>".$stockOtrasSucursales.$controlInventario.$selectEntregaProd;
			}else{
				$stock_vista = "<div class='btn-group'><button class='btn btn-info'><font size='+1'>&infin;</font></button></button></div>";		
			}


			// BOTONES
            if($value["estado_".$sucursal] != 0){
				$btnActProd = "<button class='btn btn-success btn-xs btnActProd info' data-original-title='Desactivar' idProd='".$value['id']."' estadoProd='0'>Activado</button>";
			}else{
				$btnActProd = "<button class='btn btn-warning btn-xs btnActProd info' data-original-title='Activar' idProd='".$value['id']."' estadoProd='1'>Desactivado</button>";
			}
  			$botones =  "<div class='btn-group'><button class='btn btn-warning btnEditarProducto info' data-original-title='Editar' idProducto='".$value["id"]."' data-toggle='modal' data-target='#modalEditarProducto'><i class='fa fa-pen'></i></button><button class='btn btn-danger btnEliminarProducto info' data-original-title='Eliminar' idProducto='".$value["id"]."' codigo='".$value["codigo"]."' imagen='".$value["imagen"]."'><i class='fa fa-times'></i></button></div>"; 
  			$cats = $agotado.$oferta.'<b>'.$value["cat_nom"].'</b><br>'.$value["subcat_nom"];

			$idFecha = 'fecha'.$value["id"];
  			$fechaModificacion = "<div id=".$idFecha." class='btn-group'>".$value["fecha_modif_".$sucursal]."</div>";
			

			$columna1 = "<div>".
							"<div class='d-none d-lg-block'>".($key+1)."</div>".
						"</div>";
			$columna2 = "<div>".
							"<div class='d-none d-lg-block'>".$imagen."</div>".
						"</div><br>[ID: ".$value["id"]."]";
			$columna3 = "<div>".
							"<div class='d-none d-lg-block'>".$cats."</div>".
						"</div>";



			$idRelacion = 'relacion'.$value['id'];
			if($value['prods_relacionados'] == ''){
				$columna5 = "<div id='".$idRelacion."'><button type='button' class='btn btn-primary btn-circle btn-sm relacionarProd info' data-original-title='Relacionar' idProd='".$value['id']."'><i class='fas fa-plus'></i></button></div>";
			}else{
				$arrayRelacionados = explode(',',$value['prods_relacionados']);
				$listaProdsRelacionados = '';
				for ($i=0; $i < count($arrayRelacionados); $i++){
					$infoProd = ModeloProductos::mdlMostrarProducto('productos', 'id', $arrayRelacionados[$i]);
					$listaProdsRelacionados .= $infoProd['desc_sii']."<button type='button' class='btn btn-danger btn-circle btn-sm quitarRelacion info float-right' data-original-title='Quitar Relación' idProdRelacionado='".$arrayRelacionados[$i]."' idProd='".$value['id']."'><i class='fas fa-minus'></i></button><br>";
				}

				$columna5 = "<div id='".$idRelacion."'>".$listaProdsRelacionados.
								"<button type='button' class='btn btn-primary btn-circle btn-sm relacionarProd info' data-original-title='Relacionar' idProd='".$value['id']."'><i class='fas fa-plus'></i></button>".
							"</div>";
			}
			$columna6 = "<div>".
							"<div class='d-none d-lg-block'>".$codigos."</div>".
						"</div>";
			$columna7 = "<div>".
							"<div class='d-none d-lg-block'>".$stock_vista."</div>".
						"</div>";
			$columna8 = "<div>".
							"<div class='d-none d-lg-block'>".$historial_check."</div>".
						"</div>";
			$columna9 = "<div>".
							"<div class='d-none d-lg-block'>".$preciosVista."</div>".
						"</div>";

			// MARGEN
  			if($value["maneja_stock"]=="SI"){// MANEJA STOCK Y SIN OFERTA
				
  				$margenPesosPNormal = "$ ".number_format($value["precio_venta"]-$value['precio_compra'],0,',','.');
  				$margenPesosPMayor = "$ ".number_format($value["precio_mayor"]-$value['precio_compra'],0,',','.');
  				$margenPorcentajePNormal = round((($value["precio_venta"]/$value['precio_compra'])-1)*100,2)."%";
  				$margenPorcentajePMayor = round((($value["precio_mayor"]/$value['precio_compra'])-1)*100,2)."%";

				$margen = 
				"<div>".
					"<font size='-1'>".
						"<p style='color:rgb(128,139,150)'>Dinero<br>".
						"<b>".$margenPesosPNormal."  /  ".$margenPesosPMayor."</b></p><hr>".
						"<p style='color:rgb(128,139,150)'>Porcentual<br>".
						"<b>".$margenPorcentajePNormal."  /  ".$margenPorcentajePMayor."</b>".
					"</font>".
				"</div>";
			}else{
				$margen = "";
			}

			$columna10 = "<div>".
							"<div class='d-none d-lg-block'>".$margen."</div>".
						"</div>";
			$columna11 = "<div>".
							"<div class='d-none d-lg-block'>".$fechaModificacion."</div>".
						"</div>";
			$columna12 = "<div>".
							"<div class='d-none d-lg-block'>".$btnActProd."</div>".
						"</div>";
			$columna13 = "<div>".
							"<div class='d-none d-lg-block'>".$botones."</div>".
						"</div>";


		  	$datosJson .='[
			      "'.$value['id'].'",
			      "'.$columna1.'",
			      "'.$columna2.'",
			      "'.$columna3.'",
			      "'.$descripcionCompleta.'",
			      "'.$columna5.'",
			      "'.$columna6.'",
			      "'.$columna7.'",
			      "'.$columna8.'",
			      "'.$columna9.'",
			      "'.$columna10.'",
			      "'.$columna11.'",
			      "'.$columna12.'",
			      "'.$columna13.'"
			    ],';

		  }
		  // elimina el último caracter que es la coma de la fila 96, para evitar el error de sistaxis que no debe terminar con coma
		  $datosJson = substr($datosJson, 0, -1);
		 // concateno el corchete cerrado y la llave cerrada 
		 $datosJson .=   ']

		 }';
		
		echo $datosJson;


	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$activarProductos = new TablaProductos();
$activarProductos -> mostrarTablaProductos();
