<?php
session_start();
require_once "../controladores/movimientos.controlador.php";
require_once "../modelos/movimientos.modelo.php";

class TablaMovimientos{
 	/*=============================================
 	 MOSTRAR LA TABLA DE MOVIMIENTOS
  	=============================================*/ 
	public function mostrarTablaMovimientos(){
		$ventana = $_GET['ventana'];
        $orden = 'id';
		date_default_timezone_set("America/Asuncion");
		
		if($ventana == 'movimientos-movil'){
			$tabla = 'movimientos';
			$item = 'fecha_cont';
			$fechaInicial = date('Y-m-d', strtotime('-1 month'));
			$hoy = date('Y-m-d', strtotime('+1 day'));
			$mov = ModeloMovimientos::mdlMostrarMovimientos30($tabla, $item, $fechaInicial, $hoy);
		}else if($ventana == 'movimientos-all-movil'){
	        $item = 'fecha_cont';
	        $valor = date('Y-m-d');
	        $mov = ControladorMovimientos::ctrMostrarMovimientos($item, $valor, $orden, $ventana);  
		}else if($ventana == 'movimientos-dia-movil'){
			$tabla = 'movimientos';
			$item = 'fecha_cont';
			$fechaInicial = date('Y-m-d');
			$hoy = date('Y-m-d', strtotime('+1 day'));
			$mov = ModeloMovimientos::mdlMostrarMovimientos30($tabla, $item, $fechaInicial, $hoy);
		}

        $item1 = 'tipo_mov';
        $valor1 = 'saldo';
        $saldo = ControladorMovimientos::ctrUltimoItem($item1, $valor1, $orden);  



		$columna1 = $saldo['fecha_cont'].'<br>'.
					'Apertura Caja'."<br>".
					"[Efectivo] <b>$".number_format($saldo['saldo'],0,',','.')."</b>";
		$columna2 = $saldo["fecha"];
		$columna3 = $saldo["nom_user"];
		$columna4 = '';

  		if(count($mov) == 1){

  			echo'{"data": [[
		      "'.$columna1.'",
		      "'.$columna2.'",
		      "'.$columna3.'",
		      "'.$columna4.'"]]}';

		  	return;
  		}		
		
  		$datosJson = '{
		  "data": [';

		// SALDO DIA ANTERIOR (APERTURA CAJA)

		$datosJson .='[
			      "'.$columna1.'",
			      "'.$columna2.'",
			      "'.$columna3.'",
			      "'.$columna4.'"],';

	    // MOVIMIENTOS DEL DIA
		foreach ($mov as $i => $value) {
			$traducir = ControladorMovimientos::ctrTraducirMovimiento($value['id'],$value['cargo'],$value['abono'],$value['tipo_mov'],$value['moneda'],$value['detalle'],$value['nom_client'],$value['saldo'],$value['saldo_ant'],$value['nom_prov'],$value['nro_fact'],$value['nom_empleado'],$value['nom_socio'],$value['nom_distrib']);
			$movTraducido = explode(',', $traducir);
			$descripcion = $movTraducido[0];
			$monto = $value['cargo'] != 0 ? "<font style='color:red'>".str_replace(' ', ' ',$movTraducido[2])."</font>" : "<font style='color:blue'>".str_replace(' ', ' ',$movTraducido[3])."</font>";
			$saldoDispMovil = $value['saldo'] == 0 ? "" : "Saldo: "."<b>".str_replace(' ', ' ',$movTraducido[4])."</b>";

			if($value['moneda']=='ef'){
				$moneda = 'Efectivo';
			}else if($value['moneda']=='rc'){
				$moneda = 'Registro Contable';
			}else if($value['moneda']=='transf'){
				$moneda = 'Transferencia';
			}else if($value['moneda']=='td'){
				$moneda = 'T. Debito';
			}else if($value['moneda']=='tc'){
				$moneda = 'T. Credito';
			}else if($value['moneda']=='dcto'){
				$moneda = 'Descuento';
			}

			$columna1 = 	$value['fecha_cont'].' <b><i>(ID:'.$value["id"].')</i></b><br>'.
							$descripcion."<br>".
							"[".$moneda."] ".$monto."<br>".
							$saldoDispMovil;

			$columna2 = $value["fecha"];
			$columna3 = $value["nom_user"];


			if($value['tipo_mov'] == 'abClient' || $value['tipo_mov'] == 'anticipoClient' || $value['tipo_mov'] == 'otroAbono' || $value['tipo_mov'] == 'montoOtroEgreso' || $value['tipo_mov'] == 'prestamo' || $value['tipo_mov'] == 'montoDcto' || $value['tipo_mov'] == 'montoDev'){
				$botonEditar = "<button class='btn btn-sm btn-warning btnEditarMovimiento float-right' data-toggle='modal' data-target='#editarMovimiento' idMov='".$value['id']."'><i class='fa fa-pen'></i></button>";
			}else{
				$botonEditar = "";
			}

	        $columna4 = "<button class='btn btn-sm btn-danger btnEliminarMovimiento float-right' idMov='".$value['id']."'><i class='fa fa-times'></i></button>".$botonEditar;

		  	$datosJson .='[
			      "'.$columna1.'",
			      "'.$columna2.'",
			      "'.$columna3.'",
			      "'.$columna4.'"],';
		}
		// elimina el último caracter que es la coma de la fila 96, para evitar el error de sistaxis que no debe terminar con coma
		$datosJson = substr($datosJson, 0, -1);
		// concateno el corchete cerrado y la llave cerrada 
		$datosJson .= ']}';
		echo $datosJson;
	}
}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$movimientos = new TablaMovimientos();
$movimientos -> mostrarTablaMovimientos();