<?php
session_start();
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";
require_once "../modelos/sucursales.modelo.php";
require_once "../modelos/productos.modelo.php";


class TablaProductosVentas{

	public function mostrarTablaProductosVentas(){

		$sucursal = $_SESSION['sucursal'];
		$perfil = $_GET['perfil'];
		$skuInteres = $_GET['skuInteres'];
		$utilidadMinima = $_GET['utMin'];
		$item = "estado_".$sucursal;
    	$valor = 1;
    	$orden = "fecha";
  		$productos = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);

   		$sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
	    $nombre_y_alias = array();
	    $locales = array();
            
        foreach ($sucursales as $key => $value){
        	if($value['nombre_sucursal'] != $sucursal){
	        	array_push($nombre_y_alias, $value["nombre_sucursal"]); 
	        	array_push($nombre_y_alias, $value["alias_sucursal"]);
	        	array_push($locales, $nombre_y_alias);
		    	$nombre_y_alias = array(); // vaciamos array
        	}
        }

 		
  		if(count($productos) == 0){

  			echo '{"data": []}';

		  	return;
  		}	
		
  		$datosJson = '{
		  "data": [';


		for($i = 0; $i < count($productos); $i++){

			$descripcionESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productos[$i]["descripcion"]);
			$descripcion2ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productos[$i]["descripcion2"]);

			$idProd = $productos[$i]["id"];
			$stockActual = $productos[$i]["stock_".$sucursal];

			$ubicacion = $productos[$i]["zona_".$sucursal];
			$oferta = $productos[$i]["mayor_sobre"]; // oferta== 1 -> EN OFERTA - oferta>1 -> SIN OFERTA 
			$descripcion = "<b>".$descripcionESCAPE."</b><br><font size=-2'>".$descripcion2ESCAPE."</font>";

			$precioCompra = $productos[$i]["precio_compra"];
			$manejaStock = $productos[$i]["maneja_stock"];

			$agotado = "<img style='position:absolute; right:0%; z-index:1; height:50px' src='componentes/img/sama/agotado-r.png'>";
			$enOfertaDesfasado = "<img style='position:absolute; right:3%; z-index:1; height:50px' src='componentes/img/sama/oferta-r.png'>";
			$enOferta = "<img style='position:absolute; right:0%; z-index:1; height:50px' src='componentes/img/sama/oferta-r.png'>";

			if($stockActual == 0 && $oferta == 1){ // SIN STOCK Y EN OFERTA
				$ribbon = $enOfertaDesfasado.$agotado;
				$textoOferta = "<font size='-2' style='visibility:hidden'>OFERTA</font>";
			}else if($stockActual == 0 && $oferta != 1){ // agotado
				$ribbon = $agotado;
				$textoOferta = "";
			}else if($oferta == 1){
				$ribbon = $enOferta;
				$textoOferta = "<font size='-2' style='visibility:hidden'>OFERTA</font>";
			}else{
				$ribbon = '';
				$textoOferta = "";
			}

  			$idStock = 'stock'.$productos[$i]['id'];
  			$stockIdeal = $productos[$i]['stock_ideal_'.$sucursal];
			if($stockActual == 0){
  				$color = 'bg-black'; // agotado
  				$disabledInputPV = ' disabled';
  			}else if($stockActual <= $stockIdeal/3 && $stockActual > 0){
				$color = 'btn-danger'; // stock bajo 
  				$disabledInputPV = '';
  			}else if($stockActual > $stockIdeal/3 && $stockActual <= $stockIdeal*2/3){
				$color = 'btn-warning'; // stock medio
  				$disabledInputPV = '';
  			}else if($stockActual > $stockIdeal*2/3){
				$color = 'btn-success'; // stock alto
  				$disabledInputPV = '';
  			}else{
  				$disabledInputPV = 'disabled';
  			}
  			
			$skuProductoComun = $_GET['skuProdComun']; // DIAS DE VIGENCIA COT DESDE AJUSTE BASE DE DATOS

			$disabledOferta = $oferta == 1 ? 'disabled' : '';
			$colorInputOferta = $oferta == 1 ? 'btn-success' : '';
			$pMay =  $oferta == 1 ? $productos[$i]['precio_mayor'] : $productos[$i]['precio_venta'];

			// TIPO BOTON
			if($manejaStock == "SI" && $stockActual > 0){ // MANEJA STOCK y CON STOCK
				$colorStk = "<button class='btn btn-sm ".$color."' id='".$idStock."'>";
			  	$btnAgregar =  "<div class='btn-group'><button class='btn btn-primary btn-xs ".$colorInputOferta." agregarUnico recuperarBoton' sucursal='".$sucursal."' mayDesde='0' pMay='".$pMay."' id='agregarProducto0' idProducto='".$idProd."' mayAnt='".$productos[$i]["mayor_sobre"]."' pVentMayAnt='".$productos[$i]["precio_mayor"]."'>Agregar</button></div>"; 
			}else if($manejaStock == "SI" && $stockActual == 0){ // MANEJA STOCK Y SIN STOCK
				$colorStk = "<button class='btn btn-sm ".$color."' id='".$idStock."'>";
			  	$btnAgregar =  "<div class='btn-group'><button class='btn ".$color." btn-xs ".$colorInputOferta." recuperarBoton' sucursal='".$sucursal."' id='agregarProducto0' idProducto='".$idProd."' pMay='0' mayDesde='0' mayAnt='".$productos[$i]["mayor_sobre"]."' pVentMayAnt='".$productos[$i]["precio_mayor"]."' disabled>Agotado</button></div>"; 
			}else if($manejaStock == "NO" && $productos[$i]['sku'] == $skuProductoComun){ // DETECTA PROD COMUN
			  	$btnAgregar =  "<div class='btn-group'><button class='btn btn-primary btn-xs ".$colorInputOferta." agregarUnico recuperarBoton prodComun' sucursal='".$sucursal."' id='agregarProducto0' idProducto='".$idProd."' pMay='0' mayDesde='0' mayAnt='".$productos[$i]["mayor_sobre"]."' pVentMayAnt='".$productos[$i]["precio_mayor"]."'>Agregar</button></div>"; 				
			}else{ // DETECTA PROD SIN MANEJO DE STOCK
			  	$btnAgregar =  "<div class='btn-group'><button class='btn btn-primary btn-xs ".$colorInputOferta." agregarUnico recuperarBoton noManejaStock dtMovil' sucursal='".$sucursal."' id='agregarProducto0' idProducto='".$idProd."' pMay='0' mayDesde='0' mayAnt='".$productos[$i]["mayor_sobre"]."' pVentMayAnt='".$productos[$i]["precio_mayor"]."'>Agregar</button></div>";
			}
			
			// PERMITE QUE EL BOTON SURTIR APAREZCA SI CUMPLE CON: QUE SEA EL PRODUCTO A SURTIR(TRANSFORMABLE=2), QUE EL STOCK DEL PRODUCTO BASE SEA MAYOR QUE CERO Y QUE LAS UNIDADES QUE TIENE EL PRODUCTO SEAN MENORES AL INTERCAMBIO 
			if($productos[$i]['transformable']==2){
				$prodBase = ModeloProductos::mdlMostrarProducto('productos', 'id', $productos[$i]['id_transf']);
				if($prodBase['stock_'.$sucursal]>0 && $productos[$i]['stock_'.$sucursal]<$productos[$i]['cant_transf']){
					$surtir = "<button style='color:white; background-color:lightseagreen' class='btn btn-xs mb-1 surtirAlChicoxD info' idProd='".$productos[$i]['id']."' id='surtirAlChicoxD' data-original-title='Sumar ".$productos[$i]['cant_transf']."u' ".$productos[$i]['cant_transf']."u'>SURTIR</button>";
				}else{
					$surtir = '';
				}
			}else{
				$surtir = '';
			}

			//GENERA LEYENDA QUE APARECE EN TOOLTIP CUANDO HAY STOCK >0 EN OTRAS SUCURSALES
			$stockOtrosLocales = '';
			for ($i_1=0; $i_1 < count($locales); $i_1++){
				if($productos[$i]['stock_'.$locales[$i_1][0]] > 0){
					$stockOtrosLocales .= strtoupper($locales[$i_1][0])." (".$productos[$i]['zona_'.$locales[$i_1][0]].") &rarr; ".number_format($productos[$i]['stock_'.$locales[$i_1][0]],0,',','.')."u&#10;"; // EJ. BODEGA1 (C17N5) -> 1000u
				} 
			}

			// FALTA STOCK EN OTRAS SUCURSALES Y BODEGAS
			if($manejaStock =="SI" && $stockOtrosLocales != ''){
				$stock = "<br>".$colorStk.$stockActual."</button>".$surtir."  <button style='color:white; background-color:purple' class='btn btn-xs mb-1 stockBodega info' data-original-title='".$stockOtrosLocales."'>OTROS LOCALES</button> ".$textoOferta;
			}else if($manejaStock =="SI" && $stockOtrosLocales == ''){
				$stock = "<br>".$colorStk.$stockActual."</button>  ".$surtir." ".$textoOferta;
			}else{
				$stock = "<br><div class='btn-group mb-1'><button class='btn btn-info'><font size='+1'>&infin;</font></button></div> ".$textoOferta;
			}




  			$descripcion2Movil = $descripcion2ESCAPE == '' ? '' : "<br><font size=-2'>".$descripcion2ESCAPE."</font>";
  			$descripcionDispMovil = "<font size='-2'><b>".str_replace(' ',' ', $descripcionESCAPE)."</b></font>".$descripcion2Movil;
  			$sku = $productos[$i]["sku"] <= 99999 ? '0'.$productos[$i]["sku"] : $productos[$i]["sku"];
  			$codigosDispMovil = "<br><font size='-1' id='zonaMovil".$idProd."'>".$productos[$i]["zona_".$sucursal]."-".$sku."</font>";
		  	$imagenDispMovil = "<img style='float:right' id='imagenZoom' src='".$productos[$i]["imagen"]."' alt='".$descripcionESCAPE."' class='imagenZoom' width='40px' idProducto='".$productos[$i]['id']."'>";
		  	

			$pMinProd = $productos[$i]["precio_compra"]*(1+$utilidadMinima/100) > $productos[$i]["precio_venta"] ? $productos[$i]["precio_venta"] : round($productos[$i]["precio_compra"]*(1+$utilidadMinima/100)); 
			$idInput = '\"'.'precioVentaProdMovil'.'\"';

			$valorDefaultPVMostrar = $oferta == 1 ? number_format($productos[$i]["precio_mayor"],0,',','.') : number_format($productos[$i]["precio_venta"],0,',','.');
			$valorDefaultPV = $oferta == 1 ? $productos[$i]["precio_mayor"] : $productos[$i]["precio_venta"];

			if($productos[$i]['sku'] == $skuInteres){
				$inputsPrecioVenta = 	"<div class='div-interes btn-group'>".
				                		"<input type='text' idProducto='".$idProd."' class='form-control input-lg precioVentaProdMovilVista ".$colorInputOferta."' id='precioVentaProdMovilVista".$idProd."' min='".$pMinProd."' maxlength='9' required value='".$valorDefaultPVMostrar."'>";
			}else{
				$inputsPrecioVenta = 	"<div class='btn-group'>".
				                		"<input type='text' idProducto='".$idProd."' class='form-control input-lg precioVentaProdMovilVista ".$colorInputOferta."' id='precioVentaProdMovilVista".$idProd."' min='".$pMinProd."' maxlength='9' onkeypress='return soloNumeros(event)' onkeyup='formatoMiles($(this));' onchange='sinFormatoMiles(".$idInput.", $(this).val());mayor_que(".$pMinProd.", $(this).val(),".$idInput.")' required value='".$valorDefaultPVMostrar."'".$disabledInputPV." ".$disabledOferta.">".
										"<input type='hidden' id='precioVentaProdMovil".$idProd."' name='precioVentaProdMovil' value='".$valorDefaultPV."'>";
			}


		  	if($oferta == 1){ // en oferta
			  	$pVenta = "<font size='-1'>".
			  				"<br><font style='color:red'><strike>Antes: $ ".number_format($productos[$i]["precio_venta"],0,',','.')."</strike></font><b style='color:blue'> &rarr; AHORA: $".number_format($productos[$i]["precio_mayor"],0,',','.')."</b>".
						  "</font>";
		  	}else if($oferta != 1){ // sin oferta
			  	$pVenta = "<font size='-1'>".
			  				"<br><b>Precio Venta: </b>($ ".number_format($productos[$i]["precio_venta"],0,',','.')."c/u <b style='color:indigo'><i class='fa fa-arrow-up'></i> ".$productos[$i]["mayor_sobre"]."u $".number_format($productos[$i]["precio_mayor"],0,',','.')."c/u)</b><br>".
							"<b>Sugerencia: </b>[$".number_format($pMinProd,0,',','.')." - $".number_format($productos[$i]["precio_venta"],0,',','.')."]".
						  "</font>";
		  	}else if($manejaStock == 'NO'){ // fletes, arriendos, etc
			  	$pVenta = 	"<font size='-1'>".
			  					"<br><b>Precio Estimado: </b>$".number_format($productos[$i]["precio_venta"],0,',','.').
			  			    "</font>";
		  	}


			$inputPV = "<div style='height:3px'></div>".$inputsPrecioVenta.
							"    ".$btnAgregar.
						"</div>";


			$info = $ribbon.
					$descripcionDispMovil.$codigosDispMovil.
					$pVenta.$imagenDispMovil.
					$stock.
					$inputPV;

		  	$datosJson .='[
			      "'.$info.'"
			    ],';

		}

		$datosJson = substr($datosJson, 0, -1);

		$datosJson .=   '] 

		}';
		
		echo $datosJson;

	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$activarProductosVentas = new TablaProductosVentas();
$activarProductosVentas -> mostrarTablaProductosVentas();

