<?php
require_once "../controladores/movimientos.controlador.php";
require_once "../modelos/movimientos.modelo.php";
require_once "../controladores/usuarios.controlador.php";
require_once "../modelos/usuarios.modelo.php";



class TablaProductosFaltantes{

 	/*=============================================
 	 MOSTRAR LA TABLA DE PRODUCTOS FALTANTES
  	=============================================*/ 

	public function mostrarTablaProductosFaltantes(){

        $item = null;
        $valor = null;
        $orden = "id";
        $movimientos = ControladorMovimientos::ctrMostrarMovimientos($item, $valor, $orden);  

  		if(count($movimientos) == 0){

  			echo '{"data": []}';

		  	return;
  		}
		
  		$datosJson = '{
		  "data": [';
		  // count trae la cantidad de productos
		  for($i = 0; $i < count($movimientos); $i++){

          	$itemUsuario = "id";
          	$valorUsuario = $movimientos[$i]["vendedor"];
          	$respuestaUsuario = ControladorUsuarios::ctrMostrarUsuarios($itemUsuario, $valorUsuario);


		  	// $productoFaltante = mb_strtoupper($movimientos[$i]["producto_faltante"]);
		 	// llenado de la estructura
		  	$datosJson .='[
			      "'.$movimientos[$i]["fecha"].'",
			      "'.$respuestaUsuario["nombre"].'",
			      "'.$movimientos[$i]["movimiento"].'",
			      "'.'- '.$movimientos[$i]["cargos"].'",
			      "'.'+ '.$movimientos[$i]["abonos"].'"
			    ],';

		  }
		  // elimina el último caracter que es la coma de la fila 96, para evitar el error de sistaxis que no debe terminar con coma
		  $datosJson = substr($datosJson, 0, -1);
		 // concateno el corchete cerrado y la llave cerrada 
		 $datosJson .=   ']

		 }';
		
		echo $datosJson;


	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$productosFaltantes = new TablaProductosFaltantes();
$productosFaltantes -> mostrarTablaProductosFaltantes();

