<?php
session_start();
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";
require_once "../modelos/sucursales.modelo.php";
// require_once "../modelos/ajustes.modelo.php";

class TablaProductosCotizador{

 	/*=============================================
 	 MOSTRAR LA TABLA DE PRODUCTOS
  	=============================================*/ 

	public function mostrarTablaProductosCotizador(){

	    $sucursal = $_SESSION['sucursal'];
		$item = "estado_".$sucursal;
    	$valor = 1;
    	$orden = "fecha";
  		$productos = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);
 		
   		$sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
   		// $skuFlete = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'sku_flete')['ajuste'];

	    $nombre_y_alias = array();
	    $locales = array();
        foreach ($sucursales as $key => $value){
        	if($value['nombre_sucursal'] != $sucursal){
	        	array_push($nombre_y_alias, $value["nombre_sucursal"]); 
	        	array_push($nombre_y_alias, $value["alias_sucursal"]);
	        	array_push($locales, $nombre_y_alias);
		    	$nombre_y_alias = array(); // vaciamos array
        	}
        }

  		if(count($productos) == 0){

  			echo '{"data": []}';

		  	return;
  		}	
		
  		$datosJson = '{
		  "data": [';

		foreach ($productos as $key => $value) {


			$descripcionESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $value["descripcion"]);
			$descripcion2ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $value["descripcion2"]);

		  	$imagen = "<img id='imagenZoom' src='".$value["imagen"]."' alt='".$descripcionESCAPE."' class='imagenZoom' width='40px' idProducto='".$value["id"]."' data-toggle='modal' data-target='#modalZoomProducto'>";
			$ubicacion = $value['maneja_stock'] == 'NO' ? '' : $value["zona_".$sucursal]."-";
			$sku = $value["categoria"] <= 9 ? '0'.$value["sku"] : $value["sku"];
			$oferta = $value["mayor_sobre"]; // oferta== 1 -> EN OFERTA - oferta>1 -> SIN OFERTA 			
			$descripcionOferta = 	"<div class='position-relative p-3 bg-info'>".
              						"<div class='ribbon-wrapper'>".
                						"<div class='ribbon bg-lime text-md'>".
                  							"OFERTA".
                						"</div>".
              						"</div>".
              						"<b>".$ubicacion.$sku."</b> (".$value["codigo"].")<br>".$descripcionESCAPE."<br>".
              						"<small>".$descripcion2ESCAPE."</small>".
            					"</div>";

            if($oferta == 1){
            	$descripcion = $descripcionOferta;
  				$precioVenta = "<div><strike>Antes: $ ".number_format($value["precio_venta"], 0, ',', '.')." c/u</strike><br><b class='text-danger'>Ahora: $ ".number_format($value["precio_mayor"],0,',','.')." c/u</b></div>";
            }else{
  				$descripcion = "<b>".$ubicacion.$value["sku"]."</b> (".$value["codigo"].")<br><b>".$descripcionESCAPE."</b><br><font size=-2'>".$descripcion2ESCAPE."</font>";
  				$precioVenta = "<b>&darr; ".$value["mayor_sobre"]."u $ ".number_format($value["precio_venta"], 0, ',', '.')." c/u</b> (".$value["descuento"]."%)<br><b style='color:rgb(92,184,92)'>&uarr; ".$value["mayor_sobre"]."u $ ".number_format($value["precio_mayor"],0,',','.')." c/u</b>";
            }

  			$descuento = "<b>".$value["descuento"]." %</b>";

  			$idStock = 'stock'.$value['id'];
  			$stockActual = $value["stock_".$sucursal];
  			$stockIdeal = $value['stock_ideal_'.$sucursal];
			if($stockActual == 0){ 
  				$color = 'bg-black'; // agotado
  			}else if($stockActual <= $stockIdeal/3 && $stockActual > 0){
				$color = 'btn-danger'; // stock bajo 
  			}else if($stockActual > $stockIdeal/3 && $stockActual <= $stockIdeal*2/3){
				$color = 'btn-warning'; // stock medio
  			}else if($stockActual > $stockIdeal*2/3){
				$color = 'btn-success'; // stock alto
  			}  			

			//GENERA LEYENDA QUE APARECE EN TOOLTIP CUANDO HAY STOCK >0 EN OTRAS SUCURSALES
			$stockOtrosLocales = '';
			for ($i_1=0; $i_1 < count($locales); $i_1++){
				if($value['stock_'.$locales[$i_1][0]] > 0){
					$stockOtrosLocales .= strtoupper($locales[$i_1][0])." (".$value['zona_'.$locales[$i_1][0]].") &rarr; ".number_format($value['stock_'.$locales[$i_1][0]],0,',','.')."u&#10;"; // EJ. BODEGA1 (C17N5) -> 1000u
				} 
			}

			// TIPO BOTON
			if($value['maneja_stock'] == "SI" && $stockActual > 0){ // MANEJA STOCK y CON STOCK
				$colorStk = "<button class='btn btn-sm ".$color."' id='".$idStock."'>";
			}else if($value['maneja_stock'] == "SI" && $stockActual == 0){ // MANEJA STOCK Y SIN STOCK
				$colorStk = "<button class='btn btn-sm ".$color."' id='".$idStock."'>";
			}
			
			// $colorStk = 'blue';
			// FALTA STOCK EN OTRAS SUCURSALES Y BODEGAS
			if($value['maneja_stock'] =="SI" && $stockOtrosLocales != ''){
				$stock = "<div>".$colorStk.$stockActual."</button></div><button style='color:white; background-color:purple' class='btn btn-xs stockBodega info' data-original-title='".$stockOtrosLocales."'>OTROS LOCALES</button>";
			}else if($value['maneja_stock'] =="SI" && $stockOtrosLocales == ''){
				$stock = "<div>".$colorStk.$stockActual."</button><div class='mb-1'></div><div></div>";
			}else{
				$stock = "<div class='btn-group'><button class='btn btn-info'><font size='+1'>&infin;</font></button></div>";
			}


			$detectaServicio = $value['servicio'] == 1 ? 'servicio' : '';

		  	$botones =  "<div class='btn-group'><button class='btn btn-primary agregarProductoCot recuperarBoton ".$detectaServicio."' id='agregarProductoCot0' idProducto='".$value["id"]."'>Agregar</button></div>"; 

		  	$datosJson .='[
			      "'.($key+1).'",			      
			      "'.$imagen.'",
			      "'.$descripcion.'",
			      "'.$precioVenta.'",
			      "'.$stock.'",
			      "'.$botones.'"
			    ],';

		}

		$datosJson = substr($datosJson, 0, -1);

		$datosJson .=   ']}';
		
		echo $datosJson;


	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$cotizador = new TablaProductosCotizador();
$cotizador -> mostrarTablaProductosCotizador();


