<?php
session_start();
require_once "../controladores/cotizador.controlador.php";
require_once "../modelos/cotizador.modelo.php";

class TablaCotizaciones{

 	/*=============================================
 	 MOSTRAR LA TABLA DE VENTAS
  	=============================================*/ 

	public function mostrarTablaCotizaciones(){



		if(isset($_GET['fechaInicial']) && $_GET['fechaInicial'] != 'undefined'){
			$fechaInicial = $_GET['fechaInicial'];
			$fechaFinal = $_GET['fechaFinal'];
			$cotizaciones = ModeloCotizaciones::mdlMostrarCotizacionesIntervalo('cotizaciones', 'fecha_ingreso', $fechaInicial, $fechaFinal);
		}else{
	  		$cotizaciones = ControladorCotizaciones::ctrMostrarCotizaciones(null, null, 'id');
		}

 		
  		if(count($cotizaciones) == 0){

  			echo '{"data": []}';

		  	return;
  		}	
		
  		$datosJson = '{
		  "data": [';

		  	foreach ($cotizaciones as $i => $value) {
               	
				if(date('Y-m-d')>$cotizaciones[$i]["fecha_expiracion"] && $cotizaciones[$i]['venta']==''){ // COTIZACION EXPIRADA
					$estado = "<img id='expirado".$value['id']."' style='position:absolute; z-index:1; height:40px' src='componentes/img/extras/expirado2.png'>";
					$disab = 'disabled';
					$venta = '-';
					$actualizarExpiracion = "<button class='btn btnActualizarExpiracion btn-success info' data-original-title='Habilitar a Venta' codigoCotizacion='".$cotizaciones[$i]["id"]."'><i class='fa fa-redo'></i></button>";			
				}else if($cotizaciones[$i]["venta"]!=''){ // COTIZACION VENDIDA
					$estado = "<img style='position:absolute; z-index:1; height:40px' src='componentes/img/extras/vendido3.png'>";
					$disab = 'disabled';
					$venta = "<b><a href='extensiones/tcpdf/pdf/boleta-carta.php?cod_venta=".$cotizaciones[$i]["venta"]."&motivo=ver' target='_blank'>".$cotizaciones[$i]['venta'].'</a></b>';
					// $venta = $cotizaciones[$i]["venta"];
					$actualizarExpiracion = "";	
				}else{
					$estado = '';
					$disab = " data-original-title='Vender Cotización'";
					$venta = '';
					$actualizarExpiracion = "";
				}


              	$productos=json_decode($cotizaciones[$i]["productos"]);
				$listaProds = "";

				if($productos){
					$listaProds = $productos[0]->cant." ".$productos[0]->prod." →<i><b>$".$productos[0]->pV." c/u</b>";
	            	for($ia=1;$ia<count($productos);$ia++){ 
		                $productosComprados[$ia] = "<br>".$productos[$ia]->cant." ".$productos[$ia]->prod." →<i><b>$".$productos[$ia]->pV." c/u</b></i>";
						$listaProds .= $productosComprados[$ia];               	
	            	}
			    }else{
			    	$listaProds .= 'Producto eliminado (YA NO SE TRABAJA)';
			    }

				$precioCotizacion = "<b>$ ".number_format($cotizaciones[$i]["total"],0,',','.')."</b>";
				$utilidad_total = "<b><font color='green'>$ " .number_format($cotizaciones[$i]["utilidad"],0,',','.')."</font></b>";
          	

				$mostrarImprimirTicket = $_SESSION["conexionImpresoraLocal"] == 1 ? '' : 'd-none';
				$botonReimprimirTicketCot = "<button data-original-title='Reimprimir Ticket' data-placement='bottom' class='".$mostrarImprimirTicket." imprimirTicketCot btn btn-info float-right reimprimirTicketCot' idCot='".$cotizaciones[$i]['id']."'><i class='fas fa-print'></i></button>";

	          	// ACCIONES  btnDownloadCot
			  	if($_SESSION["perfil"] == "Administrador"){
			  		$botones =  "<div class='btn-group'><button class='btn btn-info btnImprimirCotizacion info' codigoCotizacion='".$cotizaciones[$i]["id"]."' data-original-title='PDF'><i class='fa fa-file'></i></button><button class='btn btnDownloadCot info' style='background-color:purple; color:white' codigoCotizacion='".$cotizaciones[$i]["id"]."' data-original-title='Descargar'><i class='fa fa-file-download'></i></button><button class='btn btn-warning btnCotEmpresa info' codigoCotizacion='".$cotizaciones[$i]["id"]."' data-original-title='Cotización Empresa'><i class='fa fa-file-invoice-dollar'></i></button><button class='btn btnVentaCot info' style='background-color:black; color:white' codigoCotizacion='".$cotizaciones[$i]["id"]."' ".$disab."><i class='fa fa-dollar-sign'></i></button>".$actualizarExpiracion."</div><div style='height:3px'></div><div><button class='btn btnActualizarCot info bg-olive' style='color:white' codigoCotizacion='".$cotizaciones[$i]["id"]."' data-original-title='Actualizar Cot'><i class='fa fa-pen'></i></button>".$botonReimprimirTicketCot."</div>";	
			  	}else{
			  		
			  		$fechaCorteActualizarCot = date('Y-m-d', strtotime('-1 week'));
					$botonActualizarCot = $cotizaciones[$i]['fecha_ingreso'] >= $fechaCorteActualizarCot ? "<button class='btn btnActualizarCot info bg-olive' style='color:white' codigoCotizacion='".$cotizaciones[$i]["id"]."' data-original-title='Actualizar Cot'><i class='fa fa-pen'></i></button>" : "";


					$botones =  "<div class='btn-group'><button class='btn btn-info btnImprimirCotizacion' codigoCotizacion='".$cotizaciones[$i]["id"]."' data-original-title='PDF'><i class='fa fa-file'></i></button><button class='btn btnDownloadCot' style='background-color:purple; color:white' codigoCotizacion='".$cotizaciones[$i]["id"]."' data-original-title='Descargar'><i class='fa fa-file-download'></i></button><button class='btn btnVentaCot' style='background-color:black; color:white' codigoCotizacion='".$cotizaciones[$i]["id"]."' ".$disab."><i class='fa fa-dollar-sign'></i></button>".$botonActualizarCot.$botonReimprimirTicketCot."</div>";
			  	}			

				$columna2 = $cotizaciones[$i]["nom_client"];
				$columna3 = $listaProds;
				$columna4 = $precioCotizacion;

				$col5 = $_SESSION['perfil'] == 'Administrador' ? $utilidad_total : $estado.$cotizaciones[$i]["nom_vend"];
				$columna5 = $col5;

				$col6 = $_SESSION['perfil'] == 'Administrador' ? $estado.$cotizaciones[$i]["nom_vend"] : $estado.$cotizaciones[$i]["id"];
				$columna6 = $col6;

				$col7 = $_SESSION['perfil'] == 'Administrador' ? $cotizaciones[$i]["id"] : $venta;
				$columna7 = $col7;
				
				$col8 = $_SESSION['perfil'] == 'Administrador' ? $venta : $cotizaciones[$i]["fecha_ingreso"];
				$columna8 = $col8;
				
				$col9 = $_SESSION['perfil'] == 'Administrador' ? $cotizaciones[$i]["fecha_ingreso"] : $cotizaciones[$i]["fecha_expiracion"];
				$columna9 = $col9;
				
				$col10 = $_SESSION['perfil'] == 'Administrador' ? $cotizaciones[$i]["fecha_expiracion"] : $cotizaciones[$i]["fecha"];
				$columna10 = $col10;
				
				$col11 = $_SESSION['perfil'] == 'Administrador' ? $cotizaciones[$i]["fecha"] : $botones;
				$columna11 = $col11;
				
				$columna12 = $botones;
			  	if($_SESSION['perfil']=='Administrador'){
				  	$datosJson .='[
					      "'.($i+1).'",
					      "'.$columna2.'",
					      "'.$columna3.'",
					      "'.$columna4.'",
					      "'.$columna5.'",
					      "'.$columna6.'",
					      "'.$columna7.'",
					      "'.$columna8.'",
					      "'.$columna9.'",
					      "'.$columna10.'",
					      "'.$columna11.'",
					      "'.$columna12.'"
					    ],';
			  	}else{
				  	$datosJson .='[
					      "'.($i+1).'",
					      "'.$columna2.'",
					      "'.$columna3.'",
					      "'.$columna4.'",
					      "'.$columna5.'",
					      "'.$columna6.'",
					      "'.$columna7.'",				      
					      "'.$columna8.'",
					      "'.$columna9.'",
					      "'.$columna10.'",
					      "'.$columna11.'"
					    ],';
			  	}

		  	}

		$datosJson = substr($datosJson, 0, -1);

		$datosJson .=   '] 

		}';
		
		echo $datosJson;

	}

}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$cotizaciones = new TablaCotizaciones();
$cotizaciones -> mostrarTablaCotizaciones();

