<?php
session_start();
require_once "../controladores/cotizador.controlador.php";
require_once "../modelos/cotizador.modelo.php";

class TablaCotizaciones{

 	/*=============================================
 	 MOSTRAR LA TABLA DE VENTAS
  	=============================================*/ 

	public function mostrarTablaCotizaciones(){

		$item = null;	
    	$valor = null;
    	$orden = "id";

  		$cotizaciones = ControladorCotizaciones::ctrMostrarCotizaciones($item, $valor, $orden);
 		
  		if(count($cotizaciones) == 0){

  			echo '{"data": []}';

		  	return;
  		}	
		
  		$datosJson = '{
		  "data": [';

		  	foreach ($cotizaciones as $i => $value) {
               	
				if(date('Y-m-d')>$cotizaciones[$i]["fecha_expiracion"] && $cotizaciones[$i]['venta']==''){ // COTIZACION EXPIRADA
					$estado = "<img id='expirado".$value['id']."' style='position:absolute; z-index:1; height:40px' src='componentes/img/extras/expirado2.png'>";
					$disab = 'disabled';
					$venta = '';
					$actualizarExpiracion = "<button class='btn btnActualizarExpiracion btn-success' codigoCotizacion='".$cotizaciones[$i]["id"]."'><i class='fa fa-redo'></i></button>";			
				}else if($cotizaciones[$i]["venta"]!=''){ // COTIZACION VENDIDA
					$estado = "<img style='position:absolute; z-index:1; height:40px' src='componentes/img/extras/vendido3.png'>";
					$disab = 'disabled';
					$venta = "Venta Nro. <b><a href='extensiones/tcpdf/pdf/boleta-carta.php?cod_venta=".$cotizaciones[$i]["venta"]."&motivo=ver' target='_blank'>".$cotizaciones[$i]['venta'].'</a></b><br>';
					$actualizarExpiracion = "";	
				}else{
					$estado = '';
					$disab = " data-original-title='Vender Cotización'";
					$venta = '';
					$actualizarExpiracion = "";
				}

				$botonEditarCot = "<button class='btn btnActualizarCot info bg-olive' style='color:white' codigoCotizacion='".$cotizaciones[$i]["id"]."' data-original-title='Actualizar Cot'><i class='fa fa-pen'></i></button>";

			  	$utilidadMovil = $_SESSION['perfil'] == 'Administrador' ? "<font class='info' data-original-title='Utilidad Esperada' style='color:blue'> &rarr; $".number_format($cotizaciones[$i]['utilidad'],0,',','.')."</font>" : "";
				$columna1 = 		$estado.$cotizaciones[$i]["fecha_ingreso"]." - Cotización Nro. <b>".$cotizaciones[$i]["id"]."</b> <br>".
									str_replace(' ',' ',strtoupper($cotizaciones[$i]['nom_client']))."<br>".
									"Monto: <b>$".number_format($cotizaciones[$i]['total'],0,',','.')."</b>".$utilidadMovil."<br>".
									"Expiración: <b>".$cotizaciones[$i]["fecha_expiracion"]."</b><br>".
									"<i>Vendedor: ".$cotizaciones[$i]["nom_vend"]."</b><br>".
									$venta."<br>".
									"<div class='btn-group'><button class='btn btn-info btnImprimirCotizacion' codigoCotizacion='".$cotizaciones[$i]["id"]."' data-original-title='PDF'><i class='fa fa-file'></i></button><button class='btn btnVentaCot' style='background-color:black; color:white' codigoCotizacion='".$cotizaciones[$i]["id"]."' ".$disab."><i class='fa fa-dollar-sign'></i></button>".$actualizarExpiracion.$botonEditarCot;
			  	

              	$productos=json_decode($cotizaciones[$i]["productos"]);
				$listaProds = "";

				if($productos){

					$listaProds = $productos[0]->cant." ".$productos[0]->prod." →<i><b>$".$productos[0]->pV." c/u</b>";
	            	for($ia=1;$ia<count($productos);$ia++){ 
		                $productosComprados[$ia] = "<br>".$productos[$ia]->cant." ".$productos[$ia]->prod." →<i><b>$".$productos[$ia]->pV." c/u</b></i>";
						$listaProds .= $productosComprados[$ia];               	
	            	}
			    }else{
			    	$listaProds .= 'Producto eliminado (YA NO SE TRABAJA)';
			    }


			  	$datosJson .='[
				      "'.$columna1.'",
				      "'.$listaProds.'"
				    ],';

		  	}

		$datosJson = substr($datosJson, 0, -1);

		$datosJson .=   '] 

		}';
		
		echo $datosJson;

	}

}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$cotizaciones = new TablaCotizaciones();
$cotizaciones -> mostrarTablaCotizaciones();

