<?php
session_start();
require_once "../controladores/productos.controlador.php";
require_once "../modelos/productos.modelo.php";

class TablaProductosVentas{

 	/*=============================================
 	 MOSTRAR LA TABLA DE PRODUCTOS
  	=============================================*/ 

	public function mostrarTablaProductosVentas(){

		// PERMITE COMPRAR PARA UN LOCAL DETERMINADO, PERO SOLO EL ADMINISTRADOR
		$sucursal = $_SESSION['perfil'] == 'Administrador' ? $_GET['suc'] : $_SESSION['sucursal'];
		
		$item = "estado_".$sucursal;
    	$valor = 1;
    	$orden = "fecha";
  		$productos = ControladorProductos::ctrMostrarProductos($item, $valor, $orden);
 		
  		if(count($productos) == 0){

  			echo '{"data": []}';

		  	return;
  		}	
		
  		$datosJson = '{
		  "data": [';

		for($i = 0; $i < count($productos); $i++){
			if($productos[$i]["maneja_stock"] == "SI"){ // contempla solo productos que manejan stock
		
				$descripcionESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productos[$i]["descripcion"]);
				$descripcion2ESCAPE = str_replace(array('"', ',', ';'), array('\\"', '.', '.'), $productos[$i]["descripcion2"]);

				$stockActual = $productos[$i]["stock_".$sucursal];
			  	$imagen = "<img id='imagenZoom' src='".$productos[$i]["imagen"]."' alt='".$descripcionESCAPE."' class='imagenZoom' width='40px' idProducto='".$productos[$i]["id"]."' data-toggle='modal' data-target='#modalZoomProducto'>";
				$ubicacion = $productos[$i]["zona_".$sucursal];
				$descripcion = "<b>".$descripcionESCAPE."</b><br><font size=-2'>".$descripcion2ESCAPE."</font>";

				$sku = $productos[$i]["categoria"] <= 9 ? '0'.$productos[$i]['sku'] : $productos[$i]['sku'];


				$prov = $_GET['prov'];

				$arrayProvs = json_decode($productos[$i]['lista_provs_json'], true);
				$codProv = '';
				if(is_array($arrayProvs)){
					for ($i_a=0; $i_a < count($arrayProvs); $i_a++) { 
						if($arrayProvs[$i_a]['prov'] == $prov){
							$codProv = ' <b><i>['.$arrayProvs[$i_a]['cod_prov'].']</i></b>'; // si es que se ha comprado al proveedor extrae sku_prov
						}
					}
				}


	  			$codigos = "<b>".$ubicacion."-".$sku."</b> (".$productos[$i]["codigo"].") ".$codProv."<br>".$descripcion;
				// $p_comp = "$ ".number_format($productos[$i]["precio_compra"], 0, ',', '.');
			  	/*=============================================
	 	 		STOCK CON COLORES DINAMICO 
	  			=============================================*/ 

				// $stockSucursal = $productos[$i]["stock_".$sucursal];
	  			$stockIdeal = $productos[$i]['stock_ideal_'.$sucursal];
	  			if($stockActual <= $stockIdeal/3){
					$estado_stock = 1;
	  			}else if($stockActual > $stockIdeal/3 && $stockActual <= $stockIdeal*2/3){
					$estado_stock = 2;
	  			}else{
					$estado_stock = 3;
	  			}

	  			
				// TIPO BOTON
				if($estado_stock == 1 && $stockActual > 0){ // bajo stock y con stock
					$colorStk = "<button class='btn btn-danger'>";
				}else if($estado_stock == 2 && $stockActual > 0){ // medio stock y con stock
					$colorStk = "<button class='btn btn-warning'>";
				}else if($estado_stock == 3 && $stockActual > 0){ // alto stock y con stock
					$colorStk = "<button class='btn btn-success'>";
				}else{ // agotado
					$colorStk = "<button class='btn bg-black'>";
				}
					
			  	$btnAgregar =  "<div class='btn-group'><button class='btn abastecerProd recuperarBoton' style='background-color:rgb(37, 211, 102); color:white' id='agregarProducto0' idProd='".$productos[$i]["id"]."'>Abastecer</button></div>"; 
				if($productos[$i]["maneja_stock"]=="SI"){
					$stock = "<div class='btn-group'>".$colorStk.$stockActual."</button></button></div>";
				}else{
					$stock = "<div class='btn-group'><button class='btn btn-info'><font size='+1'>&infin;</font></button></button></div>";
				}


			  	// $datosJson .='[
				  //     "'.$imagen.'",
				  //     "'.$codigos.'",
				  //     "'.$p_comp.'",
				  //     "'.$stock.'",
				  //     "'.$btnAgregar.'"
				  //   ],';
			  	$datosJson .='[
				      "'.$imagen.'",
				      "'.$codigos.'",
				      "'.$stock.'",
				      "'.$btnAgregar.'"
				    ],';
			}

		  }

		  $datosJson = substr($datosJson, 0, -1);

		 $datosJson .=   '] 

		 }';
		
		echo $datosJson;


	}


}

/*=============================================
ACTIVAR TABLA DE PRODUCTOS
=============================================*/ 
$activarProductosVentas = new TablaProductosVentas();
$activarProductosVentas -> mostrarTablaProductosVentas();

