<?php
session_start();
require_once "../modelos/conexion.php";
require_once "../controladores/ajustes.controlador.php";
require_once "../controladores/movimientos-bancarios.controlador.php";
require_once "../modelos/movimientos-bancarios.modelo.php";
date_default_timezone_set("America/Santiago");

class AjaxCompromisosPago{
	/*=============================================
	REGISTRAR COMPROMISO PAGO
	=============================================*/ 
	public function revocarCompromisosPago(){
	  	$idCompromisoPago = $_POST["revocarPago"];
		$datosCompromiso = ControladorMovimientosBancarios::ctrMostrarCompromisosPago('id', $idCompromisoPago);
		$abonos = json_decode($datosCompromiso['abonos'], true);
	    foreach ($abonos as $key => $value) {
	      if($value['tipo'] != 'nc' && $value['comprobante'] != ''){
	        $rutaComprobante = '../'.$value['comprobante'];
	        unlink($rutaComprobante);
	      }
	    }
	    $respuesta = ModeloMovimientosBancarios::mdlRevocarPago($idCompromisoPago);
	    echo $respuesta;
	}

	/*=============================================
	INGRESAR ABONO NC
	=============================================*/ 
	public function aplicarNC(){
	  	$idCompromiso = $_POST["aplicarNC"];
	  	$datosCompromiso = ControladorMovimientosBancarios::ctrMostrarCompromisosPago('id', $idCompromiso);
		$abonos = json_decode($datosCompromiso['abonos'],true);
		$montoCompromiso = $datosCompromiso['monto'];
		$pagosAntesAbono = 0;
		if($datosCompromiso['abonos'] != ''){			
			for ($i=0; $i < count($abonos) ; $i++) { 
				$pagosAntesAbono += $abonos[$i]['monto'];
			}
		}
		$montoPagadoDespuesAbono = $pagosAntesAbono + $_POST['montoNC'];
		if($montoPagadoDespuesAbono >= $montoCompromiso){
			$estado = 1; 
			$actualizarInteres = ModeloMovimientosBancarios::mdlModificar1('compromisos_pago', 'interes_pagado', ($montoPagadoDespuesAbono-$montoCompromiso), $idCompromiso);
		}else{
			$estado = 0;
		}

		$actualizarEstado  = ModeloMovimientosBancarios::mdlModificar1('compromisos_pago', 'estado', $estado, $idCompromiso);
		$fecha = $_POST['fecha'];
		$actualizarFechaPago  = ModeloMovimientosBancarios::mdlModificar1('compromisos_pago', 'fecha_pago', $fecha, $idCompromiso);
		$actualizarMonto = ModeloMovimientosBancarios::mdlModificar1('compromisos_pago', 'monto_pagado', $montoPagadoDespuesAbono, $idCompromiso);
		$datosAbono = ["tipo" => $_POST['tipo'], "nro" => $_POST["nroNC"],"monto" => $_POST['montoNC'],"fecha" => $fecha];
	    $abonos[] = $datosAbono;
	    $abonos = json_encode($abonos);
	    echo $respuesta = ModeloMovimientosBancarios::mdlModificar1('compromisos_pago', 'abonos', $abonos, $idCompromiso);
	}

	/*=============================================
	INGRESAR PAGO COMPROMISO
	=============================================*/ 
	public function pagarCompromiso(){

	  	$idCompromiso = $_POST["pagarCompromiso"];
		$datosCompromiso = ControladorMovimientosBancarios::ctrMostrarCompromisosPago('id', $idCompromiso);
		$abonos = json_decode($datosCompromiso['abonos'],true);
		$fecha = $_POST['fechaAbono'];

		$correlativoAb = !empty($abonos) && is_array($abonos) ? count($abonos) : 0;

		if($datosCompromiso['tipo_compromiso'] == 'hipotecario'){ // vencido
			$valorUF = ModeloMovimientosBancarios::mdlValorUF($datosCompromiso['fecha_vencimiento'])['valor'];
			$montoPagarOriginal = $datosCompromiso["monto"]*$valorUF;
		}else{
			$montoPagarOriginal = $datosCompromiso["monto"];
		}


		// subir archivo
		if(isset($_FILES["comprobanteCompromisoPago"])){
		    $ubicacionTemporal = $_FILES["comprobanteCompromisoPago"]["tmp_name"][0];
		    $nombreArchivo = $idCompromiso.'_'.$correlativoAb;
		    $extension = pathinfo($_FILES["comprobanteCompromisoPago"]["name"][0], PATHINFO_EXTENSION);
		    $nomCarpeta = substr($fecha, 0, 4) . substr($fecha, 5, 2);
		    $rutaCarpeta = "../comprobantes/".$nomCarpeta;
		    		
		    if(!is_dir($rutaCarpeta)){
		    	mkdir($rutaCarpeta, 0755, true);
		    }

		    $rutaArchivo = $rutaCarpeta.'/'.$nombreArchivo.".".$extension;
		    move_uploaded_file($ubicacionTemporal, $rutaArchivo);
		}else{
		    $rutaArchivo = '';
		}

		$datosAb = ["tipo" => 'ab', "moneda" => $_POST["monedaAbono"],"monto" => $_POST['montoAbono'],"comprobante" => substr($rutaArchivo, 3),"fecha" => $fecha];
	    $abonos[] = $datosAb;

		$pagadoTotal = 0; 
		foreach ($abonos as $key => $value) {
			$pagadoTotal += $value['monto'];
		}

		// if($datosCompromiso['tipo_compromiso'] == 'hipotecario'){
		// 	// $buscarUF = ModeloMovimientosBancarios::mdlValorUF($fecha);

		// }else{
		// }

	    $abonos = json_encode($abonos);

		$estado = $pagadoTotal >= $montoPagarOriginal ? 1 : 0;
		$interes = $estado == 1 ? $pagadoTotal - $montoPagarOriginal : 0;

		$datos = array("estado"=>$estado,
					   "fecha_pago"=>$fecha,
					   "monto_pagado"=>$pagadoTotal,
					   "interes_pagado"=>$interes,
					   "moneda_pago"=>$_POST['monedaAbono'],
					   "abonos"=>$abonos,
					   "id"=>$idCompromiso);
		echo $respuesta = ModeloMovimientosBancarios::mdlRegistrarPago('compromisos_pago', $datos);
	}


	/*=============================================
	INFO COMPROMISO
	=============================================*/ 
	public function infoCompromiso(){
	  	$idCompromiso = $_POST["infoCompromiso"];
		$infoCompromiso = ControladorMovimientosBancarios::ctrMostrarCompromisosPago('id', $idCompromiso);
		echo json_encode($infoCompromiso);
	}

	/*=============================================
	EDITAR MONTO COMPROMISO
	=============================================*/ 
	public function editarMontoCompromiso(){
		$idCompromiso = $_POST["editarMontoCompromiso"];
		$monto = str_replace(".", "", $_POST['montoActualizado']);
		$fecha = $_POST['fecha'];
		$modificarFecha = ModeloMovimientosBancarios::mdlModificar1('compromisos_pago', 'fecha_vencimiento', $fecha, $idCompromiso);
		echo $respuesta = ModeloMovimientosBancarios::mdlModificar1('compromisos_pago', 'monto', $monto, $idCompromiso);
	}

	/*=============================================
	EDITAR FECHA COMPROMISO HIPO
	=============================================*/ 
	public function editarFechaHipo(){
		$idCompromiso = $_POST["editarFechaCompromisoHipo"];
		$fecha = $_POST['fecha'];
	
		$buscarUF = ModeloMovimientosBancarios::mdlValorUF($fecha);
        if ($buscarUF && is_array($buscarUF)){ // busca si está en DB
          $valorUF = $buscarUF['valor'];
        }else{ // si no la busca en API REST
          $fechaBuscar = date("d-m-Y", strtotime($fecha));
          $apiUrl = 'https://mindicador.cl/api/uf/'.$fechaBuscar;
          if(ini_get('allow_url_fopen')){
              $json = file_get_contents($apiUrl);
          }else{
              //De otra forma utilizamos cURL
              $curl = curl_init($apiUrl);
              curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
              $json = curl_exec($curl);
              curl_close($curl);
          }
          $dailyIndicators = json_decode($json);
          $valorUF = $dailyIndicators->serie[0]->valor;
          $registrarUFHoy = ModeloMovimientosBancarios::mdlRegistrarUFAnterior($fecha, $valorUF);
        }

		echo $modificarFecha = ModeloMovimientosBancarios::mdlModificar1('compromisos_pago', 'fecha_vencimiento', $fecha, $idCompromiso);
	}

	/*=============================================
	ELIMINAR COMPROMISO
	=============================================*/ 
	public function eliminarCompromiso(){
		$idCompromiso = $_POST["eliminarCompromiso"];
		echo $deleteCompromiso = ModeloMovimientosBancarios::mdlEliminarCompromisosPago('compromisos_pago', $idCompromiso);
	}

	/*=============================================
	EDITAR GUIA FACTURA
	=============================================*/ 
	public function editarGuiaFact(){
		$idCompromiso = $_POST["editNroDocumento"];
		echo $respuesta = ModeloMovimientosBancarios::mdlModificar1('compromisos_pago', 'descripcion', $_POST['descripcionNroDoc'], $idCompromiso);
	}

}

/*=============================================
EDITAR GUIA O FACTURA
=============================================*/ 
if(isset($_POST["editNroDocumento"])){
	$editarGuiaFact = new AjaxCompromisosPago();
	$editarGuiaFact -> editarGuiaFact();
}

/*=============================================
ELIMINAR COMPROMISO
=============================================*/ 
if(isset($_POST["eliminarCompromiso"])){
	$eliminarCompromiso = new AjaxCompromisosPago();
	$eliminarCompromiso -> eliminarCompromiso();
}

/*=============================================
EDITAR MONTO COMPROMISO
=============================================*/ 
if(isset($_POST["editarMontoCompromiso"])){
	$editarMontoCompromiso = new AjaxCompromisosPago();
	$editarMontoCompromiso -> editarMontoCompromiso();
}


/*=============================================
EDITAR FECHA COMPROMISO HIPO
=============================================*/ 
if(isset($_POST["editarFechaCompromisoHipo"])){
	$editarFechaHipo = new AjaxCompromisosPago();
	$editarFechaHipo -> editarFechaHipo();
}



/*=============================================
INFO COMPROMISO
=============================================*/ 
if(isset($_POST["infoCompromiso"])){
	$infoCompromiso = new AjaxCompromisosPago();
	$infoCompromiso -> infoCompromiso();
}


/*=============================================
PAGAR COMPROMISO
=============================================*/ 
if(isset($_POST["pagarCompromiso"])){
	$pagarCompromiso = new AjaxCompromisosPago();
	$pagarCompromiso -> pagarCompromiso();
}

/*=============================================
REVOCAR PAGO
=============================================*/ 
if(isset($_POST["revocarPago"])){
	$registrarCompromisosPago = new AjaxCompromisosPago();
	$registrarCompromisosPago -> revocarCompromisosPago();
}
/*=============================================
APLICAR NC
=============================================*/ 
if(isset($_POST["aplicarNC"])){
	$registrarCompromisosPago = new AjaxCompromisosPago();
	$registrarCompromisosPago -> aplicarNC();
}
