<?php
session_start();
require_once "../modelos/ajustes.modelo.php";
require_once "../modelos/proveedores.modelo.php";
require_once "../modelos/compras.modelo.php";
require_once "../modelos/sucursales.modelo.php";
require_once "../modelos/productos.modelo.php";
require_once "../modelos/actividad-inventario.modelo.php";
require_once "../modelos/movimientos-bancarios.modelo.php";

class AjaxCompras{
  /*=============================================
  DATOS COMPRA
  =============================================*/ 
  public function datosCompra(){
    $item = 'id';
    $valor = $_POST['datosCompra'];
    // $compra = ModeloCompras::mdlMostrarCompras('compras', $item, $valor, 'id');
    $compra = ModeloCompras::mdlMostrarCompra('compras', 'id', $valor);
    echo json_encode($compra);
  }   

  /*=============================================
  REGISTRAR COMPRA
  =============================================*/ 
  public function registrarCompra(){

    // ITEMS PRODUCTOS
    $abastecimiento = $_POST['abastecimiento'];     
    $listAbastecimiento = json_decode($abastecimiento, true);
    $totalCompra = $_POST['totalCompra'];
    $sucursal = $_SESSION['perfil'] == 'Administrador' ? $_POST['sucursalCompraNombre'] : $_SESSION['sucursal'];
    $ultimoRegistroProd = ModeloProductos::mdlSeleccionarUltimoIdRegistro();
    
    if($_POST['tipoAbastecimiento'] == 'Abastecer'){

      foreach ($listAbastecimiento as $key => $val){
        $tabla = "productos";
        // TRAE LOS PRODUCTOS ABASTECIDOS
        $item = "id";
        $valor = $val["id"];
        $orden = "id";
        $prod = ModeloProductos::mdlMostrarProductos($tabla, $item, $valor, $orden);

        // telegram
        $notificarDB = ModeloProductos::mdlActualizarProducto($tabla, 'notificacion_telegram_'.$sucursal, 0, $valor);

        // FECHA MODIF DEL PRODUCTO
          date_default_timezone_set('America/Santiago');  
        $item12 = "fecha_modif_".$sucursal;
          $valor12 = date("Y-m-d H:i:s");
        $fecha_modif = ModeloProductos::mdlActualizarProducto($tabla, $item12, $valor12, $valor);

        // FECHA ABASTECIMIENTO DEL PRODUCTO
        $item12 = "fecha_abast_".$sucursal;
          $valor12 = date("Y-m-d H:i:s");
        $fecha_abast = ModeloProductos::mdlActualizarProducto($tabla, $item12, $valor12, $valor);

        // LISTA PROVEEDORES
        $arrayProveedores = explode(',', $prod['lista_proveedores']);
        $arrayProvsJson = json_decode($prod['lista_provs_json'], true);
        
        if($_POST['provAbast'] != 0){
          if (in_array($_POST['provAbast'], $arrayProveedores)){ // revisa si está en el array
            // SOLO LISTA PROVS JSON
            if($prod['lista_provs_json'] != '' && count($arrayProvsJson) > 1){
              foreach ($arrayProvsJson as $key => $element) {
                  if(isset($element['prov']) && $element['prov'] == $_POST['provAbast']) {
                      unset($arrayProvsJson[$key]); // elimina la clave
                  }
              }
            }
              $actualizarProv = ["prov" => $_POST['provAbast'], "cod_prov" => $val['codProv'], "pc_neto" => $val["pCNetoActual"]];
              $arrayProvsJson[] = $actualizarProv;
              $jsonNuevoProd = json_encode(array_values($arrayProvsJson));
            $actualizarListaProvsJson = ModeloProductos::mdlActualizarProducto($tabla, 'lista_provs_json', $jsonNuevoProd, $valor);

          }else{
            // LISTA PROVS
            array_push($arrayProveedores, $_POST['provAbast']);
            $listaProvsDB = implode(',', $arrayProveedores);
            $actualizarListaProvs = ModeloProductos::mdlActualizarProducto($tabla, 'lista_proveedores', $listaProvsDB, $valor);
            
            // LISTA PROVS JSON
              $actualizarProv = ["prov" => $_POST['provAbast'], "cod_prov" => $val['codProv'], "pc_neto" => $val["pCNetoActual"]];
              $arrayProvsJson[] = $actualizarProv;
              $jsonNuevoProd = json_encode(array_values($arrayProvsJson));
            $actualizarListaProvsJson = ModeloProductos::mdlActualizarProducto($tabla, 'lista_provs_json', $jsonNuevoProd, $valor);
          }
        }

        if($_POST['provAbast'] != 0){
          // NUEVO PROVEEDOR
          $item12 = "nom_prov";
          $valor12 = $_POST['nomProvAbast'];
          $item12_1 = "proveedor";
          $valor12_1 = $_POST['provAbast'];
          $nuevoProveedor = ModeloProductos::mdlActualizar2($tabla, $item12, $valor12, $item12_1, $valor12_1, 'id', $valor);          
          // COD_PROVEEDOR
          $codProveedor = ModeloProductos::mdlActualizarProducto($tabla, 'cod_proveedor', $val['codProv'], $valor);
        }

        // REGISTRO DEL RESPONSABLE
        $item13 = "nom_trab";
        $valor13 = $_SESSION['nombre'];
        $item13_1 = "id_trab";
        $valor13_1 = $_SESSION["id"];
        $responsable = ModeloProductos::mdlActualizar2($tabla, $item13, $valor13, $item13_1, $valor13_1, 'id', $valor);         

        // PRECIO COMPRA NETO PROMEDIADO
        $item2 = "pc_neto";

        $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
        $locales = array();
        foreach ($sucursales as $key => $value){
          array_push($locales, $value["nombre_sucursal"]);
        }

        $stockProdGeneral = 0;
        for ($i=0; $i < count($locales); $i++) { 
          $stockProdGeneral += $prod["stock_".$locales[$i]];
        }

        $precioCompraNETOPromediado = round(($val["pCNetoActual"]*$val["cant"] + $prod['pc_neto']*$stockProdGeneral)/($stockProdGeneral+$val['cant']),2);
        $precioCompraNETOPromedio = ModeloProductos::mdlActualizarProducto($tabla, $item2, $precioCompraNETOPromediado, $valor);

        // PRECIO COMPRA C/IVA PROMEDIADO
        $item5 = "precio_compra"; //
        $valor5 = round($precioCompraNETOPromediado*1.19,0);
        $precioNetoPromedio = ModeloProductos::mdlActualizarProducto($tabla, $item5, $valor5, $valor);

        // STOCK ACTUAL
        $item4 = "stock_".$sucursal;
        $valor4 = $prod["stock_".$sucursal]+$val["cant"];
        $stockActual = ModeloProductos::mdlActualizarProducto($tabla, $item4, $valor4, $valor);

        // PRECIO VENTA UNITARIO
        $item8 = "precio_venta";
        $valor8 = $val["pV"];
        $precioVenta = ModeloProductos::mdlActualizarProducto($tabla, $item8, $valor8, $valor);
        
        // PRECIO VENTA MAYOR
        $item9 = "precio_mayor";
        $valor9 = $val["pM"];
        $precioMayor = ModeloProductos::mdlActualizarProducto($tabla, $item9, $valor9, $valor);

        //REGISTRO ACTIVIDAD
        $regActividadInventario = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistroProd[0]+1, $sucursal, 'abast', $val['cant'], '', $val['id'], $_SESSION['id'], $_SESSION['nombre']);

        if($prod['transformable'] == 1){
          // CAMBIO PRECIO COMPRA SURTIBLE
          $idProdSurtible = $prod['id_transf'];
          $item10 = "pc_neto";
          $valor10 = $val["pCNetoSurtible"];
          $pc_neto = ModeloProductos::mdlActualizarProducto($tabla, $item10, $valor10, $idProdSurtible);

          $item11 = "precio_compra";
          $valor11 = $val["pCTotalSurtible"];
          $pc_total = ModeloProductos::mdlActualizarProducto($tabla, $item11, $valor11, $idProdSurtible);

          $item12 = "precio_venta";
          $valor12 = $val["pVUnitSurtible"];
          $pc_total = ModeloProductos::mdlActualizarProducto($tabla, $item12, $valor12, $idProdSurtible);

          $item13 = "precio_mayor";
          $valor13 = $val["pVMayorSurtible"];
          $pc_total = ModeloProductos::mdlActualizarProducto($tabla, $item13, $valor13, $idProdSurtible);
        }
      }
    }

    // RESPALDAR ABASTECIMIENTO EN DB
    $tabla = "compras";
    $estado = $_POST['tipoAbastecimiento'] == 'Abastecer' ? 'enviado' : 'guardado';
    date_default_timezone_set('America/Santiago');  
    $fecha_ingreso = date("Y-m-d H:i:s");         
    $fecha_compra = $_POST['fechaAbast'];
    $id_prov = $_POST['provAbast'];
    $nom_prov = $_POST['nomProvAbast'];
    $id_trab = $_SESSION["id"];
    $nom_trab = $_SESSION["nombre"];
    // $total = $totalCompra;
    
    if(isset($_POST['nroFactura'])){
      $factura = $_POST['nroFactura'];
      $guia = 0;
      $otro_doc = 0;
      $descripcion = 'Factura nro. '.$factura;
    }else if(isset($_POST['nroGuia'])){
      $factura = $_POST['nroFacturaGuia'];
      $guia = $_POST['nroGuia'];
      $otro_doc = 0;
      $descripcion = 'Guía nro. '.$guia.' - Factura nro. '.$factura;
    }else if(isset($_POST['nroOtro'])){
      $factura = 0;
      $guia = 0;
      $otro_doc = $_POST['nroOtro'];
      $descripcion = 'Comprobante nro. '.$otro_doc;
    }else if(isset($_POST['nroFacturaMovil'])){
      $factura = $_POST['nroFacturaMovil'];
      $guia = 0;
      $otro_doc = 0;
      $descripcion = 'Factura nro. '.$factura;
    }else if(isset($_POST['nroGuiaMovil'])){
      $factura = $_POST['nroFacturaGuiaMovil'];
      $guia = $_POST['nroGuiaMovil'];
      $otro_doc = 0;
      $descripcion = 'Guía nro. '.$guia.' - Factura nro. '.$factura;
    }else if(isset($_POST['nroOtroMovil'])){
      $factura = 0;
      $guia = 0;
      $otro_doc = $_POST['nroOtroMovil'];
      $descripcion = 'Comprobante nro. '.$otro_doc;
    }

    $tipoPago = $_POST['tipoPagoAbastExterno'];


    ////////////////////////////////////////////////////////////// COMPROMISO PAGO//////////////////////////////////////////////////////////////
    if($_POST['tipoPagoAbastExterno'] == 'credito'){ // detecta compra con Cred interno proveedor

      $proveedor = ModeloProveedores::mdlMostrarProveedores('proveedores', 'id', $id_prov);
      $diasCredito = $proveedor['dias_credito'] == 0 ? 30 : $proveedor['dias_credito'];


      $fecha = new DateTime($fecha_compra);
      $fecha->add(new DateInterval('P'.$diasCredito.'D'));
      $fechaVencimiento = $fecha->format('Y-m-d');

      // $fechaVencimiento = date("Y-m-d",strtotime($fecha_compra."+ ".$diasCredito." days"));
      $tipoCompromiso = 'cred_prov';
      $sePagaDesde = '';
      $montoCompromiso = $totalCompra;
      $nroRegistros = 1; // SE REGISTRA SOLO 1 COMPROMISO
      
      $nombreFantasia = ModeloAjustes::mdlMostrarAjuste('ajustes', 'tipo_ajuste', 'nombre_comercial')['ajuste'];

      $datos = array("deudor"=>$nombreFantasia,
               "fecha_vencimiento"=>$fechaVencimiento,
               "tipo_compromiso"=>$tipoCompromiso,
               "se_paga_desde"=>$sePagaDesde,
               "descripcion"=>$descripcion,
               "acreedor"=>$nom_prov,
               "nro_cuota"=>'',
               "monto"=>$montoCompromiso);
      $registrarCompromisoPago = ModeloMovimientosBancarios::mdlRegistrarCompromisoPago('compromisos_pago', $datos);
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    echo $respuesta = ModeloProductos::mdlIngresarAbastecimiento($tabla, $totalCompra, $fecha_ingreso, $estado, $fecha_compra, $abastecimiento, $factura, $guia, $otro_doc, $id_prov, $nom_prov, $id_trab, $nom_trab, $ultimoRegistroProd[0]+1, $sucursal, $tipoPago);
  }

  /*=============================================
  REGISTRAR COMPRA
  =============================================*/ 
  public function ingresarAbastGuardado(){

    // ITEMS PRODUCTOS
    $idCompra = $_POST['ingresarAbastGuardado'];
    $datosCompra = ModeloCompras::mdlMostrarCompra('compras', 'id', $idCompra);
    $abastecimiento = $datosCompra['abastecimiento'];

    $listAbastecimiento = json_decode($abastecimiento, true);
    $totalCompra = $datosCompra['total'];
    $sucursal = $datosCompra['sucursal_abastecida'];
    $ultimoRegistroProd = ModeloProductos::mdlSeleccionarUltimoIdRegistro();
    
    foreach ($listAbastecimiento as $key => $val){
      $tabla = "productos";
      // TRAE LOS PRODUCTOS ABASTECIDOS
      $item = "id";
      $valor = $val["id"];
      $orden = "id";
      $prod = ModeloProductos::mdlMostrarProductos($tabla, $item, $valor, $orden);

      // telegram
      $notificarDB = ModeloProductos::mdlActualizarProducto($tabla, 'notificacion_telegram_'.$sucursal, 0, $valor);

      // FECHA MODIF DEL PRODUCTO
        date_default_timezone_set('America/Santiago');  
      $item12 = "fecha_modif_".$sucursal;
        $valor12 = date("Y-m-d H:i:s");
      $fecha_modif = ModeloProductos::mdlActualizarProducto($tabla, $item12, $valor12, $valor);

      // FECHA ABASTECIMIENTO DEL PRODUCTO
      $item12 = "fecha_abast_".$sucursal;
        $valor12 = date("Y-m-d H:i:s");
      $fecha_abast = ModeloProductos::mdlActualizarProducto($tabla, $item12, $valor12, $valor);

      // LISTA PROVEEDORES
      $arrayProveedores = explode(',', $prod['lista_proveedores']);
      $arrayProvsJson = json_decode($prod['lista_provs_json'], true);
      
      if($datosCompra['id_prov'] != 0){
        if (in_array($datosCompra['id_prov'], $arrayProveedores)){ // revisa si está en el array
          // SOLO LISTA PROVS JSON
          if($prod['lista_provs_json'] != '' && count($arrayProvsJson) > 1){
            foreach ($arrayProvsJson as $key => $element) {
                if(isset($element['prov']) && $element['prov'] == $datosCompra['id_prov']) {
                    unset($arrayProvsJson[$key]); // elimina la clave
                }
            }
          }
            $actualizarProv = ["prov" => $datosCompra['id_prov'], "cod_prov" => $val['codProv'], "pc_neto" => $val["pCNetoActual"]];
            $arrayProvsJson[] = $actualizarProv;
            $jsonNuevoProd = json_encode(array_values($arrayProvsJson));
          $actualizarListaProvsJson = ModeloProductos::mdlActualizarProducto($tabla, 'lista_provs_json', $jsonNuevoProd, $valor);

        }else{
          // LISTA PROVS
          array_push($arrayProveedores, $datosCompra['id_prov']);
          $listaProvsDB = implode(',', $arrayProveedores);
          $actualizarListaProvs = ModeloProductos::mdlActualizarProducto($tabla, 'lista_proveedores', $listaProvsDB, $valor);
          
          // LISTA PROVS JSON
            $actualizarProv = ["prov" => $datosCompra['id_prov'], "cod_prov" => $val['codProv'], "pc_neto" => $val["pCNetoActual"]];
            $arrayProvsJson[] = $actualizarProv;
            $jsonNuevoProd = json_encode(array_values($arrayProvsJson));
          $actualizarListaProvsJson = ModeloProductos::mdlActualizarProducto($tabla, 'lista_provs_json', $jsonNuevoProd, $valor);
        }
      }

      if($datosCompra['id_prov'] != 0){
        // NUEVO PROVEEDOR
        $item12 = "nom_prov";
        $valor12 = $datosCompra['nom_prov'];
        $item12_1 = "proveedor";
        $valor12_1 = $datosCompra['id_prov'];
        $nuevoProveedor = ModeloProductos::mdlActualizar2($tabla, $item12, $valor12, $item12_1, $valor12_1, 'id', $valor);          
        // COD_PROVEEDOR
        $codProveedor = ModeloProductos::mdlActualizarProducto($tabla, 'cod_proveedor', $val['codProv'], $valor);
      }

      // REGISTRO DEL RESPONSABLE
      $item13 = "nom_trab";
      $valor13 = $_SESSION['nombre'];
      $item13_1 = "id_trab";
      $valor13_1 = $_SESSION["id"];
      $responsable = ModeloProductos::mdlActualizar2($tabla, $item13, $valor13, $item13_1, $valor13_1, 'id', $valor);         

      // PRECIO COMPRA NETO PROMEDIADO
      $item2 = "pc_neto";

      $sucursales = ModeloSucursales::mdlMostrarSucursales("sucursales", null, null);
      $locales = array();
      foreach ($sucursales as $key => $value){
        array_push($locales, $value["nombre_sucursal"]);
      }

      $stockProdGeneral = 0;
      for ($i=0; $i < count($locales); $i++) { 
        $stockProdGeneral += $prod["stock_".$locales[$i]];
      }

      $precioCompraNETOPromediado = round(($val["pCNetoActual"]*$val["cant"] + $prod['pc_neto']*$stockProdGeneral)/($stockProdGeneral+$val['cant']),2);
      $precioCompraNETOPromedio = ModeloProductos::mdlActualizarProducto($tabla, $item2, $precioCompraNETOPromediado, $valor);

      // PRECIO COMPRA C/IVA PROMEDIADO
      $item5 = "precio_compra"; //
      $valor5 = round($precioCompraNETOPromediado*1.19,0);
      $precioNetoPromedio = ModeloProductos::mdlActualizarProducto($tabla, $item5, $valor5, $valor);

      // STOCK ACTUAL
      $item4 = "stock_".$sucursal;
      $valor4 = $prod["stock_".$sucursal]+$val["cant"];
      $stockActual = ModeloProductos::mdlActualizarProducto($tabla, $item4, $valor4, $valor);

      // PRECIO VENTA UNITARIO
      $item8 = "precio_venta";
      $valor8 = $val["pV"];
      $precioVenta = ModeloProductos::mdlActualizarProducto($tabla, $item8, $valor8, $valor);
      
      // PRECIO VENTA MAYOR
      $item9 = "precio_mayor";
      $valor9 = $val["pM"];
      $precioMayor = ModeloProductos::mdlActualizarProducto($tabla, $item9, $valor9, $valor);

      //REGISTRO ACTIVIDAD
      $regActividadInventario = ModeloActividadInventario::mdlIngresarActividad('actividad_inventario', $ultimoRegistroProd[0]+1, $sucursal, 'abast', $val['cant'], '', $val['id'], $_SESSION['id'], $_SESSION['nombre']);

      if($prod['transformable'] == 1){
        // CAMBIO PRECIO COMPRA SURTIBLE
        $idProdSurtible = $prod['id_transf'];
        $item10 = "pc_neto";
        $valor10 = $val["pCNetoSurtible"];
        $pc_neto = ModeloProductos::mdlActualizarProducto($tabla, $item10, $valor10, $idProdSurtible);

        $item11 = "precio_compra";
        $valor11 = $val["pCTotalSurtible"];
        $pc_total = ModeloProductos::mdlActualizarProducto($tabla, $item11, $valor11, $idProdSurtible);

        $item12 = "precio_venta";
        $valor12 = $val["pVUnitSurtible"];
        $pc_total = ModeloProductos::mdlActualizarProducto($tabla, $item12, $valor12, $idProdSurtible);

        $item13 = "precio_mayor";
        $valor13 = $val["pVMayorSurtible"];
        $pc_total = ModeloProductos::mdlActualizarProducto($tabla, $item13, $valor13, $idProdSurtible);
      }
    }
    echo $actualizarCompra = ModeloCompras::mdlActualizarCompra('compras', 'estado', 'enviado', $idCompra);
  }
}

/*=============================================
REGISTRAR ABASTECIMIENTO GUARDADO
=============================================*/ 
if(isset($_POST["ingresarAbastGuardado"])){
  $registrarCompra = new AjaxCompras();
  $registrarCompra -> ingresarAbastGuardado();
}

/*=============================================
REGISTRAR COMPRA
=============================================*/ 
if(isset($_POST["abastecimiento"])){
  $registrarCompra = new AjaxCompras();
  $registrarCompra -> registrarCompra();
}

/*=============================================
DATOS COMPRA
=============================================*/ 
if(isset($_POST["datosCompra"])){
  $extraerDatosCompra = new AjaxCompras();
  $extraerDatosCompra -> datosCompra();
}
